/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.command.Command;
import io.airlift.command.Option;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.compaction.CompactionManagerMBean;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="compactionstats", description="Print statistics on compactions")
public class CompactionStats
extends NodeTool.NodeToolCmd {
    @Option(title="human_readable", name={"-H", "--human-readable"}, description="Display bytes in human readable form, i.e. KB, MB, GB, TB")
    private boolean humanReadable = false;

    @Override
    public void execute(NodeProbe probe) {
        CompactionManagerMBean cm = probe.getCompactionManagerProxy();
        Map pendingTaskNumberByTable = (Map)probe.getCompactionMetric("PendingTasksByTableName");
        int numTotalPendingTask = 0;
        for (Map.Entry ksEntry : pendingTaskNumberByTable.entrySet()) {
            for (Map.Entry entry : ((Map)ksEntry.getValue()).entrySet()) {
                numTotalPendingTask += ((Integer)entry.getValue()).intValue();
            }
        }
        System.out.println("pending tasks: " + numTotalPendingTask);
        for (Map.Entry ksEntry : pendingTaskNumberByTable.entrySet()) {
            String ksName = (String)ksEntry.getKey();
            for (Map.Entry entry : ((Map)ksEntry.getValue()).entrySet()) {
                String tableName = (String)entry.getKey();
                int pendingTaskCount = (Integer)entry.getValue();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("- ");
                stringBuilder.append(ksName);
                stringBuilder.append('.');
                stringBuilder.append(tableName);
                stringBuilder.append(": ");
                stringBuilder.append(pendingTaskCount);
                System.out.println(stringBuilder.toString());
            }
        }
        System.out.println();
        long remainingBytes = 0L;
        List<Map<String, String>> compactions = cm.getCompactions();
        if (!compactions.isEmpty()) {
            int n = probe.getCompactionThroughput();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            int[] columnSizes = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
            this.addLine(arrayList, columnSizes, "id", "compaction type", "keyspace", "table", "completed", "total", "unit", "progress");
            for (Map<String, String> map : compactions) {
                long total = Long.parseLong(map.get("total"));
                long completed = Long.parseLong(map.get("completed"));
                String taskType = map.get("taskType");
                String keyspace = map.get("keyspace");
                String columnFamily = map.get("columnfamily");
                String completedStr = this.humanReadable ? FileUtils.stringifyFileSize(completed) : Long.toString(completed);
                String totalStr = this.humanReadable ? FileUtils.stringifyFileSize(total) : Long.toString(total);
                String unit = map.get("unit");
                String percentComplete = total == 0L ? "n/a" : new DecimalFormat("0.00").format((double)completed / (double)total * 100.0) + "%";
                String id = map.get("compactionId");
                this.addLine(arrayList, columnSizes, id, taskType, keyspace, columnFamily, completedStr, totalStr, unit, percentComplete);
                if (!taskType.equals(OperationType.COMPACTION.toString())) continue;
                remainingBytes += total - completed;
            }
            StringBuilder buffer = new StringBuilder();
            for (int columnSize : columnSizes) {
                buffer.append("%");
                buffer.append(columnSize + 3);
                buffer.append("s");
            }
            buffer.append("%n");
            String string = buffer.toString();
            for (String[] line : arrayList) {
                System.out.printf(string, line[0], line[1], line[2], line[3], line[4], line[5], line[6], line[7]);
            }
            String remainingTime = "n/a";
            if (n != 0) {
                long remainingTimeInSecs = remainingBytes / (0x100000L * (long)n);
                remainingTime = String.format("%dh%02dm%02ds", remainingTimeInSecs / 3600L, remainingTimeInSecs % 3600L / 60L, remainingTimeInSecs % 60L);
            }
            System.out.printf("%25s%10s%n", "Active compaction remaining time : ", remainingTime);
        }
    }

    private void addLine(List<String[]> lines, int[] columnSizes, String ... columns) {
        lines.add(columns);
        for (int i = 0; i < columns.length; ++i) {
            columnSizes[i] = Math.max(columnSizes[i], columns[i].length());
        }
    }
}

