/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.collect.Iterables;
import io.airlift.command.Command;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.openmbean.TabularData;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.CompactionHistoryRow;

@Command(name="compactionhistory", description="Print history of compaction")
public class CompactionHistory
extends NodeTool.NodeToolCmd {
    @Override
    public void execute(NodeProbe probe) {
        System.out.println("Compaction History: ");
        TabularData tabularData = probe.getCompactionHistory();
        if (tabularData.isEmpty()) {
            System.out.printf("There is no compaction history", new Object[0]);
            return;
        }
        String format = "%-41s%-19s%-29s%-26s%-15s%-15s%s%n";
        List<String> indexNames = tabularData.getTabularType().getIndexNames();
        System.out.printf(format, Iterables.toArray(indexNames, Object.class));
        Set<?> values = tabularData.keySet();
        ArrayList<CompactionHistoryRow> chr = new ArrayList<CompactionHistoryRow>();
        for (Object eachValue : values) {
            List value = (List)eachValue;
            CompactionHistoryRow chc = new CompactionHistoryRow((String)value.get(0), (String)value.get(1), (String)value.get(2), (Long)value.get(3), (Long)value.get(4), (Long)value.get(5), (String)value.get(6));
            chr.add(chc);
        }
        Collections.sort(chr);
        for (CompactionHistoryRow eachChc : chr) {
            System.out.printf(format, eachChc.getAllAsArray());
        }
    }
}

