/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.CompactionIterator;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.CompactionStrategyManager;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.compaction.writers.DefaultCompactionWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.Refs;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionTask
extends AbstractCompactionTask {
    protected static final Logger logger = LoggerFactory.getLogger(CompactionTask.class);
    protected final int gcBefore;
    protected final boolean offline;
    protected final boolean keepOriginals;
    protected static long totalBytesCompacted = 0L;
    private CompactionManager.CompactionExecutorStatsCollector collector;

    public CompactionTask(ColumnFamilyStore cfs, LifecycleTransaction txn, int gcBefore) {
        this(cfs, txn, gcBefore, false, false);
    }

    public CompactionTask(ColumnFamilyStore cfs, LifecycleTransaction txn, int gcBefore, boolean offline, boolean keepOriginals) {
        super(cfs, txn);
        this.gcBefore = gcBefore;
        this.offline = offline;
        this.keepOriginals = keepOriginals;
    }

    public static synchronized long addToTotalBytesCompacted(long bytesCompacted) {
        return totalBytesCompacted += bytesCompacted;
    }

    @Override
    protected int executeInternal(CompactionManager.CompactionExecutorStatsCollector collector) {
        this.collector = collector;
        this.run();
        return this.transaction.originals().size();
    }

    public boolean reduceScopeForLimitedSpace() {
        if (this.partialCompactionsAcceptable() && this.transaction.originals().size() > 1) {
            logger.warn("insufficient space to compact all requested files {}", (Object)StringUtils.join(this.transaction.originals(), (String)", "));
            SSTableReader removedSSTable = this.cfs.getMaxSizeFile(this.transaction.originals());
            this.transaction.cancel(removedSSTable);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runMayThrow() throws Exception {
        assert (this.transaction != null);
        if (this.transaction.originals().isEmpty()) {
            return;
        }
        CompactionStrategyManager strategy = this.cfs.getCompactionStrategyManager();
        if (DatabaseDescriptor.isSnapshotBeforeCompaction()) {
            this.cfs.snapshotWithoutFlush(System.currentTimeMillis() + "-compact-" + this.cfs.name);
        }
        long expectedWriteSize = this.cfs.getExpectedCompactedFileSize(this.transaction.originals(), this.compactionType);
        long earlySSTableEstimate = Math.max(1L, expectedWriteSize / strategy.getMaxSSTableBytes());
        this.checkAvailableDiskSpace(earlySSTableEstimate, expectedWriteSize);
        assert (!Iterables.any(this.transaction.originals(), (Predicate)new Predicate<SSTableReader>(){

            public boolean apply(SSTableReader sstable) {
                return !sstable.descriptor.cfname.equals(CompactionTask.this.cfs.name);
            }
        }));
        UUID taskId = this.transaction.opId();
        StringBuilder ssTableLoggerMsg = new StringBuilder("[");
        for (SSTableReader sstr : this.transaction.originals()) {
            ssTableLoggerMsg.append(String.format("%s:level=%d, ", sstr.getFilename(), sstr.getSSTableLevel()));
        }
        ssTableLoggerMsg.append("]");
        logger.debug("Compacting ({}) {}", (Object)taskId, (Object)ssTableLoggerMsg);
        long start = System.nanoTime();
        long totalKeysWritten = 0L;
        long estimatedKeys = 0L;
        try (CompactionController controller = this.getCompactionController(this.transaction.originals());){
            long[] mergedRowCounts;
            Object newSStables;
            Object object;
            Sets.SetView actuallyCompact = Sets.difference(this.transaction.originals(), controller.getFullyExpiredSSTables());
            int nowInSec = FBUtilities.nowInSeconds();
            try (Refs refs = Refs.ref(actuallyCompact);
                 AbstractCompactionStrategy.ScannerList scanners = strategy.getScanners((Collection<SSTableReader>)actuallyCompact);
                 CompactionIterator ci = new CompactionIterator(this.compactionType, scanners.scanners, controller, nowInSec, taskId);){
                if (this.collector != null) {
                    this.collector.beginCompaction(ci);
                }
                long lastCheckObsoletion = start;
                if (!controller.cfs.getCompactionStrategyManager().isActive) {
                    throw new CompactionInterruptedException(ci.getCompactionInfo());
                }
                try {
                    CompactionAwareWriter writer = this.getCompactionAwareWriter(this.cfs, this.getDirectories(), this.transaction, (Set<SSTableReader>)actuallyCompact);
                    object = null;
                    try {
                        estimatedKeys = writer.estimatedKeys();
                        while (ci.hasNext()) {
                            if (ci.isStopRequested()) {
                                throw new CompactionInterruptedException(ci.getCompactionInfo());
                            }
                            if (writer.append(ci.next())) {
                                ++totalKeysWritten;
                            }
                            if (System.nanoTime() - lastCheckObsoletion <= TimeUnit.MINUTES.toNanos(1L)) continue;
                            controller.maybeRefreshOverlaps();
                            lastCheckObsoletion = System.nanoTime();
                        }
                        newSStables = writer.finish();
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (writer != null) {
                            if (object != null) {
                                try {
                                    writer.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                writer.close();
                            }
                        }
                    }
                }
                finally {
                    if (this.collector != null) {
                        this.collector.finishCompaction(ci);
                    }
                    mergedRowCounts = ci.getMergedRowCounts();
                }
            }
            long dTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            long startsize = SSTableReader.getTotalBytes(this.transaction.originals());
            long endsize = SSTableReader.getTotalBytes((Iterable<SSTableReader>)newSStables);
            double ratio = (double)endsize / (double)startsize;
            StringBuilder newSSTableNames = new StringBuilder();
            object = newSStables.iterator();
            while (object.hasNext()) {
                SSTableReader reader = (SSTableReader)object.next();
                newSSTableNames.append(reader.descriptor.baseFilename()).append(",");
            }
            double mbps = dTime > 0L ? (double)endsize / 1048576.0 / ((double)dTime / 1000.0) : 0.0;
            long totalSourceRows = 0L;
            String mergeSummary = CompactionTask.updateCompactionHistory(this.cfs.keyspace.getName(), this.cfs.getColumnFamilyName(), mergedRowCounts, startsize, endsize);
            logger.debug(String.format("Compacted (%s) %d sstables to [%s] to level=%d.  %,d bytes to %,d (~%d%% of original) in %,dms = %fMB/s.  %,d total partitions merged to %,d.  Partition merge counts were {%s}", taskId, this.transaction.originals().size(), newSSTableNames.toString(), this.getLevel(), startsize, endsize, (int)(ratio * 100.0), dTime, mbps, totalSourceRows, totalKeysWritten, mergeSummary));
            logger.trace(String.format("CF Total Bytes Compacted: %,d", CompactionTask.addToTotalBytesCompacted(endsize)));
            logger.trace("Actual #keys: {}, Estimated #keys:{}, Err%: {}", new Object[]{totalKeysWritten, estimatedKeys, (double)(totalKeysWritten - estimatedKeys) / (double)totalKeysWritten});
            if (this.offline) {
                Refs.release(Refs.selfRefs(newSStables));
            }
        }
    }

    @Override
    public CompactionAwareWriter getCompactionAwareWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction transaction, Set<SSTableReader> nonExpiredSSTables) {
        return new DefaultCompactionWriter(cfs, directories, transaction, nonExpiredSSTables, this.offline, this.keepOriginals, this.getLevel());
    }

    public static String updateCompactionHistory(String keyspaceName, String columnFamilyName, long[] mergedRowCounts, long startSize, long endSize) {
        StringBuilder mergeSummary = new StringBuilder(mergedRowCounts.length * 10);
        HashMap<Integer, Long> mergedRows = new HashMap<Integer, Long>();
        for (int i = 0; i < mergedRowCounts.length; ++i) {
            long count = mergedRowCounts[i];
            if (count == 0L) continue;
            int rows = i + 1;
            mergeSummary.append(String.format("%d:%d, ", rows, count));
            mergedRows.put(rows, count);
        }
        SystemKeyspace.updateCompactionHistory(keyspaceName, columnFamilyName, System.currentTimeMillis(), startSize, endSize, mergedRows);
        return mergeSummary.toString();
    }

    protected Directories getDirectories() {
        return this.cfs.getDirectories();
    }

    public static long getMinRepairedAt(Set<SSTableReader> actuallyCompact) {
        long minRepairedAt = Long.MAX_VALUE;
        for (SSTableReader sstable : actuallyCompact) {
            minRepairedAt = Math.min(minRepairedAt, sstable.getSSTableMetadata().repairedAt);
        }
        if (minRepairedAt == Long.MAX_VALUE) {
            return 0L;
        }
        return minRepairedAt;
    }

    protected void checkAvailableDiskSpace(long estimatedSSTables, long expectedWriteSize) {
        while (!this.getDirectories().hasAvailableDiskSpace(estimatedSSTables, expectedWriteSize)) {
            if (this.reduceScopeForLimitedSpace()) continue;
            throw new RuntimeException(String.format("Not enough space for compaction, estimated sstables = %d, expected write size = %d", estimatedSSTables, expectedWriteSize));
        }
    }

    protected int getLevel() {
        return 0;
    }

    protected CompactionController getCompactionController(Set<SSTableReader> toCompact) {
        return new CompactionController(this.cfs, toCompact, this.gcBefore);
    }

    protected boolean partialCompactionsAcceptable() {
        return !this.isUserDefined;
    }

    public static long getMaxDataAge(Collection<SSTableReader> sstables) {
        long max = 0L;
        for (SSTableReader sstable : sstables) {
            if (sstable.maxDataAge <= max) continue;
            max = sstable.maxDataAge;
        }
        return max;
    }
}

