/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.cassandra.serializers.AbstractTextSerializer;
import org.apache.cassandra.serializers.MarshalException;

public class UTF8Serializer
extends AbstractTextSerializer {
    public static final UTF8Serializer instance = new UTF8Serializer();

    private UTF8Serializer() {
        super(StandardCharsets.UTF_8);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (!UTF8Validator.validate(bytes)) {
            throw new MarshalException("String didn't validate.");
        }
    }

    static class UTF8Validator {
        UTF8Validator() {
        }

        static boolean validate(ByteBuffer buf) {
            buf = buf.slice();
            byte b = 0;
            State state = State.START;
            block10: while (buf.remaining() > 0) {
                b = buf.get();
                switch (state) {
                    case START: {
                        if (b >= 0) {
                            if (b <= 127) continue block10;
                            return false;
                        }
                        if (b >> 5 == -2) {
                            if (b == -64) {
                                state = State.TWO_80;
                            } else if ((b & 0x1E) == 0) {
                                return false;
                            }
                            state = State.TWO;
                            continue block10;
                        }
                        if (b >> 4 == -2) {
                            if (b == -32) {
                                state = State.THREE_a0bf;
                                continue block10;
                            }
                            state = State.THREE_80bf_2;
                            continue block10;
                        }
                        if (b >> 3 == -2) {
                            if (b == -16) {
                                state = State.FOUR_90bf;
                                continue block10;
                            }
                            state = State.FOUR_80bf_3;
                            continue block10;
                        }
                        return false;
                    }
                    case TWO: {
                        if ((b & 0xC0) != 128) {
                            return false;
                        }
                        state = State.START;
                        continue block10;
                    }
                    case TWO_80: {
                        if (b != -128) {
                            return false;
                        }
                        state = State.START;
                        continue block10;
                    }
                    case THREE_a0bf: {
                        if ((b & 0xE0) == 128) {
                            return false;
                        }
                        state = State.THREE_80bf_1;
                        continue block10;
                    }
                    case THREE_80bf_1: {
                        if ((b & 0xC0) != 128) {
                            return false;
                        }
                        state = State.START;
                        continue block10;
                    }
                    case THREE_80bf_2: {
                        if ((b & 0xC0) != 128) {
                            return false;
                        }
                        state = State.THREE_80bf_1;
                        continue block10;
                    }
                    case FOUR_90bf: {
                        if ((b & 0x30) == 0) {
                            return false;
                        }
                        state = State.THREE_80bf_2;
                        continue block10;
                    }
                    case FOUR_80bf_3: {
                        if ((b & 0xC0) != 128) {
                            return false;
                        }
                        state = State.THREE_80bf_2;
                        continue block10;
                    }
                }
                return false;
            }
            return state == State.START;
        }

        static enum State {
            START,
            TWO,
            TWO_80,
            THREE_a0bf,
            THREE_80bf_1,
            THREE_80bf_2,
            FOUR_90bf,
            FOUR_80bf_3;

        }
    }
}

