/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.tracing.Tracing;

public class ReadCommandVerbHandler
implements IVerbHandler<ReadCommand> {
    protected IVersionedSerializer<ReadResponse> serializer() {
        return ReadResponse.serializer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doVerb(MessageIn<ReadCommand> message, int id) {
        void var4_10;
        if (StorageService.instance.isBootstrapMode()) {
            throw new RuntimeException("Cannot service reads while bootstrapping!");
        }
        ReadCommand command = (ReadCommand)message.payload;
        command.setMonitoringTime(message.constructionTime, message.getTimeout());
        try (ReadExecutionController executionController = command.executionController();
             UnfilteredPartitionIterator iterator = command.executeLocally(executionController);){
            ReadResponse response = command.createResponse(iterator, command.columnFilter());
        }
        if (!command.complete()) {
            Tracing.trace("Discarding partial response to {} (timed out)", (Object)message.from);
            MessagingService.instance().incrementDroppedMessages(message, System.currentTimeMillis() - message.constructionTime.timestamp);
            return;
        }
        Tracing.trace("Enqueuing response to {}", (Object)message.from);
        MessageOut<ReadResponse> reply = new MessageOut<ReadResponse>(MessagingService.Verb.REQUEST_RESPONSE, (ReadResponse)var4_10, ReadResponse.serializer);
        MessagingService.instance().sendReply(reply, id, message.from);
    }
}

