/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.DebuggableScheduledThreadPoolExecutor;

public class ScheduledExecutors {
    public static final DebuggableScheduledThreadPoolExecutor scheduledFastTasks = new DebuggableScheduledThreadPoolExecutor("ScheduledFastTasks");
    public static final DebuggableScheduledThreadPoolExecutor scheduledTasks = new DebuggableScheduledThreadPoolExecutor("ScheduledTasks");
    public static final DebuggableScheduledThreadPoolExecutor nonPeriodicTasks = new DebuggableScheduledThreadPoolExecutor("NonPeriodicTasks");
    public static final DebuggableScheduledThreadPoolExecutor optionalTasks = new DebuggableScheduledThreadPoolExecutor("OptionalTasks");

    @VisibleForTesting
    public static void shutdownAndWait() throws InterruptedException {
        ExecutorService[] executors;
        for (ExecutorService executor : executors = new ExecutorService[]{scheduledFastTasks, scheduledTasks, nonPeriodicTasks, optionalTasks}) {
            executor.shutdownNow();
        }
        for (ExecutorService executor : executors) {
            executor.awaitTermination(60L, TimeUnit.SECONDS);
        }
    }
}

