/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.codahale.metrics.Histogram;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.IndexInfo;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.TrackedDataInputPlus;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.vint.VIntCoding;
import org.github.jamm.Unmetered;

public class RowIndexEntry<T>
implements IMeasurableMemory {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new RowIndexEntry(0L));
    static final int CACHE_NOT_INDEXED = 0;
    static final int CACHE_INDEXED = 1;
    static final int CACHE_INDEXED_SHALLOW = 2;
    static final Histogram indexEntrySizeHistogram;
    static final Histogram indexInfoCountHistogram;
    static final Histogram indexInfoGetsHistogram;
    public final long position;

    public RowIndexEntry(long position) {
        this.position = position;
    }

    public boolean isIndexed() {
        return this.columnsIndexCount() > 1;
    }

    public boolean indexOnHeap() {
        return false;
    }

    public DeletionTime deletionTime() {
        throw new UnsupportedOperationException();
    }

    public long headerLength() {
        throw new UnsupportedOperationException();
    }

    public int columnsIndexCount() {
        return 0;
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE;
    }

    public static RowIndexEntry<IndexInfo> create(long dataFilePosition, long indexFilePosition, DeletionTime deletionTime, long headerLength, int columnIndexCount, int indexedPartSize, List<IndexInfo> indexSamples, int[] offsets, ISerializer<IndexInfo> idxInfoSerializer) {
        if (indexSamples != null && indexSamples.size() > 1) {
            return new IndexedEntry(dataFilePosition, deletionTime, headerLength, indexSamples.toArray(new IndexInfo[indexSamples.size()]), offsets, indexedPartSize, idxInfoSerializer);
        }
        if (columnIndexCount > 1) {
            return new ShallowIndexedEntry(dataFilePosition, indexFilePosition, deletionTime, headerLength, columnIndexCount, indexedPartSize, idxInfoSerializer);
        }
        return new RowIndexEntry<IndexInfo>(dataFilePosition);
    }

    public IndexInfoRetriever openWithIndex(FileHandle indexFile) {
        return null;
    }

    private static int serializedSize(DeletionTime deletionTime, long headerLength, int columnIndexCount) {
        return TypeSizes.sizeofUnsignedVInt(headerLength) + (int)DeletionTime.serializer.serializedSize(deletionTime) + TypeSizes.sizeofUnsignedVInt(columnIndexCount);
    }

    public void serialize(DataOutputPlus out, IndexInfo.Serializer idxInfoSerializer, ByteBuffer indexInfo) throws IOException {
        out.writeUnsignedVInt(this.position);
        out.writeUnsignedVInt(0L);
    }

    public void serializeForCache(DataOutputPlus out) throws IOException {
        out.writeUnsignedVInt(this.position);
        out.writeByte(0);
    }

    static {
        DefaultNameFactory factory = new DefaultNameFactory("Index", "RowIndexEntry");
        indexEntrySizeHistogram = CassandraMetricsRegistry.Metrics.histogram(factory.createMetricName("IndexedEntrySize"), false);
        indexInfoCountHistogram = CassandraMetricsRegistry.Metrics.histogram(factory.createMetricName("IndexInfoCount"), false);
        indexInfoGetsHistogram = CassandraMetricsRegistry.Metrics.histogram(factory.createMetricName("IndexInfoGets"), false);
    }

    private static abstract class FileIndexInfoRetriever
    implements IndexInfoRetriever {
        final long indexInfoFilePosition;
        final ISerializer<IndexInfo> idxInfoSerializer;
        final FileDataInput indexReader;
        int retrievals;

        FileIndexInfoRetriever(long indexInfoFilePosition, FileDataInput indexReader, ISerializer<IndexInfo> idxInfoSerializer) {
            this.indexInfoFilePosition = indexInfoFilePosition;
            this.idxInfoSerializer = idxInfoSerializer;
            this.indexReader = indexReader;
        }

        @Override
        public final IndexInfo columnsIndex(int index) throws IOException {
            return this.fetchIndex(index);
        }

        abstract IndexInfo fetchIndex(int var1) throws IOException;

        @Override
        public void close() throws IOException {
            this.indexReader.close();
            indexInfoGetsHistogram.update(this.retrievals);
        }
    }

    public static interface IndexInfoRetriever
    extends AutoCloseable {
        public IndexInfo columnsIndex(int var1) throws IOException;

        @Override
        public void close() throws IOException;
    }

    private static final class ShallowInfoRetriever
    extends FileIndexInfoRetriever {
        private final int offsetsOffset;

        private ShallowInfoRetriever(long indexInfoFilePosition, int offsetsOffset, FileDataInput indexReader, ISerializer<IndexInfo> idxInfoSerializer) {
            super(indexInfoFilePosition, indexReader, idxInfoSerializer);
            this.offsetsOffset = offsetsOffset;
        }

        @Override
        IndexInfo fetchIndex(int index) throws IOException {
            ++this.retrievals;
            this.indexReader.seek(this.indexInfoFilePosition + (long)this.offsetsOffset + (long)(index * TypeSizes.sizeof(0)));
            int indexInfoPos = this.indexReader.readInt();
            this.indexReader.seek(this.indexInfoFilePosition + (long)indexInfoPos);
            return (IndexInfo)this.idxInfoSerializer.deserialize(this.indexReader);
        }
    }

    private static final class ShallowIndexedEntry
    extends RowIndexEntry<IndexInfo> {
        private static final long BASE_SIZE = ObjectSizes.measure(new ShallowIndexedEntry(0L, 0L, DeletionTime.LIVE, 0L, 10, 0, null));
        private final long indexFilePosition;
        private final DeletionTime deletionTime;
        private final long headerLength;
        private final int columnsIndexCount;
        private final int indexedPartSize;
        private final int offsetsOffset;
        @Unmetered
        private final ISerializer<IndexInfo> idxInfoSerializer;
        private final int fieldsSerializedSize;

        private ShallowIndexedEntry(long dataFilePosition, long indexFilePosition, DeletionTime deletionTime, long headerLength, int columnIndexCount, int indexedPartSize, ISerializer<IndexInfo> idxInfoSerializer) {
            super(dataFilePosition);
            assert (columnIndexCount > 1);
            this.indexFilePosition = indexFilePosition;
            this.headerLength = headerLength;
            this.deletionTime = deletionTime;
            this.columnsIndexCount = columnIndexCount;
            this.indexedPartSize = indexedPartSize;
            this.idxInfoSerializer = idxInfoSerializer;
            this.fieldsSerializedSize = RowIndexEntry.serializedSize(deletionTime, headerLength, columnIndexCount);
            this.offsetsOffset = indexedPartSize + this.fieldsSerializedSize - this.columnsIndexCount * TypeSizes.sizeof(0);
        }

        private ShallowIndexedEntry(long dataFilePosition, DataInputPlus in, IndexInfo.Serializer idxInfoSerializer) throws IOException {
            super(dataFilePosition);
            this.indexFilePosition = in.readUnsignedVInt();
            this.headerLength = in.readUnsignedVInt();
            this.deletionTime = DeletionTime.serializer.deserialize(in);
            this.columnsIndexCount = (int)in.readUnsignedVInt();
            this.indexedPartSize = (int)in.readUnsignedVInt();
            this.idxInfoSerializer = idxInfoSerializer;
            this.fieldsSerializedSize = RowIndexEntry.serializedSize(this.deletionTime, this.headerLength, this.columnsIndexCount);
            this.offsetsOffset = this.indexedPartSize + this.fieldsSerializedSize - this.columnsIndexCount * TypeSizes.sizeof(0);
        }

        @Override
        public int columnsIndexCount() {
            return this.columnsIndexCount;
        }

        @Override
        public DeletionTime deletionTime() {
            return this.deletionTime;
        }

        @Override
        public long headerLength() {
            return this.headerLength;
        }

        @Override
        public IndexInfoRetriever openWithIndex(FileHandle indexFile) {
            indexEntrySizeHistogram.update(this.indexedPartSize + this.fieldsSerializedSize);
            indexInfoCountHistogram.update(this.columnsIndexCount);
            return new ShallowInfoRetriever(this.indexFilePosition + (long)VIntCoding.computeUnsignedVIntSize(this.position) + (long)VIntCoding.computeUnsignedVIntSize(this.indexedPartSize + this.fieldsSerializedSize) + (long)this.fieldsSerializedSize, this.offsetsOffset - this.fieldsSerializedSize, indexFile.createReader(), this.idxInfoSerializer);
        }

        @Override
        public long unsharedHeapSize() {
            return BASE_SIZE;
        }

        @Override
        public void serialize(DataOutputPlus out, IndexInfo.Serializer idxInfoSerializer, ByteBuffer indexInfo) throws IOException {
            out.writeUnsignedVInt(this.position);
            out.writeUnsignedVInt(this.fieldsSerializedSize + indexInfo.limit());
            out.writeUnsignedVInt(this.headerLength);
            DeletionTime.serializer.serialize(this.deletionTime, out);
            out.writeUnsignedVInt(this.columnsIndexCount);
            out.write(indexInfo);
        }

        static long deserializePositionAndSkip(DataInputPlus in) throws IOException {
            long position = in.readUnsignedVInt();
            int size = (int)in.readUnsignedVInt();
            if (size > 0) {
                in.skipBytesFully(size);
            }
            return position;
        }

        @Override
        public void serializeForCache(DataOutputPlus out) throws IOException {
            out.writeUnsignedVInt(this.position);
            out.writeByte(2);
            out.writeUnsignedVInt(this.indexFilePosition);
            out.writeUnsignedVInt(this.headerLength);
            DeletionTime.serializer.serialize(this.deletionTime, out);
            out.writeUnsignedVInt(this.columnsIndexCount);
            out.writeUnsignedVInt(this.indexedPartSize);
        }

        static void skipForCache(DataInputPlus in) throws IOException {
            in.readUnsignedVInt();
            in.readUnsignedVInt();
            DeletionTime.serializer.skip(in);
            in.readUnsignedVInt();
            in.readUnsignedVInt();
        }
    }

    private static final class IndexedEntry
    extends RowIndexEntry<IndexInfo> {
        private static final long BASE_SIZE = ObjectSizes.measure(new IndexedEntry(0L, DeletionTime.LIVE, 0L, null, null, 0, null));
        private final DeletionTime deletionTime;
        private final long headerLength;
        private final IndexInfo[] columnsIndex;
        private final int[] offsets;
        private final int indexedPartSize;
        @Unmetered
        private final ISerializer<IndexInfo> idxInfoSerializer;

        private IndexedEntry(long dataFilePosition, DeletionTime deletionTime, long headerLength, IndexInfo[] columnsIndex, int[] offsets, int indexedPartSize, ISerializer<IndexInfo> idxInfoSerializer) {
            super(dataFilePosition);
            this.headerLength = headerLength;
            this.deletionTime = deletionTime;
            this.columnsIndex = columnsIndex;
            this.offsets = offsets;
            this.indexedPartSize = indexedPartSize;
            this.idxInfoSerializer = idxInfoSerializer;
        }

        private IndexedEntry(long dataFilePosition, DataInputPlus in, DeletionTime deletionTime, long headerLength, int columnIndexCount, IndexInfo.Serializer idxInfoSerializer, Version version, int indexedPartSize) throws IOException {
            super(dataFilePosition);
            this.headerLength = headerLength;
            this.deletionTime = deletionTime;
            int columnsIndexCount = columnIndexCount;
            this.columnsIndex = new IndexInfo[columnsIndexCount];
            for (int i = 0; i < columnsIndexCount; ++i) {
                this.columnsIndex[i] = idxInfoSerializer.deserialize(in);
            }
            int[] offsets = null;
            if (version.storeRows()) {
                offsets = new int[this.columnsIndex.length];
                for (int i = 0; i < offsets.length; ++i) {
                    offsets[i] = in.readInt();
                }
            }
            this.offsets = offsets;
            this.indexedPartSize = indexedPartSize;
            this.idxInfoSerializer = idxInfoSerializer;
        }

        private IndexedEntry(long dataFilePosition, DataInputPlus in, IndexInfo.Serializer idxInfoSerializer, Version version) throws IOException {
            super(dataFilePosition);
            this.headerLength = in.readUnsignedVInt();
            this.deletionTime = DeletionTime.serializer.deserialize(in);
            int columnsIndexCount = (int)in.readUnsignedVInt();
            TrackedDataInputPlus trackedIn = new TrackedDataInputPlus(in);
            this.columnsIndex = new IndexInfo[columnsIndexCount];
            for (int i = 0; i < columnsIndexCount; ++i) {
                this.columnsIndex[i] = idxInfoSerializer.deserialize(trackedIn);
            }
            this.offsets = null;
            this.indexedPartSize = (int)trackedIn.getBytesRead();
            this.idxInfoSerializer = idxInfoSerializer;
        }

        private IndexedEntry(long dataFilePosition, DataInputPlus in, IndexInfo.Serializer idxInfoSerializer) throws IOException {
            super(dataFilePosition);
            long headerLength = 0L;
            this.deletionTime = DeletionTime.serializer.deserialize(in);
            int columnsIndexCount = in.readInt();
            TrackedDataInputPlus trackedIn = new TrackedDataInputPlus(in);
            this.columnsIndex = new IndexInfo[columnsIndexCount];
            for (int i = 0; i < columnsIndexCount; ++i) {
                this.columnsIndex[i] = idxInfoSerializer.deserialize(trackedIn);
                if (i != 0) continue;
                headerLength = this.columnsIndex[i].offset;
            }
            this.headerLength = headerLength;
            this.offsets = null;
            this.indexedPartSize = (int)trackedIn.getBytesRead();
            this.idxInfoSerializer = idxInfoSerializer;
        }

        @Override
        public boolean indexOnHeap() {
            return true;
        }

        @Override
        public int columnsIndexCount() {
            return this.columnsIndex.length;
        }

        @Override
        public DeletionTime deletionTime() {
            return this.deletionTime;
        }

        @Override
        public long headerLength() {
            return this.headerLength;
        }

        @Override
        public IndexInfoRetriever openWithIndex(FileHandle indexFile) {
            indexEntrySizeHistogram.update(RowIndexEntry.serializedSize(this.deletionTime, this.headerLength, this.columnsIndex.length) + this.indexedPartSize);
            indexInfoCountHistogram.update(this.columnsIndex.length);
            return new IndexInfoRetriever(){
                private int retrievals;

                @Override
                public IndexInfo columnsIndex(int index) {
                    ++this.retrievals;
                    return columnsIndex[index];
                }

                @Override
                public void close() {
                    indexInfoGetsHistogram.update(this.retrievals);
                }
            };
        }

        @Override
        public long unsharedHeapSize() {
            long entrySize = 0L;
            for (IndexInfo idx : this.columnsIndex) {
                entrySize += idx.unsharedHeapSize();
            }
            return BASE_SIZE + entrySize + ObjectSizes.sizeOfReferenceArray(this.columnsIndex.length);
        }

        @Override
        public void serialize(DataOutputPlus out, IndexInfo.Serializer idxInfoSerializer, ByteBuffer indexInfo) throws IOException {
            assert (this.indexedPartSize != Integer.MIN_VALUE);
            out.writeUnsignedVInt(this.position);
            out.writeUnsignedVInt(RowIndexEntry.serializedSize(this.deletionTime, this.headerLength, this.columnsIndex.length) + this.indexedPartSize);
            out.writeUnsignedVInt(this.headerLength);
            DeletionTime.serializer.serialize(this.deletionTime, out);
            out.writeUnsignedVInt(this.columnsIndex.length);
            for (IndexInfo info : this.columnsIndex) {
                idxInfoSerializer.serialize(info, out);
            }
            for (int offset : this.offsets) {
                out.writeInt(offset);
            }
        }

        @Override
        public void serializeForCache(DataOutputPlus out) throws IOException {
            out.writeUnsignedVInt(this.position);
            out.writeByte(1);
            out.writeUnsignedVInt(this.headerLength);
            DeletionTime.serializer.serialize(this.deletionTime, out);
            out.writeUnsignedVInt(this.columnsIndexCount());
            for (IndexInfo indexInfo : this.columnsIndex) {
                this.idxInfoSerializer.serialize(indexInfo, out);
            }
        }

        static void skipForCache(DataInputPlus in) throws IOException {
            in.readUnsignedVInt();
            DeletionTime.serializer.skip(in);
            in.readUnsignedVInt();
            in.readUnsignedVInt();
        }
    }

    private static final class LegacyIndexInfoRetriever
    extends FileIndexInfoRetriever {
        private final int[] offsets;

        private LegacyIndexInfoRetriever(long indexFilePosition, int[] offsets, FileDataInput reader, IndexInfo.Serializer idxInfoSerializer) {
            super(indexFilePosition, reader, idxInfoSerializer);
            this.offsets = offsets;
        }

        @Override
        IndexInfo fetchIndex(int index) throws IOException {
            ++this.retrievals;
            this.indexReader.seek(this.indexInfoFilePosition + (long)this.offsets[index]);
            return (IndexInfo)this.idxInfoSerializer.deserialize(this.indexReader);
        }
    }

    private static final class LegacyShallowIndexedEntry
    extends RowIndexEntry<IndexInfo> {
        private static final long BASE_SIZE = ObjectSizes.measure(new LegacyShallowIndexedEntry(0L, 0L, DeletionTime.LIVE, 0L, new int[0], null, 0));
        private final long indexFilePosition;
        private final int[] offsets;
        @Unmetered
        private final IndexInfo.Serializer idxInfoSerializer;
        private final DeletionTime deletionTime;
        private final long headerLength;
        private final int serializedSize;

        private LegacyShallowIndexedEntry(long dataFilePosition, long indexFilePosition, DeletionTime deletionTime, long headerLength, int[] offsets, IndexInfo.Serializer idxInfoSerializer, int serializedSize) {
            super(dataFilePosition);
            this.deletionTime = deletionTime;
            this.headerLength = headerLength;
            this.indexFilePosition = indexFilePosition;
            this.offsets = offsets;
            this.idxInfoSerializer = idxInfoSerializer;
            this.serializedSize = serializedSize;
        }

        @Override
        public DeletionTime deletionTime() {
            return this.deletionTime;
        }

        @Override
        public long headerLength() {
            return this.headerLength;
        }

        @Override
        public long unsharedHeapSize() {
            return BASE_SIZE + (long)(this.offsets.length * TypeSizes.sizeof(0));
        }

        @Override
        public int columnsIndexCount() {
            return this.offsets.length;
        }

        @Override
        public void serialize(DataOutputPlus out, IndexInfo.Serializer idxInfoSerializer, ByteBuffer indexInfo) {
            throw new UnsupportedOperationException("serializing legacy index entries is not supported");
        }

        @Override
        public void serializeForCache(DataOutputPlus out) {
            throw new UnsupportedOperationException("serializing legacy index entries is not supported");
        }

        @Override
        public IndexInfoRetriever openWithIndex(FileHandle indexFile) {
            int fieldsSize = (int)DeletionTime.serializer.serializedSize(this.deletionTime) + TypeSizes.sizeof(0);
            indexEntrySizeHistogram.update(this.serializedSize);
            indexInfoCountHistogram.update(this.offsets.length);
            return new LegacyIndexInfoRetriever(this.indexFilePosition + (long)TypeSizes.sizeof(0L) + (long)TypeSizes.sizeof(0) + (long)fieldsSize, this.offsets, indexFile.createReader(), this.idxInfoSerializer);
        }

        public static RowIndexEntry<IndexInfo> deserialize(DataInputPlus in, long indexFilePosition, IndexInfo.Serializer idxInfoSerializer) throws IOException {
            long dataFilePosition = in.readLong();
            int size = in.readInt();
            if (size == 0) {
                return new RowIndexEntry<IndexInfo>(dataFilePosition);
            }
            if (size <= DatabaseDescriptor.getColumnIndexCacheSize()) {
                return new IndexedEntry(dataFilePosition, in, idxInfoSerializer);
            }
            DeletionTime deletionTime = DeletionTime.serializer.deserialize(in);
            int entries = in.readInt();
            int[] offsets = new int[entries];
            TrackedDataInputPlus tracked = new TrackedDataInputPlus(in);
            long start = tracked.getBytesRead();
            long headerLength = 0L;
            for (int i = 0; i < entries; ++i) {
                offsets[i] = (int)(tracked.getBytesRead() - start);
                if (i == 0) {
                    IndexInfo info = idxInfoSerializer.deserialize(tracked);
                    headerLength = info.offset;
                    continue;
                }
                idxInfoSerializer.skip(tracked);
            }
            return new LegacyShallowIndexedEntry(dataFilePosition, indexFilePosition, deletionTime, headerLength, offsets, idxInfoSerializer, size);
        }

        static long deserializePositionAndSkip(DataInputPlus in) throws IOException {
            long position = in.readLong();
            int size = in.readInt();
            if (size > 0) {
                in.skipBytesFully(size);
            }
            return position;
        }
    }

    public static final class Serializer
    implements IndexSerializer<IndexInfo> {
        private final IndexInfo.Serializer idxInfoSerializer;
        private final Version version;

        public Serializer(CFMetaData metadata, Version version, SerializationHeader header) {
            this.idxInfoSerializer = metadata.serializers().indexInfoSerializer(version, header);
            this.version = version;
        }

        public IndexInfo.Serializer indexInfoSerializer() {
            return this.idxInfoSerializer;
        }

        @Override
        public void serialize(RowIndexEntry<IndexInfo> rie, DataOutputPlus out, ByteBuffer indexInfo) throws IOException {
            assert (this.version.storeRows()) : "We read old index files but we should never write them";
            rie.serialize(out, this.idxInfoSerializer, indexInfo);
        }

        @Override
        public void serializeForCache(RowIndexEntry<IndexInfo> rie, DataOutputPlus out) throws IOException {
            assert (this.version.storeRows());
            rie.serializeForCache(out);
        }

        @Override
        public RowIndexEntry<IndexInfo> deserializeForCache(DataInputPlus in) throws IOException {
            assert (this.version.storeRows());
            long position = in.readUnsignedVInt();
            switch (in.readByte()) {
                case 0: {
                    return new RowIndexEntry<IndexInfo>(position);
                }
                case 1: {
                    return new IndexedEntry(position, in, this.idxInfoSerializer, this.version);
                }
                case 2: {
                    return new ShallowIndexedEntry(position, in, this.idxInfoSerializer);
                }
            }
            throw new AssertionError();
        }

        public static void skipForCache(DataInputPlus in, Version version) throws IOException {
            assert (version.storeRows());
            in.readUnsignedVInt();
            switch (in.readByte()) {
                case 0: {
                    break;
                }
                case 1: {
                    IndexedEntry.skipForCache(in);
                    break;
                }
                case 2: {
                    ShallowIndexedEntry.skipForCache(in);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        @Override
        public RowIndexEntry<IndexInfo> deserialize(DataInputPlus in, long indexFilePosition) throws IOException {
            if (!this.version.storeRows()) {
                return LegacyShallowIndexedEntry.deserialize(in, indexFilePosition, this.idxInfoSerializer);
            }
            long position = in.readUnsignedVInt();
            int size = (int)in.readUnsignedVInt();
            if (size == 0) {
                return new RowIndexEntry<IndexInfo>(position);
            }
            long headerLength = in.readUnsignedVInt();
            DeletionTime deletionTime = DeletionTime.serializer.deserialize(in);
            int columnsIndexCount = (int)in.readUnsignedVInt();
            int indexedPartSize = size - RowIndexEntry.serializedSize(deletionTime, headerLength, columnsIndexCount);
            if (size <= DatabaseDescriptor.getColumnIndexCacheSize()) {
                return new IndexedEntry(position, in, deletionTime, headerLength, columnsIndexCount, this.idxInfoSerializer, this.version, indexedPartSize);
            }
            in.skipBytes(indexedPartSize);
            return new ShallowIndexedEntry(position, indexFilePosition, deletionTime, headerLength, columnsIndexCount, indexedPartSize, this.idxInfoSerializer);
        }

        @Override
        public long deserializePositionAndSkip(DataInputPlus in) throws IOException {
            if (!this.version.storeRows()) {
                return LegacyShallowIndexedEntry.deserializePositionAndSkip(in);
            }
            return ShallowIndexedEntry.deserializePositionAndSkip(in);
        }

        public static long readPosition(DataInputPlus in, Version version) throws IOException {
            return version.storeRows() ? in.readUnsignedVInt() : in.readLong();
        }

        public static void skip(DataInputPlus in, Version version) throws IOException {
            Serializer.readPosition(in, version);
            Serializer.skipPromotedIndex(in, version);
        }

        private static void skipPromotedIndex(DataInputPlus in, Version version) throws IOException {
            int size;
            int n = size = version.storeRows() ? (int)in.readUnsignedVInt() : in.readInt();
            if (size <= 0) {
                return;
            }
            in.skipBytesFully(size);
        }

        public static void serializeOffsets(DataOutputBuffer out, int[] indexOffsets, int columnIndexCount) throws IOException {
            for (int i = 0; i < columnIndexCount; ++i) {
                out.writeInt(indexOffsets[i]);
            }
        }
    }

    public static interface IndexSerializer<T> {
        public void serialize(RowIndexEntry<T> var1, DataOutputPlus var2, ByteBuffer var3) throws IOException;

        public RowIndexEntry<T> deserialize(DataInputPlus var1, long var2) throws IOException;

        public void serializeForCache(RowIndexEntry<T> var1, DataOutputPlus var2) throws IOException;

        public RowIndexEntry<T> deserializeForCache(DataInputPlus var1) throws IOException;

        public long deserializePositionAndSkip(DataInputPlus var1) throws IOException;

        public ISerializer<T> indexInfoSerializer();
    }
}

