/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.metadata;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.IMetadataSerializer;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.BufferedDataOutputStreamPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataSerializer
implements IMetadataSerializer {
    private static final Logger logger = LoggerFactory.getLogger(MetadataSerializer.class);

    @Override
    public void serialize(Map<MetadataType, MetadataComponent> components, DataOutputPlus out, Version version) throws IOException {
        ArrayList sortedComponents = Lists.newArrayList(components.values());
        Collections.sort(sortedComponents);
        out.writeInt(components.size());
        int lastPosition = 4 + 8 * sortedComponents.size();
        for (MetadataComponent component : sortedComponents) {
            MetadataType type = component.getType();
            out.writeInt(type.ordinal());
            out.writeInt(lastPosition);
            lastPosition += type.serializer.serializedSize(version, component);
        }
        for (MetadataComponent component : sortedComponents) {
            component.getType().serializer.serialize(version, component, out);
        }
    }

    @Override
    public Map<MetadataType, MetadataComponent> deserialize(Descriptor descriptor, EnumSet<MetadataType> types) throws IOException {
        EnumMap<MetadataType, MetadataComponent> components;
        logger.trace("Load metadata for {}", (Object)descriptor);
        File statsFile = new File(descriptor.filenameFor(Component.STATS));
        if (!statsFile.exists()) {
            logger.trace("No sstable stats for {}", (Object)descriptor);
            components = new EnumMap<MetadataType, StatsMetadata>(MetadataType.class);
            components.put(MetadataType.STATS, MetadataCollector.defaultStatsMetadata());
        } else {
            try (RandomAccessReader r = RandomAccessReader.open(statsFile);){
                components = this.deserialize(descriptor, r, types);
            }
        }
        return components;
    }

    @Override
    public MetadataComponent deserialize(Descriptor descriptor, MetadataType type) throws IOException {
        return this.deserialize(descriptor, EnumSet.of(type)).get((Object)type);
    }

    public Map<MetadataType, MetadataComponent> deserialize(Descriptor descriptor, FileDataInput in, EnumSet<MetadataType> types) throws IOException {
        EnumMap<MetadataType, MetadataComponent> components = new EnumMap<MetadataType, MetadataComponent>(MetadataType.class);
        int numComponents = in.readInt();
        EnumMap<MetadataType, Integer> toc = new EnumMap<MetadataType, Integer>(MetadataType.class);
        MetadataType[] values = MetadataType.values();
        for (int i = 0; i < numComponents; ++i) {
            toc.put(values[in.readInt()], in.readInt());
        }
        for (MetadataType type : types) {
            Integer offset = (Integer)toc.get((Object)type);
            if (offset == null) continue;
            in.seek(offset.intValue());
            MetadataComponent component = type.serializer.deserialize(descriptor.version, in);
            components.put(type, component);
        }
        return components;
    }

    @Override
    public void mutateLevel(Descriptor descriptor, int newLevel) throws IOException {
        logger.trace("Mutating {} to level {}", (Object)descriptor.filenameFor(Component.STATS), (Object)newLevel);
        Map<MetadataType, MetadataComponent> currentComponents = this.deserialize(descriptor, EnumSet.allOf(MetadataType.class));
        StatsMetadata stats = (StatsMetadata)currentComponents.remove((Object)MetadataType.STATS);
        currentComponents.put(MetadataType.STATS, stats.mutateLevel(newLevel));
        this.rewriteSSTableMetadata(descriptor, currentComponents);
    }

    @Override
    public void mutateRepairedAt(Descriptor descriptor, long newRepairedAt) throws IOException {
        logger.trace("Mutating {} to repairedAt time {}", (Object)descriptor.filenameFor(Component.STATS), (Object)newRepairedAt);
        Map<MetadataType, MetadataComponent> currentComponents = this.deserialize(descriptor, EnumSet.allOf(MetadataType.class));
        StatsMetadata stats = (StatsMetadata)currentComponents.remove((Object)MetadataType.STATS);
        currentComponents.put(MetadataType.STATS, stats.mutateRepairedAt(newRepairedAt));
        this.rewriteSSTableMetadata(descriptor, currentComponents);
    }

    @Override
    public void rewriteSSTableMetadata(Descriptor descriptor, Map<MetadataType, MetadataComponent> currentComponents) throws IOException {
        String filePath = descriptor.tmpFilenameFor(Component.STATS);
        try (BufferedDataOutputStreamPlus out = new BufferedDataOutputStreamPlus(new FileOutputStream(filePath));){
            this.serialize(currentComponents, out, descriptor.version);
            ((OutputStream)out).flush();
        }
        if (FBUtilities.isWindows) {
            FileUtils.delete(descriptor.filenameFor(Component.STATS));
        }
        FileUtils.renameWithConfirm(filePath, descriptor.filenameFor(Component.STATS));
    }
}

