/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.ViewDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.AlterTableStatementColumn;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.cql3.statements.TableAttributes;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.EmptyType;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.sstable.format.VersionAndType;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Indexes;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterTableStatement
extends SchemaAlteringStatement {
    private static final Logger logger = LoggerFactory.getLogger(AlterTableStatement.class);
    private static final NoSpamLogger noSpamLogger = NoSpamLogger.getLogger(logger, 5L, TimeUnit.MINUTES);
    public final Type oType;
    private final TableAttributes attrs;
    private final Map<ColumnDefinition.Raw, ColumnDefinition.Raw> renames;
    private final List<AlterTableStatementColumn> colNameList;
    private final Long deleteTimestamp;

    public AlterTableStatement(CFName name, Type type, List<AlterTableStatementColumn> colDataList, TableAttributes attrs, Map<ColumnDefinition.Raw, ColumnDefinition.Raw> renames, Long deleteTimestamp) {
        super(name);
        this.oType = type;
        this.colNameList = colDataList;
        this.attrs = attrs;
        this.renames = renames;
        this.deleteTimestamp = deleteTimestamp;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public Event.SchemaChange announceMigration(QueryState queryState, boolean isLocalOnly) throws RequestValidationException {
        CFMetaData cfm;
        CFMetaData meta = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        if (meta.isView()) {
            throw new InvalidRequestException("Cannot use ALTER TABLE on Materialized View");
        }
        ColumnIdentifier columnName = null;
        ColumnDefinition def = null;
        CQL3Type.Raw dataType = null;
        boolean isStatic = false;
        CQL3Type validator = null;
        ArrayList<ViewDefinition> viewUpdates = null;
        Iterable<ViewDefinition> views = View.findAll(this.keyspace(), this.columnFamily());
        switch (this.oType) {
            case ALTER: {
                cfm = null;
                for (AlterTableStatementColumn colData : this.colNameList) {
                    columnName = colData.getColumnName().getIdentifier(meta);
                    def = meta.getColumnDefinition(columnName);
                    dataType = colData.getColumnType();
                    validator = dataType.prepare(this.keyspace());
                    if (!meta.isDense() || !meta.compactValueColumn().equals(def) || !(meta.compactValueColumn().type instanceof EmptyType) || validator == null) continue;
                    if (validator.getType() instanceof BytesType) {
                        cfm = meta.copyWithNewCompactValueType(validator.getType());
                        continue;
                    }
                    throw new InvalidRequestException(String.format("Compact value type can only be changed to BytesType, but %s was given.", validator.getType()));
                }
                if (cfm != null) break;
                throw new InvalidRequestException("Altering of types is not allowed");
            }
            case ADD: {
                if (meta.isCompactTable()) {
                    throw new InvalidRequestException("Cannot add new column to a COMPACT STORAGE table");
                }
                cfm = meta.copy();
                for (AlterTableStatementColumn colData : this.colNameList) {
                    columnName = colData.getColumnName().getIdentifier(cfm);
                    def = cfm.getColumnDefinition(columnName);
                    dataType = colData.getColumnType();
                    assert (dataType != null);
                    isStatic = colData.getStaticType();
                    validator = dataType.prepare(this.keyspace());
                    if (isStatic) {
                        if (!cfm.isCompound()) {
                            throw new InvalidRequestException("Static columns are not allowed in COMPACT STORAGE tables");
                        }
                        if (cfm.clusteringColumns().isEmpty()) {
                            throw new InvalidRequestException("Static columns are only useful (and thus allowed) if the table has at least one clustering column");
                        }
                    }
                    if (def != null) {
                        switch (def.kind) {
                            case PARTITION_KEY: 
                            case CLUSTERING: {
                                throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with a PRIMARY KEY part", columnName));
                            }
                        }
                        throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with an existing column", columnName));
                    }
                    AbstractType<?> type = validator.getType();
                    if (type.isCollection() && type.isMultiCell()) {
                        if (!cfm.isCompound()) {
                            throw new InvalidRequestException("Cannot use non-frozen collections in COMPACT STORAGE tables");
                        }
                        if (cfm.isSuper()) {
                            throw new InvalidRequestException("Cannot use non-frozen collections with super column families");
                        }
                    }
                    ColumnDefinition toAdd = isStatic ? ColumnDefinition.staticDef(cfm, columnName.bytes, type) : ColumnDefinition.regularDef(cfm, columnName.bytes, type);
                    CFMetaData.DroppedColumn droppedColumn = meta.getDroppedColumns().get(columnName.bytes);
                    if (null != droppedColumn) {
                        String message;
                        if (droppedColumn.kind != toAdd.kind) {
                            message = String.format("Cannot re-add previously dropped column '%s' of kind %s, incompatible with previous kind %s", new Object[]{columnName, toAdd.kind, droppedColumn.kind == null ? "UNKNOWN" : droppedColumn.kind});
                            throw new InvalidRequestException(message);
                        }
                        if (!type.isValueCompatibleWith(droppedColumn.type)) {
                            message = String.format("Cannot re-add previously dropped column '%s' of type %s, incompatible with previous type %s", columnName, type.asCQL3Type(), droppedColumn.type.asCQL3Type());
                            throw new InvalidRequestException(message);
                        }
                        if (meta.isCounter()) {
                            throw new InvalidRequestException(String.format("Cannot re-add previously dropped counter column %s", columnName));
                        }
                    }
                    cfm.addColumnDefinition(toAdd);
                    if (isStatic) continue;
                    for (ViewDefinition view : views) {
                        if (!view.includeAllColumns) continue;
                        ViewDefinition viewCopy = view.copy();
                        viewCopy.metadata.addColumnDefinition(ColumnDefinition.regularDef(viewCopy.metadata, columnName.bytes, type));
                        if (viewUpdates == null) {
                            viewUpdates = new ArrayList();
                        }
                        viewUpdates.add(viewCopy);
                    }
                }
                break;
            }
            case DROP: {
                if (!meta.isCQLTable()) {
                    throw new InvalidRequestException("Cannot drop columns from a non-CQL3 table");
                }
                cfm = meta.copy();
                for (AlterTableStatementColumn colData : this.colNameList) {
                    columnName = colData.getColumnName().getIdentifier(cfm);
                    def = cfm.getColumnDefinition(columnName);
                    if (def == null) {
                        throw new InvalidRequestException(String.format("Column %s was not found in table %s", columnName, this.columnFamily()));
                    }
                    switch (def.kind) {
                        case PARTITION_KEY: 
                        case CLUSTERING: {
                            throw new InvalidRequestException(String.format("Cannot drop PRIMARY KEY part %s", columnName));
                        }
                        case REGULAR: 
                        case STATIC: {
                            ColumnDefinition toDelete = null;
                            for (ColumnDefinition columnDef : cfm.partitionColumns()) {
                                if (!columnDef.name.equals(columnName)) continue;
                                toDelete = columnDef;
                                break;
                            }
                            assert (toDelete != null);
                            cfm.removeColumnDefinition(toDelete);
                            cfm.recordColumnDrop(toDelete, this.deleteTimestamp == null ? queryState.getTimestamp() : this.deleteTimestamp.longValue());
                        }
                    }
                    Indexes allIndexes = cfm.getIndexes();
                    if (!allIndexes.isEmpty()) {
                        ColumnFamilyStore store = Keyspace.openAndGetStore(cfm);
                        Set<IndexMetadata> dependentIndexes = store.indexManager.getDependentIndexes(def);
                        if (!dependentIndexes.isEmpty()) {
                            throw new InvalidRequestException(String.format("Cannot drop column %s because it has dependent secondary indexes (%s)", def, dependentIndexes.stream().map(i -> i.name).collect(Collectors.joining(","))));
                        }
                    }
                    if (Iterables.isEmpty(views)) continue;
                    throw new InvalidRequestException(String.format("Cannot drop column %s on base table %s with materialized views.", columnName.toString(), this.columnFamily()));
                }
                break;
            }
            case DROP_COMPACT_STORAGE: {
                if (!DatabaseDescriptor.enableDropCompactStorage()) {
                    throw new InvalidRequestException("DROP COMPACT STORAGE is disabled. Enable in cassandra.yaml to use.");
                }
                if (!meta.isCompactTable()) {
                    throw new InvalidRequestException("Cannot DROP COMPACT STORAGE on table without COMPACT STORAGE");
                }
                this.validateCanDropCompactStorage();
                cfm = meta.asNonCompact();
                break;
            }
            case OPTS: {
                if (this.attrs == null) {
                    throw new InvalidRequestException("ALTER TABLE WITH invoked, but no parameters found");
                }
                this.attrs.validate();
                cfm = meta.copy();
                TableParams params = this.attrs.asAlteredTableParams(cfm.params);
                if (!Iterables.isEmpty(views) && params.gcGraceSeconds == 0) {
                    throw new InvalidRequestException("Cannot alter gc_grace_seconds of the base table of a materialized view to 0, since this value is used to TTL undelivered updates. Setting gc_grace_seconds too low might cause undelivered updates to expire before being replayed.");
                }
                if (meta.isCounter() && params.defaultTimeToLive > 0) {
                    throw new InvalidRequestException("Cannot set default_time_to_live on a table with counters");
                }
                cfm.params(params);
                break;
            }
            case RENAME: {
                cfm = meta.copy();
                for (Map.Entry<ColumnDefinition.Raw, ColumnDefinition.Raw> entry : this.renames.entrySet()) {
                    ColumnIdentifier from = entry.getKey().getIdentifier(cfm);
                    ColumnIdentifier to = entry.getValue().getIdentifier(cfm);
                    cfm.renameColumn(from, to);
                    for (ViewDefinition view : views) {
                        if (!view.includes(from)) continue;
                        ViewDefinition viewCopy = view.copy();
                        ColumnIdentifier viewFrom = entry.getKey().getIdentifier(viewCopy.metadata);
                        ColumnIdentifier viewTo = entry.getValue().getIdentifier(viewCopy.metadata);
                        viewCopy.renameColumn(viewFrom, viewTo);
                        if (viewUpdates == null) {
                            viewUpdates = new ArrayList<ViewDefinition>();
                        }
                        viewUpdates.add(viewCopy);
                    }
                }
                break;
            }
            default: {
                throw new InvalidRequestException("Can not alter table: unknown option type " + (Object)((Object)this.oType));
            }
        }
        MigrationManager.announceColumnFamilyUpdate(cfm, viewUpdates, isLocalOnly);
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }

    private void validateCanDropCompactStorage() {
        HashSet<InetAddress> before3 = new HashSet<InetAddress>();
        HashSet<InetAddress> preC15897nodes = new HashSet<InetAddress>();
        HashSet<InetAddress> with2xSStables = new HashSet<InetAddress>();
        Splitter onComma = Splitter.on((char)',').omitEmptyStrings().trimResults();
        for (InetAddress node : StorageService.instance.getTokenMetadata().getAllEndpoints()) {
            if (MessagingService.instance().getVersion(node) < 10) {
                before3.add(node);
                continue;
            }
            String sstableVersionsString = Gossiper.instance.getApplicationState(node, ApplicationState.SSTABLE_VERSIONS);
            if (sstableVersionsString == null) {
                preC15897nodes.add(node);
                continue;
            }
            try {
                boolean has2xSStables = onComma.splitToList((CharSequence)sstableVersionsString).stream().map(VersionAndType::fromString).anyMatch(v -> !v.version().storeRows());
                if (!has2xSStables) continue;
                with2xSStables.add(node);
            }
            catch (IllegalArgumentException e) {
                noSpamLogger.error("Unexpected error parsing sstable versions from gossip for {} (gossiped value is '{}'). This is a bug and should be reported. Cannot ensure that {} has no non-upgraded 2.x sstables anymore. If after this DROP COMPACT STORAGE some old sstables cannot be read anymore, please use `upgradesstables` with the `--force-compact-storage-on` option.", node, sstableVersionsString, node);
            }
        }
        if (!before3.isEmpty()) {
            throw new InvalidRequestException(String.format("Cannot DROP COMPACT STORAGE as some nodes in the cluster (%s) are not on 3.0+ yet. Please upgrade those nodes and run `upgradesstables` before retrying.", before3));
        }
        if (!preC15897nodes.isEmpty()) {
            throw new InvalidRequestException(String.format("Cannot guarantee that DROP COMPACT STORAGE is safe as some nodes in the cluster (%s) do not have https://issues.apache.org/jira/browse/CASSANDRA-15897. Please upgrade those nodes and retry.", preC15897nodes));
        }
        if (!with2xSStables.isEmpty()) {
            throw new InvalidRequestException(String.format("Cannot DROP COMPACT STORAGE as some nodes in the cluster (%s) has some non-upgraded 2.x sstables. Please run `upgradesstables` on those nodes before retrying", with2xSStables));
        }
    }

    public String toString() {
        return String.format("AlterTableStatement(name=%s, type=%s)", new Object[]{this.cfName, this.oType});
    }

    public static enum Type {
        ADD,
        ALTER,
        DROP,
        DROP_COMPACT_STORAGE,
        OPTS,
        RENAME;

    }
}

