/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.transform.DuplicateRowChecker;
import org.apache.cassandra.exceptions.ReadFailureException;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.metrics.ReadRepairMetrics;
import org.apache.cassandra.net.IAsyncCallbackWithFailure;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.AsyncRepairCallback;
import org.apache.cassandra.service.DataResolver;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.DigestResolver;
import org.apache.cassandra.service.ResponseResolver;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.SimpleCondition;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCallback
implements IAsyncCallbackWithFailure<ReadResponse> {
    protected static final Logger logger = LoggerFactory.getLogger(ReadCallback.class);
    public final ResponseResolver resolver;
    private final SimpleCondition condition = new SimpleCondition();
    private final long queryStartNanoTime;
    final int blockfor;
    final List<InetAddress> endpoints;
    private final ReadCommand command;
    private final ConsistencyLevel consistencyLevel;
    private static final AtomicIntegerFieldUpdater<ReadCallback> recievedUpdater = AtomicIntegerFieldUpdater.newUpdater(ReadCallback.class, "received");
    private volatile int received = 0;
    private static final AtomicIntegerFieldUpdater<ReadCallback> failuresUpdater = AtomicIntegerFieldUpdater.newUpdater(ReadCallback.class, "failures");
    private volatile int failures = 0;
    private final Map<InetAddress, RequestFailureReason> failureReasonByEndpoint;
    private final Keyspace keyspace;

    public ReadCallback(ResponseResolver resolver, ConsistencyLevel consistencyLevel, ReadCommand command, List<InetAddress> filteredEndpoints, long queryStartNanoTime) {
        this(resolver, consistencyLevel, consistencyLevel.blockFor(Keyspace.open(command.metadata().ksName)), command, Keyspace.open(command.metadata().ksName), filteredEndpoints, queryStartNanoTime);
    }

    public ReadCallback(ResponseResolver resolver, ConsistencyLevel consistencyLevel, int blockfor, ReadCommand command, Keyspace keyspace, List<InetAddress> endpoints, long queryStartNanoTime) {
        this.command = command;
        this.keyspace = keyspace;
        this.blockfor = blockfor;
        this.consistencyLevel = consistencyLevel;
        this.resolver = resolver;
        this.queryStartNanoTime = queryStartNanoTime;
        this.endpoints = endpoints;
        this.failureReasonByEndpoint = new ConcurrentHashMap<InetAddress, RequestFailureReason>();
        assert (!(command instanceof PartitionRangeReadCommand) || blockfor >= endpoints.size());
        if (logger.isTraceEnabled()) {
            logger.trace("Blockfor is {}; setting up requests to {}", (Object)blockfor, (Object)StringUtils.join(this.endpoints, (String)","));
        }
    }

    public boolean await(long timePastStart, TimeUnit unit) {
        long time = unit.toNanos(timePastStart) - (System.nanoTime() - this.queryStartNanoTime);
        try {
            return this.condition.await(time, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public void awaitResults() throws ReadFailureException, ReadTimeoutException {
        boolean failed;
        boolean signaled = this.await(this.command.getTimeout(), TimeUnit.MILLISECONDS);
        boolean bl = failed = this.blockfor + this.failures > this.endpoints.size();
        if (signaled && !failed) {
            return;
        }
        if (Tracing.isTracing()) {
            String gotData = this.received > 0 ? (this.resolver.isDataPresent() ? " (including data)" : " (only digests)") : "";
            Tracing.trace("{}; received {} of {} responses{}", failed ? "Failed" : "Timed out", this.received, this.blockfor, gotData);
        } else if (logger.isDebugEnabled()) {
            String gotData = this.received > 0 ? (this.resolver.isDataPresent() ? " (including data)" : " (only digests)") : "";
            logger.debug("{}; received {} of {} responses{}", new Object[]{failed ? "Failed" : "Timed out", this.received, this.blockfor, gotData});
        }
        throw failed ? new ReadFailureException(this.consistencyLevel, this.received, this.blockfor, this.resolver.isDataPresent(), this.failureReasonByEndpoint) : new ReadTimeoutException(this.consistencyLevel, this.received, this.blockfor, this.resolver.isDataPresent());
    }

    public PartitionIterator get() throws ReadFailureException, ReadTimeoutException, DigestMismatchException {
        PartitionIterator result;
        this.awaitResults();
        PartitionIterator partitionIterator = result = this.blockfor == 1 ? this.resolver.getData() : this.resolver.resolve();
        if (logger.isTraceEnabled()) {
            logger.trace("Read: {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.queryStartNanoTime));
        }
        return DuplicateRowChecker.duringRead(result, this.endpoints);
    }

    public int blockFor() {
        return this.blockfor;
    }

    @Override
    public void response(MessageIn<ReadResponse> message) {
        int n;
        this.resolver.preprocess(message);
        int n2 = n = this.waitingFor(message.from) ? recievedUpdater.incrementAndGet(this) : this.received;
        if (n >= this.blockfor && this.resolver.responses.size() >= this.blockfor && this.resolver.isDataPresent()) {
            this.condition.signalAll();
            if (this.blockfor < this.endpoints.size() && n == this.endpoints.size()) {
                TraceState traceState = Tracing.instance.get();
                if (traceState != null) {
                    traceState.trace("Initiating read-repair");
                }
                StageManager.getStage(Stage.READ_REPAIR).execute(new AsyncRepairRunner(traceState, this.queryStartNanoTime));
            }
        }
    }

    private boolean waitingFor(InetAddress from) {
        return !this.consistencyLevel.isDatacenterLocal() || DatabaseDescriptor.getLocalDataCenter().equals(DatabaseDescriptor.getEndpointSnitch().getDatacenter(from));
    }

    public int getReceivedCount() {
        return this.received;
    }

    public void response(ReadResponse result) {
        MessageIn<ReadResponse> message = MessageIn.create(FBUtilities.getBroadcastAddress(), result, Collections.emptyMap(), MessagingService.Verb.INTERNAL_RESPONSE, MessagingService.current_version);
        this.response(message);
    }

    public void assureSufficientLiveNodes() throws UnavailableException {
        this.consistencyLevel.assureSufficientLiveNodes(this.keyspace, this.endpoints);
    }

    @Override
    public boolean isLatencyForSnitch() {
        return true;
    }

    @Override
    public void onFailure(InetAddress from, RequestFailureReason failureReason) {
        int n = this.waitingFor(from) ? failuresUpdater.incrementAndGet(this) : this.failures;
        this.failureReasonByEndpoint.put(from, failureReason);
        if (this.blockfor + n > this.endpoints.size()) {
            this.condition.signalAll();
        }
    }

    private class AsyncRepairRunner
    implements Runnable {
        private final TraceState traceState;
        private final long queryStartNanoTime;

        public AsyncRepairRunner(TraceState traceState, long queryStartNanoTime) {
            this.traceState = traceState;
            this.queryStartNanoTime = queryStartNanoTime;
        }

        @Override
        public void run() {
            try {
                ReadCallback.this.resolver.compareResponses();
            }
            catch (DigestMismatchException e) {
                assert (ReadCallback.this.resolver instanceof DigestResolver);
                if (this.traceState != null) {
                    this.traceState.trace("Digest mismatch: {}", e.toString());
                }
                ReadRepairMetrics.repairedBackground.mark();
                DataResolver repairResolver = new DataResolver(ReadCallback.this.keyspace, ReadCallback.this.command, ReadCallback.this.consistencyLevel, ReadCallback.this.endpoints.size(), this.queryStartNanoTime);
                AsyncRepairCallback repairHandler = new AsyncRepairCallback(repairResolver, ReadCallback.this.endpoints.size());
                for (InetAddress endpoint : ReadCallback.this.endpoints) {
                    MessageOut<ReadCommand> message = ReadCallback.this.command.createMessage(MessagingService.instance().getVersion(endpoint));
                    MessagingService.instance().sendRR(message, endpoint, repairHandler);
                }
            }
        }
    }
}

