/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.serializers.CounterSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CounterColumnType
extends AbstractType<Long> {
    public static final CounterColumnType instance = new CounterColumnType();

    CounterColumnType() {
        super(AbstractType.ComparisonType.NOT_COMPARABLE);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public boolean isCounter() {
        return true;
    }

    @Override
    public Long compose(ByteBuffer bytes) {
        return CounterContext.instance().total(bytes);
    }

    @Override
    public ByteBuffer decompose(Long value) {
        return ByteBufferUtil.bytes(value);
    }

    @Override
    public void validateCellValue(ByteBuffer cellValue) throws MarshalException {
        CounterContext.instance().validateContext(cellValue);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return ByteBufferUtil.bytesToHex(bytes);
    }

    @Override
    public ByteBuffer fromString(String source) {
        return ByteBufferUtil.hexToBytes(source);
    }

    @Override
    public Term fromJSONObject(Object parsed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return CounterSerializer.instance.deserialize(buffer).toString();
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.COUNTER;
    }

    @Override
    public TypeSerializer<Long> getSerializer() {
        return CounterSerializer.instance;
    }
}

