/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.FileStore;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.cassandra.auth.AuthConfig;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.IInternodeAuthenticator;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.ConfigurationLoader;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.config.RequestSchedulerOptions;
import org.apache.cassandra.config.YamlConfigurationLoader;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.DiskOptimizationStrategy;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.SpinningDiskOptimizationStrategy;
import org.apache.cassandra.io.util.SsdDiskOptimizationStrategy;
import org.apache.cassandra.locator.DynamicEndpointSnitch;
import org.apache.cassandra.locator.EndpointSnitchInfo;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.SeedProvider;
import org.apache.cassandra.net.BackPressureStrategy;
import org.apache.cassandra.net.RateBasedBackPressure;
import org.apache.cassandra.scheduler.IRequestScheduler;
import org.apache.cassandra.scheduler.NoScheduler;
import org.apache.cassandra.security.EncryptionContext;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.ProtocolVersionLimit;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseDescriptor.class);
    private static final int MAX_NUM_TOKENS = 1536;
    private static Config conf;
    private static IEndpointSnitch snitch;
    private static InetAddress listenAddress;
    private static InetAddress broadcastAddress;
    private static InetAddress rpcAddress;
    private static InetAddress broadcastRpcAddress;
    private static SeedProvider seedProvider;
    private static IInternodeAuthenticator internodeAuthenticator;
    private static IPartitioner partitioner;
    private static String paritionerName;
    private static Config.DiskAccessMode indexAccessMode;
    private static IAuthenticator authenticator;
    private static IAuthorizer authorizer;
    private static IRoleManager roleManager;
    private static IRequestScheduler requestScheduler;
    private static Config.RequestSchedulerId requestSchedulerId;
    private static RequestSchedulerOptions requestSchedulerOptions;
    private static long preparedStatementsCacheSizeInMB;
    private static long thriftPreparedStatementsCacheSizeInMB;
    private static long keyCacheSizeInMB;
    private static long counterCacheSizeInMB;
    private static long indexSummaryCapacityInMB;
    private static String localDC;
    private static Comparator<InetAddress> localComparator;
    private static EncryptionContext encryptionContext;
    private static boolean hasLoggedConfig;
    private static BackPressureStrategy backPressureStrategy;
    private static DiskOptimizationStrategy diskOptimizationStrategy;
    private static boolean clientInitialized;
    private static boolean toolInitialized;
    private static boolean daemonInitialized;
    private static final int searchConcurrencyFactor;
    private static final boolean disableSTCSInL0;
    private static final boolean unsafeSystem;
    private static final boolean strictRuntimeChecks;

    public static void daemonInitialization() throws ConfigurationException {
        DatabaseDescriptor.daemonInitialization(DatabaseDescriptor::loadConfig);
    }

    public static void daemonInitialization(Supplier<Config> config) throws ConfigurationException {
        if (toolInitialized) {
            throw new AssertionError((Object)"toolInitialization() already called");
        }
        if (clientInitialized) {
            throw new AssertionError((Object)"clientInitialization() already called");
        }
        if (daemonInitialized) {
            return;
        }
        daemonInitialized = true;
        DatabaseDescriptor.setConfig(config.get());
        DatabaseDescriptor.applyAll();
        AuthConfig.applyAuth();
    }

    public static void toolInitialization() {
        DatabaseDescriptor.toolInitialization(true);
    }

    public static void toolInitialization(boolean failIfDaemonOrClient) {
        if (!failIfDaemonOrClient && (daemonInitialized || clientInitialized)) {
            return;
        }
        if (daemonInitialized) {
            throw new AssertionError((Object)"daemonInitialization() already called");
        }
        if (clientInitialized) {
            throw new AssertionError((Object)"clientInitialization() already called");
        }
        if (toolInitialized) {
            return;
        }
        toolInitialized = true;
        DatabaseDescriptor.setConfig(DatabaseDescriptor.loadConfig());
        DatabaseDescriptor.applySimpleConfig();
        DatabaseDescriptor.applyPartitioner();
        DatabaseDescriptor.applySnitch();
        DatabaseDescriptor.applyEncryptionContext();
    }

    public static void clientInitialization() {
        DatabaseDescriptor.clientInitialization(true);
    }

    public static void clientInitialization(boolean failIfDaemonOrTool) {
        if (!failIfDaemonOrTool && (daemonInitialized || toolInitialized)) {
            return;
        }
        if (daemonInitialized) {
            throw new AssertionError((Object)"daemonInitialization() already called");
        }
        if (toolInitialized) {
            throw new AssertionError((Object)"toolInitialization() already called");
        }
        if (clientInitialized) {
            return;
        }
        clientInitialized = true;
        Config.setClientMode(true);
        conf = new Config();
        diskOptimizationStrategy = new SpinningDiskOptimizationStrategy();
    }

    public static boolean isClientInitialized() {
        return clientInitialized;
    }

    public static boolean isToolInitialized() {
        return toolInitialized;
    }

    public static boolean isClientOrToolInitialized() {
        return clientInitialized || toolInitialized;
    }

    public static boolean isDaemonInitialized() {
        return daemonInitialized;
    }

    public static Config getRawConfig() {
        return conf;
    }

    @VisibleForTesting
    public static Config loadConfig() throws ConfigurationException {
        if (Config.getOverrideLoadConfig() != null) {
            return Config.getOverrideLoadConfig().get();
        }
        String loaderClass = System.getProperty("cassandra.config.loader");
        ConfigurationLoader loader = loaderClass == null ? new YamlConfigurationLoader() : (ConfigurationLoader)FBUtilities.construct(loaderClass, "configuration loading");
        Config config = loader.loadConfig();
        if (!hasLoggedConfig) {
            hasLoggedConfig = true;
            Config.log(config);
        }
        return config;
    }

    private static InetAddress getNetworkInterfaceAddress(String intf, String configName, boolean preferIPv6) throws ConfigurationException {
        try {
            NetworkInterface ni = NetworkInterface.getByName(intf);
            if (ni == null) {
                throw new ConfigurationException("Configured " + configName + " \"" + intf + "\" could not be found", false);
            }
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            if (!addrs.hasMoreElements()) {
                throw new ConfigurationException("Configured " + configName + " \"" + intf + "\" was found, but had no addresses", false);
            }
            InetAddress retval = null;
            while (addrs.hasMoreElements()) {
                InetAddress temp = addrs.nextElement();
                if (preferIPv6 && temp instanceof Inet6Address) {
                    return temp;
                }
                if (!preferIPv6 && temp instanceof Inet4Address) {
                    return temp;
                }
                if (retval != null) continue;
                retval = temp;
            }
            return retval;
        }
        catch (SocketException e) {
            throw new ConfigurationException("Configured " + configName + " \"" + intf + "\" caused an exception", e);
        }
    }

    private static void setConfig(Config config) {
        conf = config;
    }

    private static void applyAll() throws ConfigurationException {
        DatabaseDescriptor.applySimpleConfig();
        DatabaseDescriptor.applyPartitioner();
        DatabaseDescriptor.applyAddressConfig();
        DatabaseDescriptor.applyThriftHSHA();
        DatabaseDescriptor.applySnitch();
        DatabaseDescriptor.applyRequestScheduler();
        DatabaseDescriptor.applyTokensConfig();
        DatabaseDescriptor.applySeedProvider();
        DatabaseDescriptor.applyEncryptionContext();
    }

    private static void applySimpleConfig() {
        int minSize;
        int preferredSize;
        if (DatabaseDescriptor.conf.commitlog_sync == null) {
            throw new ConfigurationException("Missing required directive CommitLogSync", false);
        }
        if (DatabaseDescriptor.conf.commitlog_sync == Config.CommitLogSync.batch) {
            if (Double.isNaN(DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms) || DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms <= 0.0) {
                throw new ConfigurationException("Missing value for commitlog_sync_batch_window_in_ms: positive double value expected.", false);
            }
            if (DatabaseDescriptor.conf.commitlog_sync_period_in_ms != 0) {
                throw new ConfigurationException("Batch sync specified, but commitlog_sync_period_in_ms found. Only specify commitlog_sync_batch_window_in_ms when using batch sync", false);
            }
            logger.debug("Syncing log with a batch window of {}", (Object)DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms);
        } else {
            if (DatabaseDescriptor.conf.commitlog_sync_period_in_ms <= 0) {
                throw new ConfigurationException("Missing value for commitlog_sync_period_in_ms: positive integer expected", false);
            }
            if (!Double.isNaN(DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms)) {
                throw new ConfigurationException("commitlog_sync_period_in_ms specified, but commitlog_sync_batch_window_in_ms found.  Only specify commitlog_sync_period_in_ms when using periodic sync.", false);
            }
            logger.debug("Syncing log with a period of {}", (Object)DatabaseDescriptor.conf.commitlog_sync_period_in_ms);
        }
        if (DatabaseDescriptor.conf.disk_access_mode == Config.DiskAccessMode.auto) {
            indexAccessMode = DatabaseDescriptor.conf.disk_access_mode = DatabaseDescriptor.hasLargeAddressSpace() ? Config.DiskAccessMode.mmap : Config.DiskAccessMode.standard;
            logger.info("DiskAccessMode 'auto' determined to be {}, indexAccessMode is {}", (Object)DatabaseDescriptor.conf.disk_access_mode, (Object)indexAccessMode);
        } else if (DatabaseDescriptor.conf.disk_access_mode == Config.DiskAccessMode.mmap_index_only) {
            DatabaseDescriptor.conf.disk_access_mode = Config.DiskAccessMode.standard;
            indexAccessMode = Config.DiskAccessMode.mmap;
            logger.info("DiskAccessMode is {}, indexAccessMode is {}", (Object)DatabaseDescriptor.conf.disk_access_mode, (Object)indexAccessMode);
        } else {
            indexAccessMode = DatabaseDescriptor.conf.disk_access_mode;
            logger.info("DiskAccessMode is {}, indexAccessMode is {}", (Object)DatabaseDescriptor.conf.disk_access_mode, (Object)indexAccessMode);
        }
        if (DatabaseDescriptor.conf.gc_warn_threshold_in_ms < 0) {
            throw new ConfigurationException("gc_warn_threshold_in_ms must be a positive integer");
        }
        if (DatabaseDescriptor.conf.phi_convict_threshold < 5.0 || DatabaseDescriptor.conf.phi_convict_threshold > 16.0) {
            throw new ConfigurationException("phi_convict_threshold must be between 5 and 16, but was " + DatabaseDescriptor.conf.phi_convict_threshold, false);
        }
        if (DatabaseDescriptor.conf.concurrent_reads < 2) {
            throw new ConfigurationException("concurrent_reads must be at least 2, but was " + DatabaseDescriptor.conf.concurrent_reads, false);
        }
        if (DatabaseDescriptor.conf.concurrent_writes < 2 && System.getProperty("cassandra.test.fail_mv_locks_count", "").isEmpty()) {
            throw new ConfigurationException("concurrent_writes must be at least 2, but was " + DatabaseDescriptor.conf.concurrent_writes, false);
        }
        if (DatabaseDescriptor.conf.concurrent_counter_writes < 2) {
            throw new ConfigurationException("concurrent_counter_writes must be at least 2, but was " + DatabaseDescriptor.conf.concurrent_counter_writes, false);
        }
        if (DatabaseDescriptor.conf.concurrent_replicates != null) {
            logger.warn("concurrent_replicates has been deprecated and should be removed from cassandra.yaml");
        }
        if (DatabaseDescriptor.conf.file_cache_size_in_mb == null) {
            DatabaseDescriptor.conf.file_cache_size_in_mb = Math.min(512, (int)(Runtime.getRuntime().maxMemory() / 0x400000L));
        }
        if (DatabaseDescriptor.conf.file_cache_round_up == null) {
            DatabaseDescriptor.conf.file_cache_round_up = DatabaseDescriptor.conf.disk_optimization_strategy == Config.DiskOptimizationStrategy.spinning;
        }
        if (DatabaseDescriptor.conf.memtable_offheap_space_in_mb == null) {
            DatabaseDescriptor.conf.memtable_offheap_space_in_mb = (int)(Runtime.getRuntime().maxMemory() / 0x400000L);
        }
        if (DatabaseDescriptor.conf.memtable_offheap_space_in_mb < 0) {
            throw new ConfigurationException("memtable_offheap_space_in_mb must be positive, but was " + DatabaseDescriptor.conf.memtable_offheap_space_in_mb, false);
        }
        if (DatabaseDescriptor.conf.memtable_heap_space_in_mb == null) {
            DatabaseDescriptor.conf.memtable_heap_space_in_mb = (int)(Runtime.getRuntime().maxMemory() / 0x400000L);
        }
        if (DatabaseDescriptor.conf.memtable_heap_space_in_mb <= 0) {
            throw new ConfigurationException("memtable_heap_space_in_mb must be positive, but was " + DatabaseDescriptor.conf.memtable_heap_space_in_mb, false);
        }
        logger.info("Global memtable on-heap threshold is enabled at {}MB", (Object)DatabaseDescriptor.conf.memtable_heap_space_in_mb);
        if (DatabaseDescriptor.conf.memtable_offheap_space_in_mb == 0) {
            logger.info("Global memtable off-heap threshold is disabled, HeapAllocator will be used instead");
        } else {
            logger.info("Global memtable off-heap threshold is enabled at {}MB", (Object)DatabaseDescriptor.conf.memtable_offheap_space_in_mb);
        }
        if (DatabaseDescriptor.conf.repair_session_max_tree_depth < 10) {
            throw new ConfigurationException("repair_session_max_tree_depth should not be < 10, but was " + DatabaseDescriptor.conf.repair_session_max_tree_depth);
        }
        if (DatabaseDescriptor.conf.repair_session_max_tree_depth > 20) {
            logger.warn("repair_session_max_tree_depth of " + DatabaseDescriptor.conf.repair_session_max_tree_depth + " > 20 could lead to excessive memory usage");
        }
        if (DatabaseDescriptor.conf.thrift_framed_transport_size_in_mb <= 0) {
            throw new ConfigurationException("thrift_framed_transport_size_in_mb must be positive, but was " + DatabaseDescriptor.conf.thrift_framed_transport_size_in_mb, false);
        }
        if (DatabaseDescriptor.conf.native_transport_max_frame_size_in_mb <= 0) {
            throw new ConfigurationException("native_transport_max_frame_size_in_mb must be positive, but was " + DatabaseDescriptor.conf.native_transport_max_frame_size_in_mb, false);
        }
        if (DatabaseDescriptor.conf.native_transport_max_frame_size_in_mb >= 2048) {
            throw new ConfigurationException("native_transport_max_frame_size_in_mb must be smaller than 2048, but was " + DatabaseDescriptor.conf.native_transport_max_frame_size_in_mb, false);
        }
        if (DatabaseDescriptor.conf.commitlog_directory == null) {
            DatabaseDescriptor.conf.commitlog_directory = DatabaseDescriptor.storagedirFor("commitlog");
        }
        if (DatabaseDescriptor.conf.hints_directory == null) {
            DatabaseDescriptor.conf.hints_directory = DatabaseDescriptor.storagedirFor("hints");
        }
        if (DatabaseDescriptor.conf.native_transport_max_concurrent_requests_in_bytes <= 0L) {
            DatabaseDescriptor.conf.native_transport_max_concurrent_requests_in_bytes = Runtime.getRuntime().maxMemory() / 10L;
        }
        if (DatabaseDescriptor.conf.native_transport_max_concurrent_requests_in_bytes_per_ip <= 0L) {
            DatabaseDescriptor.conf.native_transport_max_concurrent_requests_in_bytes_per_ip = Runtime.getRuntime().maxMemory() / 40L;
        }
        if (DatabaseDescriptor.conf.cdc_raw_directory == null) {
            DatabaseDescriptor.conf.cdc_raw_directory = DatabaseDescriptor.storagedirFor("cdc_raw");
        }
        if (DatabaseDescriptor.conf.commitlog_total_space_in_mb == null) {
            preferredSize = 8192;
            minSize = 0;
            try {
                minSize = Ints.saturatedCast((long)(DatabaseDescriptor.guessFileStore(DatabaseDescriptor.conf.commitlog_directory).getTotalSpace() / 0x100000L / 4L));
            }
            catch (IOException e) {
                logger.debug("Error checking disk space", (Throwable)e);
                throw new ConfigurationException(String.format("Unable to check disk space available to %s. Perhaps the Cassandra user does not have the necessary permissions", DatabaseDescriptor.conf.commitlog_directory), e);
            }
            if (minSize < preferredSize) {
                logger.warn("Small commitlog volume detected at {}; setting commitlog_total_space_in_mb to {}.  You can override this in cassandra.yaml", (Object)DatabaseDescriptor.conf.commitlog_directory, (Object)minSize);
                DatabaseDescriptor.conf.commitlog_total_space_in_mb = minSize;
            } else {
                DatabaseDescriptor.conf.commitlog_total_space_in_mb = preferredSize;
            }
        }
        if (DatabaseDescriptor.conf.cdc_total_space_in_mb == 0) {
            preferredSize = 4096;
            try {
                minSize = Ints.saturatedCast((long)(DatabaseDescriptor.guessFileStore(DatabaseDescriptor.conf.cdc_raw_directory).getTotalSpace() / 0x100000L / 8L));
            }
            catch (IOException e) {
                logger.debug("Error checking disk space", (Throwable)e);
                throw new ConfigurationException(String.format("Unable to check disk space available to %s. Perhaps the Cassandra user does not have the necessary permissions", DatabaseDescriptor.conf.cdc_raw_directory), e);
            }
            if (minSize < preferredSize) {
                logger.warn("Small cdc volume detected at {}; setting cdc_total_space_in_mb to {}.  You can override this in cassandra.yaml", (Object)DatabaseDescriptor.conf.cdc_raw_directory, (Object)minSize);
                DatabaseDescriptor.conf.cdc_total_space_in_mb = minSize;
            } else {
                DatabaseDescriptor.conf.cdc_total_space_in_mb = preferredSize;
            }
        }
        if (DatabaseDescriptor.conf.cdc_enabled) {
            logger.info("cdc_enabled is true. Starting casssandra node with Change-Data-Capture enabled.");
        }
        if (DatabaseDescriptor.conf.saved_caches_directory == null) {
            DatabaseDescriptor.conf.saved_caches_directory = DatabaseDescriptor.storagedirFor("saved_caches");
        }
        if (DatabaseDescriptor.conf.data_file_directories == null || DatabaseDescriptor.conf.data_file_directories.length == 0) {
            DatabaseDescriptor.conf.data_file_directories = new String[]{DatabaseDescriptor.storagedir("data_file_directories") + File.separator + "data"};
        }
        long dataFreeBytes = 0L;
        for (String datadir : DatabaseDescriptor.conf.data_file_directories) {
            if (datadir == null) {
                throw new ConfigurationException("data_file_directories must not contain empty entry", false);
            }
            if (datadir.equals(DatabaseDescriptor.conf.commitlog_directory)) {
                throw new ConfigurationException("commitlog_directory must not be the same as any data_file_directories", false);
            }
            if (datadir.equals(DatabaseDescriptor.conf.hints_directory)) {
                throw new ConfigurationException("hints_directory must not be the same as any data_file_directories", false);
            }
            if (datadir.equals(DatabaseDescriptor.conf.saved_caches_directory)) {
                throw new ConfigurationException("saved_caches_directory must not be the same as any data_file_directories", false);
            }
            try {
                dataFreeBytes = DatabaseDescriptor.saturatedSum(dataFreeBytes, DatabaseDescriptor.guessFileStore(datadir).getUnallocatedSpace());
            }
            catch (IOException e) {
                logger.debug("Error checking disk space", (Throwable)e);
                throw new ConfigurationException(String.format("Unable to check disk space available to %s. Perhaps the Cassandra user does not have the necessary permissions", datadir), e);
            }
        }
        if (dataFreeBytes < 0x1000000000L) {
            logger.warn("Only {} free across all data volumes. Consider adding more capacity to your cluster or removing obsolete snapshots", (Object)FBUtilities.prettyPrintMemory(dataFreeBytes));
        }
        if (DatabaseDescriptor.conf.commitlog_directory.equals(DatabaseDescriptor.conf.saved_caches_directory)) {
            throw new ConfigurationException("saved_caches_directory must not be the same as the commitlog_directory", false);
        }
        if (DatabaseDescriptor.conf.commitlog_directory.equals(DatabaseDescriptor.conf.hints_directory)) {
            throw new ConfigurationException("hints_directory must not be the same as the commitlog_directory", false);
        }
        if (DatabaseDescriptor.conf.hints_directory.equals(DatabaseDescriptor.conf.saved_caches_directory)) {
            throw new ConfigurationException("saved_caches_directory must not be the same as the hints_directory", false);
        }
        if (DatabaseDescriptor.conf.memtable_flush_writers == 0) {
            int n = DatabaseDescriptor.conf.memtable_flush_writers = DatabaseDescriptor.conf.data_file_directories.length == 1 ? 2 : 1;
        }
        if (DatabaseDescriptor.conf.memtable_flush_writers < 1) {
            throw new ConfigurationException("memtable_flush_writers must be at least 1, but was " + DatabaseDescriptor.conf.memtable_flush_writers, false);
        }
        if (DatabaseDescriptor.conf.memtable_cleanup_threshold == null) {
            DatabaseDescriptor.conf.memtable_cleanup_threshold = Float.valueOf((float)(1.0 / (double)(1 + DatabaseDescriptor.conf.memtable_flush_writers)));
        } else {
            logger.warn("memtable_cleanup_threshold has been deprecated and should be removed from cassandra.yaml");
        }
        if (DatabaseDescriptor.conf.memtable_cleanup_threshold.floatValue() < 0.01f) {
            throw new ConfigurationException("memtable_cleanup_threshold must be >= 0.01, but was " + DatabaseDescriptor.conf.memtable_cleanup_threshold, false);
        }
        if (DatabaseDescriptor.conf.memtable_cleanup_threshold.floatValue() > 0.99f) {
            throw new ConfigurationException("memtable_cleanup_threshold must be <= 0.99, but was " + DatabaseDescriptor.conf.memtable_cleanup_threshold, false);
        }
        if (DatabaseDescriptor.conf.memtable_cleanup_threshold.floatValue() < 0.1f) {
            logger.warn("memtable_cleanup_threshold is set very low [{}], which may cause performance degradation", (Object)DatabaseDescriptor.conf.memtable_cleanup_threshold);
        }
        if (DatabaseDescriptor.conf.concurrent_compactors == null) {
            DatabaseDescriptor.conf.concurrent_compactors = Math.min(8, Math.max(2, Math.min(FBUtilities.getAvailableProcessors(), DatabaseDescriptor.conf.data_file_directories.length)));
        }
        if (DatabaseDescriptor.conf.concurrent_compactors <= 0) {
            throw new ConfigurationException("concurrent_compactors should be strictly greater than 0, but was " + DatabaseDescriptor.conf.concurrent_compactors, false);
        }
        if (DatabaseDescriptor.conf.num_tokens != null && DatabaseDescriptor.conf.num_tokens > 1536) {
            throw new ConfigurationException(String.format("A maximum number of %d tokens per node is supported", 1536), false);
        }
        try {
            long l = preparedStatementsCacheSizeInMB = DatabaseDescriptor.conf.prepared_statements_cache_size_mb == null ? (long)Math.max(10, (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L / 256L)) : DatabaseDescriptor.conf.prepared_statements_cache_size_mb;
            if (preparedStatementsCacheSizeInMB <= 0L) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("prepared_statements_cache_size_mb option was set incorrectly to '" + DatabaseDescriptor.conf.prepared_statements_cache_size_mb + "', supported values are <integer> >= 0.", false);
        }
        try {
            long l = thriftPreparedStatementsCacheSizeInMB = DatabaseDescriptor.conf.thrift_prepared_statements_cache_size_mb == null ? (long)Math.max(10, (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L / 256L)) : DatabaseDescriptor.conf.thrift_prepared_statements_cache_size_mb;
            if (thriftPreparedStatementsCacheSizeInMB <= 0L) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("thrift_prepared_statements_cache_size_mb option was set incorrectly to '" + DatabaseDescriptor.conf.thrift_prepared_statements_cache_size_mb + "', supported values are <integer> >= 0.", false);
        }
        try {
            long l = keyCacheSizeInMB = DatabaseDescriptor.conf.key_cache_size_in_mb == null ? (long)Math.min(Math.max(1, (int)((double)Runtime.getRuntime().totalMemory() * 0.05 / 1024.0 / 1024.0)), 100) : DatabaseDescriptor.conf.key_cache_size_in_mb;
            if (keyCacheSizeInMB < 0L) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("key_cache_size_in_mb option was set incorrectly to '" + DatabaseDescriptor.conf.key_cache_size_in_mb + "', supported values are <integer> >= 0.", false);
        }
        try {
            long l = counterCacheSizeInMB = DatabaseDescriptor.conf.counter_cache_size_in_mb == null ? (long)Math.min(Math.max(1, (int)((double)Runtime.getRuntime().totalMemory() * 0.025 / 1024.0 / 1024.0)), 50) : DatabaseDescriptor.conf.counter_cache_size_in_mb;
            if (counterCacheSizeInMB < 0L) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("counter_cache_size_in_mb option was set incorrectly to '" + DatabaseDescriptor.conf.counter_cache_size_in_mb + "', supported values are <integer> >= 0.", false);
        }
        long l = indexSummaryCapacityInMB = DatabaseDescriptor.conf.index_summary_capacity_in_mb == null ? (long)Math.max(1, (int)((double)Runtime.getRuntime().totalMemory() * 0.05 / 1024.0 / 1024.0)) : DatabaseDescriptor.conf.index_summary_capacity_in_mb;
        if (indexSummaryCapacityInMB < 0L) {
            throw new ConfigurationException("index_summary_capacity_in_mb option was set incorrectly to '" + DatabaseDescriptor.conf.index_summary_capacity_in_mb + "', it should be a non-negative integer.", false);
        }
        if (DatabaseDescriptor.conf.index_interval != null) {
            logger.warn("index_interval has been deprecated and should be removed from cassandra.yaml");
        }
        if (DatabaseDescriptor.conf.encryption_options != null) {
            logger.warn("Please rename encryption_options as server_encryption_options in the yaml");
            DatabaseDescriptor.conf.server_encryption_options = DatabaseDescriptor.conf.encryption_options;
        }
        DatabaseDescriptor.conf.server_encryption_options.validate();
        if (DatabaseDescriptor.conf.user_defined_function_fail_timeout < 0L) {
            throw new ConfigurationException("user_defined_function_fail_timeout must not be negative", false);
        }
        if (DatabaseDescriptor.conf.user_defined_function_warn_timeout < 0L) {
            throw new ConfigurationException("user_defined_function_warn_timeout must not be negative", false);
        }
        if (DatabaseDescriptor.conf.user_defined_function_fail_timeout < DatabaseDescriptor.conf.user_defined_function_warn_timeout) {
            throw new ConfigurationException("user_defined_function_warn_timeout must less than user_defined_function_fail_timeout", false);
        }
        if (DatabaseDescriptor.conf.commitlog_segment_size_in_mb <= 0) {
            throw new ConfigurationException("commitlog_segment_size_in_mb must be positive, but was " + DatabaseDescriptor.conf.commitlog_segment_size_in_mb, false);
        }
        if (DatabaseDescriptor.conf.commitlog_segment_size_in_mb >= 2048) {
            throw new ConfigurationException("commitlog_segment_size_in_mb must be smaller than 2048, but was " + DatabaseDescriptor.conf.commitlog_segment_size_in_mb, false);
        }
        if (DatabaseDescriptor.conf.max_mutation_size_in_kb == null) {
            DatabaseDescriptor.conf.max_mutation_size_in_kb = DatabaseDescriptor.conf.commitlog_segment_size_in_mb * 1024 / 2;
        } else if (DatabaseDescriptor.conf.commitlog_segment_size_in_mb * 1024 < 2 * DatabaseDescriptor.conf.max_mutation_size_in_kb) {
            throw new ConfigurationException("commitlog_segment_size_in_mb must be at least twice the size of max_mutation_size_in_kb / 1024", false);
        }
        if (DatabaseDescriptor.conf.native_transport_port_ssl != null && DatabaseDescriptor.conf.native_transport_port_ssl != DatabaseDescriptor.conf.native_transport_port && !DatabaseDescriptor.conf.client_encryption_options.enabled) {
            throw new ConfigurationException("Encryption must be enabled in client_encryption_options for native_transport_port_ssl", false);
        }
        if (DatabaseDescriptor.conf.native_transport_max_negotiable_protocol_version != Integer.MIN_VALUE) {
            try {
                ProtocolVersion.decode(DatabaseDescriptor.conf.native_transport_max_negotiable_protocol_version, ProtocolVersionLimit.SERVER_DEFAULT);
                logger.info("Native transport max negotiable version statically limited to {}", (Object)DatabaseDescriptor.conf.native_transport_max_negotiable_protocol_version);
            }
            catch (Exception e) {
                throw new ConfigurationException("Invalid setting for native_transport_max_negotiable_protocol_version; " + ProtocolVersion.invalidVersionMessage(DatabaseDescriptor.conf.native_transport_max_negotiable_protocol_version));
            }
        }
        if (DatabaseDescriptor.conf.max_value_size_in_mb <= 0) {
            throw new ConfigurationException("max_value_size_in_mb must be positive", false);
        }
        if (DatabaseDescriptor.conf.max_value_size_in_mb >= 2048) {
            throw new ConfigurationException("max_value_size_in_mb must be smaller than 2048, but was " + DatabaseDescriptor.conf.max_value_size_in_mb, false);
        }
        switch (DatabaseDescriptor.conf.disk_optimization_strategy) {
            case ssd: {
                diskOptimizationStrategy = new SsdDiskOptimizationStrategy(DatabaseDescriptor.conf.disk_optimization_page_cross_chance);
                break;
            }
            case spinning: {
                diskOptimizationStrategy = new SpinningDiskOptimizationStrategy();
            }
        }
        try {
            ParameterizedClass strategy = DatabaseDescriptor.conf.back_pressure_strategy != null ? DatabaseDescriptor.conf.back_pressure_strategy : RateBasedBackPressure.withDefaultParams();
            Class<?> clazz = Class.forName(strategy.class_name);
            if (!BackPressureStrategy.class.isAssignableFrom(clazz)) {
                throw new ConfigurationException(strategy + " is not an instance of " + BackPressureStrategy.class.getCanonicalName(), false);
            }
            Constructor<?> ctor = clazz.getConstructor(Map.class);
            BackPressureStrategy instance = (BackPressureStrategy)ctor.newInstance(strategy.parameters);
            logger.info("Back-pressure is {} with strategy {}.", (Object)(DatabaseDescriptor.backPressureEnabled() ? "enabled" : "disabled"), (Object)DatabaseDescriptor.conf.back_pressure_strategy);
            backPressureStrategy = instance;
        }
        catch (ConfigurationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigurationException("Error configuring back-pressure strategy: " + DatabaseDescriptor.conf.back_pressure_strategy, ex);
        }
        if (DatabaseDescriptor.conf.otc_coalescing_enough_coalesced_messages > 128) {
            throw new ConfigurationException("otc_coalescing_enough_coalesced_messages must be smaller than 128", false);
        }
        if (DatabaseDescriptor.conf.otc_coalescing_enough_coalesced_messages <= 0) {
            throw new ConfigurationException("otc_coalescing_enough_coalesced_messages must be positive", false);
        }
    }

    private static String storagedirFor(String type) {
        return DatabaseDescriptor.storagedir(type + "_directory") + File.separator + type;
    }

    private static String storagedir(String errMsgType) {
        String storagedir = System.getProperty("cassandra.storagedir", null);
        if (storagedir == null) {
            throw new ConfigurationException(errMsgType + " is missing and -Dcassandra.storagedir is not set", false);
        }
        return storagedir;
    }

    public static void applyAddressConfig() throws ConfigurationException {
        DatabaseDescriptor.applyAddressConfig(conf);
    }

    public static void applyAddressConfig(Config config) throws ConfigurationException {
        listenAddress = null;
        rpcAddress = null;
        broadcastAddress = null;
        broadcastRpcAddress = null;
        if (config.listen_address != null && config.listen_interface != null) {
            throw new ConfigurationException("Set listen_address OR listen_interface, not both", false);
        }
        if (config.listen_address != null) {
            try {
                listenAddress = InetAddress.getByName(config.listen_address);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown listen_address '" + config.listen_address + '\'', false);
            }
            if (listenAddress.isAnyLocalAddress()) {
                throw new ConfigurationException("listen_address cannot be a wildcard address (" + config.listen_address + ")!", false);
            }
        } else if (config.listen_interface != null) {
            listenAddress = DatabaseDescriptor.getNetworkInterfaceAddress(config.listen_interface, "listen_interface", config.listen_interface_prefer_ipv6);
        }
        if (config.broadcast_address != null) {
            try {
                broadcastAddress = InetAddress.getByName(config.broadcast_address);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown broadcast_address '" + config.broadcast_address + '\'', false);
            }
            if (broadcastAddress.isAnyLocalAddress()) {
                throw new ConfigurationException("broadcast_address cannot be a wildcard address (" + config.broadcast_address + ")!", false);
            }
        }
        if (config.rpc_address != null && config.rpc_interface != null) {
            throw new ConfigurationException("Set rpc_address OR rpc_interface, not both", false);
        }
        if (config.rpc_address != null) {
            try {
                rpcAddress = InetAddress.getByName(config.rpc_address);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown host in rpc_address " + config.rpc_address, false);
            }
        } else {
            rpcAddress = config.rpc_interface != null ? DatabaseDescriptor.getNetworkInterfaceAddress(config.rpc_interface, "rpc_interface", config.rpc_interface_prefer_ipv6) : FBUtilities.getLocalAddress();
        }
        if (config.broadcast_rpc_address != null) {
            try {
                broadcastRpcAddress = InetAddress.getByName(config.broadcast_rpc_address);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown broadcast_rpc_address '" + config.broadcast_rpc_address + '\'', false);
            }
            if (broadcastRpcAddress.isAnyLocalAddress()) {
                throw new ConfigurationException("broadcast_rpc_address cannot be a wildcard address (" + config.broadcast_rpc_address + ")!", false);
            }
        } else if (rpcAddress.isAnyLocalAddress()) {
            throw new ConfigurationException("If rpc_address is set to a wildcard address (" + config.rpc_address + "), then you must set broadcast_rpc_address to a value other than " + config.rpc_address, false);
        }
    }

    public static void applyThriftHSHA() {
        if ("hsha".equals(DatabaseDescriptor.conf.rpc_server_type) && DatabaseDescriptor.conf.rpc_max_threads == Integer.MAX_VALUE) {
            throw new ConfigurationException("The hsha rpc_server_type is not compatible with an rpc_max_threads setting of 'unlimited'.  Please see the comments in cassandra.yaml for rpc_server_type and rpc_max_threads.", false);
        }
        if ("hsha".equals(DatabaseDescriptor.conf.rpc_server_type) && DatabaseDescriptor.conf.rpc_max_threads > FBUtilities.getAvailableProcessors() * 2 + 1024) {
            logger.warn("rpc_max_threads setting of {} may be too high for the hsha server and cause unnecessary thread contention, reducing performance", (Object)DatabaseDescriptor.conf.rpc_max_threads);
        }
    }

    public static void applyEncryptionContext() {
        encryptionContext = new EncryptionContext(DatabaseDescriptor.conf.transparent_data_encryption_options);
    }

    public static void applySeedProvider() {
        if (DatabaseDescriptor.conf.seed_provider == null) {
            throw new ConfigurationException("seeds configuration is missing; a minimum of one seed is required.", false);
        }
        try {
            Class<?> seedProviderClass = Class.forName(DatabaseDescriptor.conf.seed_provider.class_name);
            seedProvider = (SeedProvider)seedProviderClass.getConstructor(Map.class).newInstance(DatabaseDescriptor.conf.seed_provider.parameters);
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage() + "\nFatal configuration error; unable to start server.  See log for stacktrace.", true);
        }
        if (seedProvider.getSeeds().size() == 0) {
            throw new ConfigurationException("The seed provider lists no seeds.", false);
        }
    }

    public static void applyTokensConfig() {
        DatabaseDescriptor.applyTokensConfig(conf);
    }

    static void applyTokensConfig(Config conf) {
        if (conf.initial_token != null) {
            Collection<String> tokens = DatabaseDescriptor.tokensFromString(conf.initial_token);
            if (conf.num_tokens == null) {
                if (tokens.size() == 1) {
                    conf.num_tokens = 1;
                } else {
                    throw new ConfigurationException("initial_token was set but num_tokens is not!", false);
                }
            }
            if (tokens.size() != conf.num_tokens.intValue()) {
                throw new ConfigurationException(String.format("The number of initial tokens (by initial_token) specified (%s) is different from num_tokens value (%s)", tokens.size(), conf.num_tokens), false);
            }
            for (String token : tokens) {
                partitioner.getTokenFactory().validate(token);
            }
        } else if (conf.num_tokens == null) {
            conf.num_tokens = 1;
        }
    }

    public static void applyRequestScheduler() {
        requestSchedulerOptions = DatabaseDescriptor.conf.request_scheduler_options;
        if (DatabaseDescriptor.conf.request_scheduler != null) {
            try {
                if (requestSchedulerOptions == null) {
                    requestSchedulerOptions = new RequestSchedulerOptions();
                }
                Class<?> cls = Class.forName(DatabaseDescriptor.conf.request_scheduler);
                requestScheduler = (IRequestScheduler)cls.getConstructor(RequestSchedulerOptions.class).newInstance(requestSchedulerOptions);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Invalid Request Scheduler class " + DatabaseDescriptor.conf.request_scheduler, false);
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to instantiate request scheduler", e);
            }
        } else {
            requestScheduler = new NoScheduler();
        }
        requestSchedulerId = DatabaseDescriptor.conf.request_scheduler_id == Config.RequestSchedulerId.keyspace ? DatabaseDescriptor.conf.request_scheduler_id : Config.RequestSchedulerId.keyspace;
    }

    public static void applySnitch() {
        if (DatabaseDescriptor.conf.endpoint_snitch == null) {
            throw new ConfigurationException("Missing endpoint_snitch directive", false);
        }
        snitch = DatabaseDescriptor.createEndpointSnitch(DatabaseDescriptor.conf.dynamic_snitch, DatabaseDescriptor.conf.endpoint_snitch);
        EndpointSnitchInfo.create();
        localDC = snitch.getDatacenter(FBUtilities.getBroadcastAddress());
        localComparator = (endpoint1, endpoint2) -> {
            boolean local1 = localDC.equals(snitch.getDatacenter((InetAddress)endpoint1));
            boolean local2 = localDC.equals(snitch.getDatacenter((InetAddress)endpoint2));
            if (local1 && !local2) {
                return -1;
            }
            if (local2 && !local1) {
                return 1;
            }
            return 0;
        };
    }

    public static void applyPartitioner() {
        if (DatabaseDescriptor.conf.partitioner == null) {
            throw new ConfigurationException("Missing directive: partitioner", false);
        }
        try {
            partitioner = FBUtilities.newPartitioner(System.getProperty("cassandra.partitioner", DatabaseDescriptor.conf.partitioner));
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid partitioner class " + DatabaseDescriptor.conf.partitioner, false);
        }
        paritionerName = partitioner.getClass().getCanonicalName();
    }

    private static long saturatedSum(long left, long right) {
        assert (left >= 0L && right >= 0L);
        long sum = left + right;
        return sum < 0L ? Long.MAX_VALUE : sum;
    }

    private static FileStore guessFileStore(String dir) throws IOException {
        Path path = Paths.get(dir, new String[0]);
        while (true) {
            try {
                return FileUtils.getFileStore(path);
            }
            catch (IOException e) {
                if (e instanceof NoSuchFileException) {
                    path = path.getParent();
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public static IEndpointSnitch createEndpointSnitch(boolean dynamic, String snitchClassName) throws ConfigurationException {
        if (!snitchClassName.contains(".")) {
            snitchClassName = "org.apache.cassandra.locator." + snitchClassName;
        }
        IEndpointSnitch snitch = (IEndpointSnitch)FBUtilities.construct(snitchClassName, "snitch");
        return dynamic ? new DynamicEndpointSnitch(snitch) : snitch;
    }

    public static IAuthenticator getAuthenticator() {
        return authenticator;
    }

    public static void setAuthenticator(IAuthenticator authenticator) {
        DatabaseDescriptor.authenticator = authenticator;
    }

    public static IAuthorizer getAuthorizer() {
        return authorizer;
    }

    public static void setAuthorizer(IAuthorizer authorizer) {
        DatabaseDescriptor.authorizer = authorizer;
    }

    public static IRoleManager getRoleManager() {
        return roleManager;
    }

    public static void setRoleManager(IRoleManager roleManager) {
        DatabaseDescriptor.roleManager = roleManager;
    }

    public static int getPermissionsValidity() {
        return DatabaseDescriptor.conf.permissions_validity_in_ms;
    }

    public static void setPermissionsValidity(int timeout) {
        DatabaseDescriptor.conf.permissions_validity_in_ms = timeout;
    }

    public static int getPermissionsUpdateInterval() {
        return DatabaseDescriptor.conf.permissions_update_interval_in_ms == -1 ? DatabaseDescriptor.conf.permissions_validity_in_ms : DatabaseDescriptor.conf.permissions_update_interval_in_ms;
    }

    public static void setPermissionsUpdateInterval(int updateInterval) {
        DatabaseDescriptor.conf.permissions_update_interval_in_ms = updateInterval;
    }

    public static int getPermissionsCacheMaxEntries() {
        return DatabaseDescriptor.conf.permissions_cache_max_entries;
    }

    public static int setPermissionsCacheMaxEntries(int maxEntries) {
        DatabaseDescriptor.conf.permissions_cache_max_entries = maxEntries;
        return DatabaseDescriptor.conf.permissions_cache_max_entries;
    }

    public static int getRolesValidity() {
        return DatabaseDescriptor.conf.roles_validity_in_ms;
    }

    public static void setRolesValidity(int validity) {
        DatabaseDescriptor.conf.roles_validity_in_ms = validity;
    }

    public static int getRolesUpdateInterval() {
        return DatabaseDescriptor.conf.roles_update_interval_in_ms == -1 ? DatabaseDescriptor.conf.roles_validity_in_ms : DatabaseDescriptor.conf.roles_update_interval_in_ms;
    }

    public static void setRolesUpdateInterval(int interval) {
        DatabaseDescriptor.conf.roles_update_interval_in_ms = interval;
    }

    public static int getRolesCacheMaxEntries() {
        return DatabaseDescriptor.conf.roles_cache_max_entries;
    }

    public static int setRolesCacheMaxEntries(int maxEntries) {
        DatabaseDescriptor.conf.roles_cache_max_entries = maxEntries;
        return DatabaseDescriptor.conf.roles_cache_max_entries;
    }

    public static int getCredentialsValidity() {
        return DatabaseDescriptor.conf.credentials_validity_in_ms;
    }

    public static void setCredentialsValidity(int timeout) {
        DatabaseDescriptor.conf.credentials_validity_in_ms = timeout;
    }

    public static int getCredentialsUpdateInterval() {
        return DatabaseDescriptor.conf.credentials_update_interval_in_ms == -1 ? DatabaseDescriptor.conf.credentials_validity_in_ms : DatabaseDescriptor.conf.credentials_update_interval_in_ms;
    }

    public static void setCredentialsUpdateInterval(int updateInterval) {
        DatabaseDescriptor.conf.credentials_update_interval_in_ms = updateInterval;
    }

    public static int getCredentialsCacheMaxEntries() {
        return DatabaseDescriptor.conf.credentials_cache_max_entries;
    }

    public static int setCredentialsCacheMaxEntries(int maxEntries) {
        DatabaseDescriptor.conf.credentials_cache_max_entries = maxEntries;
        return DatabaseDescriptor.conf.credentials_cache_max_entries;
    }

    public static int getThriftFramedTransportSize() {
        return DatabaseDescriptor.conf.thrift_framed_transport_size_in_mb * 1024 * 1024;
    }

    public static int getMaxValueSize() {
        return DatabaseDescriptor.conf.max_value_size_in_mb * 1024 * 1024;
    }

    public static void setMaxValueSize(int maxValueSizeInBytes) {
        DatabaseDescriptor.conf.max_value_size_in_mb = maxValueSizeInBytes / 1024 / 1024;
    }

    public static void createAllDirectories() {
        try {
            if (DatabaseDescriptor.conf.data_file_directories.length == 0) {
                throw new ConfigurationException("At least one DataFileDirectory must be specified", false);
            }
            for (String dataFileDirectory : DatabaseDescriptor.conf.data_file_directories) {
                FileUtils.createDirectory(dataFileDirectory);
            }
            if (DatabaseDescriptor.conf.commitlog_directory == null) {
                throw new ConfigurationException("commitlog_directory must be specified", false);
            }
            FileUtils.createDirectory(DatabaseDescriptor.conf.commitlog_directory);
            if (DatabaseDescriptor.conf.hints_directory == null) {
                throw new ConfigurationException("hints_directory must be specified", false);
            }
            FileUtils.createDirectory(DatabaseDescriptor.conf.hints_directory);
            if (DatabaseDescriptor.conf.saved_caches_directory == null) {
                throw new ConfigurationException("saved_caches_directory must be specified", false);
            }
            FileUtils.createDirectory(DatabaseDescriptor.conf.saved_caches_directory);
            if (DatabaseDescriptor.conf.cdc_enabled) {
                if (DatabaseDescriptor.conf.cdc_raw_directory == null) {
                    throw new ConfigurationException("cdc_raw_directory must be specified", false);
                }
                FileUtils.createDirectory(DatabaseDescriptor.conf.cdc_raw_directory);
            }
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Bad configuration; unable to start server: " + e.getMessage());
        }
        catch (FSWriteError e) {
            throw new IllegalStateException(e.getCause().getMessage() + "; unable to start server");
        }
    }

    public static IPartitioner getPartitioner() {
        return partitioner;
    }

    public static String getPartitionerName() {
        return paritionerName;
    }

    public static IPartitioner setPartitionerUnsafe(IPartitioner newPartitioner) {
        IPartitioner old = partitioner;
        partitioner = newPartitioner;
        return old;
    }

    public static IEndpointSnitch getEndpointSnitch() {
        return snitch;
    }

    public static void setEndpointSnitch(IEndpointSnitch eps) {
        snitch = eps;
    }

    public static IRequestScheduler getRequestScheduler() {
        return requestScheduler;
    }

    public static RequestSchedulerOptions getRequestSchedulerOptions() {
        return requestSchedulerOptions;
    }

    public static Config.RequestSchedulerId getRequestSchedulerId() {
        return requestSchedulerId;
    }

    public static int getColumnIndexSize() {
        return DatabaseDescriptor.conf.column_index_size_in_kb * 1024;
    }

    @VisibleForTesting
    public static void setColumnIndexSize(int val) {
        DatabaseDescriptor.conf.column_index_size_in_kb = val;
    }

    public static int getColumnIndexCacheSize() {
        return DatabaseDescriptor.conf.column_index_cache_size_in_kb * 1024;
    }

    @VisibleForTesting
    public static void setColumnIndexCacheSize(int val) {
        DatabaseDescriptor.conf.column_index_cache_size_in_kb = val;
    }

    public static int getBatchSizeWarnThreshold() {
        return DatabaseDescriptor.conf.batch_size_warn_threshold_in_kb * 1024;
    }

    public static long getBatchSizeFailThreshold() {
        return (long)DatabaseDescriptor.conf.batch_size_fail_threshold_in_kb * 1024L;
    }

    public static int getBatchSizeFailThresholdInKB() {
        return DatabaseDescriptor.conf.batch_size_fail_threshold_in_kb;
    }

    public static int getUnloggedBatchAcrossPartitionsWarnThreshold() {
        return DatabaseDescriptor.conf.unlogged_batch_across_partitions_warn_threshold;
    }

    public static void setBatchSizeWarnThresholdInKB(int threshold) {
        DatabaseDescriptor.conf.batch_size_warn_threshold_in_kb = threshold;
    }

    public static void setBatchSizeFailThresholdInKB(int threshold) {
        DatabaseDescriptor.conf.batch_size_fail_threshold_in_kb = threshold;
    }

    public static Collection<String> getInitialTokens() {
        return DatabaseDescriptor.tokensFromString(System.getProperty("cassandra.initial_token", DatabaseDescriptor.conf.initial_token));
    }

    public static String getAllocateTokensForKeyspace() {
        return System.getProperty("cassandra.allocate_tokens_for_keyspace", DatabaseDescriptor.conf.allocate_tokens_for_keyspace);
    }

    public static Collection<String> tokensFromString(String tokenString) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (tokenString != null) {
            for (String token : StringUtils.split((String)tokenString, (char)',')) {
                tokens.add(token.trim());
            }
        }
        return tokens;
    }

    public static int getNumTokens() {
        return DatabaseDescriptor.conf.num_tokens;
    }

    public static InetAddress getReplaceAddress() {
        try {
            if (System.getProperty("cassandra.replace_address", null) != null) {
                return InetAddress.getByName(System.getProperty("cassandra.replace_address", null));
            }
            if (System.getProperty("cassandra.replace_address_first_boot", null) != null) {
                return InetAddress.getByName(System.getProperty("cassandra.replace_address_first_boot", null));
            }
            return null;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Replacement host name could not be resolved or scope_id was specified for a global IPv6 address", e);
        }
    }

    public static Collection<String> getReplaceTokens() {
        return DatabaseDescriptor.tokensFromString(System.getProperty("cassandra.replace_token", null));
    }

    public static UUID getReplaceNode() {
        try {
            return UUID.fromString(System.getProperty("cassandra.replace_node", null));
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static String getClusterName() {
        return DatabaseDescriptor.conf.cluster_name;
    }

    public static int getStoragePort() {
        return Integer.parseInt(System.getProperty("cassandra.storage_port", Integer.toString(DatabaseDescriptor.conf.storage_port)));
    }

    public static int getSSLStoragePort() {
        return Integer.parseInt(System.getProperty("cassandra.ssl_storage_port", Integer.toString(DatabaseDescriptor.conf.ssl_storage_port)));
    }

    public static int getRpcPort() {
        return Integer.parseInt(System.getProperty("cassandra.rpc_port", Integer.toString(DatabaseDescriptor.conf.rpc_port)));
    }

    public static int getRpcListenBacklog() {
        return DatabaseDescriptor.conf.rpc_listen_backlog;
    }

    public static long getRpcTimeout() {
        return DatabaseDescriptor.conf.request_timeout_in_ms;
    }

    public static void setRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.request_timeout_in_ms = timeOutInMillis;
    }

    public static long getReadRpcTimeout() {
        return DatabaseDescriptor.conf.read_request_timeout_in_ms;
    }

    public static void setReadRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.read_request_timeout_in_ms = timeOutInMillis;
    }

    public static long getRangeRpcTimeout() {
        return DatabaseDescriptor.conf.range_request_timeout_in_ms;
    }

    public static void setRangeRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.range_request_timeout_in_ms = timeOutInMillis;
    }

    public static long getWriteRpcTimeout() {
        return DatabaseDescriptor.conf.write_request_timeout_in_ms;
    }

    public static void setWriteRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.write_request_timeout_in_ms = timeOutInMillis;
    }

    public static long getCounterWriteRpcTimeout() {
        return DatabaseDescriptor.conf.counter_write_request_timeout_in_ms;
    }

    public static void setCounterWriteRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.counter_write_request_timeout_in_ms = timeOutInMillis;
    }

    public static long getCasContentionTimeout() {
        return DatabaseDescriptor.conf.cas_contention_timeout_in_ms;
    }

    public static void setCasContentionTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.cas_contention_timeout_in_ms = timeOutInMillis;
    }

    public static long getTruncateRpcTimeout() {
        return DatabaseDescriptor.conf.truncate_request_timeout_in_ms;
    }

    public static void setTruncateRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.truncate_request_timeout_in_ms = timeOutInMillis;
    }

    public static boolean hasCrossNodeTimeout() {
        return DatabaseDescriptor.conf.cross_node_timeout;
    }

    public static long getSlowQueryTimeout() {
        return DatabaseDescriptor.conf.slow_query_log_timeout_in_ms;
    }

    public static long getMinRpcTimeout() {
        return Longs.min((long[])new long[]{DatabaseDescriptor.getRpcTimeout(), DatabaseDescriptor.getReadRpcTimeout(), DatabaseDescriptor.getRangeRpcTimeout(), DatabaseDescriptor.getWriteRpcTimeout(), DatabaseDescriptor.getCounterWriteRpcTimeout(), DatabaseDescriptor.getTruncateRpcTimeout()});
    }

    public static double getPhiConvictThreshold() {
        return DatabaseDescriptor.conf.phi_convict_threshold;
    }

    public static void setPhiConvictThreshold(double phiConvictThreshold) {
        DatabaseDescriptor.conf.phi_convict_threshold = phiConvictThreshold;
    }

    public static int getConcurrentReaders() {
        return DatabaseDescriptor.conf.concurrent_reads;
    }

    public static int getConcurrentWriters() {
        return DatabaseDescriptor.conf.concurrent_writes;
    }

    public static int getConcurrentCounterWriters() {
        return DatabaseDescriptor.conf.concurrent_counter_writes;
    }

    public static int getConcurrentViewWriters() {
        return DatabaseDescriptor.conf.concurrent_materialized_view_writes;
    }

    public static int getFlushWriters() {
        return DatabaseDescriptor.conf.memtable_flush_writers;
    }

    public static int getConcurrentCompactors() {
        return DatabaseDescriptor.conf.concurrent_compactors;
    }

    public static void setConcurrentCompactors(int value) {
        DatabaseDescriptor.conf.concurrent_compactors = value;
    }

    public static int getCompactionThroughputMbPerSec() {
        return DatabaseDescriptor.conf.compaction_throughput_mb_per_sec;
    }

    public static void setCompactionThroughputMbPerSec(int value) {
        DatabaseDescriptor.conf.compaction_throughput_mb_per_sec = value;
    }

    public static long getCompactionLargePartitionWarningThreshold() {
        return (long)DatabaseDescriptor.conf.compaction_large_partition_warning_threshold_mb * 1024L * 1024L;
    }

    public static long getMinFreeSpacePerDriveInBytes() {
        return (long)DatabaseDescriptor.conf.min_free_space_per_drive_in_mb * 1024L * 1024L;
    }

    public static boolean getDisableSTCSInL0() {
        return disableSTCSInL0;
    }

    public static int getStreamThroughputOutboundMegabitsPerSec() {
        return DatabaseDescriptor.conf.stream_throughput_outbound_megabits_per_sec;
    }

    public static void setStreamThroughputOutboundMegabitsPerSec(int value) {
        DatabaseDescriptor.conf.stream_throughput_outbound_megabits_per_sec = value;
    }

    public static int getInterDCStreamThroughputOutboundMegabitsPerSec() {
        return DatabaseDescriptor.conf.inter_dc_stream_throughput_outbound_megabits_per_sec;
    }

    public static void setInterDCStreamThroughputOutboundMegabitsPerSec(int value) {
        DatabaseDescriptor.conf.inter_dc_stream_throughput_outbound_megabits_per_sec = value;
    }

    public static String[] getAllDataFileLocations() {
        return DatabaseDescriptor.conf.data_file_directories;
    }

    public static String getCommitLogLocation() {
        return DatabaseDescriptor.conf.commitlog_directory;
    }

    @VisibleForTesting
    public static void setCommitLogLocation(String value) {
        DatabaseDescriptor.conf.commitlog_directory = value;
    }

    public static ParameterizedClass getCommitLogCompression() {
        return DatabaseDescriptor.conf.commitlog_compression;
    }

    public static void setCommitLogCompression(ParameterizedClass compressor) {
        DatabaseDescriptor.conf.commitlog_compression = compressor;
    }

    public static int getCommitLogMaxCompressionBuffersInPool() {
        return DatabaseDescriptor.conf.commitlog_max_compression_buffers_in_pool;
    }

    public static void setCommitLogMaxCompressionBuffersPerPool(int buffers) {
        DatabaseDescriptor.conf.commitlog_max_compression_buffers_in_pool = buffers;
    }

    public static int getMaxMutationSize() {
        return DatabaseDescriptor.conf.max_mutation_size_in_kb * 1024;
    }

    public static int getTombstoneWarnThreshold() {
        return DatabaseDescriptor.conf.tombstone_warn_threshold;
    }

    public static void setTombstoneWarnThreshold(int threshold) {
        DatabaseDescriptor.conf.tombstone_warn_threshold = threshold;
    }

    public static int getTombstoneFailureThreshold() {
        return DatabaseDescriptor.conf.tombstone_failure_threshold;
    }

    public static void setTombstoneFailureThreshold(int threshold) {
        DatabaseDescriptor.conf.tombstone_failure_threshold = threshold;
    }

    public static int getCachedReplicaRowsWarnThreshold() {
        return DatabaseDescriptor.conf.replica_filtering_protection.cached_rows_warn_threshold;
    }

    public static void setCachedReplicaRowsWarnThreshold(int threshold) {
        DatabaseDescriptor.conf.replica_filtering_protection.cached_rows_warn_threshold = threshold;
    }

    public static int getCachedReplicaRowsFailThreshold() {
        return DatabaseDescriptor.conf.replica_filtering_protection.cached_rows_fail_threshold;
    }

    public static void setCachedReplicaRowsFailThreshold(int threshold) {
        DatabaseDescriptor.conf.replica_filtering_protection.cached_rows_fail_threshold = threshold;
    }

    public static int getCommitLogSegmentSize() {
        return DatabaseDescriptor.conf.commitlog_segment_size_in_mb * 1024 * 1024;
    }

    public static void setCommitLogSegmentSize(int sizeMegabytes) {
        DatabaseDescriptor.conf.commitlog_segment_size_in_mb = sizeMegabytes;
    }

    public static String getSavedCachesLocation() {
        return DatabaseDescriptor.conf.saved_caches_directory;
    }

    public static Set<InetAddress> getSeeds() {
        return ImmutableSet.builder().addAll(seedProvider.getSeeds()).build();
    }

    public static InetAddress getListenAddress() {
        return listenAddress;
    }

    public static InetAddress getBroadcastAddress() {
        return broadcastAddress;
    }

    public static boolean shouldListenOnBroadcastAddress() {
        return DatabaseDescriptor.conf.listen_on_broadcast_address;
    }

    public static IInternodeAuthenticator getInternodeAuthenticator() {
        return internodeAuthenticator;
    }

    public static void setInternodeAuthenticator(IInternodeAuthenticator internodeAuthenticator) {
        DatabaseDescriptor.internodeAuthenticator = internodeAuthenticator;
    }

    public static void setBroadcastAddress(InetAddress broadcastAdd) {
        broadcastAddress = broadcastAdd;
    }

    public static boolean startRpc() {
        return DatabaseDescriptor.conf.start_rpc;
    }

    public static InetAddress getRpcAddress() {
        return rpcAddress;
    }

    public static void setBroadcastRpcAddress(InetAddress broadcastRPCAddr) {
        broadcastRpcAddress = broadcastRPCAddr;
    }

    public static InetAddress getBroadcastRpcAddress() {
        return broadcastRpcAddress;
    }

    public static String getRpcServerType() {
        return DatabaseDescriptor.conf.rpc_server_type;
    }

    public static boolean getRpcKeepAlive() {
        return DatabaseDescriptor.conf.rpc_keepalive;
    }

    public static Integer getRpcMinThreads() {
        return DatabaseDescriptor.conf.rpc_min_threads;
    }

    public static Integer getRpcMaxThreads() {
        return DatabaseDescriptor.conf.rpc_max_threads;
    }

    public static Integer getRpcSendBufferSize() {
        return DatabaseDescriptor.conf.rpc_send_buff_size_in_bytes;
    }

    public static Integer getRpcRecvBufferSize() {
        return DatabaseDescriptor.conf.rpc_recv_buff_size_in_bytes;
    }

    public static int getInternodeSendBufferSize() {
        return DatabaseDescriptor.conf.internode_send_buff_size_in_bytes;
    }

    public static int getInternodeRecvBufferSize() {
        return DatabaseDescriptor.conf.internode_recv_buff_size_in_bytes;
    }

    public static boolean startNativeTransport() {
        return DatabaseDescriptor.conf.start_native_transport;
    }

    public static int getNativeTransportPort() {
        return Integer.parseInt(System.getProperty("cassandra.native_transport_port", Integer.toString(DatabaseDescriptor.conf.native_transport_port)));
    }

    @VisibleForTesting
    public static void setNativeTransportPort(int port) {
        DatabaseDescriptor.conf.native_transport_port = port;
    }

    public static int getNativeTransportPortSSL() {
        return DatabaseDescriptor.conf.native_transport_port_ssl == null ? DatabaseDescriptor.getNativeTransportPort() : DatabaseDescriptor.conf.native_transport_port_ssl;
    }

    @VisibleForTesting
    public static void setNativeTransportPortSSL(Integer port) {
        DatabaseDescriptor.conf.native_transport_port_ssl = port;
    }

    public static int getNativeTransportMaxThreads() {
        return DatabaseDescriptor.conf.native_transport_max_threads;
    }

    public static int getNativeTransportMaxFrameSize() {
        return DatabaseDescriptor.conf.native_transport_max_frame_size_in_mb * 1024 * 1024;
    }

    public static long getNativeTransportMaxConcurrentConnections() {
        return DatabaseDescriptor.conf.native_transport_max_concurrent_connections;
    }

    public static void setNativeTransportMaxConcurrentConnections(long nativeTransportMaxConcurrentConnections) {
        DatabaseDescriptor.conf.native_transport_max_concurrent_connections = nativeTransportMaxConcurrentConnections;
    }

    public static long getNativeTransportMaxConcurrentConnectionsPerIp() {
        return DatabaseDescriptor.conf.native_transport_max_concurrent_connections_per_ip;
    }

    public static void setNativeTransportMaxConcurrentConnectionsPerIp(long native_transport_max_concurrent_connections_per_ip) {
        DatabaseDescriptor.conf.native_transport_max_concurrent_connections_per_ip = native_transport_max_concurrent_connections_per_ip;
    }

    public static boolean useNativeTransportLegacyFlusher() {
        return DatabaseDescriptor.conf.native_transport_flush_in_batches_legacy;
    }

    public static int getNativeProtocolMaxVersionOverride() {
        return DatabaseDescriptor.conf.native_transport_max_negotiable_protocol_version;
    }

    public static double getCommitLogSyncBatchWindow() {
        return DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms;
    }

    public static void setCommitLogSyncBatchWindow(double windowMillis) {
        DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms = windowMillis;
    }

    public static long getNativeTransportMaxConcurrentRequestsInBytesPerIp() {
        return DatabaseDescriptor.conf.native_transport_max_concurrent_requests_in_bytes_per_ip;
    }

    public static void setNativeTransportMaxConcurrentRequestsInBytesPerIp(long maxConcurrentRequestsInBytes) {
        DatabaseDescriptor.conf.native_transport_max_concurrent_requests_in_bytes_per_ip = maxConcurrentRequestsInBytes;
    }

    public static long getNativeTransportMaxConcurrentRequestsInBytes() {
        return DatabaseDescriptor.conf.native_transport_max_concurrent_requests_in_bytes;
    }

    public static void setNativeTransportMaxConcurrentRequestsInBytes(long maxConcurrentRequestsInBytes) {
        DatabaseDescriptor.conf.native_transport_max_concurrent_requests_in_bytes = maxConcurrentRequestsInBytes;
    }

    public static int getCommitLogSyncPeriod() {
        return DatabaseDescriptor.conf.commitlog_sync_period_in_ms;
    }

    public static void setCommitLogSyncPeriod(int periodMillis) {
        DatabaseDescriptor.conf.commitlog_sync_period_in_ms = periodMillis;
    }

    public static Config.CommitLogSync getCommitLogSync() {
        return DatabaseDescriptor.conf.commitlog_sync;
    }

    public static void setCommitLogSync(Config.CommitLogSync sync) {
        DatabaseDescriptor.conf.commitlog_sync = sync;
    }

    public static Config.DiskAccessMode getDiskAccessMode() {
        return DatabaseDescriptor.conf.disk_access_mode;
    }

    @VisibleForTesting
    public static void setDiskAccessMode(Config.DiskAccessMode mode) {
        DatabaseDescriptor.conf.disk_access_mode = mode;
    }

    public static Config.DiskAccessMode getIndexAccessMode() {
        return indexAccessMode;
    }

    @VisibleForTesting
    public static void setIndexAccessMode(Config.DiskAccessMode mode) {
        indexAccessMode = mode;
    }

    public static void setDiskFailurePolicy(Config.DiskFailurePolicy policy) {
        DatabaseDescriptor.conf.disk_failure_policy = policy;
    }

    public static Config.DiskFailurePolicy getDiskFailurePolicy() {
        return DatabaseDescriptor.conf.disk_failure_policy;
    }

    public static void setCommitFailurePolicy(Config.CommitFailurePolicy policy) {
        DatabaseDescriptor.conf.commit_failure_policy = policy;
    }

    public static Config.CommitFailurePolicy getCommitFailurePolicy() {
        return DatabaseDescriptor.conf.commit_failure_policy;
    }

    public static boolean isSnapshotBeforeCompaction() {
        return DatabaseDescriptor.conf.snapshot_before_compaction;
    }

    public static boolean isAutoSnapshot() {
        return DatabaseDescriptor.conf.auto_snapshot;
    }

    @VisibleForTesting
    public static void setAutoSnapshot(boolean autoSnapshot) {
        DatabaseDescriptor.conf.auto_snapshot = autoSnapshot;
    }

    @VisibleForTesting
    public static boolean getAutoSnapshot() {
        return DatabaseDescriptor.conf.auto_snapshot;
    }

    public static boolean isAutoBootstrap() {
        return Boolean.parseBoolean(System.getProperty("cassandra.auto_bootstrap", Boolean.toString(DatabaseDescriptor.conf.auto_bootstrap)));
    }

    public static void setHintedHandoffEnabled(boolean hintedHandoffEnabled) {
        DatabaseDescriptor.conf.hinted_handoff_enabled = hintedHandoffEnabled;
    }

    public static boolean hintedHandoffEnabled() {
        return DatabaseDescriptor.conf.hinted_handoff_enabled;
    }

    public static Set<String> hintedHandoffDisabledDCs() {
        return DatabaseDescriptor.conf.hinted_handoff_disabled_datacenters;
    }

    public static void enableHintsForDC(String dc) {
        DatabaseDescriptor.conf.hinted_handoff_disabled_datacenters.remove(dc);
    }

    public static void disableHintsForDC(String dc) {
        DatabaseDescriptor.conf.hinted_handoff_disabled_datacenters.add(dc);
    }

    public static void setMaxHintWindow(int ms) {
        DatabaseDescriptor.conf.max_hint_window_in_ms = ms;
    }

    public static int getMaxHintWindow() {
        return DatabaseDescriptor.conf.max_hint_window_in_ms;
    }

    public static File getHintsDirectory() {
        return new File(DatabaseDescriptor.conf.hints_directory);
    }

    public static File getSerializedCachePath(CacheService.CacheType cacheType, String version, String extension) {
        String name = cacheType.toString() + (version == null ? "" : '-' + version + '.' + extension);
        return new File(DatabaseDescriptor.conf.saved_caches_directory, name);
    }

    public static int getDynamicUpdateInterval() {
        return DatabaseDescriptor.conf.dynamic_snitch_update_interval_in_ms;
    }

    public static void setDynamicUpdateInterval(int dynamicUpdateInterval) {
        DatabaseDescriptor.conf.dynamic_snitch_update_interval_in_ms = dynamicUpdateInterval;
    }

    public static int getDynamicResetInterval() {
        return DatabaseDescriptor.conf.dynamic_snitch_reset_interval_in_ms;
    }

    public static void setDynamicResetInterval(int dynamicResetInterval) {
        DatabaseDescriptor.conf.dynamic_snitch_reset_interval_in_ms = dynamicResetInterval;
    }

    public static double getDynamicBadnessThreshold() {
        return DatabaseDescriptor.conf.dynamic_snitch_badness_threshold;
    }

    public static void setDynamicBadnessThreshold(double dynamicBadnessThreshold) {
        DatabaseDescriptor.conf.dynamic_snitch_badness_threshold = dynamicBadnessThreshold;
    }

    public static EncryptionOptions.ServerEncryptionOptions getServerEncryptionOptions() {
        return DatabaseDescriptor.conf.server_encryption_options;
    }

    public static EncryptionOptions.ClientEncryptionOptions getClientEncryptionOptions() {
        return DatabaseDescriptor.conf.client_encryption_options;
    }

    public static int getHintedHandoffThrottleInKB() {
        return DatabaseDescriptor.conf.hinted_handoff_throttle_in_kb;
    }

    public static int getBatchlogReplayThrottleInKB() {
        return DatabaseDescriptor.conf.batchlog_replay_throttle_in_kb;
    }

    public static void setHintedHandoffThrottleInKB(int throttleInKB) {
        DatabaseDescriptor.conf.hinted_handoff_throttle_in_kb = throttleInKB;
    }

    public static int getMaxHintsDeliveryThreads() {
        return DatabaseDescriptor.conf.max_hints_delivery_threads;
    }

    public static int getHintsFlushPeriodInMS() {
        return DatabaseDescriptor.conf.hints_flush_period_in_ms;
    }

    public static long getMaxHintsFileSize() {
        return (long)DatabaseDescriptor.conf.max_hints_file_size_in_mb * 1024L * 1024L;
    }

    public static ParameterizedClass getHintsCompression() {
        return DatabaseDescriptor.conf.hints_compression;
    }

    public static void setHintsCompression(ParameterizedClass parameterizedClass) {
        DatabaseDescriptor.conf.hints_compression = parameterizedClass;
    }

    public static boolean isIncrementalBackupsEnabled() {
        return DatabaseDescriptor.conf.incremental_backups;
    }

    public static void setIncrementalBackupsEnabled(boolean value) {
        DatabaseDescriptor.conf.incremental_backups = value;
    }

    public static int getFileCacheSizeInMB() {
        if (DatabaseDescriptor.conf.file_cache_size_in_mb == null) {
            assert (DatabaseDescriptor.isClientInitialized());
            return 0;
        }
        return DatabaseDescriptor.conf.file_cache_size_in_mb;
    }

    public static boolean getFileCacheRoundUp() {
        if (DatabaseDescriptor.conf.file_cache_round_up == null) {
            assert (DatabaseDescriptor.isClientInitialized());
            return false;
        }
        return DatabaseDescriptor.conf.file_cache_round_up;
    }

    public static boolean getBufferPoolUseHeapIfExhausted() {
        return DatabaseDescriptor.conf.buffer_pool_use_heap_if_exhausted;
    }

    public static DiskOptimizationStrategy getDiskOptimizationStrategy() {
        return diskOptimizationStrategy;
    }

    public static double getDiskOptimizationEstimatePercentile() {
        return DatabaseDescriptor.conf.disk_optimization_estimate_percentile;
    }

    public static long getTotalCommitlogSpaceInMB() {
        return DatabaseDescriptor.conf.commitlog_total_space_in_mb.intValue();
    }

    public static int getSSTablePreempiveOpenIntervalInMB() {
        return FBUtilities.isWindows ? -1 : DatabaseDescriptor.conf.sstable_preemptive_open_interval_in_mb;
    }

    public static void setSSTablePreempiveOpenIntervalInMB(int mb) {
        DatabaseDescriptor.conf.sstable_preemptive_open_interval_in_mb = mb;
    }

    public static boolean getTrickleFsync() {
        return DatabaseDescriptor.conf.trickle_fsync;
    }

    public static int getTrickleFsyncIntervalInKb() {
        return DatabaseDescriptor.conf.trickle_fsync_interval_in_kb;
    }

    public static long getKeyCacheSizeInMB() {
        return keyCacheSizeInMB;
    }

    public static long getIndexSummaryCapacityInMB() {
        return indexSummaryCapacityInMB;
    }

    public static int getKeyCacheSavePeriod() {
        return DatabaseDescriptor.conf.key_cache_save_period;
    }

    public static void setKeyCacheSavePeriod(int keyCacheSavePeriod) {
        DatabaseDescriptor.conf.key_cache_save_period = keyCacheSavePeriod;
    }

    public static int getKeyCacheKeysToSave() {
        return DatabaseDescriptor.conf.key_cache_keys_to_save;
    }

    public static void setKeyCacheKeysToSave(int keyCacheKeysToSave) {
        DatabaseDescriptor.conf.key_cache_keys_to_save = keyCacheKeysToSave;
    }

    public static String getRowCacheClassName() {
        return DatabaseDescriptor.conf.row_cache_class_name;
    }

    public static long getRowCacheSizeInMB() {
        return DatabaseDescriptor.conf.row_cache_size_in_mb;
    }

    @VisibleForTesting
    public static void setRowCacheSizeInMB(long val) {
        DatabaseDescriptor.conf.row_cache_size_in_mb = val;
    }

    public static int getRowCacheSavePeriod() {
        return DatabaseDescriptor.conf.row_cache_save_period;
    }

    public static void setRowCacheSavePeriod(int rowCacheSavePeriod) {
        DatabaseDescriptor.conf.row_cache_save_period = rowCacheSavePeriod;
    }

    public static int getRowCacheKeysToSave() {
        return DatabaseDescriptor.conf.row_cache_keys_to_save;
    }

    public static long getCounterCacheSizeInMB() {
        return counterCacheSizeInMB;
    }

    public static void setRowCacheKeysToSave(int rowCacheKeysToSave) {
        DatabaseDescriptor.conf.row_cache_keys_to_save = rowCacheKeysToSave;
    }

    public static int getCounterCacheSavePeriod() {
        return DatabaseDescriptor.conf.counter_cache_save_period;
    }

    public static void setCounterCacheSavePeriod(int counterCacheSavePeriod) {
        DatabaseDescriptor.conf.counter_cache_save_period = counterCacheSavePeriod;
    }

    public static int getCounterCacheKeysToSave() {
        return DatabaseDescriptor.conf.counter_cache_keys_to_save;
    }

    public static void setCounterCacheKeysToSave(int counterCacheKeysToSave) {
        DatabaseDescriptor.conf.counter_cache_keys_to_save = counterCacheKeysToSave;
    }

    public static void setStreamingSocketTimeout(int value) {
        DatabaseDescriptor.conf.streaming_socket_timeout_in_ms = value;
    }

    @Deprecated
    public static int getStreamingSocketTimeout() {
        return DatabaseDescriptor.conf.streaming_socket_timeout_in_ms;
    }

    public static int getStreamingKeepAlivePeriod() {
        return DatabaseDescriptor.conf.streaming_keep_alive_period_in_secs;
    }

    public static String getLocalDataCenter() {
        return localDC;
    }

    public static Comparator<InetAddress> getLocalComparator() {
        return localComparator;
    }

    public static Config.InternodeCompression internodeCompression() {
        return DatabaseDescriptor.conf.internode_compression;
    }

    public static boolean getInterDCTcpNoDelay() {
        return DatabaseDescriptor.conf.inter_dc_tcp_nodelay;
    }

    public static long getMemtableHeapSpaceInMb() {
        return DatabaseDescriptor.conf.memtable_heap_space_in_mb.intValue();
    }

    public static long getMemtableOffheapSpaceInMb() {
        return DatabaseDescriptor.conf.memtable_offheap_space_in_mb.intValue();
    }

    public static Config.MemtableAllocationType getMemtableAllocationType() {
        return DatabaseDescriptor.conf.memtable_allocation_type;
    }

    public static Float getMemtableCleanupThreshold() {
        return DatabaseDescriptor.conf.memtable_cleanup_threshold;
    }

    public static int getRepairSessionMaxTreeDepth() {
        return DatabaseDescriptor.conf.repair_session_max_tree_depth;
    }

    public static void setRepairSessionMaxTreeDepth(int depth) {
        if (depth < 10) {
            throw new ConfigurationException("Cannot set repair_session_max_tree_depth to " + depth + " which is < 10, doing nothing");
        }
        if (depth > 20) {
            logger.warn("repair_session_max_tree_depth of " + depth + " > 20 could lead to excessive memory usage");
        }
        DatabaseDescriptor.conf.repair_session_max_tree_depth = depth;
    }

    public static int getIndexSummaryResizeIntervalInMinutes() {
        return DatabaseDescriptor.conf.index_summary_resize_interval_in_minutes;
    }

    public static boolean hasLargeAddressSpace() {
        String arch;
        String datamodel = System.getProperty("sun.arch.data.model");
        if (datamodel != null) {
            switch (datamodel) {
                case "64": {
                    return true;
                }
                case "32": {
                    return false;
                }
            }
        }
        return (arch = System.getProperty("os.arch")).contains("64") || arch.contains("sparcv9");
    }

    public static int getTracetypeRepairTTL() {
        return DatabaseDescriptor.conf.tracetype_repair_ttl;
    }

    public static int getTracetypeQueryTTL() {
        return DatabaseDescriptor.conf.tracetype_query_ttl;
    }

    public static String getOtcCoalescingStrategy() {
        return DatabaseDescriptor.conf.otc_coalescing_strategy;
    }

    public static int getOtcCoalescingWindow() {
        return DatabaseDescriptor.conf.otc_coalescing_window_us;
    }

    public static int getOtcCoalescingEnoughCoalescedMessages() {
        return DatabaseDescriptor.conf.otc_coalescing_enough_coalesced_messages;
    }

    public static void setOtcCoalescingEnoughCoalescedMessages(int otc_coalescing_enough_coalesced_messages) {
        DatabaseDescriptor.conf.otc_coalescing_enough_coalesced_messages = otc_coalescing_enough_coalesced_messages;
    }

    public static int getOtcBacklogExpirationInterval() {
        return DatabaseDescriptor.conf.otc_backlog_expiration_interval_ms;
    }

    public static void setOtcBacklogExpirationInterval(int intervalInMillis) {
        DatabaseDescriptor.conf.otc_backlog_expiration_interval_ms = intervalInMillis;
    }

    public static int getWindowsTimerInterval() {
        return DatabaseDescriptor.conf.windows_timer_interval;
    }

    public static long getPreparedStatementsCacheSizeMB() {
        return preparedStatementsCacheSizeInMB;
    }

    public static long getThriftPreparedStatementsCacheSizeMB() {
        return thriftPreparedStatementsCacheSizeInMB;
    }

    public static boolean enableUserDefinedFunctions() {
        return DatabaseDescriptor.conf.enable_user_defined_functions;
    }

    public static boolean enableScriptedUserDefinedFunctions() {
        return DatabaseDescriptor.conf.enable_scripted_user_defined_functions;
    }

    public static void enableScriptedUserDefinedFunctions(boolean enableScriptedUserDefinedFunctions) {
        DatabaseDescriptor.conf.enable_scripted_user_defined_functions = enableScriptedUserDefinedFunctions;
    }

    public static boolean enableUserDefinedFunctionsThreads() {
        return DatabaseDescriptor.conf.enable_user_defined_functions_threads;
    }

    public static long getUserDefinedFunctionWarnTimeout() {
        return DatabaseDescriptor.conf.user_defined_function_warn_timeout;
    }

    public static void setUserDefinedFunctionWarnTimeout(long userDefinedFunctionWarnTimeout) {
        DatabaseDescriptor.conf.user_defined_function_warn_timeout = userDefinedFunctionWarnTimeout;
    }

    public static boolean getEnableMaterializedViews() {
        return DatabaseDescriptor.conf.enable_materialized_views;
    }

    public static void setEnableMaterializedViews(boolean enableMaterializedViews) {
        DatabaseDescriptor.conf.enable_materialized_views = enableMaterializedViews;
    }

    public static boolean getEnableSASIIndexes() {
        return DatabaseDescriptor.conf.enable_sasi_indexes;
    }

    public static void setEnableSASIIndexes(boolean enableSASIIndexes) {
        DatabaseDescriptor.conf.enable_sasi_indexes = enableSASIIndexes;
    }

    public static boolean enableDropCompactStorage() {
        return DatabaseDescriptor.conf.enable_drop_compact_storage;
    }

    @VisibleForTesting
    public static void setEnableDropCompactStorage(boolean enableDropCompactStorage) {
        DatabaseDescriptor.conf.enable_drop_compact_storage = enableDropCompactStorage;
    }

    public static long getUserDefinedFunctionFailTimeout() {
        return DatabaseDescriptor.conf.user_defined_function_fail_timeout;
    }

    public static void setUserDefinedFunctionFailTimeout(long userDefinedFunctionFailTimeout) {
        DatabaseDescriptor.conf.user_defined_function_fail_timeout = userDefinedFunctionFailTimeout;
    }

    public static Config.UserFunctionTimeoutPolicy getUserFunctionTimeoutPolicy() {
        return DatabaseDescriptor.conf.user_function_timeout_policy;
    }

    public static void setUserFunctionTimeoutPolicy(Config.UserFunctionTimeoutPolicy userFunctionTimeoutPolicy) {
        DatabaseDescriptor.conf.user_function_timeout_policy = userFunctionTimeoutPolicy;
    }

    public static long getGCLogThreshold() {
        return DatabaseDescriptor.conf.gc_log_threshold_in_ms;
    }

    public static EncryptionContext getEncryptionContext() {
        return encryptionContext;
    }

    public static long getGCWarnThreshold() {
        return DatabaseDescriptor.conf.gc_warn_threshold_in_ms;
    }

    public static boolean isCDCEnabled() {
        return DatabaseDescriptor.conf.cdc_enabled;
    }

    public static void setCDCEnabled(boolean cdc_enabled) {
        DatabaseDescriptor.conf.cdc_enabled = cdc_enabled;
    }

    public static String getCDCLogLocation() {
        return DatabaseDescriptor.conf.cdc_raw_directory;
    }

    public static int getCDCSpaceInMB() {
        return DatabaseDescriptor.conf.cdc_total_space_in_mb;
    }

    @VisibleForTesting
    public static void setCDCSpaceInMB(int input) {
        DatabaseDescriptor.conf.cdc_total_space_in_mb = input;
    }

    public static int getCDCDiskCheckInterval() {
        return DatabaseDescriptor.conf.cdc_free_space_check_interval_ms;
    }

    @VisibleForTesting
    public static void setEncryptionContext(EncryptionContext ec) {
        encryptionContext = ec;
    }

    public static int searchConcurrencyFactor() {
        return searchConcurrencyFactor;
    }

    public static boolean isUnsafeSystem() {
        return unsafeSystem;
    }

    public static void setBackPressureEnabled(boolean backPressureEnabled) {
        DatabaseDescriptor.conf.back_pressure_enabled = backPressureEnabled;
    }

    public static boolean backPressureEnabled() {
        return DatabaseDescriptor.conf.back_pressure_enabled;
    }

    @VisibleForTesting
    public static void setBackPressureStrategy(BackPressureStrategy strategy) {
        backPressureStrategy = strategy;
    }

    public static BackPressureStrategy getBackPressureStrategy() {
        return backPressureStrategy;
    }

    public static boolean strictRuntimeChecks() {
        return strictRuntimeChecks;
    }

    public static boolean snapshotOnDuplicateRowDetection() {
        return DatabaseDescriptor.conf.snapshot_on_duplicate_row_detection;
    }

    public static void setSnapshotOnDuplicateRowDetection(boolean enabled) {
        DatabaseDescriptor.conf.snapshot_on_duplicate_row_detection = enabled;
    }

    public static boolean checkForDuplicateRowsDuringReads() {
        return DatabaseDescriptor.conf.check_for_duplicate_rows_during_reads;
    }

    public static void setCheckForDuplicateRowsDuringReads(boolean enabled) {
        DatabaseDescriptor.conf.check_for_duplicate_rows_during_reads = enabled;
    }

    public static boolean checkForDuplicateRowsDuringCompaction() {
        return DatabaseDescriptor.conf.check_for_duplicate_rows_during_compaction;
    }

    public static void setCheckForDuplicateRowsDuringCompaction(boolean enabled) {
        DatabaseDescriptor.conf.check_for_duplicate_rows_during_compaction = enabled;
    }

    static {
        searchConcurrencyFactor = Integer.parseInt(System.getProperty("cassandra.search_concurrency_factor", "1"));
        disableSTCSInL0 = Boolean.getBoolean("cassandra.disable_stcs_in_l0");
        unsafeSystem = Boolean.getBoolean("cassandra.unsafesystem");
        strictRuntimeChecks = Boolean.getBoolean("cassandra.strict.runtime.checks");
    }
}

