/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import com.codahale.metrics.Timer;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;

public final class WaitQueue {
    private static final int CANCELLED = -1;
    private static final int SIGNALLED = 1;
    private static final int NOT_SET = 0;
    private static final AtomicIntegerFieldUpdater signalledUpdater = AtomicIntegerFieldUpdater.newUpdater(RegisteredSignal.class, "state");
    private final ConcurrentLinkedQueue<RegisteredSignal> queue = new ConcurrentLinkedQueue();

    public Signal register() {
        RegisteredSignal signal = new RegisteredSignal();
        this.queue.add(signal);
        return signal;
    }

    public Signal register(Timer.Context context) {
        assert (context != null);
        TimedSignal signal = new TimedSignal(context);
        this.queue.add(signal);
        return signal;
    }

    public boolean signal() {
        RegisteredSignal s;
        if (!this.hasWaiters()) {
            return false;
        }
        while ((s = this.queue.poll()) != null && s.signal() == null) {
        }
        return s != null;
    }

    public void signalAll() {
        if (!this.hasWaiters()) {
            return;
        }
        int i = 0;
        int s = 5;
        Thread randomThread = null;
        Iterator<RegisteredSignal> iter = this.queue.iterator();
        while (iter.hasNext()) {
            RegisteredSignal signal = iter.next();
            Thread signalled = signal.signal();
            if (signalled != null) {
                if (signalled == randomThread) break;
                if (++i == s) {
                    randomThread = signalled;
                    s <<= 1;
                }
            }
            iter.remove();
        }
    }

    private void cleanUpCancelled() {
        Iterator<RegisteredSignal> iter = this.queue.iterator();
        while (iter.hasNext()) {
            RegisteredSignal s = iter.next();
            if (!s.isCancelled()) continue;
            iter.remove();
        }
    }

    public boolean hasWaiters() {
        return !this.queue.isEmpty();
    }

    public int getWaiting() {
        if (!this.hasWaiters()) {
            return 0;
        }
        Iterator<RegisteredSignal> iter = this.queue.iterator();
        int count = 0;
        while (iter.hasNext()) {
            Signal next = iter.next();
            if (next.isCancelled()) continue;
            ++count;
        }
        return count;
    }

    public static Signal any(Signal ... signals) {
        return new AnySignal(signals);
    }

    public static Signal all(Signal ... signals) {
        return new AllSignal(signals);
    }

    public static void waitOnCondition(BooleanSupplier condition, WaitQueue queue) {
        while (!condition.getAsBoolean()) {
            Signal s = queue.register();
            if (!condition.getAsBoolean()) {
                s.awaitUninterruptibly();
                continue;
            }
            s.cancel();
        }
    }

    private static class AllSignal
    extends MultiSignal {
        protected AllSignal(Signal ... signals) {
            super(signals);
        }

        @Override
        public boolean isSignalled() {
            for (Signal signal : this.signals) {
                if (signal.isSignalled()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isSet() {
            for (Signal signal : this.signals) {
                if (signal.isSet()) continue;
                return false;
            }
            return true;
        }
    }

    private static class AnySignal
    extends MultiSignal {
        protected AnySignal(Signal ... signals) {
            super(signals);
        }

        @Override
        public boolean isSignalled() {
            for (Signal signal : this.signals) {
                if (!signal.isSignalled()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isSet() {
            for (Signal signal : this.signals) {
                if (!signal.isSet()) continue;
                return true;
            }
            return false;
        }
    }

    private static abstract class MultiSignal
    extends AbstractSignal {
        final Signal[] signals;

        protected MultiSignal(Signal[] signals) {
            this.signals = signals;
        }

        @Override
        public boolean isCancelled() {
            for (Signal signal : this.signals) {
                if (signal.isCancelled()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean checkAndClear() {
            for (Signal signal : this.signals) {
                signal.checkAndClear();
            }
            return this.isSignalled();
        }

        @Override
        public void cancel() {
            for (Signal signal : this.signals) {
                signal.cancel();
            }
        }
    }

    private final class TimedSignal
    extends RegisteredSignal {
        private final Timer.Context context;

        private TimedSignal(Timer.Context context) {
            this.context = context;
        }

        @Override
        public boolean checkAndClear() {
            this.context.stop();
            return super.checkAndClear();
        }

        @Override
        public void cancel() {
            if (!this.isCancelled()) {
                this.context.stop();
                super.cancel();
            }
        }
    }

    private class RegisteredSignal
    extends AbstractSignal {
        private volatile Thread thread = Thread.currentThread();
        volatile int state;

        private RegisteredSignal() {
        }

        @Override
        public boolean isSignalled() {
            return this.state == 1;
        }

        @Override
        public boolean isCancelled() {
            return this.state == -1;
        }

        @Override
        public boolean isSet() {
            return this.state != 0;
        }

        private Thread signal() {
            if (!this.isSet() && signalledUpdater.compareAndSet(this, 0, 1)) {
                Thread thread = this.thread;
                LockSupport.unpark(thread);
                this.thread = null;
                return thread;
            }
            return null;
        }

        @Override
        public boolean checkAndClear() {
            if (!this.isSet() && signalledUpdater.compareAndSet(this, 0, -1)) {
                this.thread = null;
                WaitQueue.this.cleanUpCancelled();
                return false;
            }
            return true;
        }

        @Override
        public void cancel() {
            if (this.isCancelled()) {
                return;
            }
            if (!signalledUpdater.compareAndSet(this, 0, -1)) {
                this.state = -1;
                WaitQueue.this.signal();
            }
            this.thread = null;
            WaitQueue.this.cleanUpCancelled();
        }
    }

    public static abstract class AbstractSignal
    implements Signal {
        @Override
        public void awaitUninterruptibly() {
            boolean interrupted = false;
            while (!this.isSignalled()) {
                if (Thread.interrupted()) {
                    interrupted = true;
                }
                LockSupport.park();
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            this.checkAndClear();
        }

        @Override
        public void await() throws InterruptedException {
            while (!this.isSignalled()) {
                this.checkInterrupted();
                LockSupport.park();
            }
            this.checkAndClear();
        }

        @Override
        public boolean awaitUntil(long until) throws InterruptedException {
            long now;
            while (until > (now = System.nanoTime()) && !this.isSignalled()) {
                this.checkInterrupted();
                long delta = until - now;
                LockSupport.parkNanos(delta);
            }
            return this.checkAndClear();
        }

        private void checkInterrupted() throws InterruptedException {
            if (Thread.interrupted()) {
                this.cancel();
                throw new InterruptedException();
            }
        }
    }

    public static interface Signal {
        public boolean isSignalled();

        public boolean isCancelled();

        public boolean isSet();

        public boolean checkAndClear();

        public void cancel();

        public void awaitUninterruptibly();

        public void await() throws InterruptedException;

        public boolean awaitUntil(long var1) throws InterruptedException;
    }
}

