/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool.formatter;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TableBuilder {
    private final char columnDelimiter;
    private int[] maximumColumnWidth;
    private final List<String[]> rows = new ArrayList<String[]>();

    public TableBuilder() {
        this(' ');
    }

    public TableBuilder(char columnDelimiter) {
        this.columnDelimiter = columnDelimiter;
    }

    public void add(String ... row) {
        Objects.requireNonNull(row);
        if (this.rows.isEmpty()) {
            this.maximumColumnWidth = new int[row.length];
        }
        if (row.length > this.maximumColumnWidth.length) {
            int[] tmp = new int[row.length];
            System.arraycopy(this.maximumColumnWidth, 0, tmp, 0, this.maximumColumnWidth.length);
            this.maximumColumnWidth = tmp;
        }
        int i = 0;
        for (String col : row) {
            this.maximumColumnWidth[i] = Math.max(this.maximumColumnWidth[i], col != null ? col.length() : 1);
            ++i;
        }
        this.rows.add(row);
    }

    public void printTo(PrintStream out) {
        if (this.rows.isEmpty()) {
            return;
        }
        for (String[] row : this.rows) {
            for (int i = 0; i < this.maximumColumnWidth.length; ++i) {
                String col = i < row.length ? row[i] : "";
                out.print(String.format("%-" + this.maximumColumnWidth[i] + 's', col != null ? col : ""));
                if (i >= this.maximumColumnWidth.length - 1) continue;
                out.print(this.columnDelimiter);
            }
            out.println();
        }
    }
}

