/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.Transactional;

public class RangeAwareSSTableWriter
implements SSTableMultiWriter {
    private final List<PartitionPosition> boundaries;
    private final Directories.DataDirectory[] directories;
    private final int sstableLevel;
    private final long estimatedKeys;
    private final long repairedAt;
    private final SSTableFormat.Type format;
    private final SerializationHeader header;
    private final LifecycleTransaction txn;
    private int currentIndex = -1;
    public final ColumnFamilyStore cfs;
    private final List<SSTableMultiWriter> finishedWriters = new ArrayList<SSTableMultiWriter>();
    private final List<SSTableReader> finishedReaders = new ArrayList<SSTableReader>();
    private SSTableMultiWriter currentWriter = null;

    public RangeAwareSSTableWriter(ColumnFamilyStore cfs, long estimatedKeys, long repairedAt, SSTableFormat.Type format, int sstableLevel, long totalSize, LifecycleTransaction txn, SerializationHeader header) throws IOException {
        this.directories = cfs.getDirectories().getWriteableLocations();
        this.sstableLevel = sstableLevel;
        this.cfs = cfs;
        this.estimatedKeys = estimatedKeys / (long)this.directories.length;
        this.repairedAt = repairedAt;
        this.format = format;
        this.txn = txn;
        this.header = header;
        this.boundaries = StorageService.getDiskBoundaries(cfs, this.directories);
        if (this.boundaries == null) {
            Directories.DataDirectory localDir = cfs.getDirectories().getWriteableLocation(totalSize);
            if (localDir == null) {
                throw new IOException(String.format("Insufficient disk space to store %s", FBUtilities.prettyPrintMemory(totalSize)));
            }
            Descriptor desc = Descriptor.fromFilename(cfs.getSSTablePath(cfs.getDirectories().getLocationForDisk(localDir), format));
            this.currentWriter = cfs.createSSTableMultiWriter(desc, estimatedKeys, repairedAt, sstableLevel, header, txn);
        }
    }

    private void maybeSwitchWriter(DecoratedKey key) {
        if (this.boundaries == null) {
            return;
        }
        boolean switched = false;
        while (this.currentIndex < 0 || key.compareTo(this.boundaries.get(this.currentIndex)) > 0) {
            switched = true;
            ++this.currentIndex;
        }
        if (switched) {
            if (this.currentWriter != null) {
                this.finishedWriters.add(this.currentWriter);
            }
            Descriptor desc = Descriptor.fromFilename(this.cfs.getSSTablePath(this.cfs.getDirectories().getLocationForDisk(this.directories[this.currentIndex])), this.format);
            this.currentWriter = this.cfs.createSSTableMultiWriter(desc, this.estimatedKeys, this.repairedAt, this.sstableLevel, this.header, this.txn);
        }
    }

    @Override
    public boolean append(UnfilteredRowIterator partition) {
        this.maybeSwitchWriter(partition.partitionKey());
        return this.currentWriter.append(partition);
    }

    @Override
    public Collection<SSTableReader> finish(long repairedAt, long maxDataAge, boolean openResult) {
        if (this.currentWriter != null) {
            this.finishedWriters.add(this.currentWriter);
        }
        this.currentWriter = null;
        for (SSTableMultiWriter writer : this.finishedWriters) {
            if (writer.getFilePointer() > 0L) {
                this.finishedReaders.addAll(writer.finish(repairedAt, maxDataAge, openResult));
                continue;
            }
            SSTableMultiWriter.abortOrDie(writer);
        }
        return this.finishedReaders;
    }

    @Override
    public Collection<SSTableReader> finish(boolean openResult) {
        if (this.currentWriter != null) {
            this.finishedWriters.add(this.currentWriter);
        }
        this.currentWriter = null;
        for (SSTableMultiWriter writer : this.finishedWriters) {
            if (writer.getFilePointer() > 0L) {
                this.finishedReaders.addAll(writer.finish(openResult));
                continue;
            }
            SSTableMultiWriter.abortOrDie(writer);
        }
        return this.finishedReaders;
    }

    @Override
    public Collection<SSTableReader> finished() {
        return this.finishedReaders;
    }

    @Override
    public SSTableMultiWriter setOpenResult(boolean openResult) {
        this.finishedWriters.forEach(w -> w.setOpenResult(openResult));
        this.currentWriter.setOpenResult(openResult);
        return this;
    }

    @Override
    public String getFilename() {
        return String.join((CharSequence)"/", this.cfs.keyspace.getName(), this.cfs.getTableName());
    }

    @Override
    public long getFilePointer() {
        return this.currentWriter.getFilePointer();
    }

    @Override
    public UUID getCfId() {
        return this.currentWriter.getCfId();
    }

    @Override
    public Throwable commit(Throwable accumulate) {
        if (this.currentWriter != null) {
            this.finishedWriters.add(this.currentWriter);
        }
        this.currentWriter = null;
        for (SSTableMultiWriter writer : this.finishedWriters) {
            accumulate = writer.commit(accumulate);
        }
        return accumulate;
    }

    @Override
    public Throwable abort(Throwable accumulate) {
        if (this.currentWriter != null) {
            this.finishedWriters.add(this.currentWriter);
        }
        this.currentWriter = null;
        for (SSTableMultiWriter finishedWriter : this.finishedWriters) {
            accumulate = finishedWriter.abort(accumulate);
        }
        return accumulate;
    }

    @Override
    public void prepareToCommit() {
        if (this.currentWriter != null) {
            this.finishedWriters.add(this.currentWriter);
        }
        this.currentWriter = null;
        this.finishedWriters.forEach(Transactional::prepareToCommit);
    }

    @Override
    public void close() {
        if (this.currentWriter != null) {
            this.finishedWriters.add(this.currentWriter);
        }
        this.currentWriter = null;
        this.finishedWriters.forEach(Transactional::close);
    }
}

