/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.UserTypes;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.InvalidRequestException;

public abstract class Operation {
    public final ColumnDefinition column;
    protected final Term t;

    protected Operation(ColumnDefinition column, Term t) {
        assert (column != null);
        this.column = column;
        this.t = t;
    }

    public void addFunctionsTo(List<Function> functions) {
        if (this.t != null) {
            this.t.addFunctionsTo(functions);
        }
    }

    public boolean requiresRead() {
        return false;
    }

    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        if (this.t != null) {
            this.t.collectMarkerSpecification(boundNames);
        }
    }

    public abstract void execute(DecoratedKey var1, UpdateParameters var2) throws InvalidRequestException;

    public static class FieldDeletion
    implements RawDeletion {
        private final ColumnDefinition.Raw id;
        private final FieldIdentifier field;

        public FieldDeletion(ColumnDefinition.Raw id, FieldIdentifier field) {
            this.id = id;
            this.field = field;
        }

        @Override
        public ColumnDefinition.Raw affectedColumn() {
            return this.id;
        }

        @Override
        public Operation prepare(String keyspace, ColumnDefinition receiver, CFMetaData cfm) throws InvalidRequestException {
            if (!receiver.type.isUDT()) {
                throw new InvalidRequestException(String.format("Invalid field deletion operation for non-UDT column %s", receiver.name));
            }
            if (!receiver.type.isMultiCell()) {
                throw new InvalidRequestException(String.format("Frozen UDT column %s does not support field deletions", receiver.name));
            }
            if (((UserType)receiver.type).fieldPosition(this.field) == -1) {
                throw new InvalidRequestException(String.format("UDT column %s does not have a field named %s", receiver.name, this.field));
            }
            return new UserTypes.DeleterByField(receiver, this.field);
        }
    }

    public static class ElementDeletion
    implements RawDeletion {
        private final ColumnDefinition.Raw id;
        private final Term.Raw element;

        public ElementDeletion(ColumnDefinition.Raw id, Term.Raw element) {
            this.id = id;
            this.element = element;
        }

        @Override
        public ColumnDefinition.Raw affectedColumn() {
            return this.id;
        }

        @Override
        public Operation prepare(String keyspace, ColumnDefinition receiver, CFMetaData cfm) throws InvalidRequestException {
            if (!receiver.type.isCollection()) {
                throw new InvalidRequestException(String.format("Invalid deletion operation for non collection column %s", receiver.name));
            }
            if (!receiver.type.isMultiCell()) {
                throw new InvalidRequestException(String.format("Invalid deletion operation for frozen collection column %s", receiver.name));
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    Term idx = this.element.prepare(keyspace, Lists.indexSpecOf(receiver));
                    return new Lists.DiscarderByIndex(receiver, idx);
                }
                case SET: {
                    Term elt = this.element.prepare(keyspace, Sets.valueSpecOf(receiver));
                    return new Sets.ElementDiscarder(receiver, elt);
                }
                case MAP: {
                    Term key = this.element.prepare(keyspace, Maps.keySpecOf(receiver));
                    return new Maps.DiscarderByKey(receiver, key);
                }
            }
            throw new AssertionError();
        }
    }

    public static class ColumnDeletion
    implements RawDeletion {
        private final ColumnDefinition.Raw id;

        public ColumnDeletion(ColumnDefinition.Raw id) {
            this.id = id;
        }

        @Override
        public ColumnDefinition.Raw affectedColumn() {
            return this.id;
        }

        @Override
        public Operation prepare(String keyspace, ColumnDefinition receiver, CFMetaData cfm) throws InvalidRequestException {
            return new Constants.Deleter(receiver);
        }
    }

    public static class Prepend
    implements RawUpdate {
        private final Term.Raw value;

        public Prepend(Term.Raw value) {
            this.value = value;
        }

        @Override
        public Operation prepare(CFMetaData cfm, ColumnDefinition receiver) throws InvalidRequestException {
            Term v = this.value.prepare(cfm.ksName, receiver);
            if (!(receiver.type instanceof ListType)) {
                throw new InvalidRequestException(String.format("Invalid operation (%s) for non list column %s", this.toString(receiver), receiver.name));
            }
            if (!receiver.type.isMultiCell()) {
                throw new InvalidRequestException(String.format("Invalid operation (%s) for frozen list column %s", this.toString(receiver), receiver.name));
            }
            return new Lists.Prepender(receiver, v);
        }

        protected String toString(ColumnSpecification column) {
            return String.format("%s = %s - %s", column.name, this.value, column.name);
        }

        @Override
        public boolean isCompatibleWith(RawUpdate other) {
            return !(other instanceof SetValue);
        }
    }

    public static class Substraction
    implements RawUpdate {
        private final Term.Raw value;

        public Substraction(Term.Raw value) {
            this.value = value;
        }

        @Override
        public Operation prepare(CFMetaData cfm, ColumnDefinition receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof CollectionType)) {
                if (!(receiver.type instanceof CounterColumnType)) {
                    throw new InvalidRequestException(String.format("Invalid operation (%s) for non counter column %s", this.toString(receiver), receiver.name));
                }
                return new Constants.Substracter(receiver, this.value.prepare(cfm.ksName, receiver));
            }
            if (!receiver.type.isMultiCell()) {
                throw new InvalidRequestException(String.format("Invalid operation (%s) for frozen collection column %s", this.toString(receiver), receiver.name));
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    return new Lists.Discarder(receiver, this.value.prepare(cfm.ksName, receiver));
                }
                case SET: {
                    return new Sets.Discarder(receiver, this.value.prepare(cfm.ksName, receiver));
                }
                case MAP: {
                    ColumnSpecification vr = new ColumnSpecification(receiver.ksName, receiver.cfName, receiver.name, SetType.getInstance(((MapType)receiver.type).getKeysType(), false));
                    return new Sets.Discarder(receiver, this.value.prepare(cfm.ksName, vr));
                }
            }
            throw new AssertionError();
        }

        protected String toString(ColumnSpecification column) {
            return String.format("%s = %s - %s", column.name, column.name, this.value);
        }

        @Override
        public boolean isCompatibleWith(RawUpdate other) {
            return !(other instanceof SetValue);
        }
    }

    public static class Addition
    implements RawUpdate {
        private final Term.Raw value;

        public Addition(Term.Raw value) {
            this.value = value;
        }

        @Override
        public Operation prepare(CFMetaData cfm, ColumnDefinition receiver) throws InvalidRequestException {
            Term v = this.value.prepare(cfm.ksName, receiver);
            if (!(receiver.type instanceof CollectionType)) {
                if (!(receiver.type instanceof CounterColumnType)) {
                    throw new InvalidRequestException(String.format("Invalid operation (%s) for non counter column %s", this.toString(receiver), receiver.name));
                }
                return new Constants.Adder(receiver, v);
            }
            if (!receiver.type.isMultiCell()) {
                throw new InvalidRequestException(String.format("Invalid operation (%s) for frozen collection column %s", this.toString(receiver), receiver.name));
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    return new Lists.Appender(receiver, v);
                }
                case SET: {
                    return new Sets.Adder(receiver, v);
                }
                case MAP: {
                    return new Maps.Putter(receiver, v);
                }
            }
            throw new AssertionError();
        }

        protected String toString(ColumnSpecification column) {
            return String.format("%s = %s + %s", column.name, column.name, this.value);
        }

        @Override
        public boolean isCompatibleWith(RawUpdate other) {
            return !(other instanceof SetValue);
        }
    }

    public static class SetField
    implements RawUpdate {
        private final FieldIdentifier field;
        private final Term.Raw value;

        public SetField(FieldIdentifier field, Term.Raw value) {
            this.field = field;
            this.value = value;
        }

        @Override
        public Operation prepare(CFMetaData cfm, ColumnDefinition receiver) throws InvalidRequestException {
            if (!receiver.type.isUDT()) {
                throw new InvalidRequestException(String.format("Invalid operation (%s) for non-UDT column %s", this.toString(receiver), receiver.name));
            }
            if (!receiver.type.isMultiCell()) {
                throw new InvalidRequestException(String.format("Invalid operation (%s) for frozen UDT column %s", this.toString(receiver), receiver.name));
            }
            int fieldPosition = ((UserType)receiver.type).fieldPosition(this.field);
            if (fieldPosition == -1) {
                throw new InvalidRequestException(String.format("UDT column %s does not have a field named %s", receiver.name, this.field));
            }
            Term val = this.value.prepare(cfm.ksName, UserTypes.fieldSpecOf(receiver, fieldPosition));
            return new UserTypes.SetterByField(receiver, this.field, val);
        }

        protected String toString(ColumnSpecification column) {
            return String.format("%s.%s = %s", column.name, this.field, this.value);
        }

        @Override
        public boolean isCompatibleWith(RawUpdate other) {
            if (other instanceof SetField) {
                return !((SetField)other).field.equals(this.field);
            }
            return !(other instanceof SetValue);
        }
    }

    public static class SetElement
    implements RawUpdate {
        private final Term.Raw selector;
        private final Term.Raw value;

        public SetElement(Term.Raw selector, Term.Raw value) {
            this.selector = selector;
            this.value = value;
        }

        @Override
        public Operation prepare(CFMetaData cfm, ColumnDefinition receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof CollectionType)) {
                throw new InvalidRequestException(String.format("Invalid operation (%s) for non collection column %s", this.toString(receiver), receiver.name));
            }
            if (!receiver.type.isMultiCell()) {
                throw new InvalidRequestException(String.format("Invalid operation (%s) for frozen collection column %s", this.toString(receiver), receiver.name));
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    Term idx = this.selector.prepare(cfm.ksName, Lists.indexSpecOf(receiver));
                    Term lval = this.value.prepare(cfm.ksName, Lists.valueSpecOf(receiver));
                    return new Lists.SetterByIndex(receiver, idx, lval);
                }
                case SET: {
                    throw new InvalidRequestException(String.format("Invalid operation (%s) for set column %s", this.toString(receiver), receiver.name));
                }
                case MAP: {
                    Term key = this.selector.prepare(cfm.ksName, Maps.keySpecOf(receiver));
                    Term mval = this.value.prepare(cfm.ksName, Maps.valueSpecOf(receiver));
                    return new Maps.SetterByKey(receiver, key, mval);
                }
            }
            throw new AssertionError();
        }

        protected String toString(ColumnSpecification column) {
            return String.format("%s[%s] = %s", column.name, this.selector, this.value);
        }

        @Override
        public boolean isCompatibleWith(RawUpdate other) {
            return !(other instanceof SetValue);
        }
    }

    public static class SetValue
    implements RawUpdate {
        private final Term.Raw value;

        public SetValue(Term.Raw value) {
            this.value = value;
        }

        @Override
        public Operation prepare(CFMetaData cfm, ColumnDefinition receiver) throws InvalidRequestException {
            Term v = this.value.prepare(cfm.ksName, receiver);
            if (receiver.type instanceof CounterColumnType) {
                throw new InvalidRequestException(String.format("Cannot set the value of counter column %s (counters can only be incremented/decremented, not set)", receiver.name));
            }
            if (receiver.type.isCollection()) {
                switch (((CollectionType)receiver.type).kind) {
                    case LIST: {
                        return new Lists.Setter(receiver, v);
                    }
                    case SET: {
                        return new Sets.Setter(receiver, v);
                    }
                    case MAP: {
                        return new Maps.Setter(receiver, v);
                    }
                }
                throw new AssertionError();
            }
            if (receiver.type.isUDT()) {
                return new UserTypes.Setter(receiver, v);
            }
            return new Constants.Setter(receiver, v);
        }

        protected String toString(ColumnSpecification column) {
            return String.format("%s = %s", column, this.value);
        }

        @Override
        public boolean isCompatibleWith(RawUpdate other) {
            return false;
        }
    }

    public static interface RawDeletion {
        public ColumnDefinition.Raw affectedColumn();

        public Operation prepare(String var1, ColumnDefinition var2, CFMetaData var3) throws InvalidRequestException;
    }

    public static interface RawUpdate {
        public Operation prepare(CFMetaData var1, ColumnDefinition var2) throws InvalidRequestException;

        public boolean isCompatibleWith(RawUpdate var1);
    }
}

