/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.nio.ch.FileChannelImpl;

public final class CLibrary {
    private static final Logger logger = LoggerFactory.getLogger(CLibrary.class);
    private static final int MCL_CURRENT;
    private static final int MCL_FUTURE;
    private static final int ENOMEM = 12;
    private static final int F_GETFL = 3;
    private static final int F_SETFL = 4;
    private static final int F_NOCACHE = 48;
    private static final int O_DIRECT = 16384;
    private static final int O_RDONLY = 0;
    private static final int POSIX_FADV_NORMAL = 0;
    private static final int POSIX_FADV_RANDOM = 1;
    private static final int POSIX_FADV_SEQUENTIAL = 2;
    private static final int POSIX_FADV_WILLNEED = 3;
    private static final int POSIX_FADV_DONTNEED = 4;
    private static final int POSIX_FADV_NOREUSE = 5;
    static boolean jnaAvailable;
    static boolean jnaLockable;
    private static boolean fsyncUnavailable;
    private static final boolean OS_LINUX;
    private static final boolean OS_AIX;
    private static final boolean OS_MAC;
    private static final Field FILE_DESCRIPTOR_FD_FIELD;
    private static final Field FILE_CHANNEL_FD_FIELD;

    private static native int mlockall(int var0) throws LastErrorException;

    private static native int munlockall() throws LastErrorException;

    private static native int fcntl(int var0, int var1, long var2) throws LastErrorException;

    private static native int posix_fadvise(int var0, long var1, int var3, int var4) throws LastErrorException;

    private static native int open(String var0, int var1) throws LastErrorException;

    private static native int fsync(int var0) throws LastErrorException;

    private static native int close(int var0) throws LastErrorException;

    private static native Pointer strerror(int var0) throws LastErrorException;

    private static int errno(RuntimeException e) {
        assert (e instanceof LastErrorException);
        try {
            return ((LastErrorException)e).getErrorCode();
        }
        catch (NoSuchMethodError x) {
            logger.warn("Obsolete version of JNA present; unable to read errno. Upgrade to JNA 3.2.7 or later");
            return 0;
        }
    }

    private CLibrary() {
    }

    public static boolean jnaAvailable() {
        return jnaAvailable;
    }

    public static boolean jnaMemoryLockable() {
        return jnaLockable;
    }

    public static void tryMlockall() {
        block5: {
            try {
                CLibrary.mlockall(MCL_CURRENT);
                jnaLockable = true;
                logger.info("JNA mlockall successful");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            }
            catch (RuntimeException e) {
                if (!(e instanceof LastErrorException)) {
                    throw e;
                }
                if (OS_LINUX && CLibrary.errno(e) == 12) {
                    logger.warn("Unable to lock JVM memory (ENOMEM). This can result in part of the JVM being swapped out, especially with mmapped I/O enabled. Increase RLIMIT_MEMLOCK or run Cassandra as root.");
                }
                if (OS_MAC) break block5;
                logger.warn("Unknown mlockall error {}", (Object)CLibrary.errno(e));
            }
        }
    }

    public static void trySkipCache(String path, long offset, long len) {
        File f = new File(path);
        if (!f.exists()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(f);){
            CLibrary.trySkipCache(CLibrary.getfd(fis.getChannel()), offset, len, path);
        }
        catch (IOException e) {
            logger.warn("Could not skip cache", (Throwable)e);
        }
    }

    public static void trySkipCache(int fd, long offset, long len, String path) {
        if (len == 0L) {
            CLibrary.trySkipCache(fd, 0L, 0, path);
        }
        while (len > 0L) {
            int sublen = (int)Math.min(Integer.MAX_VALUE, len);
            CLibrary.trySkipCache(fd, offset, sublen, path);
            len -= (long)sublen;
            offset -= (long)sublen;
        }
    }

    public static void trySkipCache(int fd, long offset, int len, String path) {
        if (fd < 0) {
            return;
        }
        try {
            int result;
            if (OS_LINUX && (result = CLibrary.posix_fadvise(fd, offset, len, 4)) != 0) {
                NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 10L, TimeUnit.MINUTES, "Failed trySkipCache on file: {} Error: " + CLibrary.strerror(result).getString(0L), path);
            }
        }
        catch (UnsatisfiedLinkError result) {
        }
        catch (RuntimeException e) {
            if (!(e instanceof LastErrorException)) {
                throw e;
            }
            logger.warn("posix_fadvise({}, {}) failed, errno ({}).", new Object[]{fd, offset, CLibrary.errno(e)});
        }
    }

    public static int tryFcntl(int fd, int command, int flags) {
        int result = -1;
        try {
            result = CLibrary.fcntl(fd, command, flags);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (RuntimeException e) {
            if (!(e instanceof LastErrorException)) {
                throw e;
            }
            logger.warn("fcntl({}, {}, {}) failed, errno ({}).", new Object[]{fd, command, flags, CLibrary.errno(e)});
        }
        return result;
    }

    public static int tryOpenDirectory(String path) {
        int fd = -1;
        try {
            return CLibrary.open(path, 0);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (RuntimeException e) {
            if (!(e instanceof LastErrorException)) {
                throw e;
            }
            logger.warn("open({}, O_RDONLY) failed, errno ({}).", (Object)path, (Object)CLibrary.errno(e));
        }
        return fd;
    }

    public static void trySync(int fd) {
        if (fsyncUnavailable || fd == -1) {
            return;
        }
        try {
            CLibrary.fsync(fd);
        }
        catch (UnsatisfiedLinkError e) {
            fsyncUnavailable = true;
        }
        catch (RuntimeException e) {
            if (!(e instanceof LastErrorException)) {
                throw e;
            }
            logger.warn(String.format("fsync(%d) failed, errno (%d) {}", fd, CLibrary.errno(e)), (Throwable)e);
        }
    }

    public static void tryCloseFD(int fd) {
        if (fd == -1) {
            return;
        }
        try {
            CLibrary.close(fd);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (RuntimeException e) {
            if (!(e instanceof LastErrorException)) {
                throw e;
            }
            logger.warn("close({}) failed, errno ({}).", (Object)fd, (Object)CLibrary.errno(e));
        }
    }

    public static int getfd(FileChannel channel) {
        try {
            return CLibrary.getfd((FileDescriptor)FILE_CHANNEL_FD_FIELD.get(channel));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.warn("Unable to read fd field from FileChannel");
            return -1;
        }
    }

    public static int getfd(FileDescriptor descriptor) {
        try {
            return FILE_DESCRIPTOR_FD_FIELD.getInt(descriptor);
        }
        catch (Exception e) {
            JVMStabilityInspector.inspectThrowable(e);
            logger.warn("Unable to read fd field from FileDescriptor");
            return -1;
        }
    }

    static {
        jnaAvailable = true;
        jnaLockable = false;
        fsyncUnavailable = false;
        String os = System.getProperty("os.name").toLowerCase();
        OS_LINUX = os.contains("linux");
        OS_AIX = os.contains("aix");
        OS_MAC = os.contains("mac");
        FILE_DESCRIPTOR_FD_FIELD = FBUtilities.getProtectedField(FileDescriptor.class, "fd");
        FILE_CHANNEL_FD_FIELD = FBUtilities.getProtectedField(FileChannelImpl.class, "fd");
        try {
            Native.register((String)"c");
        }
        catch (NoClassDefFoundError e) {
            logger.warn("JNA not found. Native methods will be disabled.");
            jnaAvailable = false;
        }
        catch (UnsatisfiedLinkError e) {
            logger.warn("JNA link failure, one or more native method will be unavailable.");
            logger.trace("JNA link failure details: {}", (Object)e.getMessage());
        }
        catch (NoSuchMethodError e) {
            logger.warn("Obsolete version of JNA present; unable to register C library. Upgrade to JNA 3.2.7 or later");
            jnaAvailable = false;
        }
        if (System.getProperty("os.arch").toLowerCase().contains("ppc")) {
            if (OS_LINUX) {
                MCL_CURRENT = 8192;
                MCL_FUTURE = 16384;
            } else if (OS_AIX) {
                MCL_CURRENT = 256;
                MCL_FUTURE = 512;
            } else {
                MCL_CURRENT = 1;
                MCL_FUTURE = 2;
            }
        } else {
            MCL_CURRENT = 1;
            MCL_FUTURE = 2;
        }
    }
}

