/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.lifecycle.LogRecord;
import org.apache.cassandra.db.lifecycle.LogTransaction;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.CLibrary;

final class LogReplica
implements AutoCloseable {
    private final File file;
    private int directoryDescriptor;
    private final Map<String, String> errors = new HashMap<String, String>();

    static LogReplica create(File directory, String fileName) {
        return new LogReplica(new File(fileName), CLibrary.tryOpenDirectory(directory.getPath()));
    }

    static LogReplica open(File file) {
        return new LogReplica(file, CLibrary.tryOpenDirectory(file.getParentFile().getPath()));
    }

    LogReplica(File file, int directoryDescriptor) {
        this.file = file;
        this.directoryDescriptor = directoryDescriptor;
    }

    File file() {
        return this.file;
    }

    List<String> readLines() {
        return FileUtils.readLines(this.file);
    }

    String getFileName() {
        return this.file.getName();
    }

    String getDirectory() {
        return this.file.getParent();
    }

    void append(LogRecord record) {
        boolean existed = this.exists();
        FileUtils.appendAndSync(this.file, record.toString());
        if (!existed) {
            this.syncDirectory();
        }
    }

    void syncDirectory() {
        if (this.directoryDescriptor >= 0) {
            CLibrary.trySync(this.directoryDescriptor);
        }
    }

    void delete() {
        LogTransaction.delete(this.file);
        this.syncDirectory();
    }

    boolean exists() {
        return this.file.exists();
    }

    @Override
    public void close() {
        if (this.directoryDescriptor >= 0) {
            CLibrary.tryCloseFD(this.directoryDescriptor);
            this.directoryDescriptor = -1;
        }
    }

    public String toString() {
        return String.format("[%s] ", this.file);
    }

    void setError(String line, String error) {
        this.errors.put(line, error);
    }

    void printContentsWithAnyErrors(StringBuilder str) {
        str.append(this.file.getPath());
        str.append(System.lineSeparator());
        FileUtils.readLines(this.file).forEach(line -> this.printLineWithAnyError(str, (String)line));
    }

    private void printLineWithAnyError(StringBuilder str, String line) {
        str.append('\t');
        str.append(line);
        str.append(System.lineSeparator());
        String error = this.errors.get(line);
        if (error != null) {
            str.append("\t\t***");
            str.append(error);
            str.append(System.lineSeparator());
        }
    }
}

