/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.aggregation.AggregationSpecification;
import org.apache.cassandra.db.aggregation.GroupMaker;
import org.apache.cassandra.db.aggregation.GroupingState;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.BaseRowIterator;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.BasePartitions;
import org.apache.cassandra.db.transform.BaseRows;
import org.apache.cassandra.db.transform.StoppingTransformation;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class DataLimits {
    public static final Serializer serializer = new Serializer();
    public static final int NO_LIMIT = Integer.MAX_VALUE;
    public static final DataLimits NONE = new CQLLimits(Integer.MAX_VALUE){

        @Override
        public boolean hasEnoughLiveData(CachedPartition cached, int nowInSec) {
            return false;
        }

        @Override
        public UnfilteredPartitionIterator filter(UnfilteredPartitionIterator iter, int nowInSec) {
            return iter;
        }

        @Override
        public UnfilteredRowIterator filter(UnfilteredRowIterator iter, int nowInSec) {
            return iter;
        }
    };
    public static final DataLimits DISTINCT_NONE = new CQLLimits(Integer.MAX_VALUE, 1, true);

    public static DataLimits cqlLimits(int cqlRowLimit) {
        return cqlRowLimit == Integer.MAX_VALUE ? NONE : new CQLLimits(cqlRowLimit);
    }

    public static DataLimits cqlLimits(int cqlRowLimit, int perPartitionLimit) {
        return cqlRowLimit == Integer.MAX_VALUE && perPartitionLimit == Integer.MAX_VALUE ? NONE : new CQLLimits(cqlRowLimit, perPartitionLimit);
    }

    private static DataLimits cqlLimits(int cqlRowLimit, int perPartitionLimit, boolean isDistinct) {
        return cqlRowLimit == Integer.MAX_VALUE && perPartitionLimit == Integer.MAX_VALUE && !isDistinct ? NONE : new CQLLimits(cqlRowLimit, perPartitionLimit, isDistinct);
    }

    public static DataLimits groupByLimits(int groupLimit, int groupPerPartitionLimit, int rowLimit, AggregationSpecification groupBySpec) {
        return new CQLGroupByLimits(groupLimit, groupPerPartitionLimit, rowLimit, groupBySpec);
    }

    public static DataLimits distinctLimits(int cqlRowLimit) {
        return CQLLimits.distinct(cqlRowLimit);
    }

    public static DataLimits thriftLimits(int partitionLimit, int cellPerPartitionLimit) {
        return new ThriftLimits(partitionLimit, cellPerPartitionLimit);
    }

    public static DataLimits superColumnCountingLimits(int partitionLimit, int cellPerPartitionLimit) {
        return new SuperColumnCountingLimits(partitionLimit, cellPerPartitionLimit);
    }

    public abstract Kind kind();

    public abstract boolean isUnlimited();

    public abstract boolean isDistinct();

    public boolean isGroupByLimit() {
        return false;
    }

    public boolean isExhausted(Counter counter) {
        return counter.counted() < this.count();
    }

    public abstract DataLimits forPaging(int var1);

    public abstract DataLimits forPaging(int var1, ByteBuffer var2, int var3);

    public abstract DataLimits forShortReadRetry(int var1);

    public DataLimits forGroupByInternalPaging(GroupingState state) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean hasEnoughLiveData(CachedPartition var1, int var2);

    public abstract Counter newCounter(int var1, boolean var2);

    public abstract int count();

    public abstract int perPartitionCount();

    public abstract DataLimits withoutState();

    public UnfilteredPartitionIterator filter(UnfilteredPartitionIterator iter, int nowInSec) {
        return this.newCounter(nowInSec, false).applyTo(iter);
    }

    public UnfilteredRowIterator filter(UnfilteredRowIterator iter, int nowInSec) {
        return this.newCounter(nowInSec, false).applyTo(iter);
    }

    public PartitionIterator filter(PartitionIterator iter, int nowInSec) {
        return this.newCounter(nowInSec, true).applyTo(iter);
    }

    public abstract float estimateTotalResults(ColumnFamilyStore var1);

    public static class Serializer {
        public void serialize(DataLimits limits, DataOutputPlus out, int version, ClusteringComparator comparator) throws IOException {
            out.writeByte(limits.kind().ordinal());
            switch (limits.kind()) {
                case CQL_LIMIT: 
                case CQL_PAGING_LIMIT: {
                    CQLLimits cqlLimits = (CQLLimits)limits;
                    out.writeUnsignedVInt(cqlLimits.rowLimit);
                    out.writeUnsignedVInt(cqlLimits.perPartitionLimit);
                    out.writeBoolean(cqlLimits.isDistinct);
                    if (limits.kind() != Kind.CQL_PAGING_LIMIT) break;
                    CQLPagingLimits pagingLimits = (CQLPagingLimits)cqlLimits;
                    ByteBufferUtil.writeWithVIntLength(pagingLimits.lastReturnedKey, out);
                    out.writeUnsignedVInt(pagingLimits.lastReturnedKeyRemaining);
                    break;
                }
                case CQL_GROUP_BY_LIMIT: 
                case CQL_GROUP_BY_PAGING_LIMIT: {
                    CQLGroupByLimits groupByLimits = (CQLGroupByLimits)limits;
                    out.writeUnsignedVInt(groupByLimits.groupLimit);
                    out.writeUnsignedVInt(groupByLimits.groupPerPartitionLimit);
                    out.writeUnsignedVInt(groupByLimits.rowLimit);
                    AggregationSpecification groupBySpec = groupByLimits.groupBySpec;
                    AggregationSpecification.serializer.serialize(groupBySpec, out, version);
                    GroupingState.serializer.serialize(groupByLimits.state, out, version, comparator);
                    if (limits.kind() != Kind.CQL_GROUP_BY_PAGING_LIMIT) break;
                    CQLGroupByPagingLimits pagingLimits = (CQLGroupByPagingLimits)groupByLimits;
                    ByteBufferUtil.writeWithVIntLength(pagingLimits.lastReturnedKey, out);
                    out.writeUnsignedVInt(pagingLimits.lastReturnedKeyRemaining);
                    break;
                }
                case THRIFT_LIMIT: 
                case SUPER_COLUMN_COUNTING_LIMIT: {
                    ThriftLimits thriftLimits = (ThriftLimits)limits;
                    out.writeUnsignedVInt(thriftLimits.partitionLimit);
                    out.writeUnsignedVInt(thriftLimits.cellPerPartitionLimit);
                }
            }
        }

        public DataLimits deserialize(DataInputPlus in, int version, ClusteringComparator comparator) throws IOException {
            Kind kind = Kind.values()[in.readUnsignedByte()];
            switch (kind) {
                case CQL_LIMIT: 
                case CQL_PAGING_LIMIT: {
                    int rowLimit = (int)in.readUnsignedVInt();
                    int perPartitionLimit = (int)in.readUnsignedVInt();
                    boolean isDistinct = in.readBoolean();
                    if (kind == Kind.CQL_LIMIT) {
                        return DataLimits.cqlLimits(rowLimit, perPartitionLimit, isDistinct);
                    }
                    ByteBuffer lastKey = ByteBufferUtil.readWithVIntLength(in);
                    int lastRemaining = (int)in.readUnsignedVInt();
                    return new CQLPagingLimits(rowLimit, perPartitionLimit, isDistinct, lastKey, lastRemaining);
                }
                case CQL_GROUP_BY_LIMIT: 
                case CQL_GROUP_BY_PAGING_LIMIT: {
                    int groupLimit = (int)in.readUnsignedVInt();
                    int groupPerPartitionLimit = (int)in.readUnsignedVInt();
                    int rowLimit = (int)in.readUnsignedVInt();
                    AggregationSpecification groupBySpec = AggregationSpecification.serializer.deserialize(in, version, comparator);
                    GroupingState state = GroupingState.serializer.deserialize(in, version, comparator);
                    if (kind == Kind.CQL_GROUP_BY_LIMIT) {
                        return new CQLGroupByLimits(groupLimit, groupPerPartitionLimit, rowLimit, groupBySpec, state);
                    }
                    ByteBuffer lastKey = ByteBufferUtil.readWithVIntLength(in);
                    int lastRemaining = (int)in.readUnsignedVInt();
                    return new CQLGroupByPagingLimits(groupLimit, groupPerPartitionLimit, rowLimit, groupBySpec, state, lastKey, lastRemaining);
                }
                case THRIFT_LIMIT: 
                case SUPER_COLUMN_COUNTING_LIMIT: {
                    int partitionLimit = (int)in.readUnsignedVInt();
                    int cellPerPartitionLimit = (int)in.readUnsignedVInt();
                    return kind == Kind.THRIFT_LIMIT ? new ThriftLimits(partitionLimit, cellPerPartitionLimit) : new SuperColumnCountingLimits(partitionLimit, cellPerPartitionLimit);
                }
            }
            throw new AssertionError();
        }

        public long serializedSize(DataLimits limits, int version, ClusteringComparator comparator) {
            long size = TypeSizes.sizeof((byte)limits.kind().ordinal());
            switch (limits.kind()) {
                case CQL_LIMIT: 
                case CQL_PAGING_LIMIT: {
                    CQLLimits cqlLimits = (CQLLimits)limits;
                    size += (long)TypeSizes.sizeofUnsignedVInt(cqlLimits.rowLimit);
                    size += (long)TypeSizes.sizeofUnsignedVInt(cqlLimits.perPartitionLimit);
                    size += (long)TypeSizes.sizeof(cqlLimits.isDistinct);
                    if (limits.kind() != Kind.CQL_PAGING_LIMIT) break;
                    CQLPagingLimits pagingLimits = (CQLPagingLimits)cqlLimits;
                    size += (long)ByteBufferUtil.serializedSizeWithVIntLength(pagingLimits.lastReturnedKey);
                    size += (long)TypeSizes.sizeofUnsignedVInt(pagingLimits.lastReturnedKeyRemaining);
                    break;
                }
                case CQL_GROUP_BY_LIMIT: 
                case CQL_GROUP_BY_PAGING_LIMIT: {
                    CQLGroupByLimits groupByLimits = (CQLGroupByLimits)limits;
                    size += (long)TypeSizes.sizeofUnsignedVInt(groupByLimits.groupLimit);
                    size += (long)TypeSizes.sizeofUnsignedVInt(groupByLimits.groupPerPartitionLimit);
                    size += (long)TypeSizes.sizeofUnsignedVInt(groupByLimits.rowLimit);
                    AggregationSpecification groupBySpec = groupByLimits.groupBySpec;
                    size += AggregationSpecification.serializer.serializedSize(groupBySpec, version);
                    size += GroupingState.serializer.serializedSize(groupByLimits.state, version, comparator);
                    if (limits.kind() != Kind.CQL_GROUP_BY_PAGING_LIMIT) break;
                    CQLGroupByPagingLimits pagingLimits = (CQLGroupByPagingLimits)groupByLimits;
                    size += (long)ByteBufferUtil.serializedSizeWithVIntLength(pagingLimits.lastReturnedKey);
                    size += (long)TypeSizes.sizeofUnsignedVInt(pagingLimits.lastReturnedKeyRemaining);
                    break;
                }
                case THRIFT_LIMIT: 
                case SUPER_COLUMN_COUNTING_LIMIT: {
                    ThriftLimits thriftLimits = (ThriftLimits)limits;
                    size += (long)TypeSizes.sizeofUnsignedVInt(thriftLimits.partitionLimit);
                    size += (long)TypeSizes.sizeofUnsignedVInt(thriftLimits.cellPerPartitionLimit);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return size;
        }
    }

    private static class SuperColumnCountingLimits
    extends ThriftLimits {
        private SuperColumnCountingLimits(int partitionLimit, int cellPerPartitionLimit) {
            super(partitionLimit, cellPerPartitionLimit);
        }

        @Override
        public Kind kind() {
            return Kind.SUPER_COLUMN_COUNTING_LIMIT;
        }

        @Override
        public DataLimits forPaging(int pageSize) {
            assert (this.partitionLimit == 1);
            return new SuperColumnCountingLimits(this.partitionLimit, pageSize);
        }

        @Override
        public DataLimits forShortReadRetry(int toFetch) {
            return new SuperColumnCountingLimits(1, toFetch);
        }

        @Override
        public Counter newCounter(int nowInSec, boolean assumeLiveData) {
            return new SuperColumnCountingCounter(nowInSec, assumeLiveData);
        }

        protected class SuperColumnCountingCounter
        extends ThriftLimits.ThriftCounter {
            public SuperColumnCountingCounter(int nowInSec, boolean assumeLiveData) {
                super(nowInSec, assumeLiveData);
            }

            @Override
            public Row applyToRow(Row row) {
                if (this.isLive(row)) {
                    ++this.cellsCounted;
                    if (++this.cellsInCurrentPartition >= SuperColumnCountingLimits.this.cellPerPartitionLimit) {
                        this.stopInPartition();
                    }
                }
                return row;
            }
        }
    }

    private static class ThriftLimits
    extends DataLimits {
        protected final int partitionLimit;
        protected final int cellPerPartitionLimit;

        private ThriftLimits(int partitionLimit, int cellPerPartitionLimit) {
            this.partitionLimit = partitionLimit;
            this.cellPerPartitionLimit = cellPerPartitionLimit;
        }

        @Override
        public Kind kind() {
            return Kind.THRIFT_LIMIT;
        }

        @Override
        public boolean isUnlimited() {
            return this.partitionLimit == Integer.MAX_VALUE && this.cellPerPartitionLimit == Integer.MAX_VALUE;
        }

        @Override
        public boolean isDistinct() {
            return false;
        }

        @Override
        public DataLimits forPaging(int pageSize) {
            assert (this.partitionLimit == 1);
            return new ThriftLimits(this.partitionLimit, pageSize);
        }

        @Override
        public DataLimits forPaging(int pageSize, ByteBuffer lastReturnedKey, int lastReturnedKeyRemaining) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DataLimits forShortReadRetry(int toFetch) {
            return new ThriftLimits(1, toFetch);
        }

        /*
         * Exception decompiling
         */
        @Override
        public boolean hasEnoughLiveData(CachedPartition cached, int nowInSec) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public Counter newCounter(int nowInSec, boolean assumeLiveData) {
            return new ThriftCounter(nowInSec, assumeLiveData);
        }

        @Override
        public int count() {
            return this.partitionLimit * this.cellPerPartitionLimit;
        }

        @Override
        public int perPartitionCount() {
            return this.cellPerPartitionLimit;
        }

        @Override
        public DataLimits withoutState() {
            return this;
        }

        @Override
        public float estimateTotalResults(ColumnFamilyStore cfs) {
            float cellsPerPartition = (float)cfs.getMeanColumns() / (float)cfs.metadata.partitionColumns().regulars.size();
            return cellsPerPartition * (float)cfs.estimateKeys();
        }

        public String toString() {
            return String.format("THRIFT LIMIT (partitions=%d, cells_per_partition=%d)", this.partitionLimit, this.cellPerPartitionLimit);
        }

        protected class ThriftCounter
        extends Counter {
            protected int partitionsCounted;
            protected int cellsCounted;
            protected int cellsInCurrentPartition;

            public ThriftCounter(int nowInSec, boolean assumeLiveData) {
                super(nowInSec, assumeLiveData);
            }

            @Override
            public void applyToPartition(DecoratedKey partitionKey, Row staticRow) {
                this.cellsInCurrentPartition = 0;
                if (!staticRow.isEmpty()) {
                    this.applyToRow(staticRow);
                }
            }

            @Override
            public Row applyToRow(Row row) {
                for (Cell cell : row.cells()) {
                    if (!this.assumeLiveData && !cell.isLive(this.nowInSec)) continue;
                    ++this.cellsCounted;
                    if (++this.cellsInCurrentPartition < ThriftLimits.this.cellPerPartitionLimit) continue;
                    this.stopInPartition();
                }
                return row;
            }

            @Override
            public void onPartitionClose() {
                if (++this.partitionsCounted >= ThriftLimits.this.partitionLimit) {
                    this.stop();
                }
                super.onPartitionClose();
            }

            @Override
            public int counted() {
                return this.cellsCounted;
            }

            @Override
            public int countedInCurrentPartition() {
                return this.cellsInCurrentPartition;
            }

            @Override
            public int rowCounted() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int rowCountedInCurrentPartition() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isDone() {
                return this.partitionsCounted >= ThriftLimits.this.partitionLimit;
            }

            @Override
            public boolean isDoneForPartition() {
                return this.isDone() || this.cellsInCurrentPartition >= ThriftLimits.this.cellPerPartitionLimit;
            }
        }
    }

    private static class CQLGroupByPagingLimits
    extends CQLGroupByLimits {
        private final ByteBuffer lastReturnedKey;
        private final int lastReturnedKeyRemaining;

        public CQLGroupByPagingLimits(int groupLimit, int groupPerPartitionLimit, int rowLimit, AggregationSpecification groupBySpec, GroupingState state, ByteBuffer lastReturnedKey, int lastReturnedKeyRemaining) {
            super(groupLimit, groupPerPartitionLimit, rowLimit, groupBySpec, state);
            this.lastReturnedKey = lastReturnedKey;
            this.lastReturnedKeyRemaining = lastReturnedKeyRemaining;
        }

        @Override
        public Kind kind() {
            return Kind.CQL_GROUP_BY_PAGING_LIMIT;
        }

        @Override
        public DataLimits forPaging(int pageSize) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DataLimits forPaging(int pageSize, ByteBuffer lastReturnedKey, int lastReturnedKeyRemaining) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DataLimits forGroupByInternalPaging(GroupingState state) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Counter newCounter(int nowInSec, boolean assumeLiveData) {
            assert (this.state == GroupingState.EMPTY_STATE || this.lastReturnedKey.equals(this.state.partitionKey()));
            return new PagingGroupByAwareCounter(nowInSec, assumeLiveData);
        }

        @Override
        public DataLimits withoutState() {
            return new CQLGroupByLimits(this.groupLimit, this.groupPerPartitionLimit, this.rowLimit, this.groupBySpec);
        }

        private class PagingGroupByAwareCounter
        extends CQLGroupByLimits.GroupByAwareCounter {
            private PagingGroupByAwareCounter(int nowInSec, boolean assumeLiveData) {
                super(nowInSec, assumeLiveData);
            }

            @Override
            public void applyToPartition(DecoratedKey partitionKey, Row staticRow) {
                if (partitionKey.getKey().equals(CQLGroupByPagingLimits.this.lastReturnedKey)) {
                    this.currentPartitionKey = partitionKey;
                    this.groupInCurrentPartition = CQLGroupByPagingLimits.this.groupPerPartitionLimit - CQLGroupByPagingLimits.this.lastReturnedKeyRemaining;
                    this.hasReturnedRowsFromCurrentPartition = true;
                    this.hasLiveStaticRow = false;
                    this.hasGroupStarted = CQLGroupByPagingLimits.this.state.hasClustering();
                } else {
                    super.applyToPartition(partitionKey, staticRow);
                }
            }
        }
    }

    private static class CQLGroupByLimits
    extends CQLLimits {
        protected final GroupingState state;
        protected final AggregationSpecification groupBySpec;
        protected final int groupLimit;
        protected final int groupPerPartitionLimit;

        public CQLGroupByLimits(int groupLimit, int groupPerPartitionLimit, int rowLimit, AggregationSpecification groupBySpec) {
            this(groupLimit, groupPerPartitionLimit, rowLimit, groupBySpec, GroupingState.EMPTY_STATE);
        }

        private CQLGroupByLimits(int groupLimit, int groupPerPartitionLimit, int rowLimit, AggregationSpecification groupBySpec, GroupingState state) {
            super(rowLimit, Integer.MAX_VALUE, false);
            this.groupLimit = groupLimit;
            this.groupPerPartitionLimit = groupPerPartitionLimit;
            this.groupBySpec = groupBySpec;
            this.state = state;
        }

        @Override
        public Kind kind() {
            return Kind.CQL_GROUP_BY_LIMIT;
        }

        @Override
        public boolean isGroupByLimit() {
            return true;
        }

        @Override
        public boolean isUnlimited() {
            return this.groupLimit == Integer.MAX_VALUE && this.groupPerPartitionLimit == Integer.MAX_VALUE && this.rowLimit == Integer.MAX_VALUE;
        }

        @Override
        public DataLimits forShortReadRetry(int toFetch) {
            return new CQLLimits(toFetch);
        }

        @Override
        public float estimateTotalResults(ColumnFamilyStore cfs) {
            return super.estimateTotalResults(cfs);
        }

        @Override
        public DataLimits forPaging(int pageSize) {
            return new CQLGroupByLimits(pageSize, this.groupPerPartitionLimit, this.rowLimit, this.groupBySpec, this.state);
        }

        @Override
        public DataLimits forPaging(int pageSize, ByteBuffer lastReturnedKey, int lastReturnedKeyRemaining) {
            return new CQLGroupByPagingLimits(pageSize, this.groupPerPartitionLimit, this.rowLimit, this.groupBySpec, this.state, lastReturnedKey, lastReturnedKeyRemaining);
        }

        @Override
        public DataLimits forGroupByInternalPaging(GroupingState state) {
            return new CQLGroupByLimits(this.rowLimit, this.groupPerPartitionLimit, this.rowLimit, this.groupBySpec, state);
        }

        @Override
        public Counter newCounter(int nowInSec, boolean assumeLiveData) {
            return new GroupByAwareCounter(nowInSec, assumeLiveData);
        }

        @Override
        public int count() {
            return this.groupLimit;
        }

        @Override
        public int perPartitionCount() {
            return this.groupPerPartitionLimit;
        }

        @Override
        public DataLimits withoutState() {
            return this.state == GroupingState.EMPTY_STATE ? this : new CQLGroupByLimits(this.groupLimit, this.groupPerPartitionLimit, this.rowLimit, this.groupBySpec);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.groupLimit != Integer.MAX_VALUE) {
                sb.append("GROUP LIMIT ").append(this.groupLimit);
                if (this.groupPerPartitionLimit != Integer.MAX_VALUE || this.rowLimit != Integer.MAX_VALUE) {
                    sb.append(' ');
                }
            }
            if (this.groupPerPartitionLimit != Integer.MAX_VALUE) {
                sb.append("GROUP PER PARTITION LIMIT ").append(this.groupPerPartitionLimit);
                if (this.rowLimit != Integer.MAX_VALUE) {
                    sb.append(' ');
                }
            }
            if (this.rowLimit != Integer.MAX_VALUE) {
                sb.append("LIMIT ").append(this.rowLimit);
            }
            return sb.toString();
        }

        @Override
        public boolean isExhausted(Counter counter) {
            return ((GroupByAwareCounter)counter).rowCounted < this.rowLimit && counter.counted() < this.groupLimit;
        }

        protected class GroupByAwareCounter
        extends Counter {
            private final GroupMaker groupMaker;
            protected DecoratedKey currentPartitionKey;
            protected int rowCounted;
            protected int rowCountedInCurrentPartition;
            protected int groupCounted;
            protected int groupInCurrentPartition;
            protected boolean hasGroupStarted;
            protected boolean hasLiveStaticRow;
            protected boolean hasReturnedRowsFromCurrentPartition;

            private GroupByAwareCounter(int nowInSec, boolean assumeLiveData) {
                super(nowInSec, assumeLiveData);
                this.groupMaker = CQLGroupByLimits.this.groupBySpec.newGroupMaker(CQLGroupByLimits.this.state);
                this.hasGroupStarted = CQLGroupByLimits.this.state.hasClustering();
            }

            @Override
            public void applyToPartition(DecoratedKey partitionKey, Row staticRow) {
                if (partitionKey.getKey().equals(CQLGroupByLimits.this.state.partitionKey())) {
                    this.hasLiveStaticRow = false;
                    this.hasReturnedRowsFromCurrentPartition = true;
                    this.hasGroupStarted = true;
                } else {
                    if (this.hasGroupStarted && this.groupMaker.isNewGroup(partitionKey, Clustering.STATIC_CLUSTERING)) {
                        this.incrementGroupCount();
                        if (this.isDone()) {
                            this.incrementGroupInCurrentPartitionCount();
                        }
                        this.hasGroupStarted = false;
                    }
                    this.hasReturnedRowsFromCurrentPartition = false;
                    this.hasLiveStaticRow = !staticRow.isEmpty() && this.isLive(staticRow);
                }
                this.currentPartitionKey = partitionKey;
                if (!this.isDone()) {
                    this.groupInCurrentPartition = 0;
                    this.rowCountedInCurrentPartition = 0;
                }
            }

            @Override
            protected Row applyToStatic(Row row) {
                if (this.isDone()) {
                    this.hasLiveStaticRow = false;
                    return Rows.EMPTY_STATIC_ROW;
                }
                return row;
            }

            @Override
            public Row applyToRow(Row row) {
                if (this.groupMaker.isNewGroup(this.currentPartitionKey, row.clustering())) {
                    if (this.hasGroupStarted) {
                        this.incrementGroupCount();
                        this.incrementGroupInCurrentPartitionCount();
                    }
                    this.hasGroupStarted = false;
                }
                if (this.isDoneForPartition()) {
                    this.hasGroupStarted = false;
                    return null;
                }
                if (this.isLive(row)) {
                    this.hasGroupStarted = true;
                    this.incrementRowCount();
                    this.hasReturnedRowsFromCurrentPartition = true;
                }
                return row;
            }

            @Override
            public int counted() {
                return this.groupCounted;
            }

            @Override
            public int countedInCurrentPartition() {
                return this.groupInCurrentPartition;
            }

            @Override
            public int rowCounted() {
                return this.rowCounted;
            }

            @Override
            public int rowCountedInCurrentPartition() {
                return this.rowCountedInCurrentPartition;
            }

            protected void incrementRowCount() {
                ++this.rowCountedInCurrentPartition;
                if (++this.rowCounted >= CQLGroupByLimits.this.rowLimit) {
                    this.stop();
                }
            }

            private void incrementGroupCount() {
                ++this.groupCounted;
                if (this.groupCounted >= CQLGroupByLimits.this.groupLimit) {
                    this.stop();
                }
            }

            private void incrementGroupInCurrentPartitionCount() {
                ++this.groupInCurrentPartition;
                if (this.groupInCurrentPartition >= CQLGroupByLimits.this.groupPerPartitionLimit) {
                    this.stopInPartition();
                }
            }

            @Override
            public boolean isDoneForPartition() {
                return this.isDone() || this.groupInCurrentPartition >= CQLGroupByLimits.this.groupPerPartitionLimit;
            }

            @Override
            public boolean isDone() {
                return this.groupCounted >= CQLGroupByLimits.this.groupLimit;
            }

            @Override
            public void onPartitionClose() {
                if (this.hasLiveStaticRow && !this.hasReturnedRowsFromCurrentPartition) {
                    this.incrementRowCount();
                    this.incrementGroupCount();
                    this.incrementGroupInCurrentPartitionCount();
                    this.hasGroupStarted = false;
                }
                super.onPartitionClose();
            }

            @Override
            public void onClose() {
                if (this.hasGroupStarted && this.groupCounted < CQLGroupByLimits.this.groupLimit && this.rowCounted < CQLGroupByLimits.this.rowLimit) {
                    this.incrementGroupCount();
                    this.incrementGroupInCurrentPartitionCount();
                }
                super.onClose();
            }
        }
    }

    private static class CQLPagingLimits
    extends CQLLimits {
        private final ByteBuffer lastReturnedKey;
        private final int lastReturnedKeyRemaining;

        public CQLPagingLimits(int rowLimit, int perPartitionLimit, boolean isDistinct, ByteBuffer lastReturnedKey, int lastReturnedKeyRemaining) {
            super(rowLimit, perPartitionLimit, isDistinct);
            this.lastReturnedKey = lastReturnedKey;
            this.lastReturnedKeyRemaining = lastReturnedKeyRemaining;
        }

        @Override
        public Kind kind() {
            return Kind.CQL_PAGING_LIMIT;
        }

        @Override
        public DataLimits forPaging(int pageSize) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DataLimits forPaging(int pageSize, ByteBuffer lastReturnedKey, int lastReturnedKeyRemaining) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DataLimits withoutState() {
            return new CQLLimits(this.rowLimit, this.perPartitionLimit, this.isDistinct);
        }

        @Override
        public Counter newCounter(int nowInSec, boolean assumeLiveData) {
            return new PagingAwareCounter(nowInSec, assumeLiveData);
        }

        private class PagingAwareCounter
        extends CQLLimits.CQLCounter {
            private PagingAwareCounter(int nowInSec, boolean assumeLiveData) {
                super(nowInSec, assumeLiveData);
            }

            @Override
            public void applyToPartition(DecoratedKey partitionKey, Row staticRow) {
                if (partitionKey.getKey().equals(CQLPagingLimits.this.lastReturnedKey)) {
                    this.rowInCurrentPartition = CQLPagingLimits.this.perPartitionLimit - CQLPagingLimits.this.lastReturnedKeyRemaining;
                    this.hasLiveStaticRow = false;
                } else {
                    super.applyToPartition(partitionKey, staticRow);
                }
            }
        }
    }

    private static class CQLLimits
    extends DataLimits {
        protected final int rowLimit;
        protected final int perPartitionLimit;
        protected final boolean isDistinct;

        private CQLLimits(int rowLimit) {
            this(rowLimit, Integer.MAX_VALUE);
        }

        private CQLLimits(int rowLimit, int perPartitionLimit) {
            this(rowLimit, perPartitionLimit, false);
        }

        private CQLLimits(int rowLimit, int perPartitionLimit, boolean isDistinct) {
            this.rowLimit = rowLimit;
            this.perPartitionLimit = perPartitionLimit;
            this.isDistinct = isDistinct;
        }

        private static CQLLimits distinct(int rowLimit) {
            return new CQLLimits(rowLimit, 1, true);
        }

        @Override
        public Kind kind() {
            return Kind.CQL_LIMIT;
        }

        @Override
        public boolean isUnlimited() {
            return this.rowLimit == Integer.MAX_VALUE && this.perPartitionLimit == Integer.MAX_VALUE;
        }

        @Override
        public boolean isDistinct() {
            return this.isDistinct;
        }

        @Override
        public DataLimits forPaging(int pageSize) {
            return new CQLLimits(pageSize, this.perPartitionLimit, this.isDistinct);
        }

        @Override
        public DataLimits forPaging(int pageSize, ByteBuffer lastReturnedKey, int lastReturnedKeyRemaining) {
            return new CQLPagingLimits(pageSize, this.perPartitionLimit, this.isDistinct, lastReturnedKey, lastReturnedKeyRemaining);
        }

        @Override
        public DataLimits forShortReadRetry(int toFetch) {
            return new CQLLimits(toFetch, Integer.MAX_VALUE, this.isDistinct);
        }

        /*
         * Exception decompiling
         */
        @Override
        public boolean hasEnoughLiveData(CachedPartition cached, int nowInSec) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public Counter newCounter(int nowInSec, boolean assumeLiveData) {
            return new CQLCounter(nowInSec, assumeLiveData);
        }

        @Override
        public int count() {
            return this.rowLimit;
        }

        @Override
        public int perPartitionCount() {
            return this.perPartitionLimit;
        }

        @Override
        public DataLimits withoutState() {
            return this;
        }

        @Override
        public float estimateTotalResults(ColumnFamilyStore cfs) {
            float rowsPerPartition = (float)cfs.getMeanColumns() / (float)cfs.metadata.partitionColumns().regulars.size();
            return rowsPerPartition * (float)cfs.estimateKeys();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.rowLimit != Integer.MAX_VALUE) {
                sb.append("LIMIT ").append(this.rowLimit);
                if (this.perPartitionLimit != Integer.MAX_VALUE) {
                    sb.append(' ');
                }
            }
            if (this.perPartitionLimit != Integer.MAX_VALUE) {
                sb.append("PER PARTITION LIMIT ").append(this.perPartitionLimit);
            }
            return sb.toString();
        }

        protected class CQLCounter
        extends Counter {
            protected int rowCounted;
            protected int rowInCurrentPartition;
            protected boolean hasLiveStaticRow;

            public CQLCounter(int nowInSec, boolean assumeLiveData) {
                super(nowInSec, assumeLiveData);
            }

            @Override
            public void applyToPartition(DecoratedKey partitionKey, Row staticRow) {
                this.rowInCurrentPartition = 0;
                this.hasLiveStaticRow = !staticRow.isEmpty() && this.isLive(staticRow);
            }

            @Override
            public Row applyToRow(Row row) {
                if (this.isLive(row)) {
                    this.incrementRowCount();
                }
                return row;
            }

            @Override
            public void onPartitionClose() {
                if (this.hasLiveStaticRow && this.rowInCurrentPartition == 0) {
                    this.incrementRowCount();
                }
                super.onPartitionClose();
            }

            protected void incrementRowCount() {
                if (++this.rowCounted >= CQLLimits.this.rowLimit) {
                    this.stop();
                }
                if (++this.rowInCurrentPartition >= CQLLimits.this.perPartitionLimit) {
                    this.stopInPartition();
                }
            }

            @Override
            public int counted() {
                return this.rowCounted;
            }

            @Override
            public int countedInCurrentPartition() {
                return this.rowInCurrentPartition;
            }

            @Override
            public int rowCounted() {
                return this.rowCounted;
            }

            @Override
            public int rowCountedInCurrentPartition() {
                return this.rowInCurrentPartition;
            }

            @Override
            public boolean isDone() {
                return this.rowCounted >= CQLLimits.this.rowLimit;
            }

            @Override
            public boolean isDoneForPartition() {
                return this.isDone() || this.rowInCurrentPartition >= CQLLimits.this.perPartitionLimit;
            }
        }
    }

    public static abstract class Counter
    extends StoppingTransformation<BaseRowIterator<?>> {
        protected final int nowInSec;
        protected final boolean assumeLiveData;
        private boolean enforceLimits = true;

        protected Counter(int nowInSec, boolean assumeLiveData) {
            this.nowInSec = nowInSec;
            this.assumeLiveData = assumeLiveData;
        }

        public Counter onlyCount() {
            this.enforceLimits = false;
            return this;
        }

        public PartitionIterator applyTo(PartitionIterator partitions) {
            return Transformation.apply(partitions, this);
        }

        public UnfilteredPartitionIterator applyTo(UnfilteredPartitionIterator partitions) {
            return Transformation.apply(partitions, this);
        }

        public UnfilteredRowIterator applyTo(UnfilteredRowIterator partition) {
            return (UnfilteredRowIterator)this.applyToPartition(partition);
        }

        public RowIterator applyTo(RowIterator partition) {
            return (RowIterator)this.applyToPartition(partition);
        }

        public abstract int counted();

        public abstract int countedInCurrentPartition();

        public abstract int rowCounted();

        public abstract int rowCountedInCurrentPartition();

        public abstract boolean isDone();

        public abstract boolean isDoneForPartition();

        protected boolean isLive(Row row) {
            return this.assumeLiveData || row.hasLiveData(this.nowInSec);
        }

        @Override
        protected BaseRowIterator<?> applyToPartition(BaseRowIterator<?> partition) {
            return partition instanceof UnfilteredRowIterator ? Transformation.apply((UnfilteredRowIterator)partition, this) : Transformation.apply((RowIterator)partition, this);
        }

        protected abstract void applyToPartition(DecoratedKey var1, Row var2);

        @Override
        protected void attachTo(BasePartitions partitions) {
            if (this.enforceLimits) {
                super.attachTo(partitions);
            }
            if (this.isDone()) {
                this.stop();
            }
        }

        @Override
        protected void attachTo(BaseRows rows) {
            if (this.enforceLimits) {
                super.attachTo(rows);
            }
            this.applyToPartition(rows.partitionKey(), rows.staticRow());
            if (this.isDoneForPartition()) {
                this.stopInPartition();
            }
        }

        @Override
        public void onClose() {
            super.onClose();
        }
    }

    public static enum Kind {
        CQL_LIMIT,
        CQL_PAGING_LIMIT,
        THRIFT_LIMIT,
        SUPER_COLUMN_COUNTING_LIMIT,
        CQL_GROUP_BY_LIMIT,
        CQL_GROUP_BY_PAGING_LIMIT;

    }
}

