/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.Restrictions;
import org.apache.cassandra.cql3.restrictions.SingleColumnRestriction;
import org.apache.cassandra.cql3.restrictions.SingleRestriction;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.SecondaryIndexManager;

final class RestrictionSet
implements Restrictions,
Iterable<SingleRestriction> {
    private static final Comparator<ColumnDefinition> COLUMN_DEFINITION_COMPARATOR = new Comparator<ColumnDefinition>(){

        @Override
        public int compare(ColumnDefinition column, ColumnDefinition otherColumn) {
            int value = Integer.compare(column.position(), otherColumn.position());
            return value != 0 ? value : column.name.bytes.compareTo(otherColumn.name.bytes);
        }
    };
    protected final TreeMap<ColumnDefinition, SingleRestriction> restrictions;
    private final boolean hasMultiColumnRestrictions;

    public RestrictionSet() {
        this(new TreeMap<ColumnDefinition, SingleRestriction>(COLUMN_DEFINITION_COMPARATOR), false);
    }

    private RestrictionSet(TreeMap<ColumnDefinition, SingleRestriction> restrictions, boolean hasMultiColumnRestrictions) {
        this.restrictions = restrictions;
        this.hasMultiColumnRestrictions = hasMultiColumnRestrictions;
    }

    @Override
    public void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexManager, QueryOptions options) throws InvalidRequestException {
        for (Restriction restriction : this.restrictions.values()) {
            restriction.addRowFilterTo(filter, indexManager, options);
        }
    }

    @Override
    public List<ColumnDefinition> getColumnDefs() {
        return new ArrayList<ColumnDefinition>(this.restrictions.keySet());
    }

    @Override
    public void addFunctionsTo(List<Function> functions) {
        for (Restriction restriction : this) {
            restriction.addFunctionsTo(functions);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.restrictions.isEmpty();
    }

    @Override
    public int size() {
        return this.restrictions.size();
    }

    public boolean hasRestrictionFor(ColumnDefinition.Kind kind) {
        for (ColumnDefinition column : this.restrictions.keySet()) {
            if (column.kind != kind) continue;
            return true;
        }
        return false;
    }

    public RestrictionSet addRestriction(SingleRestriction restriction) {
        TreeMap<ColumnDefinition, SingleRestriction> newRestrictions = new TreeMap<ColumnDefinition, SingleRestriction>((SortedMap<ColumnDefinition, SingleRestriction>)this.restrictions);
        return new RestrictionSet(this.mergeRestrictions(newRestrictions, restriction), this.hasMultiColumnRestrictions || restriction.isMultiColumn());
    }

    private TreeMap<ColumnDefinition, SingleRestriction> mergeRestrictions(TreeMap<ColumnDefinition, SingleRestriction> restrictions, SingleRestriction restriction) {
        List<ColumnDefinition> columnDefs = restriction.getColumnDefs();
        Set<SingleRestriction> existingRestrictions = this.getRestrictions(columnDefs);
        if (existingRestrictions.isEmpty()) {
            for (ColumnDefinition columnDef : columnDefs) {
                restrictions.put(columnDef, restriction);
            }
        } else {
            for (SingleRestriction existing : existingRestrictions) {
                SingleRestriction newRestriction = RestrictionSet.mergeRestrictions(existing, restriction);
                for (ColumnDefinition columnDef : columnDefs) {
                    restrictions.put(columnDef, newRestriction);
                }
            }
        }
        return restrictions;
    }

    @Override
    public Set<Restriction> getRestrictions(ColumnDefinition columnDef) {
        Restriction existing = this.restrictions.get(columnDef);
        return existing == null ? Collections.emptySet() : Collections.singleton(existing);
    }

    private Set<SingleRestriction> getRestrictions(Collection<ColumnDefinition> columnDefs) {
        HashSet<SingleRestriction> set = new HashSet<SingleRestriction>();
        for (ColumnDefinition columnDef : columnDefs) {
            SingleRestriction existing = this.restrictions.get(columnDef);
            if (existing == null) continue;
            set.add(existing);
        }
        return set;
    }

    @Override
    public final boolean hasSupportingIndex(SecondaryIndexManager indexManager) {
        for (Restriction restriction : this.restrictions.values()) {
            if (!restriction.hasSupportingIndex(indexManager)) continue;
            return true;
        }
        return false;
    }

    ColumnDefinition nextColumn(ColumnDefinition columnDef) {
        return (ColumnDefinition)this.restrictions.tailMap(columnDef, false).firstKey();
    }

    @Override
    public ColumnDefinition getFirstColumn() {
        return this.isEmpty() ? null : this.restrictions.firstKey();
    }

    @Override
    public ColumnDefinition getLastColumn() {
        return this.isEmpty() ? null : this.restrictions.lastKey();
    }

    SingleRestriction lastRestriction() {
        return this.isEmpty() ? null : this.restrictions.lastEntry().getValue();
    }

    private static SingleRestriction mergeRestrictions(SingleRestriction restriction, SingleRestriction otherRestriction) {
        return restriction == null ? otherRestriction : restriction.mergeWith(otherRestriction);
    }

    public final boolean hasMultipleContains() {
        int numberOfContains = 0;
        for (SingleRestriction restriction : this.restrictions.values()) {
            if (!restriction.isContains()) continue;
            SingleColumnRestriction.ContainsRestriction contains = (SingleColumnRestriction.ContainsRestriction)restriction;
            numberOfContains += contains.numberOfValues() + contains.numberOfKeys() + contains.numberOfEntries();
        }
        return numberOfContains > 1;
    }

    @Override
    public Iterator<SingleRestriction> iterator() {
        Iterator<SingleRestriction> iterator = this.restrictions.values().iterator();
        return this.hasMultiColumnRestrictions ? new DistinctIterator<SingleRestriction>(iterator) : iterator;
    }

    @Override
    public final boolean hasIN() {
        for (SingleRestriction restriction : this) {
            if (!restriction.isIN()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasSlice() {
        for (SingleRestriction restriction : this) {
            if (!restriction.isSlice()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasOnlyEqualityRestrictions() {
        for (SingleRestriction restriction : this) {
            if (restriction.isEQ() || restriction.isIN()) continue;
            return false;
        }
        return true;
    }

    private static final class DistinctIterator<E>
    extends AbstractIterator<E> {
        private final Iterator<E> iterator;
        private E previous;

        public DistinctIterator(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        protected E computeNext() {
            while (this.iterator.hasNext()) {
                E next = this.iterator.next();
                if (next.equals(this.previous)) continue;
                this.previous = next;
                return next;
            }
            return (E)this.endOfData();
        }
    }
}

