/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Constants {
    private static final Logger logger = LoggerFactory.getLogger(Constants.class);
    public static final UnsetLiteral UNSET_LITERAL = new UnsetLiteral();
    public static final Value UNSET_VALUE = new Value(ByteBufferUtil.UNSET_BYTE_BUFFER);
    public static final NullLiteral NULL_LITERAL = new NullLiteral();
    public static final Term.Terminal NULL_VALUE = new Value(null){

        @Override
        public Term.Terminal bind(QueryOptions options) {
            return null;
        }

        @Override
        public String toString() {
            return "null";
        }
    };

    public static class Deleter
    extends Operation {
        public Deleter(ColumnDefinition column) {
            super(column, null);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            if (this.column.type.isMultiCell()) {
                params.setComplexDeletionTime(this.column);
            } else {
                params.addTombstone(this.column);
            }
        }
    }

    public static class Substracter
    extends Operation {
        public Substracter(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            ByteBuffer bytes = this.t.bindAndGet(params.options);
            if (bytes == null) {
                throw new InvalidRequestException("Invalid null value for counter increment");
            }
            if (bytes == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                return;
            }
            long increment = ByteBufferUtil.toLong(bytes);
            if (increment == Long.MIN_VALUE) {
                throw new InvalidRequestException("The negation of " + increment + " overflows supported counter precision (signed 8 bytes integer)");
            }
            params.addCounter(this.column, -increment);
        }
    }

    public static class Adder
    extends Operation {
        public Adder(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            ByteBuffer bytes = this.t.bindAndGet(params.options);
            if (bytes == null) {
                throw new InvalidRequestException("Invalid null value for counter increment");
            }
            if (bytes == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                return;
            }
            long increment = ByteBufferUtil.toLong(bytes);
            params.addCounter(this.column, increment);
        }
    }

    public static class Setter
    extends Operation {
        public Setter(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            ByteBuffer value = this.t.bindAndGet(params.options);
            if (value == null) {
                params.addTombstone(this.column);
            } else if (value != ByteBufferUtil.UNSET_BYTE_BUFFER) {
                params.addCell(this.column, value);
            }
        }
    }

    public static class Marker
    extends AbstractMarker {
        protected Marker(int bindIndex, ColumnSpecification receiver) {
            super(bindIndex, receiver);
            assert (!receiver.type.isCollection());
        }

        @Override
        public ByteBuffer bindAndGet(QueryOptions options) throws InvalidRequestException {
            try {
                ByteBuffer value = options.getValues().get(this.bindIndex);
                if (value != null && value != ByteBufferUtil.UNSET_BYTE_BUFFER) {
                    this.receiver.type.validate(value);
                }
                return value;
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        @Override
        public Value bind(QueryOptions options) throws InvalidRequestException {
            ByteBuffer bytes = this.bindAndGet(options);
            if (bytes == null) {
                return null;
            }
            if (bytes == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                return UNSET_VALUE;
            }
            return new Value(bytes);
        }
    }

    public static class Value
    extends Term.Terminal {
        public final ByteBuffer bytes;

        public Value(ByteBuffer bytes) {
            this.bytes = bytes;
        }

        @Override
        public ByteBuffer get(ProtocolVersion protocolVersion) {
            return this.bytes;
        }

        @Override
        public ByteBuffer bindAndGet(QueryOptions options) {
            return this.bytes;
        }

        public String toString() {
            return ByteBufferUtil.bytesToHex(this.bytes);
        }
    }

    public static class Literal
    extends Term.Raw {
        private final Type type;
        private final String text;

        private Literal(Type type, String text) {
            assert (type != null && text != null);
            this.type = type;
            this.text = text;
        }

        public static Literal string(String text) {
            return new Literal(Type.STRING, text);
        }

        public static Literal integer(String text) {
            return new Literal(Type.INTEGER, text);
        }

        public static Literal floatingPoint(String text) {
            return new Literal(Type.FLOAT, text);
        }

        public static Literal uuid(String text) {
            return new Literal(Type.UUID, text);
        }

        public static Literal bool(String text) {
            return new Literal(Type.BOOLEAN, text);
        }

        public static Literal hex(String text) {
            return new Literal(Type.HEX, text);
        }

        public static Literal duration(String text) {
            return new Literal(Type.DURATION, text);
        }

        @Override
        public Value prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            if (!this.testAssignment(keyspace, receiver).isAssignable()) {
                throw new InvalidRequestException(String.format("Invalid %s constant (%s) for \"%s\" of type %s", new Object[]{this.type, this.text, receiver.name, receiver.type.asCQL3Type()}));
            }
            return new Value(this.parsedValue(receiver.type));
        }

        private ByteBuffer parsedValue(AbstractType<?> validator) throws InvalidRequestException {
            if (validator instanceof ReversedType) {
                validator = ((ReversedType)validator).baseType;
            }
            try {
                if (this.type == Type.HEX) {
                    return BytesType.instance.fromString(this.text.substring(2));
                }
                if (validator instanceof CounterColumnType) {
                    return LongType.instance.fromString(this.text);
                }
                return validator.fromString(this.text);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            CQL3Type receiverType = receiver.type.asCQL3Type();
            if (receiverType.isCollection() || receiverType.isUDT()) {
                return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
            }
            if (!(receiverType instanceof CQL3Type.Native)) {
                return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
            }
            CQL3Type.Native nt = (CQL3Type.Native)receiverType;
            switch (this.type) {
                case STRING: {
                    switch (nt) {
                        case ASCII: 
                        case TEXT: 
                        case INET: 
                        case VARCHAR: 
                        case DATE: 
                        case TIME: 
                        case TIMESTAMP: {
                            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
                        }
                    }
                    break;
                }
                case INTEGER: {
                    switch (nt) {
                        case DATE: 
                        case TIME: 
                        case TIMESTAMP: 
                        case BIGINT: 
                        case COUNTER: 
                        case DECIMAL: 
                        case DOUBLE: 
                        case DURATION: 
                        case FLOAT: 
                        case INT: 
                        case SMALLINT: 
                        case TINYINT: 
                        case VARINT: {
                            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
                        }
                    }
                    break;
                }
                case UUID: {
                    switch (nt) {
                        case UUID: 
                        case TIMEUUID: {
                            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (nt) {
                        case DECIMAL: 
                        case DOUBLE: 
                        case FLOAT: {
                            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
                        }
                    }
                    break;
                }
                case BOOLEAN: {
                    switch (nt) {
                        case BOOLEAN: {
                            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
                        }
                    }
                    break;
                }
                case HEX: {
                    switch (nt) {
                        case BLOB: {
                            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
                        }
                    }
                    break;
                }
                case DURATION: {
                    switch (nt) {
                        case DURATION: {
                            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
                        }
                    }
                }
            }
            return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return null;
        }

        public String getRawText() {
            return this.text;
        }

        @Override
        public String getText() {
            return this.type == Type.STRING ? String.format("'%s'", this.text) : this.text;
        }
    }

    private static class NullLiteral
    extends Term.Raw {
        private NullLiteral() {
        }

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            if (!this.testAssignment(keyspace, receiver).isAssignable()) {
                throw new InvalidRequestException("Invalid null value for counter increment/decrement");
            }
            return NULL_VALUE;
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            return receiver.type instanceof CounterColumnType ? AssignmentTestable.TestResult.NOT_ASSIGNABLE : AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
        }

        @Override
        public String getText() {
            return "NULL";
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return null;
        }
    }

    private static class UnsetLiteral
    extends Term.Raw {
        private UnsetLiteral() {
        }

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            return UNSET_VALUE;
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
        }

        @Override
        public String getText() {
            return "";
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return null;
        }
    }

    public static enum Type {
        STRING,
        INTEGER,
        UUID,
        FLOAT,
        BOOLEAN,
        HEX,
        DURATION;

    }
}

