/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.batchlog.Batch;
import org.apache.cassandra.batchlog.BatchlogManager;
import org.apache.cassandra.batchlog.LegacyBatchlogMigrator;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.HintedHandOffManager;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Truncation;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.TombstoneOverwhelmingException;
import org.apache.cassandra.db.partitions.FilteredPartition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.view.ViewUtils;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.IsBootstrappingException;
import org.apache.cassandra.exceptions.OverloadedException;
import org.apache.cassandra.exceptions.ReadFailureException;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.RequestFailureException;
import org.apache.cassandra.exceptions.RequestTimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.exceptions.WriteFailureException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.hints.Hint;
import org.apache.cassandra.hints.HintsService;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.metrics.CASClientRequestMetrics;
import org.apache.cassandra.metrics.ClientRequestMetrics;
import org.apache.cassandra.metrics.ReadRepairMetrics;
import org.apache.cassandra.metrics.StorageMetrics;
import org.apache.cassandra.metrics.ViewWriteMetrics;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.IAsyncCallbackWithFailure;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.AbstractReadExecutor;
import org.apache.cassandra.service.AbstractWriteResponseHandler;
import org.apache.cassandra.service.BatchlogResponseHandler;
import org.apache.cassandra.service.CASRequest;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.DataResolver;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.ReadCallback;
import org.apache.cassandra.service.StorageProxyMBean;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.TruncateResponseHandler;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.service.paxos.PrepareCallback;
import org.apache.cassandra.service.paxos.ProposeCallback;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.triggers.TriggerExecutor;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.UUIDSerializer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageProxy
implements StorageProxyMBean {
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=StorageProxy";
    private static final Logger logger = LoggerFactory.getLogger(StorageProxy.class);
    public static final String UNREACHABLE = "UNREACHABLE";
    private static final WritePerformer standardWritePerformer;
    private static final WritePerformer counterWritePerformer;
    private static final WritePerformer counterWriteOnCoordinatorPerformer;
    public static final StorageProxy instance;
    private static volatile int maxHintsInProgress;
    private static final CacheLoader<InetAddress, AtomicInteger> hintsInProgress;
    private static final ClientRequestMetrics readMetrics;
    private static final ClientRequestMetrics rangeMetrics;
    private static final ClientRequestMetrics writeMetrics;
    private static final CASClientRequestMetrics casWriteMetrics;
    private static final CASClientRequestMetrics casReadMetrics;
    private static final ViewWriteMetrics viewWriteMetrics;
    private static final double CONCURRENT_SUBREQUESTS_MARGIN = 0.1;

    private StorageProxy() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RowIterator cas(String keyspaceName, String cfName, DecoratedKey key, CASRequest request, ConsistencyLevel consistencyForPaxos, ConsistencyLevel consistencyForCommit, ClientState state) throws UnavailableException, IsBootstrappingException, RequestFailureException, RequestTimeoutException, InvalidRequestException {
        long start = System.nanoTime();
        int contentions = 0;
        try {
            consistencyForPaxos.validateForCas();
            consistencyForCommit.validateForCasCommit(keyspaceName);
            CFMetaData metadata = Schema.instance.getCFMetaData(keyspaceName, cfName);
            long timeout = TimeUnit.MILLISECONDS.toNanos(DatabaseDescriptor.getCasContentionTimeout());
            while (System.nanoTime() - start < timeout) {
                FilteredPartition current;
                Pair<List<InetAddress>, Integer> p = StorageProxy.getPaxosParticipants(metadata, key, consistencyForPaxos);
                List liveEndpoints = (List)p.left;
                int requiredParticipants = (Integer)p.right;
                Pair<UUID, Integer> pair = StorageProxy.beginAndRepairPaxos(start, key, metadata, liveEndpoints, requiredParticipants, consistencyForPaxos, consistencyForCommit, true, state);
                UUID ballot = (UUID)pair.left;
                contentions += ((Integer)pair.right).intValue();
                Tracing.trace("Reading existing values for CAS precondition");
                SinglePartitionReadCommand readCommand = request.readCommand(FBUtilities.nowInSeconds());
                ConsistencyLevel readConsistency = consistencyForPaxos == ConsistencyLevel.LOCAL_SERIAL ? ConsistencyLevel.LOCAL_QUORUM : ConsistencyLevel.QUORUM;
                try (RowIterator rowIter = StorageProxy.readOne(readCommand, readConsistency);){
                    current = FilteredPartition.create(rowIter);
                }
                if (!request.appliesTo(current)) {
                    Tracing.trace("CAS precondition does not match current values {}", (Object)current);
                    StorageProxy.casWriteMetrics.conditionNotMet.inc();
                    rowIter = current.rowIterator();
                    return rowIter;
                }
                PartitionUpdate updates = request.makeUpdates(current);
                updates = TriggerExecutor.instance.execute(updates);
                Commit proposal = Commit.newProposal(ballot, updates);
                Tracing.trace("CAS precondition is met; proposing client-requested updates for {}", (Object)ballot);
                if (StorageProxy.proposePaxos(proposal, liveEndpoints, requiredParticipants, true, consistencyForPaxos)) {
                    StorageProxy.commitPaxos(proposal, consistencyForCommit, true);
                    Tracing.trace("CAS successful");
                    RowIterator rowIterator = null;
                    return rowIterator;
                }
                Tracing.trace("Paxos proposal not accepted (pre-empted by a higher ballot)");
                ++contentions;
                Uninterruptibles.sleepUninterruptibly((long)ThreadLocalRandom.current().nextInt(100), (TimeUnit)TimeUnit.MILLISECONDS);
            }
            throw new WriteTimeoutException(WriteType.CAS, consistencyForPaxos, 0, consistencyForPaxos.blockFor(Keyspace.open(keyspaceName)));
        }
        catch (ReadTimeoutException | WriteTimeoutException e) {
            StorageProxy.casWriteMetrics.timeouts.mark();
            throw e;
        }
        catch (ReadFailureException | WriteFailureException e) {
            StorageProxy.casWriteMetrics.failures.mark();
            throw e;
        }
        catch (UnavailableException e) {
            StorageProxy.casWriteMetrics.unavailables.mark();
            throw e;
        }
        finally {
            if (contentions > 0) {
                StorageProxy.casWriteMetrics.contention.update(contentions);
            }
            casWriteMetrics.addNano(System.nanoTime() - start);
        }
    }

    private static Predicate<InetAddress> sameDCPredicateFor(final String dc) {
        final IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        return new Predicate<InetAddress>(){

            public boolean apply(InetAddress host) {
                return dc.equals(snitch.getDatacenter(host));
            }
        };
    }

    private static Pair<List<InetAddress>, Integer> getPaxosParticipants(CFMetaData cfm, DecoratedKey key, ConsistencyLevel consistencyForPaxos) throws UnavailableException {
        Token tk = key.getToken();
        ImmutableList naturalEndpoints = StorageService.instance.getNaturalEndpoints(cfm.ksName, tk);
        ImmutableList pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor(tk, cfm.ksName);
        if (consistencyForPaxos == ConsistencyLevel.LOCAL_SERIAL) {
            String localDc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
            Predicate<InetAddress> isLocalDc = StorageProxy.sameDCPredicateFor(localDc);
            naturalEndpoints = ImmutableList.copyOf((Iterable)Iterables.filter(naturalEndpoints, isLocalDc));
            pendingEndpoints = ImmutableList.copyOf((Iterable)Iterables.filter(pendingEndpoints, isLocalDc));
        }
        int participants = pendingEndpoints.size() + naturalEndpoints.size();
        int requiredParticipants = participants / 2 + 1;
        ImmutableList liveEndpoints = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)naturalEndpoints, pendingEndpoints), IAsyncCallback.isAlive));
        if (liveEndpoints.size() < requiredParticipants) {
            throw new UnavailableException(consistencyForPaxos, requiredParticipants, liveEndpoints.size());
        }
        if (pendingEndpoints.size() > 1) {
            throw new UnavailableException(String.format("Cannot perform LWT operation as there is more than one (%d) pending range movement", pendingEndpoints.size()), consistencyForPaxos, participants + 1, liveEndpoints.size());
        }
        return Pair.create(liveEndpoints, requiredParticipants);
    }

    private static Pair<UUID, Integer> beginAndRepairPaxos(long start, DecoratedKey key, CFMetaData metadata, List<InetAddress> liveEndpoints, int requiredParticipants, ConsistencyLevel consistencyForPaxos, ConsistencyLevel consistencyForCommit, boolean isWrite, ClientState state) throws WriteTimeoutException, WriteFailureException {
        long timeout = TimeUnit.MILLISECONDS.toNanos(DatabaseDescriptor.getCasContentionTimeout());
        PrepareCallback summary = null;
        int contentions = 0;
        while (System.nanoTime() - start < timeout) {
            long minTimestampMicrosToUse = summary == null ? Long.MIN_VALUE : 1L + UUIDGen.microsTimestamp(summary.mostRecentInProgressCommit.ballot);
            long ballotMicros = state.getTimestampForPaxos(minTimestampMicrosToUse);
            UUID ballot = UUIDGen.getRandomTimeUUIDFromMicros(ballotMicros);
            Tracing.trace("Preparing {}", (Object)ballot);
            Commit toPrepare = Commit.newPrepare(key, metadata, ballot);
            summary = StorageProxy.preparePaxos(toPrepare, liveEndpoints, requiredParticipants, consistencyForPaxos);
            if (!summary.promised) {
                Tracing.trace("Some replicas have already promised a higher ballot than ours; aborting");
                ++contentions;
                Uninterruptibles.sleepUninterruptibly((long)ThreadLocalRandom.current().nextInt(100), (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
            Commit inProgress = summary.mostRecentInProgressCommitWithUpdate;
            Commit mostRecent = summary.mostRecentCommit;
            if (!inProgress.update.isEmpty() && inProgress.isAfter(mostRecent)) {
                Tracing.trace("Finishing incomplete paxos round {}", (Object)inProgress);
                if (isWrite) {
                    StorageProxy.casWriteMetrics.unfinishedCommit.inc();
                } else {
                    StorageProxy.casReadMetrics.unfinishedCommit.inc();
                }
                Commit refreshedInProgress = Commit.newProposal(ballot, inProgress.update);
                if (StorageProxy.proposePaxos(refreshedInProgress, liveEndpoints, requiredParticipants, false, consistencyForPaxos)) {
                    try {
                        StorageProxy.commitPaxos(refreshedInProgress, consistencyForCommit, false);
                        continue;
                    }
                    catch (WriteTimeoutException e) {
                        throw new WriteTimeoutException(WriteType.CAS, e.consistency, e.received, e.blockFor);
                    }
                }
                Tracing.trace("Some replicas have already promised a higher ballot than ours; aborting");
                ++contentions;
                Uninterruptibles.sleepUninterruptibly((long)ThreadLocalRandom.current().nextInt(100), (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
            int nowInSec = Ints.checkedCast((long)TimeUnit.MICROSECONDS.toSeconds(ballotMicros));
            Iterable<InetAddress> missingMRC = summary.replicasMissingMostRecentCommit(metadata, nowInSec);
            if (Iterables.size(missingMRC) > 0) {
                Tracing.trace("Repairing replicas that missed the most recent commit");
                StorageProxy.sendCommit(mostRecent, missingMRC);
                continue;
            }
            return Pair.create(ballot, contentions);
        }
        throw new WriteTimeoutException(WriteType.CAS, consistencyForPaxos, 0, consistencyForPaxos.blockFor(Keyspace.open(metadata.ksName)));
    }

    private static void sendCommit(Commit commit, Iterable<InetAddress> replicas) {
        MessageOut<Commit> message = new MessageOut<Commit>(MessagingService.Verb.PAXOS_COMMIT, commit, Commit.serializer);
        for (InetAddress target : replicas) {
            MessagingService.instance().sendOneWay(message, target);
        }
    }

    private static PrepareCallback preparePaxos(Commit toPrepare, List<InetAddress> endpoints, int requiredParticipants, ConsistencyLevel consistencyForPaxos) throws WriteTimeoutException {
        PrepareCallback callback = new PrepareCallback(toPrepare.update.partitionKey(), toPrepare.update.metadata(), requiredParticipants, consistencyForPaxos);
        MessageOut<Commit> message = new MessageOut<Commit>(MessagingService.Verb.PAXOS_PREPARE, toPrepare, Commit.serializer);
        for (InetAddress target : endpoints) {
            MessagingService.instance().sendRR(message, target, callback);
        }
        callback.await();
        return callback;
    }

    private static boolean proposePaxos(Commit proposal, List<InetAddress> endpoints, int requiredParticipants, boolean timeoutIfPartial, ConsistencyLevel consistencyLevel) throws WriteTimeoutException {
        ProposeCallback callback = new ProposeCallback(endpoints.size(), requiredParticipants, !timeoutIfPartial, consistencyLevel);
        MessageOut<Commit> message = new MessageOut<Commit>(MessagingService.Verb.PAXOS_PROPOSE, proposal, Commit.serializer);
        for (InetAddress target : endpoints) {
            MessagingService.instance().sendRR(message, target, callback);
        }
        callback.await();
        if (callback.isSuccessful()) {
            return true;
        }
        if (timeoutIfPartial && !callback.isFullyRefused()) {
            throw new WriteTimeoutException(WriteType.CAS, consistencyLevel, callback.getAcceptCount(), requiredParticipants);
        }
        return false;
    }

    private static void commitPaxos(Commit proposal, ConsistencyLevel consistencyLevel, boolean shouldHint) throws WriteTimeoutException {
        boolean shouldBlock = consistencyLevel != ConsistencyLevel.ANY;
        Keyspace keyspace = Keyspace.open(proposal.update.metadata().ksName);
        Token tk = proposal.update.partitionKey().getToken();
        List<InetAddress> naturalEndpoints = StorageService.instance.getNaturalEndpoints(keyspace.getName(), tk);
        Collection<InetAddress> pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor(tk, keyspace.getName());
        AbstractWriteResponseHandler responseHandler = null;
        if (shouldBlock) {
            AbstractReplicationStrategy rs = keyspace.getReplicationStrategy();
            responseHandler = rs.getWriteResponseHandler(naturalEndpoints, pendingEndpoints, consistencyLevel, null, WriteType.SIMPLE);
        }
        MessageOut<Commit> message = new MessageOut<Commit>(MessagingService.Verb.PAXOS_COMMIT, proposal, Commit.serializer);
        for (InetAddress destination : Iterables.concat(naturalEndpoints, pendingEndpoints)) {
            if (FailureDetector.instance.isAlive(destination)) {
                if (shouldBlock) {
                    if (StorageProxy.canDoLocalRequest(destination)) {
                        StorageProxy.commitPaxosLocal(message, responseHandler);
                        continue;
                    }
                    MessagingService.instance().sendRR(message, destination, responseHandler, shouldHint);
                    continue;
                }
                MessagingService.instance().sendOneWay(message, destination);
                continue;
            }
            if (!shouldHint) continue;
            StorageProxy.submitHint(proposal.makeMutation(), destination, null);
        }
        if (shouldBlock) {
            responseHandler.get();
        }
    }

    private static void commitPaxosLocal(final MessageOut<Commit> message, final AbstractWriteResponseHandler<?> responseHandler) {
        StageManager.getStage(MessagingService.verbStages.get((Object)MessagingService.Verb.PAXOS_COMMIT)).maybeExecuteImmediately(new LocalMutationRunnable(){

            @Override
            public void runMayThrow() {
                try {
                    PaxosState.commit((Commit)message.payload);
                    if (responseHandler != null) {
                        responseHandler.response(null);
                    }
                }
                catch (Exception ex) {
                    if (!(ex instanceof WriteTimeoutException)) {
                        logger.error("Failed to apply paxos commit locally : {}", (Throwable)ex);
                    }
                    responseHandler.onFailure(FBUtilities.getBroadcastAddress());
                }
            }

            @Override
            protected MessagingService.Verb verb() {
                return MessagingService.Verb.PAXOS_COMMIT;
            }
        });
    }

    public static void mutate(Collection<? extends IMutation> mutations, ConsistencyLevel consistency_level) throws UnavailableException, OverloadedException, WriteTimeoutException, WriteFailureException {
        block14: {
            Tracing.trace("Determining replicas for mutation");
            String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
            long startTime = System.nanoTime();
            ArrayList<AbstractWriteResponseHandler<IMutation>> responseHandlers = new ArrayList<AbstractWriteResponseHandler<IMutation>>(mutations.size());
            try {
                for (IMutation iMutation : mutations) {
                    if (iMutation instanceof CounterMutation) {
                        responseHandlers.add(StorageProxy.mutateCounter((CounterMutation)iMutation, localDataCenter));
                        continue;
                    }
                    WriteType wt = mutations.size() <= 1 ? WriteType.SIMPLE : WriteType.UNLOGGED_BATCH;
                    responseHandlers.add(StorageProxy.performWrite(iMutation, consistency_level, localDataCenter, standardWritePerformer, null, wt));
                }
                for (AbstractWriteResponseHandler abstractWriteResponseHandler : responseHandlers) {
                    abstractWriteResponseHandler.get();
                }
            }
            catch (WriteFailureException | WriteTimeoutException ex) {
                if (consistency_level == ConsistencyLevel.ANY) {
                    StorageProxy.hintMutations(mutations);
                    break block14;
                }
                if (ex instanceof WriteFailureException) {
                    StorageProxy.writeMetrics.failures.mark();
                    WriteFailureException writeFailureException = (WriteFailureException)ex;
                    Tracing.trace("Write failure; received {} of {} required replies, failed {} requests", writeFailureException.received, writeFailureException.blockFor, writeFailureException.failures);
                } else {
                    StorageProxy.writeMetrics.timeouts.mark();
                    WriteTimeoutException writeTimeoutException = (WriteTimeoutException)ex;
                    Tracing.trace("Write timeout; received {} of {} required replies", (Object)writeTimeoutException.received, (Object)writeTimeoutException.blockFor);
                }
                throw ex;
            }
            catch (UnavailableException e) {
                StorageProxy.writeMetrics.unavailables.mark();
                Tracing.trace("Unavailable");
                throw e;
            }
            catch (OverloadedException e) {
                StorageProxy.writeMetrics.unavailables.mark();
                Tracing.trace("Overloaded");
                throw e;
            }
            finally {
                writeMetrics.addNano(System.nanoTime() - startTime);
            }
        }
    }

    private static void hintMutations(Collection<? extends IMutation> mutations) {
        for (IMutation iMutation : mutations) {
            if (iMutation instanceof CounterMutation) continue;
            StorageProxy.hintMutation((Mutation)iMutation);
        }
        Tracing.trace("Wrote hints to satisfy CL.ANY after no replicas acknowledged the write");
    }

    private static void hintMutation(Mutation mutation) {
        String keyspaceName = mutation.getKeyspaceName();
        Token token = mutation.key().getToken();
        Iterable<InetAddress> endpoints = StorageService.instance.getNaturalAndPendingEndpoints(keyspaceName, token);
        ArrayList<InetAddress> endpointsToHint = new ArrayList<InetAddress>(Iterables.size(endpoints));
        for (InetAddress target : endpoints) {
            if (target.equals(FBUtilities.getBroadcastAddress()) || !StorageProxy.shouldHint(target)) continue;
            endpointsToHint.add(target);
        }
        StorageProxy.submitHint(mutation, endpointsToHint, null);
    }

    public boolean appliesLocally(Mutation mutation) {
        String keyspaceName = mutation.getKeyspaceName();
        Token token = mutation.key().getToken();
        InetAddress local = FBUtilities.getBroadcastAddress();
        return StorageService.instance.getNaturalEndpoints(keyspaceName, token).contains(local) || StorageService.instance.getTokenMetadata().pendingEndpointsFor(token, keyspaceName).contains(local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mutateMV(ByteBuffer dataKey, Collection<Mutation> mutations, boolean writeCommitLog, AtomicLong baseComplete) throws UnavailableException, OverloadedException, WriteTimeoutException {
        Tracing.trace("Determining replicas for mutation");
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
        long startTime = System.nanoTime();
        try {
            UUID batchUUID = UUIDGen.getTimeUUID();
            if (StorageService.instance.isStarting() || StorageService.instance.isJoining() || StorageService.instance.isMoving()) {
                BatchlogManager.store(Batch.createLocal(batchUUID, FBUtilities.timestampMicros(), mutations), writeCommitLog);
            } else {
                ArrayList<WriteResponseHandlerWrapper> wrappers = new ArrayList<WriteResponseHandlerWrapper>(mutations.size());
                LinkedList<Mutation> nonPairedMutations = new LinkedList<Mutation>();
                Token baseToken = StorageService.instance.getTokenMetadata().partitioner.getToken(dataKey);
                ConsistencyLevel consistencyLevel = ConsistencyLevel.ONE;
                Set<InetAddress> batchlogEndpoints = Collections.singleton(FBUtilities.getBroadcastAddress());
                BatchlogResponseHandler.BatchlogCleanup cleanup = new BatchlogResponseHandler.BatchlogCleanup(mutations.size(), () -> StorageProxy.asyncRemoveFromBatchlog(batchlogEndpoints, batchUUID));
                for (Mutation mutation : mutations) {
                    String keyspaceName = mutation.getKeyspaceName();
                    Token tk = mutation.key().getToken();
                    Optional<InetAddress> pairedEndpoint = ViewUtils.getViewNaturalEndpoint(keyspaceName, baseToken, tk);
                    Collection<InetAddress> pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor(tk, keyspaceName);
                    if (pairedEndpoint.isPresent()) {
                        if (pairedEndpoint.get().equals(FBUtilities.getBroadcastAddress()) && pendingEndpoints.isEmpty() && StorageService.instance.isJoined()) {
                            try {
                                mutation.apply(writeCommitLog);
                                continue;
                            }
                            catch (Exception exc) {
                                logger.error("Error applying local view update to keyspace {}: {}", (Object)mutation.getKeyspaceName(), (Object)mutation);
                                throw exc;
                            }
                        }
                        wrappers.add(StorageProxy.wrapViewBatchResponseHandler(mutation, consistencyLevel, consistencyLevel, Collections.singletonList(pairedEndpoint.get()), baseComplete, WriteType.BATCH, cleanup));
                        continue;
                    }
                    if (pendingEndpoints.isEmpty()) {
                        logger.warn("Received base materialized view mutation for key {} that does not belong to this node. There is probably a range movement happening (move or decommission),but this node hasn't updated its ring metadata yet. Adding mutation to local batchlog to be replayed later.", (Object)mutation.key());
                    }
                    nonPairedMutations.add(mutation);
                }
                if (!wrappers.isEmpty()) {
                    BatchlogManager.store(Batch.createLocal(batchUUID, FBUtilities.timestampMicros(), Lists.transform(wrappers, w -> w.mutation)), writeCommitLog);
                    StorageProxy.asyncWriteBatchedMutations(wrappers, localDataCenter, Stage.VIEW_MUTATION);
                }
                if (!nonPairedMutations.isEmpty()) {
                    BatchlogManager.store(Batch.createLocal(batchUUID, FBUtilities.timestampMicros(), nonPairedMutations), writeCommitLog);
                }
            }
        }
        finally {
            viewWriteMetrics.addNano(System.nanoTime() - startTime);
        }
    }

    public static void mutateWithTriggers(Collection<? extends IMutation> mutations, ConsistencyLevel consistencyLevel, boolean mutateAtomically) throws WriteTimeoutException, WriteFailureException, UnavailableException, OverloadedException, InvalidRequestException {
        Collection<Mutation> augmented = TriggerExecutor.instance.execute(mutations);
        boolean updatesView = Keyspace.open((String)mutations.iterator().next().getKeyspaceName()).viewManager.updatesAffectView(mutations, true);
        if (augmented != null) {
            StorageProxy.mutateAtomically(augmented, consistencyLevel, updatesView);
        } else if (mutateAtomically || updatesView) {
            StorageProxy.mutateAtomically(mutations, consistencyLevel, updatesView);
        } else {
            StorageProxy.mutate(mutations, consistencyLevel);
        }
    }

    public static void mutateAtomically(Collection<Mutation> mutations, ConsistencyLevel consistency_level, boolean requireQuorumForRemove) throws UnavailableException, OverloadedException, WriteTimeoutException {
        Tracing.trace("Determining replicas for atomic batch");
        long startTime = System.nanoTime();
        ArrayList<WriteResponseHandlerWrapper> wrappers = new ArrayList<WriteResponseHandlerWrapper>(mutations.size());
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
        try {
            ConsistencyLevel batchConsistencyLevel = requireQuorumForRemove ? ConsistencyLevel.QUORUM : consistency_level;
            switch (consistency_level) {
                case ALL: 
                case EACH_QUORUM: {
                    batchConsistencyLevel = consistency_level;
                }
            }
            BatchlogEndpoints batchlogEndpoints = StorageProxy.getBatchlogEndpoints(localDataCenter, batchConsistencyLevel);
            UUID batchUUID = UUIDGen.getTimeUUID();
            BatchlogResponseHandler.BatchlogCleanup cleanup = new BatchlogResponseHandler.BatchlogCleanup(mutations.size(), () -> StorageProxy.asyncRemoveFromBatchlog(batchlogEndpoints, batchUUID));
            for (Mutation mutation : mutations) {
                WriteResponseHandlerWrapper wrapper = StorageProxy.wrapBatchResponseHandler(mutation, consistency_level, batchConsistencyLevel, WriteType.BATCH, cleanup);
                wrapper.handler.assureSufficientLiveNodes();
                wrappers.add(wrapper);
            }
            StorageProxy.syncWriteToBatchlog(mutations, batchlogEndpoints, batchUUID);
            StorageProxy.syncWriteBatchedMutations(wrappers, localDataCenter, Stage.MUTATION);
        }
        catch (UnavailableException e) {
            StorageProxy.writeMetrics.unavailables.mark();
            Tracing.trace("Unavailable");
            throw e;
        }
        catch (WriteTimeoutException e) {
            StorageProxy.writeMetrics.timeouts.mark();
            Tracing.trace("Write timeout; received {} of {} required replies", (Object)e.received, (Object)e.blockFor);
            throw e;
        }
        catch (WriteFailureException e) {
            StorageProxy.writeMetrics.failures.mark();
            Tracing.trace("Write failure; received {} of {} required replies", (Object)e.received, (Object)e.blockFor);
            throw e;
        }
        finally {
            writeMetrics.addNano(System.nanoTime() - startTime);
        }
    }

    public static boolean canDoLocalRequest(InetAddress replica) {
        return replica.equals(FBUtilities.getBroadcastAddress());
    }

    private static void syncWriteToBatchlog(Collection<Mutation> mutations, BatchlogEndpoints endpoints, UUID uuid) throws WriteTimeoutException, WriteFailureException {
        WriteResponseHandler handler = new WriteResponseHandler(endpoints.all, Collections.emptyList(), endpoints.all.size() == 1 ? ConsistencyLevel.ONE : ConsistencyLevel.TWO, Keyspace.open("system"), null, WriteType.BATCH_LOG);
        Batch batch = Batch.createLocal(uuid, FBUtilities.timestampMicros(), mutations);
        if (!endpoints.current.isEmpty()) {
            StorageProxy.syncWriteToBatchlog(handler, batch, endpoints.current);
        }
        if (!endpoints.legacy.isEmpty()) {
            LegacyBatchlogMigrator.syncWriteToBatchlog(handler, batch, endpoints.legacy);
        }
        handler.get();
    }

    private static void syncWriteToBatchlog(WriteResponseHandler<?> handler, Batch batch, Collection<InetAddress> endpoints) throws WriteTimeoutException, WriteFailureException {
        MessageOut<Batch> message = new MessageOut<Batch>(MessagingService.Verb.BATCH_STORE, batch, Batch.serializer);
        for (InetAddress target : endpoints) {
            logger.trace("Sending batchlog store request {} to {} for {} mutations", new Object[]{batch.id, target, batch.size()});
            if (StorageProxy.canDoLocalRequest(target)) {
                StorageProxy.performLocally(Stage.MUTATION, () -> BatchlogManager.store(batch), handler);
                continue;
            }
            MessagingService.instance().sendRR(message, target, handler);
        }
    }

    private static void asyncRemoveFromBatchlog(BatchlogEndpoints endpoints, UUID uuid) {
        if (!endpoints.current.isEmpty()) {
            StorageProxy.asyncRemoveFromBatchlog(endpoints.current, uuid);
        }
        if (!endpoints.legacy.isEmpty()) {
            LegacyBatchlogMigrator.asyncRemoveFromBatchlog(endpoints.legacy, uuid);
        }
    }

    private static void asyncRemoveFromBatchlog(Collection<InetAddress> endpoints, UUID uuid) {
        MessageOut<UUID> message = new MessageOut<UUID>(MessagingService.Verb.BATCH_REMOVE, uuid, UUIDSerializer.serializer);
        for (InetAddress target : endpoints) {
            if (logger.isTraceEnabled()) {
                logger.trace("Sending batchlog remove request {} to {}", (Object)uuid, (Object)target);
            }
            if (StorageProxy.canDoLocalRequest(target)) {
                StorageProxy.performLocally(Stage.MUTATION, () -> BatchlogManager.remove(uuid));
                continue;
            }
            MessagingService.instance().sendOneWay(message, target);
        }
    }

    private static void asyncWriteBatchedMutations(List<WriteResponseHandlerWrapper> wrappers, String localDataCenter, Stage stage) {
        for (WriteResponseHandlerWrapper wrapper : wrappers) {
            Iterable endpoints = Iterables.concat((Iterable)wrapper.handler.naturalEndpoints, (Iterable)wrapper.handler.pendingEndpoints);
            try {
                StorageProxy.sendToHintedEndpoints(wrapper.mutation, endpoints, wrapper.handler, localDataCenter, stage);
            }
            catch (OverloadedException | WriteTimeoutException e) {
                wrapper.handler.onFailure(FBUtilities.getBroadcastAddress());
            }
        }
    }

    private static void syncWriteBatchedMutations(List<WriteResponseHandlerWrapper> wrappers, String localDataCenter, Stage stage) throws WriteTimeoutException, OverloadedException {
        for (WriteResponseHandlerWrapper wrapper : wrappers) {
            Iterable endpoints = Iterables.concat((Iterable)wrapper.handler.naturalEndpoints, (Iterable)wrapper.handler.pendingEndpoints);
            StorageProxy.sendToHintedEndpoints(wrapper.mutation, endpoints, wrapper.handler, localDataCenter, stage);
        }
        for (WriteResponseHandlerWrapper wrapper : wrappers) {
            wrapper.handler.get();
        }
    }

    public static AbstractWriteResponseHandler<IMutation> performWrite(IMutation mutation, ConsistencyLevel consistency_level, String localDataCenter, WritePerformer performer, Runnable callback, WriteType writeType) throws UnavailableException, OverloadedException {
        String keyspaceName = mutation.getKeyspaceName();
        AbstractReplicationStrategy rs = Keyspace.open(keyspaceName).getReplicationStrategy();
        Token tk = mutation.key().getToken();
        List<InetAddress> naturalEndpoints = StorageService.instance.getNaturalEndpoints(keyspaceName, tk);
        Collection<InetAddress> pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor(tk, keyspaceName);
        AbstractWriteResponseHandler<IMutation> responseHandler = rs.getWriteResponseHandler(naturalEndpoints, pendingEndpoints, consistency_level, callback, writeType);
        responseHandler.assureSufficientLiveNodes();
        performer.apply(mutation, Iterables.concat(naturalEndpoints, pendingEndpoints), responseHandler, localDataCenter, consistency_level);
        return responseHandler;
    }

    private static WriteResponseHandlerWrapper wrapBatchResponseHandler(Mutation mutation, ConsistencyLevel consistency_level, ConsistencyLevel batchConsistencyLevel, WriteType writeType, BatchlogResponseHandler.BatchlogCleanup cleanup) {
        Keyspace keyspace = Keyspace.open(mutation.getKeyspaceName());
        AbstractReplicationStrategy rs = keyspace.getReplicationStrategy();
        String keyspaceName = mutation.getKeyspaceName();
        Token tk = mutation.key().getToken();
        List<InetAddress> naturalEndpoints = StorageService.instance.getNaturalEndpoints(keyspaceName, tk);
        Collection<InetAddress> pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor(tk, keyspaceName);
        AbstractWriteResponseHandler writeHandler = rs.getWriteResponseHandler(naturalEndpoints, pendingEndpoints, consistency_level, null, writeType);
        BatchlogResponseHandler<IMutation> batchHandler = new BatchlogResponseHandler<IMutation>(writeHandler, batchConsistencyLevel.blockFor(keyspace), cleanup);
        return new WriteResponseHandlerWrapper(batchHandler, mutation);
    }

    private static WriteResponseHandlerWrapper wrapViewBatchResponseHandler(Mutation mutation, ConsistencyLevel consistency_level, ConsistencyLevel batchConsistencyLevel, List<InetAddress> naturalEndpoints, AtomicLong baseComplete, WriteType writeType, BatchlogResponseHandler.BatchlogCleanup cleanup) {
        Keyspace keyspace = Keyspace.open(mutation.getKeyspaceName());
        AbstractReplicationStrategy rs = keyspace.getReplicationStrategy();
        String keyspaceName = mutation.getKeyspaceName();
        Token tk = mutation.key().getToken();
        Collection<InetAddress> pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor(tk, keyspaceName);
        AbstractWriteResponseHandler<IMutation> writeHandler = rs.getWriteResponseHandler(naturalEndpoints, pendingEndpoints, consistency_level, () -> {
            long delay = Math.max(0L, System.currentTimeMillis() - baseComplete.get());
            StorageProxy.viewWriteMetrics.viewWriteLatency.update(delay, TimeUnit.MILLISECONDS);
        }, writeType);
        ViewWriteMetricsWrapped batchHandler = new ViewWriteMetricsWrapped(writeHandler, batchConsistencyLevel.blockFor(keyspace), cleanup);
        return new WriteResponseHandlerWrapper(batchHandler, mutation);
    }

    private static BatchlogEndpoints getBatchlogEndpoints(String localDataCenter, ConsistencyLevel consistencyLevel) throws UnavailableException {
        TokenMetadata.Topology topology = StorageService.instance.getTokenMetadata().cachedOnlyTokenMap().getTopology();
        HashMultimap localEndpoints = HashMultimap.create(topology.getDatacenterRacks().get(localDataCenter));
        String localRack = DatabaseDescriptor.getEndpointSnitch().getRack(FBUtilities.getBroadcastAddress());
        Collection<InetAddress> chosenEndpoints = new BatchlogManager.EndpointFilter(localRack, (Multimap<String, InetAddress>)localEndpoints).filter();
        if (chosenEndpoints.isEmpty()) {
            if (consistencyLevel == ConsistencyLevel.ANY) {
                return new BatchlogEndpoints(Collections.singleton(FBUtilities.getBroadcastAddress()));
            }
            throw new UnavailableException(ConsistencyLevel.ONE, 1, 0);
        }
        return new BatchlogEndpoints(chosenEndpoints);
    }

    public static void sendToHintedEndpoints(Mutation mutation, Iterable<InetAddress> targets, AbstractWriteResponseHandler<IMutation> responseHandler, String localDataCenter, Stage stage) throws OverloadedException {
        HashMap dcGroups = null;
        MessageOut<Mutation> message = null;
        boolean insertLocal = false;
        ArrayList<InetAddress> endpointsToHint = null;
        for (InetAddress destination : targets) {
            StorageProxy.checkHintOverload(destination);
            if (FailureDetector.instance.isAlive(destination)) {
                ArrayList<InetAddress> messages;
                String dc;
                if (StorageProxy.canDoLocalRequest(destination)) {
                    insertLocal = true;
                    continue;
                }
                if (message == null) {
                    message = mutation.createMessage();
                }
                if (localDataCenter.equals(dc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(destination))) {
                    MessagingService.instance().sendRR(message, destination, responseHandler, true);
                    continue;
                }
                ArrayList<InetAddress> arrayList = messages = dcGroups != null ? (ArrayList<InetAddress>)dcGroups.get(dc) : null;
                if (messages == null) {
                    messages = new ArrayList<InetAddress>(3);
                    if (dcGroups == null) {
                        dcGroups = new HashMap();
                    }
                    dcGroups.put(dc, messages);
                }
                messages.add(destination);
                continue;
            }
            if (!StorageProxy.shouldHint(destination)) continue;
            if (endpointsToHint == null) {
                endpointsToHint = new ArrayList<InetAddress>(Iterables.size(targets));
            }
            endpointsToHint.add(destination);
        }
        if (endpointsToHint != null) {
            StorageProxy.submitHint(mutation, endpointsToHint, responseHandler);
        }
        if (insertLocal) {
            StorageProxy.performLocally(stage, mutation::apply, responseHandler);
        }
        if (dcGroups != null) {
            if (message == null) {
                message = mutation.createMessage();
            }
            for (Collection dcTargets : dcGroups.values()) {
                StorageProxy.sendMessagesToNonlocalDC(message, dcTargets, responseHandler);
            }
        }
    }

    private static void checkHintOverload(InetAddress destination) {
        if (StorageMetrics.totalHintsInProgress.getCount() > (long)maxHintsInProgress && StorageProxy.getHintsInProgressFor(destination).get() > 0 && StorageProxy.shouldHint(destination)) {
            throw new OverloadedException("Too many in flight hints: " + StorageMetrics.totalHintsInProgress.getCount() + " destination: " + destination + " destination hints: " + StorageProxy.getHintsInProgressFor(destination).get());
        }
    }

    private static void sendMessagesToNonlocalDC(MessageOut<? extends IMutation> message, Collection<InetAddress> targets, AbstractWriteResponseHandler<IMutation> handler) {
        Iterator<InetAddress> iter = targets.iterator();
        InetAddress target = iter.next();
        try (DataOutputBuffer out = new DataOutputBuffer();){
            out.writeInt(targets.size() - 1);
            while (iter.hasNext()) {
                InetAddress destination = iter.next();
                CompactEndpointSerializationHelper.serialize(destination, out);
                int id = MessagingService.instance().addCallback(handler, message, destination, message.getTimeout(), handler.consistencyLevel, true);
                out.writeInt(id);
                logger.trace("Adding FWD message to {}@{}", (Object)id, (Object)destination);
            }
            message = message.withParameter("FWD_TO", out.getData());
            int id = MessagingService.instance().sendRR(message, target, handler, true);
            logger.trace("Sending message to {}@{}", (Object)id, (Object)target);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void performLocally(Stage stage, final Runnable runnable) {
        StageManager.getStage(stage).maybeExecuteImmediately(new LocalMutationRunnable(){

            @Override
            public void runMayThrow() {
                try {
                    runnable.run();
                }
                catch (Exception ex) {
                    logger.error("Failed to apply mutation locally : {}", (Throwable)ex);
                }
            }

            @Override
            protected MessagingService.Verb verb() {
                return MessagingService.Verb.MUTATION;
            }
        });
    }

    private static void performLocally(Stage stage, final Runnable runnable, final IAsyncCallbackWithFailure<?> handler) {
        StageManager.getStage(stage).maybeExecuteImmediately(new LocalMutationRunnable(){

            @Override
            public void runMayThrow() {
                try {
                    runnable.run();
                    handler.response(null);
                }
                catch (Exception ex) {
                    if (!(ex instanceof WriteTimeoutException)) {
                        logger.error("Failed to apply mutation locally : {}", (Throwable)ex);
                    }
                    handler.onFailure(FBUtilities.getBroadcastAddress());
                }
            }

            @Override
            protected MessagingService.Verb verb() {
                return MessagingService.Verb.MUTATION;
            }
        });
    }

    public static AbstractWriteResponseHandler<IMutation> mutateCounter(CounterMutation cm, String localDataCenter) throws UnavailableException, OverloadedException {
        InetAddress endpoint = StorageProxy.findSuitableEndpoint(cm.getKeyspaceName(), cm.key(), localDataCenter, cm.consistency());
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return StorageProxy.applyCounterMutationOnCoordinator(cm, localDataCenter);
        }
        String keyspaceName = cm.getKeyspaceName();
        AbstractReplicationStrategy rs = Keyspace.open(keyspaceName).getReplicationStrategy();
        Token tk = cm.key().getToken();
        List<InetAddress> naturalEndpoints = StorageService.instance.getNaturalEndpoints(keyspaceName, tk);
        Collection<InetAddress> pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor(tk, keyspaceName);
        rs.getWriteResponseHandler(naturalEndpoints, pendingEndpoints, cm.consistency(), null, WriteType.COUNTER).assureSufficientLiveNodes();
        WriteResponseHandler<IMutation> responseHandler = new WriteResponseHandler<IMutation>(endpoint, WriteType.COUNTER);
        Tracing.trace("Enqueuing counter update to {}", (Object)endpoint);
        MessagingService.instance().sendRR(cm.makeMutationMessage(), endpoint, responseHandler, false);
        return responseHandler;
    }

    private static InetAddress findSuitableEndpoint(String keyspaceName, DecoratedKey key, String localDataCenter, ConsistencyLevel cl) throws UnavailableException {
        Keyspace keyspace = Keyspace.open(keyspaceName);
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        List<InetAddress> endpoints = StorageService.instance.getLiveNaturalEndpoints(keyspace, key);
        if (endpoints.isEmpty()) {
            throw new UnavailableException(cl, cl.blockFor(keyspace), 0);
        }
        ArrayList<InetAddress> localEndpoints = new ArrayList<InetAddress>();
        for (InetAddress endpoint : endpoints) {
            if (!snitch.getDatacenter(endpoint).equals(localDataCenter)) continue;
            localEndpoints.add(endpoint);
        }
        if (localEndpoints.isEmpty()) {
            snitch.sortByProximity(FBUtilities.getBroadcastAddress(), endpoints);
            return endpoints.get(0);
        }
        return (InetAddress)localEndpoints.get(ThreadLocalRandom.current().nextInt(localEndpoints.size()));
    }

    public static AbstractWriteResponseHandler<IMutation> applyCounterMutationOnLeader(CounterMutation cm, String localDataCenter, Runnable callback) throws UnavailableException, OverloadedException {
        return StorageProxy.performWrite(cm, cm.consistency(), localDataCenter, counterWritePerformer, callback, WriteType.COUNTER);
    }

    public static AbstractWriteResponseHandler<IMutation> applyCounterMutationOnCoordinator(CounterMutation cm, String localDataCenter) throws UnavailableException, OverloadedException {
        return StorageProxy.performWrite(cm, cm.consistency(), localDataCenter, counterWriteOnCoordinatorPerformer, null, WriteType.COUNTER);
    }

    private static Runnable counterWriteTask(final IMutation mutation, final Iterable<InetAddress> targets, final AbstractWriteResponseHandler<IMutation> responseHandler, final String localDataCenter) {
        return new DroppableRunnable(MessagingService.Verb.COUNTER_MUTATION){

            @Override
            public void runMayThrow() throws OverloadedException, WriteTimeoutException {
                assert (mutation instanceof CounterMutation);
                Mutation result = ((CounterMutation)mutation).apply();
                responseHandler.response(null);
                Sets.SetView remotes = Sets.difference((Set)ImmutableSet.copyOf((Iterable)targets), (Set)ImmutableSet.of((Object)FBUtilities.getBroadcastAddress()));
                if (!remotes.isEmpty()) {
                    StorageProxy.sendToHintedEndpoints(result, (Iterable<InetAddress>)remotes, responseHandler, localDataCenter, Stage.COUNTER_MUTATION);
                }
            }
        };
    }

    private static boolean systemKeyspaceQuery(List<? extends ReadCommand> cmds) {
        for (ReadCommand readCommand : cmds) {
            if (Schema.isSystemKeyspace(readCommand.metadata().ksName)) continue;
            return false;
        }
        return true;
    }

    public static RowIterator readOne(SinglePartitionReadCommand command, ConsistencyLevel consistencyLevel) throws UnavailableException, IsBootstrappingException, ReadFailureException, ReadTimeoutException, InvalidRequestException {
        return StorageProxy.readOne(command, consistencyLevel, null);
    }

    public static RowIterator readOne(SinglePartitionReadCommand command, ConsistencyLevel consistencyLevel, ClientState state) throws UnavailableException, IsBootstrappingException, ReadFailureException, ReadTimeoutException, InvalidRequestException {
        return PartitionIterators.getOnlyElement(StorageProxy.read(SinglePartitionReadCommand.Group.one(command), consistencyLevel, state), command);
    }

    public static PartitionIterator read(SinglePartitionReadCommand.Group group, ConsistencyLevel consistencyLevel) throws UnavailableException, IsBootstrappingException, ReadFailureException, ReadTimeoutException, InvalidRequestException {
        assert (!consistencyLevel.isSerialConsistency());
        return StorageProxy.read(group, consistencyLevel, null);
    }

    public static PartitionIterator read(SinglePartitionReadCommand.Group group, ConsistencyLevel consistencyLevel, ClientState state) throws UnavailableException, IsBootstrappingException, ReadFailureException, ReadTimeoutException, InvalidRequestException {
        if (StorageService.instance.isBootstrapMode() && !StorageProxy.systemKeyspaceQuery(group.commands)) {
            StorageProxy.readMetrics.unavailables.mark();
            throw new IsBootstrappingException();
        }
        return consistencyLevel.isSerialConsistency() ? StorageProxy.readWithPaxos(group, consistencyLevel, state) : StorageProxy.readRegular(group, consistencyLevel);
    }

    private static PartitionIterator readWithPaxos(SinglePartitionReadCommand.Group group, ConsistencyLevel consistencyLevel, ClientState state) throws InvalidRequestException, UnavailableException, ReadFailureException, ReadTimeoutException {
        assert (state != null);
        if (group.commands.size() > 1) {
            throw new InvalidRequestException("SERIAL/LOCAL_SERIAL consistency may only be requested for one partition at a time");
        }
        long start = System.nanoTime();
        SinglePartitionReadCommand command = group.commands.get(0);
        CFMetaData metadata = command.metadata();
        DecoratedKey key = command.partitionKey();
        PartitionIterator result = null;
        try {
            Pair<List<InetAddress>, Integer> p = StorageProxy.getPaxosParticipants(metadata, key, consistencyLevel);
            List liveEndpoints = (List)p.left;
            int requiredParticipants = (Integer)p.right;
            ConsistencyLevel consistencyForCommitOrFetch = consistencyLevel == ConsistencyLevel.LOCAL_SERIAL ? ConsistencyLevel.LOCAL_QUORUM : ConsistencyLevel.QUORUM;
            try {
                Pair<UUID, Integer> pair = StorageProxy.beginAndRepairPaxos(start, key, metadata, liveEndpoints, requiredParticipants, consistencyLevel, consistencyForCommitOrFetch, false, state);
                if ((Integer)pair.right > 0) {
                    StorageProxy.casReadMetrics.contention.update(((Integer)pair.right).intValue());
                }
            }
            catch (WriteTimeoutException e) {
                throw new ReadTimeoutException(consistencyLevel, 0, consistencyLevel.blockFor(Keyspace.open(metadata.ksName)), false);
            }
            catch (WriteFailureException e) {
                throw new ReadFailureException(consistencyLevel, e.received, e.failures, e.blockFor, false);
            }
            result = StorageProxy.fetchRows(group.commands, consistencyForCommitOrFetch);
        }
        catch (UnavailableException e) {
            StorageProxy.readMetrics.unavailables.mark();
            StorageProxy.casReadMetrics.unavailables.mark();
            throw e;
        }
        catch (ReadTimeoutException e) {
            StorageProxy.readMetrics.timeouts.mark();
            StorageProxy.casReadMetrics.timeouts.mark();
            throw e;
        }
        catch (ReadFailureException e) {
            StorageProxy.readMetrics.failures.mark();
            StorageProxy.casReadMetrics.failures.mark();
            throw e;
        }
        finally {
            long latency = System.nanoTime() - start;
            readMetrics.addNano(latency);
            casReadMetrics.addNano(latency);
            Keyspace.open((String)metadata.ksName).getColumnFamilyStore((String)metadata.cfName).metric.coordinatorReadLatency.update(latency, TimeUnit.NANOSECONDS);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PartitionIterator readRegular(SinglePartitionReadCommand.Group group, ConsistencyLevel consistencyLevel) throws UnavailableException, ReadFailureException, ReadTimeoutException {
        PartitionIterator partitionIterator;
        long start = System.nanoTime();
        try {
            PartitionIterator result = StorageProxy.fetchRows(group.commands, consistencyLevel);
            if (group.commands.size() > 1) {
                result = group.limits().filter(result, group.nowInSec());
            }
            partitionIterator = result;
        }
        catch (UnavailableException e) {
            try {
                StorageProxy.readMetrics.unavailables.mark();
                throw e;
                catch (ReadTimeoutException e2) {
                    StorageProxy.readMetrics.timeouts.mark();
                    throw e2;
                }
                catch (ReadFailureException e3) {
                    StorageProxy.readMetrics.failures.mark();
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                long latency = System.nanoTime() - start;
                readMetrics.addNano(latency);
                Iterator<SinglePartitionReadCommand> iterator = group.commands.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        throw throwable;
                    }
                    ReadCommand readCommand = iterator.next();
                    Keyspace.openAndGetStore((CFMetaData)readCommand.metadata()).metric.coordinatorReadLatency.update(latency, TimeUnit.NANOSECONDS);
                }
            }
        }
        long latency = System.nanoTime() - start;
        readMetrics.addNano(latency);
        Iterator<SinglePartitionReadCommand> iterator = group.commands.iterator();
        while (iterator.hasNext()) {
            ReadCommand readCommand = iterator.next();
            Keyspace.openAndGetStore((CFMetaData)readCommand.metadata()).metric.coordinatorReadLatency.update(latency, TimeUnit.NANOSECONDS);
        }
        return partitionIterator;
    }

    private static PartitionIterator fetchRows(List<SinglePartitionReadCommand> commands, ConsistencyLevel consistencyLevel) throws UnavailableException, ReadFailureException, ReadTimeoutException {
        int i;
        int cmdCount = commands.size();
        SinglePartitionReadLifecycle[] reads = new SinglePartitionReadLifecycle[cmdCount];
        for (i = 0; i < cmdCount; ++i) {
            reads[i] = new SinglePartitionReadLifecycle(commands.get(i), consistencyLevel);
        }
        for (i = 0; i < cmdCount; ++i) {
            reads[i].doInitialQueries();
        }
        for (i = 0; i < cmdCount; ++i) {
            reads[i].maybeTryAdditionalReplicas();
        }
        for (i = 0; i < cmdCount; ++i) {
            reads[i].awaitResultsAndRetryOnDigestMismatch();
        }
        for (i = 0; i < cmdCount; ++i) {
            if (reads[i].isDone()) continue;
            reads[i].maybeAwaitFullDataRead();
        }
        ArrayList<PartitionIterator> results = new ArrayList<PartitionIterator>(cmdCount);
        for (int i2 = 0; i2 < cmdCount; ++i2) {
            assert (reads[i2].isDone());
            results.add(reads[i2].getResult());
        }
        return PartitionIterators.concat(results);
    }

    public static List<InetAddress> getLiveSortedEndpoints(Keyspace keyspace, ByteBuffer key) {
        return StorageProxy.getLiveSortedEndpoints(keyspace, StorageService.instance.getTokenMetadata().decorateKey(key));
    }

    public static List<InetAddress> getLiveSortedEndpoints(Keyspace keyspace, RingPosition pos) {
        List<InetAddress> liveEndpoints = StorageService.instance.getLiveNaturalEndpoints(keyspace, pos);
        DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getBroadcastAddress(), liveEndpoints);
        return liveEndpoints;
    }

    private static List<InetAddress> intersection(List<InetAddress> l1, List<InetAddress> l2) {
        ArrayList<InetAddress> inter = new ArrayList<InetAddress>(l1);
        inter.retainAll(l2);
        return inter;
    }

    private static float estimateResultsPerRange(PartitionRangeReadCommand command, Keyspace keyspace) {
        ColumnFamilyStore cfs = keyspace.getColumnFamilyStore(command.metadata().cfId);
        Index index = command.getIndex(cfs);
        float maxExpectedResults = index == null ? command.limits().estimateTotalResults(cfs) : (float)index.getEstimatedResultRows();
        return maxExpectedResults / (float)DatabaseDescriptor.getNumTokens().intValue() / (float)keyspace.getReplicationStrategy().getReplicationFactor();
    }

    public static PartitionIterator getRangeSlice(PartitionRangeReadCommand command, ConsistencyLevel consistencyLevel) throws UnavailableException, ReadFailureException, ReadTimeoutException {
        Tracing.trace("Computing ranges to query");
        Keyspace keyspace = Keyspace.open(command.metadata().ksName);
        RangeIterator ranges = new RangeIterator(command, keyspace, consistencyLevel);
        float resultsPerRange = StorageProxy.estimateResultsPerRange(command, keyspace);
        resultsPerRange = (float)((double)resultsPerRange - (double)resultsPerRange * 0.1);
        int concurrencyFactor = (double)resultsPerRange == 0.0 ? 1 : Math.max(1, Math.min(ranges.rangeCount(), (int)Math.ceil((float)command.limits().count() / resultsPerRange)));
        logger.trace("Estimated result rows per range: {}; requested rows: {}, ranges.size(): {}; concurrent range requests: {}", new Object[]{Float.valueOf(resultsPerRange), command.limits().count(), ranges.rangeCount(), concurrencyFactor});
        Tracing.trace("Submitting range requests on {} ranges with a concurrency of {} ({} rows per range expected)", ranges.rangeCount(), concurrencyFactor, Float.valueOf(resultsPerRange));
        return command.limits().filter(command.postReconciliationProcessing(new RangeCommandIterator(ranges, command, concurrencyFactor, keyspace, consistencyLevel)), command.nowInSec());
    }

    @Override
    public Map<String, List<String>> getSchemaVersions() {
        return StorageProxy.describeSchemaVersions();
    }

    public static Map<String, List<String>> describeSchemaVersions() {
        String myVersion = Schema.instance.getVersion().toString();
        final ConcurrentHashMap versions = new ConcurrentHashMap();
        Set<InetAddress> liveHosts = Gossiper.instance.getLiveMembers();
        final CountDownLatch latch = new CountDownLatch(liveHosts.size());
        IAsyncCallback<UUID> cb = new IAsyncCallback<UUID>(){

            @Override
            public void response(MessageIn<UUID> message) {
                versions.put(message.from, message.payload);
                latch.countDown();
            }

            @Override
            public boolean isLatencyForSnitch() {
                return false;
            }
        };
        MessageOut message = new MessageOut(MessagingService.Verb.SCHEMA_CHECK);
        for (InetAddress endpoint : liveHosts) {
            MessagingService.instance().sendRR(message, endpoint, cb);
        }
        try {
            latch.await(DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)"This latch shouldn't have been interrupted.");
        }
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        Iterable allHosts = Iterables.concat(Gossiper.instance.getLiveMembers(), Gossiper.instance.getUnreachableMembers());
        for (InetAddress inetAddress : allHosts) {
            UUID version = (UUID)versions.get(inetAddress);
            String stringVersion = version == null ? UNREACHABLE : version.toString();
            ArrayList<String> hosts = (ArrayList<String>)results.get(stringVersion);
            if (hosts == null) {
                hosts = new ArrayList<String>();
                results.put(stringVersion, hosts);
            }
            hosts.add(inetAddress.getHostAddress());
        }
        if (results.get(UNREACHABLE) != null) {
            logger.debug("Hosts not in agreement. Didn't get a response from everybody: {}", (Object)StringUtils.join((Iterable)((Iterable)results.get(UNREACHABLE)), (String)","));
        }
        for (Map.Entry entry : results.entrySet()) {
            if (((String)entry.getKey()).equals(UNREACHABLE) || ((String)entry.getKey()).equals(myVersion)) continue;
            for (String host : (List)entry.getValue()) {
                logger.debug("{} disagrees ({})", (Object)host, entry.getKey());
            }
        }
        if (results.size() == 1) {
            logger.debug("Schemas are in agreement.");
        }
        return results;
    }

    static <T extends RingPosition<T>> List<AbstractBounds<T>> getRestrictedRanges(AbstractBounds<T> queryRange) {
        Token upperBoundToken;
        Object upperBound;
        if (queryRange instanceof Bounds && queryRange.left.equals(queryRange.right) && !queryRange.left.isMinimum()) {
            return Collections.singletonList(queryRange);
        }
        TokenMetadata tokenMetadata = StorageService.instance.getTokenMetadata();
        ArrayList<AbstractBounds<T>> ranges = new ArrayList<AbstractBounds<T>>();
        Iterator<Token> ringIter = TokenMetadata.ringIterator(tokenMetadata.sortedTokens(), queryRange.left.getToken(), true);
        AbstractBounds remainder = queryRange;
        while (ringIter.hasNext() && (remainder.left.equals(upperBound = (upperBoundToken = ringIter.next()).upperBound(queryRange.left.getClass())) || remainder.contains(upperBound))) {
            Pair<AbstractBounds<T>, AbstractBounds<T>> splits = remainder.split(upperBound);
            if (splits == null) continue;
            ranges.add((AbstractBounds<T>)splits.left);
            remainder = (AbstractBounds)splits.right;
        }
        ranges.add(remainder);
        return ranges;
    }

    @Override
    public boolean getHintedHandoffEnabled() {
        return DatabaseDescriptor.hintedHandoffEnabled();
    }

    @Override
    public void setHintedHandoffEnabled(boolean b) {
        DatabaseDescriptor.setHintedHandoffEnabled(b);
    }

    @Override
    public void enableHintsForDC(String dc) {
        DatabaseDescriptor.enableHintsForDC(dc);
    }

    @Override
    public void disableHintsForDC(String dc) {
        DatabaseDescriptor.disableHintsForDC(dc);
    }

    @Override
    public Set<String> getHintedHandoffDisabledDCs() {
        return DatabaseDescriptor.hintedHandoffDisabledDCs();
    }

    @Override
    public int getMaxHintWindow() {
        return DatabaseDescriptor.getMaxHintWindow();
    }

    @Override
    public void setMaxHintWindow(int ms) {
        DatabaseDescriptor.setMaxHintWindow(ms);
    }

    public static boolean shouldHint(InetAddress ep) {
        if (DatabaseDescriptor.hintedHandoffEnabled()) {
            boolean hintWindowExpired;
            String dc;
            Set<String> disabledDCs = DatabaseDescriptor.hintedHandoffDisabledDCs();
            if (!disabledDCs.isEmpty() && disabledDCs.contains(dc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(ep))) {
                Tracing.trace("Not hinting {} since its data center {} has been disabled {}", ep, dc, disabledDCs);
                return false;
            }
            boolean bl = hintWindowExpired = Gossiper.instance.getEndpointDowntime(ep) > (long)DatabaseDescriptor.getMaxHintWindow();
            if (hintWindowExpired) {
                HintsService.instance.metrics.incrPastWindow(ep);
                Tracing.trace("Not hinting {} which has been down {} ms", (Object)ep, (Object)Gossiper.instance.getEndpointDowntime(ep));
            }
            return !hintWindowExpired;
        }
        return false;
    }

    public static void truncateBlocking(String keyspace, String cfname) throws UnavailableException, TimeoutException, IOException {
        logger.debug("Starting a blocking truncate operation on keyspace {}, CF {}", (Object)keyspace, (Object)cfname);
        if (StorageProxy.isAnyStorageHostDown()) {
            logger.info("Cannot perform truncate, some hosts are down");
            int liveMembers = Gossiper.instance.getLiveMembers().size();
            throw new UnavailableException(ConsistencyLevel.ALL, liveMembers + Gossiper.instance.getUnreachableMembers().size(), liveMembers);
        }
        Set<InetAddress> allEndpoints = StorageService.instance.getLiveRingMembers(true);
        int blockFor = allEndpoints.size();
        TruncateResponseHandler responseHandler = new TruncateResponseHandler(blockFor);
        Tracing.trace("Enqueuing truncate messages to hosts {}", allEndpoints);
        Truncation truncation = new Truncation(keyspace, cfname);
        MessageOut<Truncation> message = truncation.createMessage();
        for (InetAddress endpoint : allEndpoints) {
            MessagingService.instance().sendRR(message, endpoint, responseHandler);
        }
        try {
            responseHandler.get();
        }
        catch (TimeoutException e) {
            Tracing.trace("Timed out");
            throw e;
        }
    }

    private static boolean isAnyStorageHostDown() {
        return !Gossiper.instance.getUnreachableTokenOwners().isEmpty();
    }

    @Override
    public long getTotalHints() {
        return StorageMetrics.totalHints.getCount();
    }

    @Override
    public int getMaxHintsInProgress() {
        return maxHintsInProgress;
    }

    @Override
    public void setMaxHintsInProgress(int qs) {
        maxHintsInProgress = qs;
    }

    @Override
    public int getHintsInProgress() {
        return (int)StorageMetrics.totalHintsInProgress.getCount();
    }

    public void verifyNoHintsInProgress() {
        if (this.getHintsInProgress() > 0) {
            logger.warn("Some hints were not written before shutdown.  This is not supposed to happen.  You should (a) run repair, and (b) file a bug report");
        }
    }

    private static AtomicInteger getHintsInProgressFor(InetAddress destination) {
        try {
            return (AtomicInteger)hintsInProgress.load((Object)destination);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Future<Void> submitHint(Mutation mutation, InetAddress target, AbstractWriteResponseHandler<IMutation> responseHandler) {
        return StorageProxy.submitHint(mutation, Collections.singleton(target), responseHandler);
    }

    public static Future<Void> submitHint(final Mutation mutation, Collection<InetAddress> targets, final AbstractWriteResponseHandler<IMutation> responseHandler) {
        HintRunnable runnable = new HintRunnable(targets){

            @Override
            public void runMayThrow() {
                HashSet<InetAddress> validTargets = new HashSet<InetAddress>(this.targets.size());
                HashSet<UUID> hostIds = new HashSet<UUID>(this.targets.size());
                for (InetAddress target : this.targets) {
                    UUID hostId = StorageService.instance.getHostIdForEndpoint(target);
                    if (hostId != null) {
                        hostIds.add(hostId);
                        validTargets.add(target);
                        continue;
                    }
                    logger.debug("Discarding hint for endpoint not part of ring: {}", (Object)target);
                }
                logger.trace("Adding hints for {}", validTargets);
                HintsService.instance.write(hostIds, Hint.create(mutation, System.currentTimeMillis()));
                validTargets.forEach(HintsService.instance.metrics::incrCreatedHints);
                if (responseHandler != null && responseHandler.consistencyLevel == ConsistencyLevel.ANY) {
                    responseHandler.response(null);
                }
            }
        };
        return StorageProxy.submitHint(runnable);
    }

    private static Future<Void> submitHint(HintRunnable runnable) {
        StorageMetrics.totalHintsInProgress.inc((long)runnable.targets.size());
        for (InetAddress target : runnable.targets) {
            StorageProxy.getHintsInProgressFor(target).incrementAndGet();
        }
        return StageManager.getStage(Stage.MUTATION).submit(runnable);
    }

    @Override
    public Long getRpcTimeout() {
        return DatabaseDescriptor.getRpcTimeout();
    }

    @Override
    public void setRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getReadRpcTimeout() {
        return DatabaseDescriptor.getReadRpcTimeout();
    }

    @Override
    public void setReadRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setReadRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getWriteRpcTimeout() {
        return DatabaseDescriptor.getWriteRpcTimeout();
    }

    @Override
    public void setWriteRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setWriteRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getCounterWriteRpcTimeout() {
        return DatabaseDescriptor.getCounterWriteRpcTimeout();
    }

    @Override
    public void setCounterWriteRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setCounterWriteRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getCasContentionTimeout() {
        return DatabaseDescriptor.getCasContentionTimeout();
    }

    @Override
    public void setCasContentionTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setCasContentionTimeout(timeoutInMillis);
    }

    @Override
    public Long getRangeRpcTimeout() {
        return DatabaseDescriptor.getRangeRpcTimeout();
    }

    @Override
    public void setRangeRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setRangeRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getTruncateRpcTimeout() {
        return DatabaseDescriptor.getTruncateRpcTimeout();
    }

    @Override
    public void setTruncateRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setTruncateRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getNativeTransportMaxConcurrentConnections() {
        return DatabaseDescriptor.getNativeTransportMaxConcurrentConnections();
    }

    @Override
    public void setNativeTransportMaxConcurrentConnections(Long nativeTransportMaxConcurrentConnections) {
        DatabaseDescriptor.setNativeTransportMaxConcurrentConnections(nativeTransportMaxConcurrentConnections);
    }

    public Long getNativeTransportMaxConcurrentConnectionsPerIp() {
        return DatabaseDescriptor.getNativeTransportMaxConcurrentConnectionsPerIp();
    }

    public void setNativeTransportMaxConcurrentConnectionsPerIp(Long nativeTransportMaxConcurrentConnections) {
        DatabaseDescriptor.setNativeTransportMaxConcurrentConnectionsPerIp(nativeTransportMaxConcurrentConnections);
    }

    @Override
    public void reloadTriggerClasses() {
        TriggerExecutor.instance.reloadClasses();
    }

    @Override
    public long getReadRepairAttempted() {
        return ReadRepairMetrics.attempted.getCount();
    }

    @Override
    public long getReadRepairRepairedBlocking() {
        return ReadRepairMetrics.repairedBlocking.getCount();
    }

    @Override
    public long getReadRepairRepairedBackground() {
        return ReadRepairMetrics.repairedBackground.getCount();
    }

    static {
        instance = new StorageProxy();
        maxHintsInProgress = 128 * FBUtilities.getAvailableProcessors();
        hintsInProgress = new CacheLoader<InetAddress, AtomicInteger>(){

            public AtomicInteger load(InetAddress inetAddress) {
                return new AtomicInteger(0);
            }
        };
        readMetrics = new ClientRequestMetrics("Read");
        rangeMetrics = new ClientRequestMetrics("RangeSlice");
        writeMetrics = new ClientRequestMetrics("Write");
        casWriteMetrics = new CASClientRequestMetrics("CASWrite");
        casReadMetrics = new CASClientRequestMetrics("CASRead");
        viewWriteMetrics = new ViewWriteMetrics("ViewWrite");
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(instance, new ObjectName(MBEAN_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HintsService.instance.registerMBean();
        HintedHandOffManager.instance.registerMBean();
        standardWritePerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Iterable<InetAddress> targets, AbstractWriteResponseHandler<IMutation> responseHandler, String localDataCenter, ConsistencyLevel consistency_level) throws OverloadedException {
                assert (mutation instanceof Mutation);
                StorageProxy.sendToHintedEndpoints((Mutation)mutation, targets, responseHandler, localDataCenter, Stage.MUTATION);
            }
        };
        counterWritePerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Iterable<InetAddress> targets, AbstractWriteResponseHandler<IMutation> responseHandler, String localDataCenter, ConsistencyLevel consistencyLevel) {
                StorageProxy.counterWriteTask(mutation, targets, responseHandler, localDataCenter).run();
            }
        };
        counterWriteOnCoordinatorPerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Iterable<InetAddress> targets, AbstractWriteResponseHandler<IMutation> responseHandler, String localDataCenter, ConsistencyLevel consistencyLevel) {
                StageManager.getStage(Stage.COUNTER_MUTATION).execute(StorageProxy.counterWriteTask(mutation, targets, responseHandler, localDataCenter));
            }
        };
    }

    private static abstract class HintRunnable
    implements Runnable {
        public final Collection<InetAddress> targets;

        protected HintRunnable(Collection<InetAddress> targets) {
            this.targets = targets;
        }

        @Override
        public void run() {
            try {
                this.runMayThrow();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                StorageMetrics.totalHintsInProgress.dec((long)this.targets.size());
                for (InetAddress target : this.targets) {
                    StorageProxy.getHintsInProgressFor(target).decrementAndGet();
                }
            }
        }

        protected abstract void runMayThrow() throws Exception;
    }

    private static abstract class LocalMutationRunnable
    implements Runnable {
        private final long constructionTime = System.currentTimeMillis();

        private LocalMutationRunnable() {
        }

        @Override
        public final void run() {
            MessagingService.Verb verb = this.verb();
            if (System.currentTimeMillis() > this.constructionTime + DatabaseDescriptor.getTimeout(verb)) {
                if (MessagingService.DROPPABLE_VERBS.contains((Object)this.verb())) {
                    MessagingService.instance().incrementDroppedMessages(verb);
                }
                HintRunnable runnable = new HintRunnable(Collections.singleton(FBUtilities.getBroadcastAddress())){

                    @Override
                    protected void runMayThrow() throws Exception {
                        this.runMayThrow();
                    }
                };
                StorageProxy.submitHint(runnable);
                return;
            }
            try {
                this.runMayThrow();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract MessagingService.Verb verb();

        protected abstract void runMayThrow() throws Exception;
    }

    private static abstract class DroppableRunnable
    implements Runnable {
        private final long constructionTime = System.nanoTime();
        private final MessagingService.Verb verb;

        public DroppableRunnable(MessagingService.Verb verb) {
            this.verb = verb;
        }

        @Override
        public final void run() {
            if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.constructionTime) > DatabaseDescriptor.getTimeout(this.verb)) {
                MessagingService.instance().incrementDroppedMessages(this.verb);
                return;
            }
            try {
                this.runMayThrow();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected MessagingService.Verb verb() {
            return this.verb;
        }

        protected abstract void runMayThrow() throws Exception;
    }

    private static class ViewWriteMetricsWrapped
    extends BatchlogResponseHandler<IMutation> {
        public ViewWriteMetricsWrapped(AbstractWriteResponseHandler<IMutation> writeHandler, int i, BatchlogResponseHandler.BatchlogCleanup cleanup) {
            super(writeHandler, i, cleanup);
            viewWriteMetrics.viewReplicasAttempted.inc((long)this.totalEndpoints());
        }

        @Override
        public void response(MessageIn<IMutation> msg) {
            super.response(msg);
            viewWriteMetrics.viewReplicasSuccess.inc();
        }
    }

    public static interface WritePerformer {
        public void apply(IMutation var1, Iterable<InetAddress> var2, AbstractWriteResponseHandler<IMutation> var3, String var4, ConsistencyLevel var5) throws OverloadedException;
    }

    private static class RangeCommandIterator
    extends AbstractIterator<RowIterator>
    implements PartitionIterator {
        private final Iterator<RangeForQuery> ranges;
        private final int totalRangeCount;
        private final PartitionRangeReadCommand command;
        private final Keyspace keyspace;
        private final ConsistencyLevel consistency;
        private final long startTime;
        private DataLimits.Counter counter;
        private PartitionIterator sentQueryIterator;
        private int concurrencyFactor;
        private int liveReturned;
        private int rangesQueried;

        public RangeCommandIterator(RangeIterator ranges, PartitionRangeReadCommand command, int concurrencyFactor, Keyspace keyspace, ConsistencyLevel consistency) {
            this.command = command;
            this.concurrencyFactor = concurrencyFactor;
            this.startTime = System.nanoTime();
            this.ranges = new RangeMerger(ranges, keyspace, consistency);
            this.totalRangeCount = ranges.rangeCount();
            this.consistency = consistency;
            this.keyspace = keyspace;
        }

        @Override
        public RowIterator computeNext() {
            while (this.sentQueryIterator == null || !this.sentQueryIterator.hasNext()) {
                if (!this.ranges.hasNext()) {
                    return (RowIterator)this.endOfData();
                }
                if (this.sentQueryIterator != null) {
                    this.liveReturned += this.counter.counted();
                    this.sentQueryIterator.close();
                    this.updateConcurrencyFactor();
                }
                this.sentQueryIterator = this.sendNextRequests();
            }
            return (RowIterator)this.sentQueryIterator.next();
        }

        private void updateConcurrencyFactor() {
            if (this.liveReturned == 0) {
                this.concurrencyFactor = this.totalRangeCount - this.rangesQueried;
                return;
            }
            int remainingRows = this.command.limits().count() - this.liveReturned;
            float rowsPerRange = (float)this.liveReturned / (float)this.rangesQueried;
            this.concurrencyFactor = Math.max(1, Math.min(this.totalRangeCount - this.rangesQueried, Math.round((float)remainingRows / rowsPerRange)));
            logger.trace("Didn't get enough response rows; actual rows per range: {}; remaining rows: {}, new concurrent requests: {}", new Object[]{Float.valueOf(rowsPerRange), remainingRows, this.concurrencyFactor});
        }

        private SingleRangeResponse query(RangeForQuery toQuery) {
            PartitionRangeReadCommand rangeCommand = this.command.forSubRange(toQuery.range);
            DataResolver resolver = new DataResolver(this.keyspace, rangeCommand, this.consistency, toQuery.filteredEndpoints.size());
            int blockFor = this.consistency.blockFor(this.keyspace);
            int minResponses = Math.min(toQuery.filteredEndpoints.size(), blockFor);
            List<InetAddress> minimalEndpoints = toQuery.filteredEndpoints.subList(0, minResponses);
            ReadCallback handler = new ReadCallback(resolver, this.consistency, rangeCommand, minimalEndpoints);
            handler.assureSufficientLiveNodes();
            if (toQuery.filteredEndpoints.size() == 1 && StorageProxy.canDoLocalRequest(toQuery.filteredEndpoints.get(0))) {
                StageManager.getStage(Stage.READ).execute(new LocalReadRunnable(rangeCommand, handler));
            } else {
                for (InetAddress endpoint : toQuery.filteredEndpoints) {
                    MessageOut<ReadCommand> message = rangeCommand.createMessage(MessagingService.instance().getVersion(endpoint));
                    Tracing.trace("Enqueuing request to {}", (Object)endpoint);
                    MessagingService.instance().sendRRWithFailure(message, endpoint, handler);
                }
            }
            return new SingleRangeResponse(handler);
        }

        private PartitionIterator sendNextRequests() {
            ArrayList<PartitionIterator> concurrentQueries = new ArrayList<PartitionIterator>(this.concurrencyFactor);
            for (int i = 0; i < this.concurrencyFactor && this.ranges.hasNext(); ++i) {
                concurrentQueries.add(this.query(this.ranges.next()));
                ++this.rangesQueried;
            }
            Tracing.trace("Submitted {} concurrent range requests", (Object)concurrentQueries.size());
            this.counter = DataLimits.NONE.newCounter(this.command.nowInSec(), true);
            return this.counter.applyTo(PartitionIterators.concat(concurrentQueries));
        }

        @Override
        public void close() {
            try {
                if (this.sentQueryIterator != null) {
                    this.sentQueryIterator.close();
                }
            }
            finally {
                long latency = System.nanoTime() - this.startTime;
                rangeMetrics.addNano(latency);
                Keyspace.openAndGetStore((CFMetaData)this.command.metadata()).metric.coordinatorScanLatency.update(latency, TimeUnit.NANOSECONDS);
            }
        }
    }

    private static class SingleRangeResponse
    extends AbstractIterator<RowIterator>
    implements PartitionIterator {
        private final ReadCallback handler;
        private PartitionIterator result;

        private SingleRangeResponse(ReadCallback handler) {
            this.handler = handler;
        }

        private void waitForResponse() throws ReadTimeoutException {
            if (this.result != null) {
                return;
            }
            try {
                this.result = this.handler.get();
            }
            catch (DigestMismatchException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected RowIterator computeNext() {
            this.waitForResponse();
            return this.result.hasNext() ? (RowIterator)this.result.next() : (RowIterator)this.endOfData();
        }

        @Override
        public void close() {
            if (this.result != null) {
                this.result.close();
            }
        }
    }

    private static class RangeMerger
    extends AbstractIterator<RangeForQuery> {
        private final Keyspace keyspace;
        private final ConsistencyLevel consistency;
        private final PeekingIterator<RangeForQuery> ranges;

        private RangeMerger(Iterator<RangeForQuery> iterator, Keyspace keyspace, ConsistencyLevel consistency) {
            this.keyspace = keyspace;
            this.consistency = consistency;
            this.ranges = Iterators.peekingIterator(iterator);
        }

        @Override
        protected RangeForQuery computeNext() {
            if (!this.ranges.hasNext()) {
                return (RangeForQuery)this.endOfData();
            }
            RangeForQuery current = (RangeForQuery)this.ranges.next();
            while (this.ranges.hasNext() && !((PartitionPosition)current.range.right).isMinimum()) {
                RangeForQuery next = (RangeForQuery)this.ranges.peek();
                List merged = StorageProxy.intersection(current.liveEndpoints, next.liveEndpoints);
                if (!this.consistency.isSufficientLiveNodes(this.keyspace, merged)) break;
                List<InetAddress> filteredMerged = this.consistency.filterForQuery(this.keyspace, merged);
                if (!DatabaseDescriptor.getEndpointSnitch().isWorthMergingForRangeQuery(filteredMerged, current.filteredEndpoints, next.filteredEndpoints)) break;
                current = new RangeForQuery(current.range.withNewRight((PartitionPosition)next.range.right), merged, filteredMerged);
                this.ranges.next();
            }
            return current;
        }
    }

    private static class RangeIterator
    extends AbstractIterator<RangeForQuery> {
        private final Keyspace keyspace;
        private final ConsistencyLevel consistency;
        private final Iterator<? extends AbstractBounds<PartitionPosition>> ranges;
        private final int rangeCount;

        public RangeIterator(PartitionRangeReadCommand command, Keyspace keyspace, ConsistencyLevel consistency) {
            this.keyspace = keyspace;
            this.consistency = consistency;
            List<AbstractBounds<PartitionPosition>> l = keyspace.getReplicationStrategy() instanceof LocalStrategy ? command.dataRange().keyRange().unwrap() : StorageProxy.getRestrictedRanges(command.dataRange().keyRange());
            this.ranges = l.iterator();
            this.rangeCount = l.size();
        }

        public int rangeCount() {
            return this.rangeCount;
        }

        @Override
        protected RangeForQuery computeNext() {
            if (!this.ranges.hasNext()) {
                return (RangeForQuery)this.endOfData();
            }
            AbstractBounds<PartitionPosition> range = this.ranges.next();
            List<InetAddress> liveEndpoints = StorageProxy.getLiveSortedEndpoints(this.keyspace, range.right);
            return new RangeForQuery(range, liveEndpoints, this.consistency.filterForQuery(this.keyspace, liveEndpoints));
        }
    }

    private static class RangeForQuery {
        public final AbstractBounds<PartitionPosition> range;
        public final List<InetAddress> liveEndpoints;
        public final List<InetAddress> filteredEndpoints;

        public RangeForQuery(AbstractBounds<PartitionPosition> range, List<InetAddress> liveEndpoints, List<InetAddress> filteredEndpoints) {
            this.range = range;
            this.liveEndpoints = liveEndpoints;
            this.filteredEndpoints = filteredEndpoints;
        }
    }

    static class LocalReadRunnable
    extends DroppableRunnable {
        private final ReadCommand command;
        private final ReadCallback handler;
        private final long start = System.nanoTime();

        LocalReadRunnable(ReadCommand command, ReadCallback handler) {
            super(MessagingService.Verb.READ);
            this.command = command;
            this.handler = handler;
        }

        @Override
        protected void runMayThrow() {
            try {
                try (ReadOrderGroup orderGroup = this.command.startOrderGroup();
                     UnfilteredPartitionIterator iterator = this.command.executeLocally(orderGroup);){
                    this.handler.response(this.command.createResponse(iterator));
                }
                MessagingService.instance().addLatency(FBUtilities.getBroadcastAddress(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.start));
            }
            catch (Throwable t) {
                this.handler.onFailure(FBUtilities.getBroadcastAddress());
                if (t instanceof TombstoneOverwhelmingException) {
                    logger.error(t.getMessage());
                }
                throw t;
            }
        }
    }

    private static class SinglePartitionReadLifecycle {
        private final SinglePartitionReadCommand command;
        private final AbstractReadExecutor executor;
        private final ConsistencyLevel consistency;
        private PartitionIterator result;
        private ReadCallback repairHandler;

        SinglePartitionReadLifecycle(SinglePartitionReadCommand command, ConsistencyLevel consistency) {
            this.command = command;
            this.executor = AbstractReadExecutor.getReadExecutor(command, consistency);
            this.consistency = consistency;
        }

        boolean isDone() {
            return this.result != null;
        }

        void doInitialQueries() {
            this.executor.executeAsync();
        }

        void maybeTryAdditionalReplicas() {
            this.executor.maybeTryAdditionalReplicas();
        }

        void awaitResultsAndRetryOnDigestMismatch() throws ReadFailureException, ReadTimeoutException {
            try {
                this.result = this.executor.get();
            }
            catch (DigestMismatchException ex) {
                Tracing.trace("Digest mismatch: {}", (Object)ex);
                ReadRepairMetrics.repairedBlocking.mark();
                Keyspace keyspace = Keyspace.open(this.command.metadata().ksName);
                DataResolver resolver = new DataResolver(keyspace, this.command, ConsistencyLevel.ALL, this.executor.handler.endpoints.size());
                this.repairHandler = new ReadCallback(resolver, ConsistencyLevel.ALL, this.executor.getContactedReplicas().size(), this.command, keyspace, this.executor.handler.endpoints);
                for (InetAddress endpoint : this.executor.getContactedReplicas()) {
                    MessageOut<ReadCommand> message = this.command.createMessage(MessagingService.instance().getVersion(endpoint));
                    Tracing.trace("Enqueuing full data read to {}", (Object)endpoint);
                    MessagingService.instance().sendRRWithFailure(message, endpoint, this.repairHandler);
                }
            }
        }

        void maybeAwaitFullDataRead() throws ReadTimeoutException {
            if (this.repairHandler == null) {
                return;
            }
            try {
                this.result = this.repairHandler.get();
            }
            catch (DigestMismatchException e) {
                throw new AssertionError((Object)e);
            }
            catch (ReadTimeoutException e) {
                if (Tracing.isTracing()) {
                    Tracing.trace("Timed out waiting on digest mismatch repair requests");
                } else {
                    logger.trace("Timed out waiting on digest mismatch repair requests");
                }
                int blockFor = this.consistency.blockFor(Keyspace.open(this.command.metadata().ksName));
                throw new ReadTimeoutException(this.consistency, blockFor - 1, blockFor, true);
            }
        }

        PartitionIterator getResult() {
            assert (this.result != null);
            return this.result;
        }
    }

    private static final class BatchlogEndpoints {
        public final Collection<InetAddress> all;
        public final Collection<InetAddress> current;
        public final Collection<InetAddress> legacy;

        BatchlogEndpoints(Collection<InetAddress> endpoints) {
            this.all = endpoints;
            this.current = new ArrayList<InetAddress>(2);
            this.legacy = new ArrayList<InetAddress>(2);
            for (InetAddress ep : endpoints) {
                if (MessagingService.instance().getVersion(ep) >= 10) {
                    this.current.add(ep);
                    continue;
                }
                this.legacy.add(ep);
            }
        }
    }

    private static class WriteResponseHandlerWrapper {
        final BatchlogResponseHandler<IMutation> handler;
        final Mutation mutation;

        WriteResponseHandlerWrapper(BatchlogResponseHandler<IMutation> handler, Mutation mutation) {
            this.handler = handler;
            this.mutation = mutation;
        }
    }
}

