/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.ReadRepairDecision;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.CreateTableStatement;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CompactTables;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.Serializers;
import org.apache.cassandra.db.UnknownColumnFamilyException;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.CachingParams;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Indexes;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.SpeculativeRetryParam;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.schema.Triggers;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.UUIDSerializer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.github.jamm.Unmetered;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Unmetered
public final class CFMetaData {
    private static final Logger logger = LoggerFactory.getLogger(CFMetaData.class);
    public static final Serializer serializer = new Serializer();
    public final UUID cfId;
    public final String ksName;
    public final String cfName;
    public final Pair<String, String> ksAndCFName;
    public final byte[] ksAndCFBytes;
    private final ImmutableSet<Flag> flags;
    private final boolean isDense;
    private final boolean isCompound;
    private final boolean isSuper;
    private final boolean isCounter;
    private final boolean isView;
    private final boolean isIndex;
    public volatile ClusteringComparator comparator;
    public final IPartitioner partitioner;
    private final Serializers serializers;
    public volatile TableParams params = TableParams.DEFAULT;
    private volatile AbstractType<?> keyValidator = BytesType.instance;
    private volatile Map<ByteBuffer, DroppedColumn> droppedColumns = new HashMap<ByteBuffer, DroppedColumn>();
    private volatile Triggers triggers = Triggers.none();
    private volatile Indexes indexes = Indexes.none();
    private final Map<ByteBuffer, ColumnDefinition> columnMetadata = new ConcurrentHashMap<ByteBuffer, ColumnDefinition>();
    private volatile List<ColumnDefinition> partitionKeyColumns;
    private volatile List<ColumnDefinition> clusteringColumns;
    private volatile PartitionColumns partitionColumns;
    private volatile ColumnDefinition compactValueColumn;

    public CFMetaData params(TableParams params) {
        this.params = params;
        return this;
    }

    public CFMetaData bloomFilterFpChance(double prop) {
        this.params = TableParams.builder(this.params).bloomFilterFpChance(prop).build();
        return this;
    }

    public CFMetaData caching(CachingParams prop) {
        this.params = TableParams.builder(this.params).caching(prop).build();
        return this;
    }

    public CFMetaData comment(String prop) {
        this.params = TableParams.builder(this.params).comment(prop).build();
        return this;
    }

    public CFMetaData compaction(CompactionParams prop) {
        this.params = TableParams.builder(this.params).compaction(prop).build();
        return this;
    }

    public CFMetaData compression(CompressionParams prop) {
        this.params = TableParams.builder(this.params).compression(prop).build();
        return this;
    }

    public CFMetaData dcLocalReadRepairChance(double prop) {
        this.params = TableParams.builder(this.params).dcLocalReadRepairChance(prop).build();
        return this;
    }

    public CFMetaData defaultTimeToLive(int prop) {
        this.params = TableParams.builder(this.params).defaultTimeToLive(prop).build();
        return this;
    }

    public CFMetaData gcGraceSeconds(int prop) {
        this.params = TableParams.builder(this.params).gcGraceSeconds(prop).build();
        return this;
    }

    public CFMetaData maxIndexInterval(int prop) {
        this.params = TableParams.builder(this.params).maxIndexInterval(prop).build();
        return this;
    }

    public CFMetaData memtableFlushPeriod(int prop) {
        this.params = TableParams.builder(this.params).memtableFlushPeriodInMs(prop).build();
        return this;
    }

    public CFMetaData minIndexInterval(int prop) {
        this.params = TableParams.builder(this.params).minIndexInterval(prop).build();
        return this;
    }

    public CFMetaData readRepairChance(double prop) {
        this.params = TableParams.builder(this.params).readRepairChance(prop).build();
        return this;
    }

    public CFMetaData crcCheckChance(double prop) {
        this.params = TableParams.builder(this.params).crcCheckChance(prop).build();
        return this;
    }

    public CFMetaData speculativeRetry(SpeculativeRetryParam prop) {
        this.params = TableParams.builder(this.params).speculativeRetry(prop).build();
        return this;
    }

    public CFMetaData extensions(Map<String, ByteBuffer> extensions) {
        this.params = TableParams.builder(this.params).extensions(extensions).build();
        return this;
    }

    public CFMetaData droppedColumns(Map<ByteBuffer, DroppedColumn> cols) {
        this.droppedColumns = cols;
        return this;
    }

    public CFMetaData triggers(Triggers prop) {
        this.triggers = prop;
        return this;
    }

    public CFMetaData indexes(Indexes indexes) {
        this.indexes = indexes;
        return this;
    }

    private CFMetaData(String keyspace, String name, UUID cfId, boolean isSuper, boolean isCounter, boolean isDense, boolean isCompound, boolean isView, List<ColumnDefinition> partitionKeyColumns, List<ColumnDefinition> clusteringColumns, PartitionColumns partitionColumns, IPartitioner partitioner) {
        this.cfId = cfId;
        this.ksName = keyspace;
        this.cfName = name;
        this.ksAndCFName = Pair.create(keyspace, name);
        byte[] ksBytes = FBUtilities.toWriteUTFBytes(this.ksName);
        byte[] cfBytes = FBUtilities.toWriteUTFBytes(this.cfName);
        this.ksAndCFBytes = Arrays.copyOf(ksBytes, ksBytes.length + cfBytes.length);
        System.arraycopy(cfBytes, 0, this.ksAndCFBytes, ksBytes.length, cfBytes.length);
        this.isDense = isDense;
        this.isCompound = isCompound;
        this.isSuper = isSuper;
        this.isCounter = isCounter;
        this.isView = isView;
        EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
        if (isSuper) {
            flags.add(Flag.SUPER);
        }
        if (isCounter) {
            flags.add(Flag.COUNTER);
        }
        if (isDense) {
            flags.add(Flag.DENSE);
        }
        if (isCompound) {
            flags.add(Flag.COMPOUND);
        }
        this.flags = Sets.immutableEnumSet(flags);
        this.isIndex = this.cfName.contains(".");
        assert (partitioner != null) : "This assertion failure is probably due to accessing Schema.instance from client-mode tools - See CASSANDRA-8143.";
        this.partitioner = partitioner;
        assert (this.isCQLTable() || !clusteringColumns.isEmpty()) : String.format("For table %s.%s, isDense=%b, isCompound=%b, clustering=%s", this.ksName, this.cfName, isDense, isCompound, clusteringColumns);
        this.partitionKeyColumns = partitionKeyColumns;
        this.clusteringColumns = clusteringColumns;
        this.partitionColumns = partitionColumns;
        this.serializers = new Serializers(this);
        this.rebuild();
    }

    private void rebuild() {
        this.comparator = new ClusteringComparator(CFMetaData.extractTypes(this.clusteringColumns));
        this.columnMetadata.clear();
        for (ColumnDefinition def : this.partitionKeyColumns) {
            this.columnMetadata.put(def.name.bytes, def);
        }
        for (ColumnDefinition def : this.clusteringColumns) {
            this.columnMetadata.put(def.name.bytes, def);
            def.type.checkComparable();
        }
        for (ColumnDefinition def : this.partitionColumns) {
            this.columnMetadata.put(def.name.bytes, def);
        }
        List<AbstractType<?>> keyTypes = CFMetaData.extractTypes(this.partitionKeyColumns);
        AbstractType abstractType = this.keyValidator = keyTypes.size() == 1 ? keyTypes.get(0) : CompositeType.getInstance(keyTypes);
        if (this.isCompactTable()) {
            this.compactValueColumn = CompactTables.getCompactValueColumn(this.partitionColumns, this.isSuper());
        }
    }

    public Indexes getIndexes() {
        return this.indexes;
    }

    public static CFMetaData create(String ksName, String name, UUID cfId, boolean isDense, boolean isCompound, boolean isSuper, boolean isCounter, boolean isView, List<ColumnDefinition> columns, IPartitioner partitioner) {
        ArrayList<ColumnDefinition> partitions = new ArrayList<ColumnDefinition>();
        ArrayList<ColumnDefinition> clusterings = new ArrayList<ColumnDefinition>();
        PartitionColumns.Builder builder = PartitionColumns.builder();
        block4: for (ColumnDefinition column : columns) {
            switch (column.kind) {
                case PARTITION_KEY: {
                    partitions.add(column);
                    continue block4;
                }
                case CLUSTERING: {
                    clusterings.add(column);
                    continue block4;
                }
            }
            builder.add(column);
        }
        Collections.sort(partitions);
        Collections.sort(clusterings);
        return new CFMetaData(ksName, name, cfId, isSuper, isCounter, isDense, isCompound, isView, partitions, clusterings, builder.build(), partitioner);
    }

    private static List<AbstractType<?>> extractTypes(List<ColumnDefinition> clusteringColumns) {
        ArrayList types = new ArrayList(clusteringColumns.size());
        for (ColumnDefinition def : clusteringColumns) {
            types.add(def.type);
        }
        return types;
    }

    public Set<Flag> flags() {
        return this.flags;
    }

    public static CFMetaData createFake(String keyspace, String name) {
        return Builder.create(keyspace, name).addPartitionKey("key", (AbstractType)BytesType.instance).build();
    }

    public Triggers getTriggers() {
        return this.triggers;
    }

    public static CFMetaData compile(String cql, String keyspace) {
        CFStatement parsed = (CFStatement)QueryProcessor.parseStatement(cql);
        parsed.prepareKeyspace(keyspace);
        CreateTableStatement statement = (CreateTableStatement)((CreateTableStatement.RawStatement)parsed).prepare((Types)Types.none()).statement;
        return statement.metadataBuilder().withId(CFMetaData.generateLegacyCfId(keyspace, statement.columnFamily())).build().params(statement.params()).readRepairChance(0.0).dcLocalReadRepairChance(0.0).gcGraceSeconds(0).memtableFlushPeriod((int)TimeUnit.HOURS.toMillis(1L));
    }

    public static UUID generateLegacyCfId(String ksName, String cfName) {
        return UUID.nameUUIDFromBytes(ArrayUtils.addAll((byte[])ksName.getBytes(), (byte[])cfName.getBytes()));
    }

    public CFMetaData reloadIndexMetadataProperties(CFMetaData parent) {
        TableParams.Builder indexParams = TableParams.builder(parent.params);
        if (parent.params.caching.cacheKeys()) {
            indexParams.caching(CachingParams.CACHE_KEYS);
        } else {
            indexParams.caching(CachingParams.CACHE_NOTHING);
        }
        indexParams.readRepairChance(0.0).dcLocalReadRepairChance(0.0).gcGraceSeconds(0);
        return this.params(indexParams.build());
    }

    public CFMetaData copy() {
        return this.copy(this.cfId);
    }

    public CFMetaData copy(UUID newCfId) {
        return CFMetaData.copyOpts(new CFMetaData(this.ksName, this.cfName, newCfId, this.isSuper(), this.isCounter(), this.isDense(), this.isCompound(), this.isView(), CFMetaData.copy(this.partitionKeyColumns), CFMetaData.copy(this.clusteringColumns), CFMetaData.copy(this.partitionColumns), this.partitioner), this);
    }

    public CFMetaData copy(IPartitioner partitioner) {
        return CFMetaData.copyOpts(new CFMetaData(this.ksName, this.cfName, this.cfId, this.isSuper, this.isCounter, this.isDense, this.isCompound, this.isView, CFMetaData.copy(this.partitionKeyColumns), CFMetaData.copy(this.clusteringColumns), CFMetaData.copy(this.partitionColumns), partitioner), this);
    }

    private static List<ColumnDefinition> copy(List<ColumnDefinition> l) {
        ArrayList<ColumnDefinition> copied = new ArrayList<ColumnDefinition>(l.size());
        for (ColumnDefinition cd : l) {
            copied.add(cd.copy());
        }
        return copied;
    }

    private static PartitionColumns copy(PartitionColumns columns) {
        PartitionColumns.Builder newColumns = PartitionColumns.builder();
        for (ColumnDefinition cd : columns) {
            newColumns.add(cd.copy());
        }
        return newColumns.build();
    }

    @VisibleForTesting
    public static CFMetaData copyOpts(CFMetaData newCFMD, CFMetaData oldCFMD) {
        return newCFMD.params(oldCFMD.params).droppedColumns(new HashMap<ByteBuffer, DroppedColumn>(oldCFMD.droppedColumns)).triggers(oldCFMD.triggers).indexes(oldCFMD.indexes);
    }

    public String indexColumnFamilyName(IndexMetadata info) {
        return this.cfName + "." + info.name;
    }

    public boolean isIndex() {
        return this.isIndex;
    }

    public DecoratedKey decorateKey(ByteBuffer key) {
        return this.partitioner.decorateKey(key);
    }

    public Map<ByteBuffer, ColumnDefinition> getColumnMetadata() {
        return this.columnMetadata;
    }

    public String getParentColumnFamilyName() {
        return this.isIndex ? this.cfName.substring(0, this.cfName.indexOf(46)) : null;
    }

    public ReadRepairDecision newReadRepairDecision() {
        double chance = ThreadLocalRandom.current().nextDouble();
        if (this.params.readRepairChance > chance) {
            return ReadRepairDecision.GLOBAL;
        }
        if (this.params.dcLocalReadRepairChance > chance) {
            return ReadRepairDecision.DC_LOCAL;
        }
        return ReadRepairDecision.NONE;
    }

    public AbstractType<?> getColumnDefinitionNameComparator(ColumnDefinition.Kind kind) {
        return this.isSuper() && kind == ColumnDefinition.Kind.REGULAR || this.isStaticCompactTable() && kind == ColumnDefinition.Kind.STATIC ? this.thriftColumnNameType() : UTF8Type.instance;
    }

    public AbstractType<?> getKeyValidator() {
        return this.keyValidator;
    }

    public Collection<ColumnDefinition> allColumns() {
        return this.columnMetadata.values();
    }

    public Iterator<ColumnDefinition> allColumnsInSelectOrder() {
        final boolean isStaticCompactTable = this.isStaticCompactTable();
        final boolean noNonPkColumns = this.isCompactTable() && CompactTables.hasEmptyCompactValue(this);
        return new AbstractIterator<ColumnDefinition>(){
            private final Iterator<ColumnDefinition> partitionKeyIter;
            private final Iterator<ColumnDefinition> clusteringIter;
            private final Iterator<ColumnDefinition> otherColumns;
            {
                this.partitionKeyIter = CFMetaData.this.partitionKeyColumns.iterator();
                Iterator<Object> iterator = this.clusteringIter = isStaticCompactTable ? Collections.emptyIterator() : CFMetaData.this.clusteringColumns.iterator();
                this.otherColumns = noNonPkColumns ? Collections.emptyIterator() : (isStaticCompactTable ? ((CFMetaData)CFMetaData.this).partitionColumns.statics.selectOrderIterator() : CFMetaData.this.partitionColumns.selectOrderIterator());
            }

            @Override
            protected ColumnDefinition computeNext() {
                if (this.partitionKeyIter.hasNext()) {
                    return this.partitionKeyIter.next();
                }
                if (this.clusteringIter.hasNext()) {
                    return this.clusteringIter.next();
                }
                return this.otherColumns.hasNext() ? this.otherColumns.next() : (ColumnDefinition)this.endOfData();
            }
        };
    }

    public Iterable<ColumnDefinition> primaryKeyColumns() {
        return Iterables.concat(this.partitionKeyColumns, this.clusteringColumns);
    }

    public List<ColumnDefinition> partitionKeyColumns() {
        return this.partitionKeyColumns;
    }

    public List<ColumnDefinition> clusteringColumns() {
        return this.clusteringColumns;
    }

    public PartitionColumns partitionColumns() {
        return this.partitionColumns;
    }

    public ColumnDefinition compactValueColumn() {
        return this.compactValueColumn;
    }

    public ClusteringComparator getKeyValidatorAsClusteringComparator() {
        boolean isCompound = this.keyValidator instanceof CompositeType;
        List<AbstractType<?>> types = isCompound ? ((CompositeType)this.keyValidator).types : Collections.singletonList(this.keyValidator);
        return new ClusteringComparator(types);
    }

    public static ByteBuffer serializePartitionKey(ClusteringPrefix keyAsClustering) {
        if (keyAsClustering.size() == 1) {
            return keyAsClustering.get(0);
        }
        ByteBuffer[] values = new ByteBuffer[keyAsClustering.size()];
        for (int i = 0; i < keyAsClustering.size(); ++i) {
            values[i] = keyAsClustering.get(i);
        }
        return CompositeType.build(values);
    }

    public Map<ByteBuffer, DroppedColumn> getDroppedColumns() {
        return this.droppedColumns;
    }

    public ColumnDefinition getDroppedColumnDefinition(ByteBuffer name) {
        DroppedColumn dropped = this.droppedColumns.get(name);
        if (dropped == null) {
            return null;
        }
        AbstractType type = dropped.type == null ? BytesType.instance : dropped.type;
        return ColumnDefinition.regularDef(this, name, type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CFMetaData)) {
            return false;
        }
        CFMetaData other = (CFMetaData)o;
        return Objects.equal((Object)this.cfId, (Object)other.cfId) && Objects.equal(this.flags, other.flags) && Objects.equal((Object)this.ksName, (Object)other.ksName) && Objects.equal((Object)this.cfName, (Object)other.cfName) && Objects.equal((Object)this.params, (Object)other.params) && Objects.equal((Object)this.comparator, (Object)other.comparator) && Objects.equal(this.keyValidator, other.keyValidator) && Objects.equal(this.columnMetadata, other.columnMetadata) && Objects.equal(this.droppedColumns, other.droppedColumns) && Objects.equal((Object)this.triggers, (Object)other.triggers) && Objects.equal((Object)this.indexes, (Object)other.indexes);
    }

    public int hashCode() {
        return new HashCodeBuilder(29, 1597).append((Object)this.cfId).append((Object)this.ksName).append((Object)this.cfName).append(this.flags).append((Object)this.comparator).append((Object)this.params).append(this.keyValidator).append(this.columnMetadata).append(this.droppedColumns).append((Object)this.triggers).append((Object)this.indexes).toHashCode();
    }

    @VisibleForTesting
    public boolean apply(CFMetaData cfm) throws ConfigurationException {
        logger.debug("applying {} to {}", (Object)cfm, (Object)this);
        this.validateCompatibility(cfm);
        this.partitionKeyColumns = cfm.partitionKeyColumns;
        this.clusteringColumns = cfm.clusteringColumns;
        boolean changeAffectsStatements = !this.partitionColumns.equals(cfm.partitionColumns);
        this.partitionColumns = cfm.partitionColumns;
        this.rebuild();
        this.params = cfm.params;
        this.keyValidator = cfm.keyValidator;
        if (!cfm.droppedColumns.isEmpty()) {
            this.droppedColumns = cfm.droppedColumns;
        }
        this.triggers = cfm.triggers;
        boolean bl = !this.indexes.equals(cfm.indexes);
        this.indexes = cfm.indexes;
        logger.debug("application result is {}", (Object)this);
        return changeAffectsStatements |= bl;
    }

    public void validateCompatibility(CFMetaData cfm) throws ConfigurationException {
        if (!cfm.ksName.equals(this.ksName)) {
            throw new ConfigurationException(String.format("Keyspace mismatch (found %s; expected %s)", cfm.ksName, this.ksName));
        }
        if (!cfm.cfName.equals(this.cfName)) {
            throw new ConfigurationException(String.format("Column family mismatch (found %s; expected %s)", cfm.cfName, this.cfName));
        }
        if (!cfm.cfId.equals(this.cfId)) {
            throw new ConfigurationException(String.format("Column family ID mismatch (found %s; expected %s)", cfm.cfId, this.cfId));
        }
        if (!cfm.flags.equals(this.flags)) {
            throw new ConfigurationException("types do not match.");
        }
        if (!cfm.comparator.isCompatibleWith(this.comparator)) {
            throw new ConfigurationException(String.format("Column family comparators do not match or are not compatible (found %s; expected %s).", cfm.comparator.toString(), this.comparator.toString()));
        }
    }

    public static Class<? extends AbstractCompactionStrategy> createCompactionStrategy(String className) throws ConfigurationException {
        Class strategyClass = FBUtilities.classForName(className = className.contains(".") ? className : "org.apache.cassandra.db.compaction." + className, "compaction strategy");
        if (!AbstractCompactionStrategy.class.isAssignableFrom(strategyClass)) {
            throw new ConfigurationException(String.format("Specified compaction strategy class (%s) is not derived from AbstractReplicationStrategy", className));
        }
        return strategyClass;
    }

    public static AbstractCompactionStrategy createCompactionStrategyInstance(ColumnFamilyStore cfs, CompactionParams compactionParams) {
        try {
            Constructor<? extends AbstractCompactionStrategy> constructor = compactionParams.klass().getConstructor(ColumnFamilyStore.class, Map.class);
            return constructor.newInstance(cfs, compactionParams.options());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public ColumnDefinition getColumnDefinition(ColumnIdentifier name) {
        return this.columnMetadata.get(name.bytes);
    }

    public ColumnDefinition getColumnDefinition(ByteBuffer name) {
        return this.columnMetadata.get(name);
    }

    public static boolean isNameValid(String name) {
        return name != null && !name.isEmpty() && name.length() <= 48 && name.matches("\\w+");
    }

    public CFMetaData validate() throws ConfigurationException {
        this.rebuild();
        if (!CFMetaData.isNameValid(this.ksName)) {
            throw new ConfigurationException(String.format("Keyspace name must not be empty, more than %s characters long, or contain non-alphanumeric-underscore characters (got \"%s\")", 48, this.ksName));
        }
        if (!CFMetaData.isNameValid(this.cfName)) {
            throw new ConfigurationException(String.format("ColumnFamily name must not be empty, more than %s characters long, or contain non-alphanumeric-underscore characters (got \"%s\")", 48, this.cfName));
        }
        this.params.validate();
        for (int i = 0; i < this.comparator.size(); ++i) {
            if (!(this.comparator.subtype(i) instanceof CounterColumnType)) continue;
            throw new ConfigurationException("CounterColumnType is not a valid comparator");
        }
        if (this.keyValidator instanceof CounterColumnType) {
            throw new ConfigurationException("CounterColumnType is not a valid key validator");
        }
        if (this.isCounter()) {
            for (ColumnDefinition def : this.partitionColumns()) {
                if (def.type instanceof CounterColumnType || CompactTables.isSuperColumnMapColumn(def)) continue;
                throw new ConfigurationException("Cannot add a non counter column (" + def.name + ") in a counter column family");
            }
        } else {
            for (ColumnDefinition def : this.allColumns()) {
                if (!(def.type instanceof CounterColumnType)) continue;
                throw new ConfigurationException("Cannot add a counter column (" + def.name + ") in a non counter column family");
            }
        }
        if (!this.indexes.isEmpty() && this.isSuper()) {
            throw new ConfigurationException("Secondary indexes are not supported on super column families");
        }
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.ksName);
        Set<Object> indexNames = ksm == null ? new HashSet() : ksm.existingIndexNames(this.cfName);
        for (IndexMetadata index : this.indexes) {
            if (indexNames.contains(index.name)) {
                throw new ConfigurationException("Duplicate index name " + index.name);
            }
            indexNames.add(index.name);
            index.validate(this);
        }
        return this;
    }

    public AbstractType<?> thriftColumnNameType() {
        if (this.isSuper()) {
            ColumnDefinition def = this.compactValueColumn();
            assert (def != null && def.type instanceof MapType);
            return ((MapType)def.type).nameComparator();
        }
        assert (this.isStaticCompactTable());
        return this.clusteringColumns.get((int)0).type;
    }

    public CFMetaData addColumnDefinition(ColumnDefinition def) throws ConfigurationException {
        if (this.columnMetadata.containsKey(def.name.bytes)) {
            throw new ConfigurationException(String.format("Cannot add column %s, a column with the same name already exists", def.name));
        }
        return this.addOrReplaceColumnDefinition(def);
    }

    public CFMetaData addOrReplaceColumnDefinition(ColumnDefinition def) {
        switch (def.kind) {
            case PARTITION_KEY: {
                this.partitionKeyColumns.set(def.position(), def);
                List<AbstractType<?>> keyTypes = CFMetaData.extractTypes(this.partitionKeyColumns);
                this.keyValidator = keyTypes.size() == 1 ? keyTypes.get(0) : CompositeType.getInstance(keyTypes);
                break;
            }
            case CLUSTERING: {
                this.clusteringColumns.set(def.position(), def);
                this.comparator = new ClusteringComparator(CFMetaData.extractTypes(this.clusteringColumns));
                break;
            }
            case REGULAR: 
            case STATIC: {
                PartitionColumns.Builder builder = PartitionColumns.builder();
                for (ColumnDefinition column : this.partitionColumns) {
                    if (column.name.equals(def.name)) continue;
                    builder.add(column);
                }
                builder.add(def);
                this.partitionColumns = builder.build();
                if (!this.isDense()) break;
                this.compactValueColumn = def;
            }
        }
        this.columnMetadata.put(def.name.bytes, def);
        return this;
    }

    public boolean removeColumnDefinition(ColumnDefinition def) {
        boolean removed;
        assert (!def.isPartitionKey());
        boolean bl = removed = this.columnMetadata.remove(def.name.bytes) != null;
        if (removed) {
            this.partitionColumns = this.partitionColumns.without(def);
        }
        return removed;
    }

    public void recordColumnDrop(ColumnDefinition def) {
        this.droppedColumns.put(def.name.bytes, new DroppedColumn(def.name.toString(), def.type, FBUtilities.timestampMicros()));
    }

    public void renameColumn(ColumnIdentifier from, ColumnIdentifier to) throws InvalidRequestException {
        ColumnDefinition def = this.getColumnDefinition(from);
        if (def == null) {
            throw new InvalidRequestException(String.format("Cannot rename unknown column %s in keyspace %s", from, this.cfName));
        }
        if (this.getColumnDefinition(to) != null) {
            throw new InvalidRequestException(String.format("Cannot rename column %s to %s in keyspace %s; another column of that name already exist", from, to, this.cfName));
        }
        if (def.isPartOfCellName(this.isCQLTable(), this.isSuper())) {
            throw new InvalidRequestException(String.format("Cannot rename non PRIMARY KEY part %s", from));
        }
        if (!this.getIndexes().isEmpty()) {
            ColumnFamilyStore store = Keyspace.openAndGetStore(this);
            Set<IndexMetadata> dependentIndexes = store.indexManager.getDependentIndexes(def);
            if (!dependentIndexes.isEmpty()) {
                throw new InvalidRequestException(String.format("Cannot rename column %s because it has dependent secondary indexes (%s)", from, dependentIndexes.stream().map(i -> i.name).collect(Collectors.joining(","))));
            }
        }
        ColumnDefinition newDef = def.withNewName(to);
        this.addOrReplaceColumnDefinition(newDef);
        if (def.isPartitionKey()) {
            this.columnMetadata.remove(def.name.bytes);
        } else {
            this.removeColumnDefinition(def);
        }
    }

    public boolean isCQLTable() {
        return !this.isSuper() && !this.isDense() && this.isCompound();
    }

    public boolean isCompactTable() {
        return !this.isCQLTable();
    }

    public boolean isStaticCompactTable() {
        return !this.isSuper() && !this.isDense() && !this.isCompound();
    }

    public boolean isThriftCompatible() {
        return this.isCompactTable();
    }

    public boolean hasStaticColumns() {
        return !this.partitionColumns.statics.isEmpty();
    }

    public boolean hasCollectionColumns() {
        for (ColumnDefinition def : this.partitionColumns()) {
            if (!(def.type instanceof CollectionType) || !def.type.isMultiCell()) continue;
            return true;
        }
        return false;
    }

    public boolean hasComplexColumns() {
        for (ColumnDefinition def : this.partitionColumns()) {
            if (!def.isComplex()) continue;
            return true;
        }
        return false;
    }

    public boolean hasDroppedCollectionColumns() {
        for (DroppedColumn def : this.getDroppedColumns().values()) {
            if (!(def.type instanceof CollectionType) || !def.type.isMultiCell()) continue;
            return true;
        }
        return false;
    }

    public boolean isSuper() {
        return this.isSuper;
    }

    public boolean isCounter() {
        return this.isCounter;
    }

    public boolean isDense() {
        return this.isDense;
    }

    public boolean isCompound() {
        return this.isCompound;
    }

    public boolean isView() {
        return this.isView;
    }

    public Serializers serializers() {
        return this.serializers;
    }

    public AbstractType<?> makeLegacyDefaultValidator() {
        return this.isCounter() ? CounterColumnType.instance : (this.isCompactTable() ? this.compactValueColumn().type : BytesType.instance);
    }

    public static Set<Flag> flagsFromStrings(Set<String> strings) {
        return strings.stream().map(String::toUpperCase).map(Flag::valueOf).collect(Collectors.toSet());
    }

    public static Set<String> flagsToStrings(Set<Flag> flags) {
        return flags.stream().map(Enum::toString).map(String::toLowerCase).collect(Collectors.toSet());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cfId", (Object)this.cfId).append("ksName", (Object)this.ksName).append("cfName", (Object)this.cfName).append("flags", this.flags).append("params", (Object)this.params).append("comparator", (Object)this.comparator).append("partitionColumns", (Object)this.partitionColumns).append("partitionKeyColumns", this.partitionKeyColumns).append("clusteringColumns", this.clusteringColumns).append("keyValidator", this.keyValidator).append("columnMetadata", this.columnMetadata.values()).append("droppedColumns", this.droppedColumns).append("triggers", (Object)this.triggers).append("indexes", (Object)this.indexes).toString();
    }

    public static class DroppedColumn {
        public final String name;
        public final AbstractType<?> type;
        public final long droppedTime;

        public DroppedColumn(String name, AbstractType<?> type, long droppedTime) {
            this.name = name;
            this.type = type;
            this.droppedTime = droppedTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DroppedColumn)) {
                return false;
            }
            DroppedColumn dc = (DroppedColumn)o;
            return this.name.equals(dc.name) && this.type.equals(dc.type) && this.droppedTime == dc.droppedTime;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.type, this.droppedTime});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", this.type).add("droppedTime", this.droppedTime).toString();
        }
    }

    public static class Serializer {
        public void serialize(CFMetaData metadata, DataOutputPlus out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(metadata.cfId, out, version);
        }

        public CFMetaData deserialize(DataInputPlus in, int version) throws IOException {
            UUID cfId = UUIDSerializer.serializer.deserialize(in, version);
            CFMetaData metadata = Schema.instance.getCFMetaData(cfId);
            if (metadata == null) {
                String message = String.format("Couldn't find table for cfId %s. If a table was just created, this is likely due to the schema not being fully propagated.  Please wait for schema agreement on table creation.", cfId);
                throw new UnknownColumnFamilyException(message, cfId);
            }
            return metadata;
        }

        public long serializedSize(CFMetaData metadata, int version) {
            return UUIDSerializer.serializer.serializedSize(metadata.cfId, version);
        }
    }

    public static class Builder {
        private final String keyspace;
        private final String table;
        private final boolean isDense;
        private final boolean isCompound;
        private final boolean isSuper;
        private final boolean isCounter;
        private final boolean isView;
        private Optional<IPartitioner> partitioner;
        private UUID tableId;
        private final List<Pair<ColumnIdentifier, AbstractType>> partitionKeys = new ArrayList<Pair<ColumnIdentifier, AbstractType>>();
        private final List<Pair<ColumnIdentifier, AbstractType>> clusteringColumns = new ArrayList<Pair<ColumnIdentifier, AbstractType>>();
        private final List<Pair<ColumnIdentifier, AbstractType>> staticColumns = new ArrayList<Pair<ColumnIdentifier, AbstractType>>();
        private final List<Pair<ColumnIdentifier, AbstractType>> regularColumns = new ArrayList<Pair<ColumnIdentifier, AbstractType>>();

        private Builder(String keyspace, String table, boolean isDense, boolean isCompound, boolean isSuper, boolean isCounter, boolean isView) {
            this.keyspace = keyspace;
            this.table = table;
            this.isDense = isDense;
            this.isCompound = isCompound;
            this.isSuper = isSuper;
            this.isCounter = isCounter;
            this.isView = isView;
            this.partitioner = Optional.empty();
        }

        public static Builder create(String keyspace, String table) {
            return Builder.create(keyspace, table, false, true, false);
        }

        public static Builder create(String keyspace, String table, boolean isDense, boolean isCompound, boolean isCounter) {
            return Builder.create(keyspace, table, isDense, isCompound, false, isCounter);
        }

        public static Builder create(String keyspace, String table, boolean isDense, boolean isCompound, boolean isSuper, boolean isCounter) {
            return new Builder(keyspace, table, isDense, isCompound, isSuper, isCounter, false);
        }

        public static Builder createView(String keyspace, String table) {
            return new Builder(keyspace, table, false, true, false, false, true);
        }

        public static Builder createDense(String keyspace, String table, boolean isCompound, boolean isCounter) {
            return Builder.create(keyspace, table, true, isCompound, isCounter);
        }

        public static Builder createSuper(String keyspace, String table, boolean isCounter) {
            return Builder.create(keyspace, table, false, false, true, isCounter);
        }

        public Builder withPartitioner(IPartitioner partitioner) {
            this.partitioner = Optional.ofNullable(partitioner);
            return this;
        }

        public Builder withId(UUID tableId) {
            this.tableId = tableId;
            return this;
        }

        public Builder addPartitionKey(String name, AbstractType type) {
            return this.addPartitionKey(ColumnIdentifier.getInterned(name, false), type);
        }

        public Builder addPartitionKey(ColumnIdentifier name, AbstractType type) {
            this.partitionKeys.add(Pair.create(name, type));
            return this;
        }

        public Builder addClusteringColumn(String name, AbstractType type) {
            return this.addClusteringColumn(ColumnIdentifier.getInterned(name, false), type);
        }

        public Builder addClusteringColumn(ColumnIdentifier name, AbstractType type) {
            this.clusteringColumns.add(Pair.create(name, type));
            return this;
        }

        public Builder addRegularColumn(String name, AbstractType type) {
            return this.addRegularColumn(ColumnIdentifier.getInterned(name, false), type);
        }

        public Builder addRegularColumn(ColumnIdentifier name, AbstractType type) {
            this.regularColumns.add(Pair.create(name, type));
            return this;
        }

        public boolean hasRegulars() {
            return !this.regularColumns.isEmpty();
        }

        public Builder addStaticColumn(String name, AbstractType type) {
            return this.addStaticColumn(ColumnIdentifier.getInterned(name, false), type);
        }

        public Builder addStaticColumn(ColumnIdentifier name, AbstractType type) {
            this.staticColumns.add(Pair.create(name, type));
            return this;
        }

        public Set<String> usedColumnNames() {
            HashSet<String> usedNames = new HashSet<String>();
            for (Pair<ColumnIdentifier, AbstractType> p : this.partitionKeys) {
                usedNames.add(((ColumnIdentifier)p.left).toString());
            }
            for (Pair<ColumnIdentifier, AbstractType> p : this.clusteringColumns) {
                usedNames.add(((ColumnIdentifier)p.left).toString());
            }
            for (Pair<ColumnIdentifier, AbstractType> p : this.staticColumns) {
                usedNames.add(((ColumnIdentifier)p.left).toString());
            }
            for (Pair<ColumnIdentifier, AbstractType> p : this.regularColumns) {
                usedNames.add(((ColumnIdentifier)p.left).toString());
            }
            return usedNames;
        }

        public CFMetaData build() {
            Pair<ColumnIdentifier, AbstractType> p2;
            int i;
            if (this.tableId == null) {
                this.tableId = UUIDGen.getTimeUUID();
            }
            ArrayList<ColumnDefinition> partitions = new ArrayList<ColumnDefinition>(this.partitionKeys.size());
            ArrayList<ColumnDefinition> clusterings = new ArrayList<ColumnDefinition>(this.clusteringColumns.size());
            PartitionColumns.Builder builder = PartitionColumns.builder();
            for (i = 0; i < this.partitionKeys.size(); ++i) {
                p2 = this.partitionKeys.get(i);
                partitions.add(new ColumnDefinition(this.keyspace, this.table, (ColumnIdentifier)p2.left, (AbstractType)p2.right, i, ColumnDefinition.Kind.PARTITION_KEY));
            }
            for (i = 0; i < this.clusteringColumns.size(); ++i) {
                p2 = this.clusteringColumns.get(i);
                clusterings.add(new ColumnDefinition(this.keyspace, this.table, (ColumnIdentifier)p2.left, (AbstractType)p2.right, i, ColumnDefinition.Kind.CLUSTERING));
            }
            for (Pair<ColumnIdentifier, AbstractType> p2 : this.regularColumns) {
                builder.add(new ColumnDefinition(this.keyspace, this.table, (ColumnIdentifier)p2.left, (AbstractType)p2.right, -1, ColumnDefinition.Kind.REGULAR));
            }
            for (Pair<ColumnIdentifier, AbstractType> p2 : this.staticColumns) {
                builder.add(new ColumnDefinition(this.keyspace, this.table, (ColumnIdentifier)p2.left, (AbstractType)p2.right, -1, ColumnDefinition.Kind.STATIC));
            }
            return new CFMetaData(this.keyspace, this.table, this.tableId, this.isSuper, this.isCounter, this.isDense, this.isCompound, this.isView, partitions, clusterings, builder.build(), this.partitioner.orElseGet(DatabaseDescriptor::getPartitioner));
        }
    }

    public static enum Flag {
        SUPER,
        COUNTER,
        DENSE,
        COMPOUND;

    }
}

