/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.UTName;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.EmptyType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CQL3Type {
    public static final Logger logger = LoggerFactory.getLogger(CQL3Type.class);

    public boolean isCollection();

    public AbstractType<?> getType();

    default public String asCQLLiteral(ByteBuffer buffer, int version) {
        StringBuilder sb = new StringBuilder();
        this.toCQLLiteral(buffer, version, sb);
        return sb.toString();
    }

    public void toCQLLiteral(ByteBuffer var1, int var2, StringBuilder var3);

    public static abstract class Raw {
        protected boolean frozen = false;

        protected abstract boolean supportsFreezing();

        public boolean isCollection() {
            return false;
        }

        public boolean isFrozen() {
            return this.frozen;
        }

        public boolean canBeNonFrozen() {
            return true;
        }

        public boolean isCounter() {
            return false;
        }

        public String keyspace() {
            return null;
        }

        public void freeze() throws InvalidRequestException {
            String message = String.format("frozen<> is only allowed on collections, tuples, and user-defined types (got %s)", this);
            throw new InvalidRequestException(message);
        }

        public CQL3Type prepare(String keyspace) {
            KeyspaceMetadata ksm = Schema.instance.getKSMetaData(keyspace);
            if (ksm == null) {
                throw new ConfigurationException(String.format("Keyspace %s doesn't exist", keyspace));
            }
            return this.prepare(keyspace, ksm.types);
        }

        public abstract CQL3Type prepare(String var1, Types var2) throws InvalidRequestException;

        public CQL3Type prepareInternal(String keyspace, Types udts) throws InvalidRequestException {
            return this.prepare(keyspace, udts);
        }

        public boolean referencesUserType(String name) {
            return false;
        }

        public static Raw from(CQL3Type type) {
            return new RawType(type);
        }

        public static Raw userType(UTName name) {
            return new RawUT(name);
        }

        public static Raw map(Raw t1, Raw t2) {
            return new RawCollection(CollectionType.Kind.MAP, t1, t2);
        }

        public static Raw list(Raw t) {
            return new RawCollection(CollectionType.Kind.LIST, null, t);
        }

        public static Raw set(Raw t) {
            return new RawCollection(CollectionType.Kind.SET, null, t);
        }

        public static Raw tuple(List<Raw> ts) {
            return new RawTuple(ts);
        }

        public static Raw frozen(Raw t) throws InvalidRequestException {
            t.freeze();
            return t;
        }

        private static class RawTuple
        extends Raw {
            private final List<Raw> types;

            private RawTuple(List<Raw> types) {
                this.types = types;
            }

            @Override
            protected boolean supportsFreezing() {
                return true;
            }

            @Override
            public boolean isCollection() {
                return false;
            }

            @Override
            public void freeze() throws InvalidRequestException {
                for (Raw t : this.types) {
                    if (!t.supportsFreezing()) continue;
                    t.freeze();
                }
                this.frozen = true;
            }

            @Override
            public CQL3Type prepare(String keyspace, Types udts) throws InvalidRequestException {
                if (!this.frozen) {
                    this.freeze();
                }
                ArrayList ts = new ArrayList(this.types.size());
                for (Raw t : this.types) {
                    if (t.isCounter()) {
                        throw new InvalidRequestException("Counters are not allowed inside tuples");
                    }
                    ts.add(t.prepare(keyspace, udts).getType());
                }
                return new Tuple(new TupleType(ts));
            }

            @Override
            public boolean referencesUserType(String name) {
                return this.types.stream().anyMatch(t -> t.referencesUserType(name));
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("tuple<");
                for (int i = 0; i < this.types.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.types.get(i));
                }
                sb.append('>');
                return sb.toString();
            }
        }

        private static class RawUT
        extends Raw {
            private final UTName name;

            private RawUT(UTName name) {
                this.name = name;
            }

            @Override
            public String keyspace() {
                return this.name.getKeyspace();
            }

            @Override
            public void freeze() {
                this.frozen = true;
            }

            @Override
            public boolean canBeNonFrozen() {
                return false;
            }

            @Override
            public CQL3Type prepare(String keyspace, Types udts) throws InvalidRequestException {
                UserType type;
                if (this.name.hasKeyspace()) {
                    if (!keyspace.equals(this.name.getKeyspace())) {
                        throw new InvalidRequestException(String.format("Statement on keyspace %s cannot refer to a user type in keyspace %s; user types can only be used in the keyspace they are defined in", keyspace, this.name.getKeyspace()));
                    }
                } else {
                    this.name.setKeyspace(keyspace);
                }
                if ((type = udts.getNullable(this.name.getUserTypeName())) == null) {
                    throw new InvalidRequestException("Unknown type " + this.name);
                }
                if (!this.frozen) {
                    throw new InvalidRequestException("Non-frozen User-Defined types are not supported, please use frozen<>");
                }
                return new UserDefined(this.name.toString(), type);
            }

            @Override
            public boolean referencesUserType(String name) {
                return this.name.getStringTypeName().equals(name);
            }

            @Override
            protected boolean supportsFreezing() {
                return true;
            }

            public String toString() {
                return this.name.toString();
            }
        }

        private static class RawCollection
        extends Raw {
            private final CollectionType.Kind kind;
            private final Raw keys;
            private final Raw values;

            private RawCollection(CollectionType.Kind kind, Raw keys, Raw values) {
                this.kind = kind;
                this.keys = keys;
                this.values = values;
            }

            @Override
            public void freeze() throws InvalidRequestException {
                if (this.keys != null && this.keys.supportsFreezing()) {
                    this.keys.freeze();
                }
                if (this.values != null && this.values.supportsFreezing()) {
                    this.values.freeze();
                }
                this.frozen = true;
            }

            @Override
            protected boolean supportsFreezing() {
                return true;
            }

            @Override
            public boolean isCollection() {
                return true;
            }

            @Override
            public CQL3Type prepare(String keyspace, Types udts) throws InvalidRequestException {
                return this.prepare(keyspace, udts, false);
            }

            @Override
            public CQL3Type prepareInternal(String keyspace, Types udts) {
                return this.prepare(keyspace, udts, true);
            }

            public CQL3Type prepare(String keyspace, Types udts, boolean isInternal) throws InvalidRequestException {
                assert (this.values != null) : "Got null values type for a collection";
                if (!this.frozen && this.values.supportsFreezing() && !this.values.frozen) {
                    throw new InvalidRequestException("Non-frozen collections are not allowed inside collections: " + this);
                }
                if (this.values.isCounter() && !isInternal) {
                    throw new InvalidRequestException("Counters are not allowed inside collections: " + this);
                }
                if (this.keys != null) {
                    if (this.keys.isCounter()) {
                        throw new InvalidRequestException("Counters are not allowed inside collections: " + this);
                    }
                    if (!this.frozen && this.keys.supportsFreezing() && !this.keys.frozen) {
                        throw new InvalidRequestException("Non-frozen collections are not allowed inside collections: " + this);
                    }
                }
                switch (this.kind) {
                    case LIST: {
                        return new Collection(ListType.getInstance(this.values.prepare(keyspace, udts).getType(), !this.frozen));
                    }
                    case SET: {
                        return new Collection(SetType.getInstance(this.values.prepare(keyspace, udts).getType(), !this.frozen));
                    }
                    case MAP: {
                        assert (this.keys != null) : "Got null keys type for a collection";
                        return new Collection(MapType.getInstance(this.keys.prepare(keyspace, udts).getType(), this.values.prepare(keyspace, udts).getType(), !this.frozen));
                    }
                }
                throw new AssertionError();
            }

            @Override
            public boolean referencesUserType(String name) {
                return this.keys != null && this.keys.referencesUserType(name) || this.values.referencesUserType(name);
            }

            public String toString() {
                String start = this.frozen ? "frozen<" : "";
                String end = this.frozen ? ">" : "";
                switch (this.kind) {
                    case LIST: {
                        return start + "list<" + this.values + '>' + end;
                    }
                    case SET: {
                        return start + "set<" + this.values + '>' + end;
                    }
                    case MAP: {
                        return start + "map<" + this.keys + ", " + this.values + '>' + end;
                    }
                }
                throw new AssertionError();
            }
        }

        private static class RawType
        extends Raw {
            private final CQL3Type type;

            private RawType(CQL3Type type) {
                this.type = type;
            }

            @Override
            public CQL3Type prepare(String keyspace, Types udts) throws InvalidRequestException {
                return this.type;
            }

            @Override
            protected boolean supportsFreezing() {
                return false;
            }

            @Override
            public boolean isCounter() {
                return this.type == Native.COUNTER;
            }

            public String toString() {
                return this.type.toString();
            }
        }
    }

    public static class Tuple
    implements CQL3Type {
        private final TupleType type;

        private Tuple(TupleType type) {
            this.type = type;
        }

        public static Tuple create(TupleType type) {
            return new Tuple(type);
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public AbstractType<?> getType() {
            return this.type;
        }

        @Override
        public void toCQLLiteral(ByteBuffer buffer, int version, StringBuilder target) {
            if (buffer == null) {
                target.append("null");
            } else {
                target.append('(');
                boolean first = true;
                for (int i = 0; i < this.type.size() && buffer.hasRemaining(); ++i) {
                    if (buffer.remaining() < 4) {
                        throw new MarshalException(String.format("Not enough bytes to read size of %dth component", i));
                    }
                    int size = buffer.getInt();
                    if (first) {
                        first = false;
                    } else {
                        target.append(", ");
                    }
                    if (size < 0) {
                        target.append("null");
                        continue;
                    }
                    if (buffer.remaining() < size) {
                        throw new MarshalException(String.format("Not enough bytes to read %dth component", i));
                    }
                    ByteBuffer field = ByteBufferUtil.readBytes(buffer, size);
                    this.type.type(i).asCQL3Type().toCQLLiteral(field, version, target);
                }
                target.append(')');
            }
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Tuple)) {
                return false;
            }
            Tuple that = (Tuple)o;
            return this.type.equals(that.type);
        }

        public final int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("frozen<tuple<");
            for (int i = 0; i < this.type.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.type.type(i).asCQL3Type());
            }
            sb.append(">>");
            return sb.toString();
        }
    }

    public static class UserDefined
    implements CQL3Type {
        private final String name;
        private final UserType type;

        private UserDefined(String name, UserType type) {
            this.name = name;
            this.type = type;
        }

        public static UserDefined create(UserType type) {
            return new UserDefined((String)UTF8Type.instance.compose(type.name), type);
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public AbstractType<?> getType() {
            return this.type;
        }

        @Override
        public void toCQLLiteral(ByteBuffer buffer, int version, StringBuilder target) {
            if (buffer == null) {
                target.append("null");
            } else {
                target.append('{');
                for (int i = 0; i < this.type.size() && buffer.hasRemaining(); ++i) {
                    if (buffer.remaining() < 4) {
                        throw new MarshalException(String.format("Not enough bytes to read size of %dth field %s", i, this.type.fieldName(i)));
                    }
                    int size = buffer.getInt();
                    if (i > 0) {
                        target.append(", ");
                    }
                    target.append(ColumnIdentifier.maybeQuote(this.type.fieldNameAsString(i)));
                    target.append(": ");
                    if (size < 0) {
                        target.append("null");
                        continue;
                    }
                    if (buffer.remaining() < size) {
                        throw new MarshalException(String.format("Not enough bytes to read %dth field %s", i, this.type.fieldName(i)));
                    }
                    ByteBuffer field = ByteBufferUtil.readBytes(buffer, size);
                    this.type.fieldType(i).asCQL3Type().toCQLLiteral(field, version, target);
                }
                target.append('}');
            }
        }

        public final boolean equals(Object o) {
            if (!(o instanceof UserDefined)) {
                return false;
            }
            UserDefined that = (UserDefined)o;
            return this.type.equals(that.type);
        }

        public final int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return "frozen<" + ColumnIdentifier.maybeQuote(this.name) + '>';
        }
    }

    public static class Collection
    implements CQL3Type {
        private final CollectionType type;

        public Collection(CollectionType type) {
            this.type = type;
        }

        @Override
        public AbstractType<?> getType() {
            return this.type;
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public void toCQLLiteral(ByteBuffer buffer, int version, StringBuilder target) {
            if (buffer == null || !buffer.hasRemaining()) {
                if (buffer == null && this.type.isFrozenCollection()) {
                    target.append("null");
                } else {
                    switch (this.type.kind) {
                        case LIST: {
                            target.append("[]");
                            break;
                        }
                        case SET: 
                        case MAP: {
                            target.append("{}");
                        }
                    }
                }
            } else {
                int size = CollectionSerializer.readCollectionSize(buffer, version);
                switch (this.type.kind) {
                    case LIST: {
                        CQL3Type elements = ((ListType)this.type).getElementsType().asCQL3Type();
                        target.append('[');
                        Collection.generateSetOrListCQLLiteral(buffer, version, target, size, elements);
                        target.append(']');
                        break;
                    }
                    case SET: {
                        CQL3Type elements = ((SetType)this.type).getElementsType().asCQL3Type();
                        target.append('{');
                        Collection.generateSetOrListCQLLiteral(buffer, version, target, size, elements);
                        target.append('}');
                        break;
                    }
                    case MAP: {
                        target.append('{');
                        this.generateMapCQLLiteral(buffer, version, target, size);
                        target.append('}');
                    }
                }
            }
        }

        private void generateMapCQLLiteral(ByteBuffer buffer, int version, StringBuilder target, int size) {
            CQL3Type keys = ((MapType)this.type).getKeysType().asCQL3Type();
            CQL3Type values = ((MapType)this.type).getValuesType().asCQL3Type();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    target.append(", ");
                }
                ByteBuffer element = CollectionSerializer.readValue(buffer, version);
                keys.toCQLLiteral(element, version, target);
                target.append(": ");
                element = CollectionSerializer.readValue(buffer, version);
                values.toCQLLiteral(element, version, target);
            }
        }

        private static void generateSetOrListCQLLiteral(ByteBuffer buffer, int version, StringBuilder target, int size, CQL3Type elements) {
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    target.append(", ");
                }
                ByteBuffer element = CollectionSerializer.readValue(buffer, version);
                elements.toCQLLiteral(element, version, target);
            }
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Collection)) {
                return false;
            }
            Collection that = (Collection)o;
            return this.type.equals(that.type);
        }

        public final int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            boolean isFrozen = !this.type.isMultiCell();
            StringBuilder sb = new StringBuilder(isFrozen ? "frozen<" : "");
            switch (this.type.kind) {
                case LIST: {
                    AbstractType listType = ((ListType)this.type).getElementsType();
                    sb.append("list<").append(listType.asCQL3Type());
                    break;
                }
                case SET: {
                    AbstractType setType = ((SetType)this.type).getElementsType();
                    sb.append("set<").append(setType.asCQL3Type());
                    break;
                }
                case MAP: {
                    AbstractType keysType = ((MapType)this.type).getKeysType();
                    AbstractType valuesType = ((MapType)this.type).getValuesType();
                    sb.append("map<").append(keysType.asCQL3Type()).append(", ").append(valuesType.asCQL3Type());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            sb.append('>');
            if (isFrozen) {
                sb.append('>');
            }
            return sb.toString();
        }
    }

    public static class Custom
    implements CQL3Type {
        private final AbstractType<?> type;

        public Custom(AbstractType<?> type) {
            this.type = type;
        }

        public Custom(String className) throws SyntaxException, ConfigurationException {
            this(TypeParser.parse(className));
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public AbstractType<?> getType() {
            return this.type;
        }

        @Override
        public void toCQLLiteral(ByteBuffer buffer, int version, StringBuilder target) {
            if (buffer == null) {
                target.append("null");
            } else {
                target.append(this.type.getString(buffer));
            }
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Custom)) {
                return false;
            }
            Custom that = (Custom)o;
            return this.type.equals(that.type);
        }

        public final int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return "'" + this.type + '\'';
        }
    }

    public static enum Native implements CQL3Type
    {
        ASCII(AsciiType.instance),
        BIGINT(LongType.instance),
        BLOB(BytesType.instance),
        BOOLEAN(BooleanType.instance),
        COUNTER(CounterColumnType.instance),
        DATE(SimpleDateType.instance),
        DECIMAL(DecimalType.instance),
        DOUBLE(DoubleType.instance),
        EMPTY(EmptyType.instance),
        FLOAT(FloatType.instance),
        INET(InetAddressType.instance),
        INT(Int32Type.instance),
        SMALLINT(ShortType.instance),
        TEXT(UTF8Type.instance),
        TIME(TimeType.instance),
        TIMESTAMP(TimestampType.instance),
        TIMEUUID(TimeUUIDType.instance),
        TINYINT(ByteType.instance),
        UUID(UUIDType.instance),
        VARCHAR(UTF8Type.instance),
        VARINT(IntegerType.instance);

        private final AbstractType<?> type;

        private Native(AbstractType<?> type) {
            this.type = type;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public AbstractType<?> getType() {
            return this.type;
        }

        @Override
        public void toCQLLiteral(ByteBuffer buffer, int version, StringBuilder target) {
            this.type.getSerializer().toCQLLiteral(buffer, target);
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

