/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="cleanup", description="Triggers the immediate cleanup of keys no longer belonging to a node. By default, clean all keyspaces")
public class Cleanup
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<keyspace> <tables>...]", description="The keyspace followed by one or many tables")
    private List<String> args = new ArrayList<String>();
    @Option(title="jobs", name={"-j", "--jobs"}, description="Number of sstables to cleanup simultanously, set to 0 to use all available compaction threads")
    private int jobs = 2;

    @Override
    public void execute(NodeProbe probe) {
        List<String> keyspaces = this.parseOptionalKeyspace(this.args, probe, NodeTool.NodeToolCmd.KeyspaceSet.NON_LOCAL_STRATEGY);
        String[] tableNames = this.parseOptionalTables(this.args);
        for (String keyspace : keyspaces) {
            if (Schema.isLocalSystemKeyspace(keyspace)) continue;
            try {
                probe.forceKeyspaceCleanup(probe.output().out, this.jobs, keyspace, tableNames);
            }
            catch (Exception e) {
                throw new RuntimeException("Error occurred during cleanup", e);
            }
        }
    }
}

