/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.btree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.Spliterators;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.BTreeSearchIterator;
import org.apache.cassandra.utils.btree.UpdateFunction;

public class BTreeSet<V>
implements NavigableSet<V>,
List<V> {
    protected final Comparator<? super V> comparator;
    protected final Object[] tree;

    public BTreeSet(Object[] tree, Comparator<? super V> comparator) {
        this.tree = tree;
        this.comparator = comparator;
    }

    public BTreeSet<V> update(Collection<V> updateWith) {
        return new BTreeSet<V>(BTree.update(this.tree, this.comparator, updateWith, UpdateFunction.noOp()), this.comparator);
    }

    @Override
    public Comparator<? super V> comparator() {
        return this.comparator;
    }

    protected BTreeSearchIterator<V, V> slice(BTree.Dir dir) {
        return BTree.slice(this.tree, this.comparator, dir);
    }

    public Object[] tree() {
        return this.tree;
    }

    @Override
    public int indexOf(Object item) {
        return BTree.findIndex(this.tree, this.comparator, item);
    }

    @Override
    public V get(int index) {
        return BTree.findByIndex(this.tree, index);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public BTreeSet<V> subList(int fromIndex, int toIndex) {
        return new BTreeRange<V>(this.tree, this.comparator, fromIndex, toIndex - 1);
    }

    @Override
    public int size() {
        return BTree.size(this.tree);
    }

    @Override
    public boolean isEmpty() {
        return BTree.isEmpty(this.tree);
    }

    public BTreeSearchIterator<V, V> iterator() {
        return this.slice(BTree.Dir.ASC);
    }

    public BTreeSearchIterator<V, V> descendingIterator() {
        return this.slice(BTree.Dir.DESC);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArray(a, 0);
    }

    public <T> T[] toArray(T[] a, int offset) {
        int size = this.size();
        if (a.length < size + offset) {
            a = Arrays.copyOf(a, size);
        }
        BTree.toArray(this.tree, a, offset);
        return a;
    }

    @Override
    public Spliterator<V> spliterator() {
        return Spliterators.spliterator(this, 1361);
    }

    @Override
    public BTreeSet<V> subSet(V fromElement, boolean fromInclusive, V toElement, boolean toInclusive) {
        return new BTreeRange<V>(this.tree, this.comparator, fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public BTreeSet<V> headSet(V toElement, boolean inclusive) {
        return new BTreeRange<Object>(this.tree, (Comparator<Object>)this.comparator, null, true, toElement, inclusive);
    }

    @Override
    public BTreeSet<V> tailSet(V fromElement, boolean inclusive) {
        return new BTreeRange<Object>(this.tree, (Comparator<Object>)this.comparator, fromElement, inclusive, null, true);
    }

    @Override
    public SortedSet<V> subSet(V fromElement, V toElement) {
        return this.subSet((Object)fromElement, true, (Object)toElement, false);
    }

    @Override
    public SortedSet<V> headSet(V toElement) {
        return this.headSet((Object)toElement, false);
    }

    @Override
    public SortedSet<V> tailSet(V fromElement) {
        return this.tailSet((Object)fromElement, true);
    }

    @Override
    public BTreeSet<V> descendingSet() {
        return new BTreeRange<V>(this.tree, this.comparator).descendingSet();
    }

    @Override
    public V first() {
        return this.get(0);
    }

    @Override
    public V last() {
        return this.get(this.size() - 1);
    }

    @Override
    public V lower(V v) {
        return BTree.lower(this.tree, this.comparator, v);
    }

    @Override
    public V floor(V v) {
        return BTree.floor(this.tree, this.comparator, v);
    }

    @Override
    public V ceiling(V v) {
        return BTree.ceil(this.tree, this.comparator, v);
    }

    @Override
    public V higher(V v) {
        return BTree.higher(this.tree, this.comparator, v);
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (Object v : this) {
            result = 31 * result + Objects.hashCode(v);
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V set(int index, V element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, V element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<V> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<V> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    public static <V> Builder<V> builder(Comparator<? super V> comparator) {
        return new Builder<V>(comparator);
    }

    public static <V> BTreeSet<V> wrap(Object[] btree, Comparator<V> comparator) {
        return new BTreeSet<V>(btree, comparator);
    }

    public static <V extends Comparable<V>> BTreeSet<V> of(Collection<V> sortedValues) {
        return new BTreeSet<V>(BTree.build(sortedValues, UpdateFunction.noOp()), Ordering.natural());
    }

    public static <V extends Comparable<V>> BTreeSet<V> of(V value) {
        return new BTreeSet<V>(BTree.build(ImmutableList.of(value), UpdateFunction.noOp()), Ordering.natural());
    }

    public static <V> BTreeSet<V> empty(Comparator<? super V> comparator) {
        return new BTreeSet<V>(BTree.empty(), comparator);
    }

    public static <V> BTreeSet<V> of(Comparator<? super V> comparator, V value) {
        return new BTreeSet<V>(BTree.build(ImmutableList.of(value), UpdateFunction.noOp()), comparator);
    }

    public static class Builder<V> {
        final BTree.Builder<V> builder;

        protected Builder(Comparator<? super V> comparator) {
            this.builder = BTree.builder(comparator);
        }

        public Builder<V> add(V v) {
            this.builder.add(v);
            return this;
        }

        public Builder<V> addAll(Collection<V> iter) {
            this.builder.addAll(iter);
            return this;
        }

        public boolean isEmpty() {
            return this.builder.isEmpty();
        }

        public BTreeSet<V> build() {
            return new BTreeSet(this.builder.build(), this.builder.comparator);
        }
    }

    public static class BTreeDescRange<V>
    extends BTreeRange<V> {
        BTreeDescRange(BTreeRange<V> from) {
            super(from.tree, from.comparator, from.lowerBound, from.upperBound);
        }

        @Override
        protected BTreeSearchIterator<V, V> slice(BTree.Dir dir) {
            return super.slice(dir.invert());
        }

        @Override
        public V higher(V v) {
            return super.lower(v);
        }

        @Override
        public V ceiling(V v) {
            return super.floor(v);
        }

        @Override
        public V floor(V v) {
            return super.ceiling(v);
        }

        @Override
        public V lower(V v) {
            return super.higher(v);
        }

        @Override
        public V get(int index) {
            if (this.outOfBounds(index = this.upperBound - index)) {
                throw new NoSuchElementException();
            }
            return BTree.findByIndex(this.tree, index);
        }

        @Override
        public int indexOf(Object item) {
            int i = super.indexOf(item);
            return i < 0 ? -2 - this.size() - i : this.size() - (i + 1);
        }

        @Override
        public BTreeSet<V> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return new BTreeDescRange(new BTreeRange(this.tree, this.comparator, this.upperBound - (toIndex - 1), this.upperBound - fromIndex));
        }

        @Override
        public BTreeSet<V> subSet(V fromElement, boolean fromInclusive, V toElement, boolean toInclusive) {
            return ((BTreeSet)super.subSet((Object)toElement, toInclusive, (Object)fromElement, fromInclusive)).descendingSet();
        }

        @Override
        public BTreeSet<V> headSet(V toElement, boolean inclusive) {
            return ((BTreeSet)super.tailSet((Object)toElement, inclusive)).descendingSet();
        }

        @Override
        public BTreeSet<V> tailSet(V fromElement, boolean inclusive) {
            return ((BTreeSet)super.headSet((Object)fromElement, inclusive)).descendingSet();
        }

        @Override
        public BTreeSet<V> descendingSet() {
            return new BTreeRange(this);
        }

        @Override
        public Comparator<V> comparator() {
            return (a, b) -> this.comparator.compare(b, a);
        }

        @Override
        public <T> T[] toArray(T[] a, int offset) {
            a = super.toArray(a, offset);
            int count = this.size();
            int flip = count / 2;
            for (int i = 0; i < flip; ++i) {
                int j = count - (i + 1);
                T t = a[i + offset];
                a[i + offset] = a[j + offset];
                a[j + offset] = t;
            }
            return a;
        }
    }

    public static class BTreeRange<V>
    extends BTreeSet<V> {
        protected final int lowerBound;
        protected final int upperBound;

        BTreeRange(Object[] tree, Comparator<? super V> comparator) {
            this(tree, comparator, null, true, null, true);
        }

        BTreeRange(BTreeRange<V> from) {
            super(from.tree, from.comparator);
            this.lowerBound = from.lowerBound;
            this.upperBound = from.upperBound;
        }

        BTreeRange(Object[] tree, Comparator<? super V> comparator, int lowerBound, int upperBound) {
            super(tree, comparator);
            if (upperBound < lowerBound - 1) {
                upperBound = lowerBound - 1;
            }
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        BTreeRange(Object[] tree, Comparator<? super V> comparator, V lowerBound, boolean inclusiveLowerBound, V upperBound, boolean inclusiveUpperBound) {
            this(tree, comparator, lowerBound == null ? 0 : (inclusiveLowerBound ? BTree.ceilIndex(tree, comparator, lowerBound) : BTree.higherIndex(tree, comparator, lowerBound)), upperBound == null ? BTree.size(tree) - 1 : (inclusiveUpperBound ? BTree.floorIndex(tree, comparator, upperBound) : BTree.lowerIndex(tree, comparator, upperBound)));
        }

        BTreeRange(BTreeRange<V> a, BTreeRange<V> b) {
            this(a.tree, a.comparator, Math.max(a.lowerBound, b.lowerBound), Math.min(a.upperBound, b.upperBound));
            assert (a.tree == b.tree);
        }

        @Override
        protected BTreeSearchIterator<V, V> slice(BTree.Dir dir) {
            return new BTreeSearchIterator(this.tree, this.comparator, dir, this.lowerBound, this.upperBound);
        }

        @Override
        public boolean isEmpty() {
            return this.upperBound < this.lowerBound;
        }

        @Override
        public int size() {
            return this.upperBound - this.lowerBound + 1;
        }

        boolean outOfBounds(int i) {
            return i < this.lowerBound | i > this.upperBound;
        }

        @Override
        public V get(int index) {
            if (this.outOfBounds(index += this.lowerBound)) {
                throw new NoSuchElementException();
            }
            return super.get(index);
        }

        @Override
        public int indexOf(Object item) {
            boolean negate;
            int i = super.indexOf(item);
            boolean bl = negate = i < 0;
            if (negate) {
                i = -1 - i;
            }
            if (this.outOfBounds(i)) {
                return i < this.lowerBound ? -1 : -1 - this.size();
            }
            i -= this.lowerBound;
            if (negate) {
                i = -1 - i;
            }
            return i;
        }

        @Override
        public V lower(V v) {
            return this.maybe(Math.min(this.upperBound, BTree.lowerIndex(this.tree, this.comparator, v)));
        }

        @Override
        public V floor(V v) {
            return this.maybe(Math.min(this.upperBound, BTree.floorIndex(this.tree, this.comparator, v)));
        }

        @Override
        public V ceiling(V v) {
            return this.maybe(Math.max(this.lowerBound, BTree.ceilIndex(this.tree, this.comparator, v)));
        }

        @Override
        public V higher(V v) {
            return this.maybe(Math.max(this.lowerBound, BTree.higherIndex(this.tree, this.comparator, v)));
        }

        private V maybe(int i) {
            if (this.outOfBounds(i)) {
                return null;
            }
            return super.get(i);
        }

        @Override
        public BTreeSet<V> subSet(V fromElement, boolean fromInclusive, V toElement, boolean toInclusive) {
            return new BTreeRange<V>(this, new BTreeRange<V>(this.tree, this.comparator, fromElement, fromInclusive, toElement, toInclusive));
        }

        @Override
        public BTreeSet<V> headSet(V toElement, boolean inclusive) {
            return new BTreeRange<Object>(this, new BTreeRange<Object>(this.tree, this.comparator, null, true, toElement, inclusive));
        }

        @Override
        public BTreeSet<V> tailSet(V fromElement, boolean inclusive) {
            return new BTreeRange<Object>(this, new BTreeRange<Object>(this.tree, this.comparator, fromElement, inclusive, null, true));
        }

        @Override
        public BTreeSet<V> descendingSet() {
            return new BTreeDescRange(this);
        }

        @Override
        public BTreeSet<V> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return new BTreeRange<V>(this.tree, this.comparator, this.lowerBound + fromIndex, this.lowerBound + toIndex - 1);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.toArray(a, 0);
        }

        @Override
        public <T> T[] toArray(T[] a, int offset) {
            if (this.size() + offset < a.length) {
                a = Arrays.copyOf(a, this.size() + offset);
            }
            BTree.toArray(this.tree, this.lowerBound, this.upperBound + 1, a, offset);
            return a;
        }
    }
}

