/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;

public class NanoTimeToCurrentTimeMillis {
    private static final String TIMESTAMP_UPDATE_INTERVAL_PROPERTY = "cassandra.NANOTIMETOMILLIS_TIMESTAMP_UPDATE_INTERVAL";
    private static final long TIMESTAMP_UPDATE_INTERVAL = Long.getLong("cassandra.NANOTIMETOMILLIS_TIMESTAMP_UPDATE_INTERVAL", 10000L);
    private static volatile long[] TIMESTAMP_BASE = new long[]{System.currentTimeMillis(), System.nanoTime()};
    @VisibleForTesting
    public static final Object TIMESTAMP_UPDATE = new Object();
    private static final Thread updater = new Thread("NanoTimeToCurrentTimeMillis updater"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Object object = TIMESTAMP_UPDATE;
                    synchronized (object) {
                        TIMESTAMP_UPDATE.wait(TIMESTAMP_UPDATE_INTERVAL);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                NanoTimeToCurrentTimeMillis.access$102(new long[]{Math.max(TIMESTAMP_BASE[0], System.currentTimeMillis()), Math.max(TIMESTAMP_BASE[1], System.nanoTime())});
            }
        }
    };

    public static final long convert(long nanoTime) {
        long[] timestampBase = TIMESTAMP_BASE;
        return timestampBase[0] + TimeUnit.NANOSECONDS.toMillis(nanoTime - timestampBase[1]);
    }

    public static void shutdown(long millis) throws InterruptedException {
        updater.interrupt();
        updater.join(millis);
    }

    static /* synthetic */ long[] access$102(long[] x0) {
        TIMESTAMP_BASE = x0;
        return x0;
    }

    static {
        updater.setDaemon(true);
        updater.start();
    }
}

