/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.serializers.InetAddressSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class InetAddressType
extends AbstractType<InetAddress> {
    public static final InetAddressType instance = new InetAddressType();

    InetAddressType() {
        super(AbstractType.ComparisonType.BYTE_ORDER);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        InetAddress address;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            address = InetAddress.getByName(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("Unable to make inet address from '%s'", source), e);
        }
        return this.decompose(address);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(instance.fromString((String)parsed));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a string representation of an inet value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    private String toString(InetAddress inet) {
        return inet != null ? inet.getHostAddress() : "";
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        return '\"' + this.toString(this.getSerializer().deserialize(buffer)) + '\"';
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.INET;
    }

    @Override
    public TypeSerializer<InetAddress> getSerializer() {
        return InetAddressSerializer.instance;
    }
}

