/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.exceptions.OverloadedException;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.service.DataResolver;
import org.apache.cassandra.service.ReadCallback;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReplicaFilteringProtection {
    private static final Logger logger = LoggerFactory.getLogger(ReplicaFilteringProtection.class);
    private static final NoSpamLogger oneMinuteLogger = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);
    private static final Function<UnfilteredRowIterator, EncodingStats> NULL_TO_NO_STATS = rowIterator -> rowIterator == null ? EncodingStats.NO_STATS : rowIterator.stats();
    private final Keyspace keyspace;
    private final ReadCommand command;
    private final ConsistencyLevel consistency;
    private final InetAddress[] sources;
    private final TableMetrics tableMetrics;
    private final int cachedRowsWarnThreshold;
    private final int cachedRowsFailThreshold;
    private boolean hitWarningThreshold = false;
    private int currentRowsCached = 0;
    private int maxRowsCached = 0;
    private final List<Queue<PartitionBuilder>> originalPartitions;

    ReplicaFilteringProtection(Keyspace keyspace, ReadCommand command, ConsistencyLevel consistency, InetAddress[] sources, int cachedRowsWarnThreshold, int cachedRowsFailThreshold) {
        this.keyspace = keyspace;
        this.command = command;
        this.consistency = consistency;
        this.sources = sources;
        this.originalPartitions = new ArrayList<Queue<PartitionBuilder>>(sources.length);
        for (int i = 0; i < sources.length; ++i) {
            this.originalPartitions.add(new ArrayDeque());
        }
        this.tableMetrics = ColumnFamilyStore.metricsFor(command.metadata().cfId);
        this.cachedRowsWarnThreshold = cachedRowsWarnThreshold;
        this.cachedRowsFailThreshold = cachedRowsFailThreshold;
    }

    private UnfilteredPartitionIterator executeReadCommand(ReadCommand cmd, InetAddress source) {
        DataResolver resolver = new DataResolver(this.keyspace, cmd, ConsistencyLevel.ONE, 1);
        ReadCallback handler = new ReadCallback(resolver, ConsistencyLevel.ONE, cmd, Collections.singletonList(source));
        if (StorageProxy.canDoLocalRequest(source)) {
            StageManager.getStage(Stage.READ).maybeExecuteImmediately(new StorageProxy.LocalReadRunnable(cmd, handler));
        } else {
            MessagingService.instance().sendRRWithFailure(cmd.createMessage(MessagingService.current_version), source, handler);
        }
        handler.awaitResults();
        assert (resolver.responses.size() == 1);
        return ((ReadResponse)((MessageIn)resolver.responses.get((int)0)).payload).makeIterator(this.command);
    }

    UnfilteredPartitionIterators.MergeListener mergeController() {
        return new UnfilteredPartitionIterators.MergeListener(){

            @Override
            public void close() {
                ((ReplicaFilteringProtection)ReplicaFilteringProtection.this).tableMetrics.rfpRowsCachedPerQuery.update(Math.max(ReplicaFilteringProtection.this.currentRowsCached, ReplicaFilteringProtection.this.maxRowsCached));
            }

            @Override
            public UnfilteredRowIterators.MergeListener getRowMergeListener(DecoratedKey partitionKey, List<UnfilteredRowIterator> versions) {
                final PartitionBuilder[] builders = new PartitionBuilder[ReplicaFilteringProtection.this.sources.length];
                PartitionColumns columns = ReplicaFilteringProtection.columns(versions);
                EncodingStats stats = EncodingStats.merge(versions, NULL_TO_NO_STATS);
                for (int i = 0; i < ReplicaFilteringProtection.this.sources.length; ++i) {
                    builders[i] = new PartitionBuilder(partitionKey, ReplicaFilteringProtection.this.sources[i], columns, stats);
                }
                return new UnfilteredRowIterators.MergeListener(){

                    @Override
                    public void onMergedPartitionLevelDeletion(DeletionTime mergedDeletion, DeletionTime[] versions) {
                        for (int i = 0; i < versions.length; ++i) {
                            builders[i].setDeletionTime(versions[i]);
                        }
                    }

                    @Override
                    public Row onMergedRows(Row merged, Row[] versions) {
                        for (int i = 0; i < versions.length; ++i) {
                            builders[i].addRow(versions[i]);
                        }
                        if (merged.isEmpty()) {
                            return merged;
                        }
                        boolean isPotentiallyOutdated = false;
                        boolean isStatic = merged.isStatic();
                        for (int i = 0; i < versions.length; ++i) {
                            Row version = versions[i];
                            if (version != null && (!isStatic || !version.isEmpty())) continue;
                            isPotentiallyOutdated = true;
                            builders[i].addToFetch(merged);
                        }
                        return isPotentiallyOutdated ? null : merged;
                    }

                    @Override
                    public void onMergedRangeTombstoneMarkers(RangeTombstoneMarker merged, RangeTombstoneMarker[] versions) {
                        for (int i = 0; i < versions.length; ++i) {
                            builders[i].addRangeTombstoneMarker(versions[i]);
                        }
                    }

                    @Override
                    public void close() {
                        for (int i = 0; i < ReplicaFilteringProtection.this.sources.length; ++i) {
                            ((Queue)ReplicaFilteringProtection.this.originalPartitions.get(i)).add(builders[i]);
                        }
                    }
                };
            }
        };
    }

    private void incrementCachedRows() {
        ++this.currentRowsCached;
        if (this.currentRowsCached == this.cachedRowsFailThreshold + 1) {
            String message = String.format("Replica filtering protection has cached over %d rows during query %s. (See 'cached_replica_rows_fail_threshold' in cassandra.yaml.)", this.cachedRowsFailThreshold, this.command.toCQLString());
            logger.error(message);
            Tracing.trace(message);
            throw new OverloadedException(message);
        }
        if (this.currentRowsCached == this.cachedRowsWarnThreshold + 1 && !this.hitWarningThreshold) {
            this.hitWarningThreshold = true;
            String message = String.format("Replica filtering protection has cached over %d rows during query %s. (See 'cached_replica_rows_warn_threshold' in cassandra.yaml.)", this.cachedRowsWarnThreshold, this.command.toCQLString());
            ClientWarn.instance.warn(message);
            oneMinuteLogger.warn(message, new Object[0]);
            Tracing.trace(message);
        }
    }

    private void releaseCachedRows(int count) {
        this.maxRowsCached = Math.max(this.maxRowsCached, this.currentRowsCached);
        this.currentRowsCached -= count;
    }

    private static PartitionColumns columns(List<UnfilteredRowIterator> versions) {
        Columns statics = Columns.NONE;
        Columns regulars = Columns.NONE;
        for (UnfilteredRowIterator iter : versions) {
            if (iter == null) continue;
            PartitionColumns cols = iter.columns();
            statics = statics.mergeTo(cols.statics);
            regulars = regulars.mergeTo(cols.regulars);
        }
        return new PartitionColumns(statics, regulars);
    }

    UnfilteredPartitionIterator queryProtectedPartitions(final PartitionIterator merged, final int source) {
        return new UnfilteredPartitionIterator(){
            final Queue<PartitionBuilder> partitions;
            {
                this.partitions = (Queue)ReplicaFilteringProtection.this.originalPartitions.get(source);
            }

            @Override
            public boolean isForThrift() {
                return ReplicaFilteringProtection.this.command.isForThrift();
            }

            @Override
            public CFMetaData metadata() {
                return ReplicaFilteringProtection.this.command.metadata();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                if (this.partitions.isEmpty()) {
                    PartitionIterators.consumeNext(merged);
                }
                return !this.partitions.isEmpty();
            }

            @Override
            public UnfilteredRowIterator next() {
                PartitionBuilder builder = this.partitions.poll();
                assert (builder != null);
                return builder.protectedPartition();
            }
        };
    }

    private class PartitionBuilder {
        private final DecoratedKey key;
        private final InetAddress source;
        private final PartitionColumns columns;
        private final EncodingStats stats;
        private DeletionTime deletionTime;
        private Row staticRow = Rows.EMPTY_STATIC_ROW;
        private final Queue<Unfiltered> contents = new ArrayDeque<Unfiltered>();
        private BTreeSet.Builder<Clustering> toFetch;
        private int partitionRowsCached;

        private PartitionBuilder(DecoratedKey key, InetAddress source, PartitionColumns columns, EncodingStats stats) {
            this.key = key;
            this.source = source;
            this.columns = columns;
            this.stats = stats;
        }

        private void setDeletionTime(DeletionTime deletionTime) {
            this.deletionTime = deletionTime;
        }

        private void addRow(Row row) {
            ++this.partitionRowsCached;
            ReplicaFilteringProtection.this.incrementCachedRows();
            if (row == null) {
                return;
            }
            if (row.isStatic()) {
                this.staticRow = row;
            } else {
                this.contents.add(row);
            }
        }

        private void addRangeTombstoneMarker(RangeTombstoneMarker marker) {
            if (marker != null) {
                this.contents.add(marker);
            }
        }

        private void addToFetch(Row row) {
            if (this.toFetch == null) {
                this.toFetch = BTreeSet.builder(((ReplicaFilteringProtection)ReplicaFilteringProtection.this).command.metadata().comparator);
            }
            if (!row.isStatic()) {
                this.toFetch.add(row.clustering());
            }
        }

        private UnfilteredRowIterator originalPartition() {
            return new UnfilteredRowIterator(){

                @Override
                public DeletionTime partitionLevelDeletion() {
                    return PartitionBuilder.this.deletionTime;
                }

                @Override
                public EncodingStats stats() {
                    return PartitionBuilder.this.stats;
                }

                @Override
                public CFMetaData metadata() {
                    return ReplicaFilteringProtection.this.command.metadata();
                }

                @Override
                public boolean isReverseOrder() {
                    return ReplicaFilteringProtection.this.command.isReversed();
                }

                @Override
                public PartitionColumns columns() {
                    return PartitionBuilder.this.columns;
                }

                @Override
                public DecoratedKey partitionKey() {
                    return PartitionBuilder.this.key;
                }

                @Override
                public Row staticRow() {
                    return PartitionBuilder.this.staticRow;
                }

                @Override
                public void close() {
                    ReplicaFilteringProtection.this.releaseCachedRows(PartitionBuilder.this.partitionRowsCached);
                }

                @Override
                public boolean hasNext() {
                    return !PartitionBuilder.this.contents.isEmpty();
                }

                @Override
                public Unfiltered next() {
                    return (Unfiltered)PartitionBuilder.this.contents.poll();
                }
            };
        }

        /*
         * Loose catch block
         */
        private UnfilteredRowIterator protectedPartition() {
            UnfilteredRowIterator original;
            block29: {
                original = this.originalPartition();
                if (this.toFetch != null) {
                    Throwable throwable = null;
                    try (UnfilteredPartitionIterator partitions = this.fetchFromSource();){
                        if (partitions.hasNext()) {
                            try (UnfilteredRowIterator fetchedRows = (UnfilteredRowIterator)partitions.next();){
                                UnfilteredRowIterator unfilteredRowIterator = UnfilteredRowIterators.merge(Arrays.asList(original, fetchedRows), ReplicaFilteringProtection.this.command.nowInSec());
                                return unfilteredRowIterator;
                            }
                        }
                        break block29;
                        {
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                throw throwable3;
                            }
                        }
                    }
                }
            }
            return original;
        }

        private UnfilteredPartitionIterator fetchFromSource() {
            assert (this.toFetch != null);
            BTreeSet<Clustering> clusterings = this.toFetch.build();
            ((ReplicaFilteringProtection)ReplicaFilteringProtection.this).tableMetrics.replicaFilteringProtectionRequests.mark();
            if (logger.isTraceEnabled()) {
                logger.trace("Requesting rows {} in partition {} from {} for replica filtering protection", new Object[]{clusterings, this.key, this.source});
            }
            Tracing.trace("Requesting {} rows in partition {} from {} for replica filtering protection", clusterings.size(), this.key, this.source);
            DataLimits limits = clusterings.isEmpty() ? DataLimits.cqlLimits(1) : DataLimits.NONE;
            ClusteringIndexNamesFilter filter = new ClusteringIndexNamesFilter(clusterings, ReplicaFilteringProtection.this.command.isReversed());
            SinglePartitionReadCommand cmd = SinglePartitionReadCommand.create(ReplicaFilteringProtection.this.command.metadata(), ReplicaFilteringProtection.this.command.nowInSec(), ReplicaFilteringProtection.this.command.columnFilter(), RowFilter.NONE, limits, this.key, filter);
            try {
                return ReplicaFilteringProtection.this.executeReadCommand(cmd, this.source);
            }
            catch (ReadTimeoutException e) {
                int blockFor = ReplicaFilteringProtection.this.consistency.blockFor(ReplicaFilteringProtection.this.keyspace);
                throw new ReadTimeoutException(ReplicaFilteringProtection.this.consistency, blockFor - 1, blockFor, true);
            }
            catch (UnavailableException e) {
                int blockFor = ReplicaFilteringProtection.this.consistency.blockFor(ReplicaFilteringProtection.this.keyspace);
                throw new UnavailableException(ReplicaFilteringProtection.this.consistency, blockFor, blockFor - 1);
            }
        }
    }
}

