/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.transform;

import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.BaseRowIterator;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.utils.DiagnosticSnapshotService;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateRowChecker
extends Transformation<BaseRowIterator<?>> {
    private static final Logger logger = LoggerFactory.getLogger(DuplicateRowChecker.class);
    Clustering previous = null;
    int duplicatesDetected = 0;
    final String stage;
    final List<InetAddress> replicas;
    final CFMetaData metadata;
    final DecoratedKey key;
    final boolean snapshotOnDuplicate;

    DuplicateRowChecker(DecoratedKey key, CFMetaData metadata, String stage, boolean snapshotOnDuplicate, List<InetAddress> replicas) {
        this.key = key;
        this.metadata = metadata;
        this.stage = stage;
        this.snapshotOnDuplicate = snapshotOnDuplicate;
        this.replicas = replicas;
    }

    @Override
    protected DeletionTime applyToDeletion(DeletionTime deletionTime) {
        return deletionTime;
    }

    @Override
    protected RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
        return marker;
    }

    @Override
    protected Row applyToStatic(Row row) {
        return row;
    }

    @Override
    protected Row applyToRow(Row row) {
        if (null != this.previous && row.clustering().equals(this.previous)) {
            ++this.duplicatesDetected;
        }
        this.previous = row.clustering();
        return row;
    }

    @Override
    protected void onPartitionClose() {
        if (this.duplicatesDetected > 0) {
            logger.warn("Detected {} duplicate rows for {} during {}", new Object[]{this.duplicatesDetected, this.metadata.getKeyValidator().getString(this.key.getKey()), this.stage});
            if (this.snapshotOnDuplicate) {
                DiagnosticSnapshotService.duplicateRows(this.metadata, this.replicas);
            }
        }
        this.duplicatesDetected = 0;
        this.previous = null;
        super.onPartitionClose();
    }

    public static UnfilteredPartitionIterator duringCompaction(UnfilteredPartitionIterator iterator, final OperationType type) {
        if (!DatabaseDescriptor.checkForDuplicateRowsDuringCompaction()) {
            return iterator;
        }
        final List<InetAddress> address = Collections.singletonList(FBUtilities.getBroadcastAddress());
        final boolean snapshot = DatabaseDescriptor.snapshotOnDuplicateRowDetection();
        return Transformation.apply(iterator, (Transformation<? super UnfilteredRowIterator>)new Transformation<UnfilteredRowIterator>(){

            @Override
            protected UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
                return Transformation.apply(partition, new DuplicateRowChecker(partition.partitionKey(), partition.metadata(), type.toString(), snapshot, address));
            }
        });
    }

    public static PartitionIterator duringRead(PartitionIterator iterator, final List<InetAddress> replicas) {
        if (!DatabaseDescriptor.checkForDuplicateRowsDuringReads()) {
            return iterator;
        }
        final boolean snapshot = DatabaseDescriptor.snapshotOnDuplicateRowDetection();
        return Transformation.apply(iterator, (Transformation<? super RowIterator>)new Transformation<RowIterator>(){

            @Override
            protected RowIterator applyToPartition(RowIterator partition) {
                return Transformation.apply(partition, new DuplicateRowChecker(partition.partitionKey(), partition.metadata(), "Read", snapshot, replicas));
            }
        });
    }
}

