/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.ColumnCondition;
import org.apache.cassandra.cql3.ColumnConditions;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Conditions;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Json;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.Operations;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.SingleColumnRelation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.WhereClause;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.SingleColumnRestriction;
import org.apache.cassandra.cql3.restrictions.TermSlice;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.CompactTables;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;

public class SuperColumnCompatibility {
    public static final ByteBuffer SUPER_COLUMN_MAP_COLUMN = ByteBufferUtil.EMPTY_BYTE_BUFFER;
    public static final String SUPER_COLUMN_MAP_COLUMN_STR = (String)UTF8Type.instance.compose(SUPER_COLUMN_MAP_COLUMN);

    public static boolean recalculateIsDense(Columns columns) {
        return columns.size() == 1 && columns.getComplex((int)0).name.toString().isEmpty();
    }

    public static ColumnFilter getColumnFilter(CFMetaData cfm, QueryOptions queryOptions, SuperColumnRestrictions restrictions) {
        assert (cfm.isSuper() && cfm.isDense());
        ColumnFilter.Builder builder = ColumnFilter.selectionBuilder();
        builder.add(cfm.compactValueColumn());
        if (restrictions.keySliceRestriction != null) {
            SingleColumnRestriction.SuperColumnKeySliceRestriction restriction = restrictions.keySliceRestriction;
            TermSlice slice = restriction.slice;
            ByteBuffer start = slice.hasBound(Bound.START) ? slice.bound(Bound.START).bindAndGet(queryOptions) : null;
            ByteBuffer end = slice.hasBound(Bound.END) ? slice.bound(Bound.END).bindAndGet(queryOptions) : null;
            builder.slice(cfm.compactValueColumn(), start == null ? CellPath.BOTTOM : CellPath.create(start), end == null ? CellPath.TOP : CellPath.create(end));
        } else if (restrictions.keyEQRestriction != null) {
            SingleColumnRestriction.SuperColumnKeyEQRestriction restriction = restrictions.keyEQRestriction;
            ByteBuffer value = restriction.bindValue(queryOptions);
            builder.select(cfm.compactValueColumn(), CellPath.create(value));
        } else if (restrictions.keyINRestriction != null) {
            SingleColumnRestriction.SuperColumnKeyINRestriction cast = restrictions.keyINRestriction;
            TreeSet<ByteBuffer> keyINRestrictionValues = new TreeSet<ByteBuffer>(((MapType)cfm.compactValueColumn().type).getKeysType());
            keyINRestrictionValues.addAll(cast.getValues(queryOptions));
            for (ByteBuffer value : keyINRestrictionValues) {
                builder.select(cfm.compactValueColumn(), CellPath.create(value));
            }
        } else if (restrictions.multiEQRestriction != null) {
            SingleColumnRestriction.SuperColumnMultiEQRestriction restriction = restrictions.multiEQRestriction;
            ByteBuffer value = restriction.secondValue;
            builder.select(cfm.compactValueColumn(), CellPath.create(value));
        }
        return builder.build();
    }

    public static void processPartition(CFMetaData cfm, Selection selection, RowIterator partition, Selection.ResultSetBuilder result, int protocolVersion, SuperColumnRestrictions restrictions, QueryOptions queryOptions) {
        assert (cfm.isDense());
        ByteBuffer[] keyComponents = SelectStatement.getComponents(cfm, partition.partitionKey());
        int nowInSeconds = FBUtilities.nowInSeconds();
        while (partition.hasNext()) {
            Row row = (Row)partition.next();
            ComplexColumnData ccd = row.getComplexColumnData(cfm.compactValueColumn());
            if (ccd == null) continue;
            block6: for (Cell cell : ccd) {
                ByteBuffer superColumnKey = cell.path().get(0);
                if (restrictions != null) {
                    AbstractType t;
                    int cmp;
                    if (restrictions.keySliceRestriction != null) {
                        for (Bound bound : Bound.values()) {
                            ByteBuffer excludedValue;
                            if (restrictions.keySliceRestriction.hasBound(bound) && !restrictions.keySliceRestriction.isInclusive(bound) && (excludedValue = restrictions.keySliceRestriction.bindValue(queryOptions)).equals(superColumnKey)) continue block6;
                        }
                    }
                    if (restrictions.multiSliceRestriction != null && cfm.comparator.compare(row.clustering(), new Clustering(((SuperColumnRestrictions)restrictions).multiSliceRestriction.firstValue)) == 0 && ((cmp = (t = ((MapType)cfm.compactValueColumn().type).getKeysType()).compare(superColumnKey, ((SuperColumnRestrictions)restrictions).multiSliceRestriction.secondValue)) == 0 && !((SuperColumnRestrictions)restrictions).multiSliceRestriction.trueInclusive || restrictions.multiSliceRestriction.hasBound(Bound.END) && cmp > 0 || restrictions.multiSliceRestriction.hasBound(Bound.START) && cmp < 0)) continue;
                }
                result.newRow(protocolVersion);
                for (ColumnDefinition def : selection.getColumns()) {
                    if (cfm.isSuperColumnKeyColumn(def)) {
                        result.add(superColumnKey);
                        continue;
                    }
                    if (cfm.isSuperColumnValueColumn(def)) {
                        result.add(cell, nowInSeconds);
                        continue;
                    }
                    switch (def.kind) {
                        case PARTITION_KEY: {
                            result.add(keyComponents[def.position()]);
                            break;
                        }
                        case CLUSTERING: {
                            result.add(row.clustering().get(def.position()));
                            break;
                        }
                        case REGULAR: 
                        case STATIC: {
                            throw new AssertionError((Object)String.format("Invalid column '%s' found in SuperColumn table", def.name.toString()));
                        }
                    }
                }
            }
        }
    }

    public static void prepareInsertOperations(CFMetaData cfm, List<ColumnIdentifier.Raw> columnNames, WhereClause.Builder whereClause, List<Term.Raw> columnValues, VariableSpecifications boundNames, Operations operations) {
        ArrayList<ColumnDefinition> defs = new ArrayList<ColumnDefinition>(columnNames.size());
        for (int i = 0; i < columnNames.size(); ++i) {
            ColumnIdentifier id = columnNames.get(i).prepare(cfm);
            defs.add(cfm.getColumnDefinition(id));
        }
        SuperColumnCompatibility.prepareInsertOperations(cfm, defs, boundNames, columnValues, whereClause, operations);
    }

    public static void prepareInsertJSONOperations(CFMetaData cfm, List<ColumnDefinition> defs, VariableSpecifications boundNames, Json.Prepared prepared, WhereClause.Builder whereClause, Operations operations) {
        ArrayList<Term.Raw> columnValues = new ArrayList<Term.Raw>(defs.size());
        for (ColumnDefinition def : defs) {
            columnValues.add(prepared.getRawTermForColumn(def));
        }
        SuperColumnCompatibility.prepareInsertOperations(cfm, defs, boundNames, columnValues, whereClause, operations);
    }

    private static void prepareInsertOperations(CFMetaData cfm, List<ColumnDefinition> defs, VariableSpecifications boundNames, List<Term.Raw> columnValues, WhereClause.Builder whereClause, Operations operations) {
        assert (cfm.isDense());
        assert (defs.size() == columnValues.size());
        Term.Raw superColumnKey = null;
        Term.Raw superColumnValue = null;
        int size = defs.size();
        for (int i = 0; i < size; ++i) {
            ColumnDefinition def = defs.get(i);
            Term.Raw raw = columnValues.get(i);
            if (cfm.isSuperColumnKeyColumn(def)) {
                superColumnKey = raw;
                SuperColumnCompatibility.collectMarkerSpecifications(raw, boundNames, def);
                continue;
            }
            if (cfm.isSuperColumnValueColumn(def)) {
                superColumnValue = raw;
                SuperColumnCompatibility.collectMarkerSpecifications(raw, boundNames, def);
                continue;
            }
            if (def.isPrimaryKeyColumn()) {
                whereClause.add(new SingleColumnRelation(new ColumnIdentifier.ColumnIdentifierValue(def.name), Operator.EQ, raw));
                continue;
            }
            throw RequestValidations.invalidRequest("Invalid column {} in where clause", new Object[0]);
        }
        RequestValidations.checkTrue(superColumnValue != null, "Column value is mandatory for SuperColumn tables");
        RequestValidations.checkTrue(superColumnKey != null, "Column key is mandatory for SuperColumn tables");
        Operation operation = new Operation.SetElement(superColumnKey, superColumnValue).prepare(cfm.ksName, cfm.compactValueColumn());
        operations.add(operation);
    }

    private static void collectMarkerSpecifications(Term.Raw raw, VariableSpecifications boundNames, ColumnDefinition def) {
        if (raw instanceof AbstractMarker.Raw) {
            boundNames.add(((AbstractMarker.Raw)raw).bindIndex(), def);
        }
    }

    public static WhereClause prepareUpdateOperations(CFMetaData cfm, WhereClause whereClause, List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> updates, VariableSpecifications boundNames, Operations operations) {
        ColumnDefinition def;
        ColumnIdentifier id;
        assert (cfm.isDense());
        Term.Raw superColumnKey = null;
        Term.Raw superColumnValue = null;
        ArrayList<Relation> newRelations = new ArrayList<Relation>(whereClause.relations.size());
        for (int i = 0; i < whereClause.relations.size(); ++i) {
            SingleColumnRelation relation = (SingleColumnRelation)whereClause.relations.get(i);
            id = relation.getEntity().prepare(cfm);
            def = cfm.getColumnDefinition(id);
            if (cfm.isSuperColumnKeyColumn(def)) {
                superColumnKey = relation.getValue();
                SuperColumnCompatibility.collectMarkerSpecifications(superColumnKey, boundNames, def);
                continue;
            }
            newRelations.add(relation);
        }
        RequestValidations.checkTrue(superColumnKey != null, "Column key is mandatory for SuperColumn tables");
        for (Pair<ColumnIdentifier.Raw, Operation.RawUpdate> entry : updates) {
            Operation operation;
            Operation.RawUpdate op;
            id = ((ColumnIdentifier.Raw)entry.left).prepare(cfm);
            def = cfm.getColumnDefinition(id);
            if (!cfm.isSuperColumnValueColumn(def)) {
                throw RequestValidations.invalidRequest("Column `%s` of type `%s` found in SET part", def.name, def.type.asCQL3Type());
            }
            if (entry.right instanceof Operation.Addition) {
                op = (Operation.Addition)entry.right;
                superColumnValue = ((Operation.Addition)op).value();
                operation = new Operation.ElementAddition(superColumnKey, superColumnValue).prepare(cfm.ksName, cfm.compactValueColumn());
            } else if (entry.right instanceof Operation.Substraction) {
                op = (Operation.Substraction)entry.right;
                superColumnValue = ((Operation.Substraction)op).value();
                operation = new Operation.ElementSubtraction(superColumnKey, superColumnValue).prepare(cfm.ksName, cfm.compactValueColumn());
            } else if (entry.right instanceof Operation.SetValue) {
                op = (Operation.SetValue)entry.right;
                superColumnValue = ((Operation.SetValue)op).value();
                operation = new Operation.SetElement(superColumnKey, superColumnValue).prepare(cfm.ksName, cfm.compactValueColumn());
            } else {
                throw RequestValidations.invalidRequest("Invalid operation `%s` on column `%s` of type `%s` found in SET part", entry.right, def.name, def.type.asCQL3Type());
            }
            SuperColumnCompatibility.collectMarkerSpecifications(superColumnValue, boundNames, def);
            operations.add(operation);
        }
        RequestValidations.checkTrue(superColumnValue != null, "Column value is mandatory for SuperColumn tables");
        return newRelations.size() != whereClause.relations.size() ? whereClause.copy(newRelations) : whereClause;
    }

    public static Conditions rebuildLWTColumnConditions(Conditions conditions, CFMetaData cfm, WhereClause whereClause) {
        if (conditions.isEmpty() || conditions.isIfExists() || conditions.isIfNotExists()) {
            return conditions;
        }
        ColumnConditions.Builder builder = ColumnConditions.newBuilder();
        Collection<ColumnCondition> columnConditions = ((ColumnConditions)conditions).columnConditions();
        Pair<ColumnDefinition, Relation> superColumnKeyRelation = SuperColumnCompatibility.getSuperColumnKeyRelation(whereClause.relations, cfm);
        RequestValidations.checkNotNull(superColumnKeyRelation, "Lightweight transactions on SuperColumn tables are only supported with supplied SuperColumn key", new Object[0]);
        for (ColumnCondition columnCondition : columnConditions) {
            RequestValidations.checkTrue(cfm.isSuperColumnValueColumn(columnCondition.column), "Lightweight transactions are only supported on the value column of SuperColumn tables");
            Term.Raw value = ((Relation)superColumnKeyRelation.right).getValue();
            Term collectionElemnt = value instanceof AbstractMarker.Raw ? new Constants.Marker(((AbstractMarker.Raw)value).bindIndex(), (ColumnSpecification)superColumnKeyRelation.left) : value.prepare(cfm.ksName, (ColumnSpecification)superColumnKeyRelation.left);
            builder.add(ColumnCondition.condition(cfm.compactValueColumn(), collectionElemnt, columnCondition.value(), columnCondition.operator));
        }
        return builder.build();
    }

    private static Pair<ColumnDefinition, Relation> getSuperColumnKeyRelation(List<Relation> relations, CFMetaData cfm) {
        for (int i = 0; i < relations.size(); ++i) {
            SingleColumnRelation relation = (SingleColumnRelation)relations.get(i);
            ColumnIdentifier id = relation.getEntity().prepare(cfm);
            ColumnDefinition def = cfm.getColumnDefinition(id);
            if (!cfm.isSuperColumnKeyColumn(def)) continue;
            return Pair.create(def, relation);
        }
        return null;
    }

    public static WhereClause prepareDeleteOperations(CFMetaData cfm, WhereClause whereClause, VariableSpecifications boundNames, Operations operations) {
        assert (cfm.isDense());
        ArrayList<Relation> newRelations = new ArrayList<Relation>(whereClause.relations.size());
        for (int i = 0; i < whereClause.relations.size(); ++i) {
            Relation orig = whereClause.relations.get(i);
            RequestValidations.checkFalse(orig.isMultiColumn(), "Multi-column relations cannot be used in WHERE clauses for UPDATE and DELETE statements: %s", orig);
            RequestValidations.checkFalse(orig.onToken(), "Token relations cannot be used in WHERE clauses for UPDATE and DELETE statements: %s", orig);
            SingleColumnRelation relation = (SingleColumnRelation)orig;
            ColumnIdentifier id = relation.getEntity().prepare(cfm);
            ColumnDefinition def = cfm.getColumnDefinition(id);
            if (cfm.isSuperColumnKeyColumn(def)) {
                Term.Raw value = relation.getValue();
                if (value instanceof AbstractMarker.Raw) {
                    boundNames.add(((AbstractMarker.Raw)value).bindIndex(), def);
                }
                Maps.DiscarderByKey operation = new Maps.DiscarderByKey(cfm.compactValueColumn(), value.prepare(cfm.ksName, def));
                operations.add(operation);
                continue;
            }
            newRelations.add(relation);
        }
        return newRelations.size() != whereClause.relations.size() ? whereClause.copy(newRelations) : whereClause;
    }

    public static CompactTables.DefaultNames columnNameGenerator(List<ColumnDefinition> partitionKeyColumns, List<ColumnDefinition> clusteringColumns, PartitionColumns partitionColumns) {
        HashSet<String> names = new HashSet<String>();
        names.add("column1");
        for (ColumnDefinition columnDefinition : partitionKeyColumns) {
            names.add(columnDefinition.name.toString());
        }
        for (ColumnDefinition columnDefinition : clusteringColumns) {
            names.add(columnDefinition.name.toString());
        }
        for (ColumnDefinition columnDefinition : partitionColumns) {
            names.add(columnDefinition.name.toString());
        }
        return CompactTables.defaultNameGenerator(names);
    }

    public static ColumnDefinition getSuperCfKeyColumn(CFMetaData cfm, List<ColumnDefinition> clusteringColumns, CompactTables.DefaultNames defaultNames) {
        assert (cfm.isDense());
        MapType mapType = (MapType)cfm.compactValueColumn().type;
        if (clusteringColumns.size() == 1) {
            ColumnIdentifier identifier = ColumnIdentifier.getInterned(defaultNames.defaultClusteringName(), true);
            return new ColumnDefinition(cfm.ksName, cfm.cfName, identifier, mapType.getKeysType(), -1, ColumnDefinition.Kind.REGULAR);
        }
        assert (clusteringColumns.size() == 2) : clusteringColumns;
        ColumnDefinition cd = clusteringColumns.get(1);
        assert (cd.type.equals(mapType.getKeysType())) : cd.type + " != " + mapType.getKeysType();
        return new ColumnDefinition(cfm.ksName, cfm.cfName, cd.name, mapType.getKeysType(), -1, ColumnDefinition.Kind.REGULAR);
    }

    public static ColumnDefinition getSuperCfValueColumn(CFMetaData cfm, PartitionColumns partitionColumns, ColumnDefinition superCfKeyColumn, CompactTables.DefaultNames defaultNames) {
        assert (cfm.isDense());
        MapType mapType = (MapType)cfm.compactValueColumn().type;
        for (ColumnDefinition def : partitionColumns.regulars) {
            if (def.name.bytes.equals(SUPER_COLUMN_MAP_COLUMN) || !def.type.equals(mapType.getValuesType()) || def.equals(superCfKeyColumn)) continue;
            return def;
        }
        ColumnIdentifier identifier = ColumnIdentifier.getInterned(defaultNames.defaultCompactValueName(), true);
        return new ColumnDefinition(cfm.ksName, cfm.cfName, identifier, mapType.getValuesType(), -1, ColumnDefinition.Kind.REGULAR);
    }

    public static ColumnDefinition getSuperCfSschemaRepresentation(ColumnDefinition superCfKeyColumn) {
        return new ColumnDefinition(superCfKeyColumn.ksName, superCfKeyColumn.cfName, superCfKeyColumn.name, superCfKeyColumn.type, 1, ColumnDefinition.Kind.CLUSTERING);
    }

    public static boolean isSuperColumnMapColumn(ColumnDefinition column) {
        return column.isRegular() && column.name.bytes.equals(SUPER_COLUMN_MAP_COLUMN);
    }

    public static ColumnDefinition getCompactValueColumn(PartitionColumns columns) {
        for (ColumnDefinition column : columns.regulars) {
            if (!SuperColumnCompatibility.isSuperColumnMapColumn(column)) continue;
            return column;
        }
        throw new AssertionError((Object)"Invalid super column table definition, no 'dynamic' map column");
    }

    public static class SuperColumnRestrictions {
        private final SingleColumnRestriction.SuperColumnMultiSliceRestriction multiSliceRestriction;
        private final SingleColumnRestriction.SuperColumnMultiEQRestriction multiEQRestriction;
        private final SingleColumnRestriction.SuperColumnKeySliceRestriction keySliceRestriction;
        private final SingleColumnRestriction.SuperColumnKeyINRestriction keyINRestriction;
        private final SingleColumnRestriction.SuperColumnKeyEQRestriction keyEQRestriction;

        public SuperColumnRestrictions(Iterator<Restriction> restrictions) {
            SingleColumnRestriction.SuperColumnMultiSliceRestriction multiSliceRestriction = null;
            SingleColumnRestriction.SuperColumnKeySliceRestriction keySliceRestriction = null;
            SingleColumnRestriction.SuperColumnKeyINRestriction keyINRestriction = null;
            SingleColumnRestriction.SuperColumnMultiEQRestriction multiEQRestriction = null;
            SingleColumnRestriction.SuperColumnKeyEQRestriction keyEQRestriction = null;
            while (restrictions.hasNext()) {
                Restriction restriction = restrictions.next();
                if (restriction instanceof SingleColumnRestriction.SuperColumnMultiSliceRestriction) {
                    multiSliceRestriction = (SingleColumnRestriction.SuperColumnMultiSliceRestriction)restriction;
                    continue;
                }
                if (restriction instanceof SingleColumnRestriction.SuperColumnKeySliceRestriction) {
                    keySliceRestriction = (SingleColumnRestriction.SuperColumnKeySliceRestriction)restriction;
                    continue;
                }
                if (restriction instanceof SingleColumnRestriction.SuperColumnKeyINRestriction) {
                    keyINRestriction = (SingleColumnRestriction.SuperColumnKeyINRestriction)restriction;
                    continue;
                }
                if (restriction instanceof SingleColumnRestriction.SuperColumnMultiEQRestriction) {
                    multiEQRestriction = (SingleColumnRestriction.SuperColumnMultiEQRestriction)restriction;
                    continue;
                }
                if (!(restriction instanceof SingleColumnRestriction.SuperColumnKeyEQRestriction)) continue;
                keyEQRestriction = (SingleColumnRestriction.SuperColumnKeyEQRestriction)restriction;
            }
            this.multiSliceRestriction = multiSliceRestriction;
            this.keySliceRestriction = keySliceRestriction;
            this.keyINRestriction = keyINRestriction;
            this.multiEQRestriction = multiEQRestriction;
            this.keyEQRestriction = keyEQRestriction;
        }
    }
}

