/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Collections2;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.serializers.MarshalException;
import org.github.jamm.Unmetered;

@Unmetered
public class ColumnDefinition
extends ColumnSpecification
implements Comparable<ColumnDefinition> {
    public static final Comparator<Object> asymmetricColumnDataComparator = (a, b) -> ((ColumnData)a).column().compareTo((ColumnDefinition)b);
    public static final int NO_POSITION = -1;
    public final Kind kind;
    private final int position;
    private final Comparator<CellPath> cellPathComparator;
    private final Comparator<Object> asymmetricCellPathComparator;
    private final Comparator<? super Cell> cellComparator;
    private final long comparisonOrder;

    private static long comparisonOrder(Kind kind, boolean isComplex, long position, ColumnIdentifier name) {
        assert (position >= 0L && position < 4096L);
        return (long)kind.ordinal() << 61 | (isComplex ? 0x1000000000000000L : 0L) | position << 48 | name.prefixComparison >>> 16;
    }

    public static ColumnDefinition partitionKeyDef(CFMetaData cfm, ByteBuffer name, AbstractType<?> type, int position) {
        return new ColumnDefinition(cfm, name, type, position, Kind.PARTITION_KEY);
    }

    public static ColumnDefinition partitionKeyDef(String ksName, String cfName, String name, AbstractType<?> type, int position) {
        return new ColumnDefinition(ksName, cfName, ColumnIdentifier.getInterned(name, true), type, position, Kind.PARTITION_KEY);
    }

    public static ColumnDefinition clusteringDef(CFMetaData cfm, ByteBuffer name, AbstractType<?> type, int position) {
        return new ColumnDefinition(cfm, name, type, position, Kind.CLUSTERING);
    }

    public static ColumnDefinition clusteringDef(String ksName, String cfName, String name, AbstractType<?> type, int position) {
        return new ColumnDefinition(ksName, cfName, ColumnIdentifier.getInterned(name, true), type, position, Kind.CLUSTERING);
    }

    public static ColumnDefinition regularDef(CFMetaData cfm, ByteBuffer name, AbstractType<?> type) {
        return new ColumnDefinition(cfm, name, type, -1, Kind.REGULAR);
    }

    public static ColumnDefinition regularDef(String ksName, String cfName, String name, AbstractType<?> type) {
        return new ColumnDefinition(ksName, cfName, ColumnIdentifier.getInterned(name, true), type, -1, Kind.REGULAR);
    }

    public static ColumnDefinition staticDef(CFMetaData cfm, ByteBuffer name, AbstractType<?> type) {
        return new ColumnDefinition(cfm, name, type, -1, Kind.STATIC);
    }

    public ColumnDefinition(CFMetaData cfm, ByteBuffer name, AbstractType<?> type, int position, Kind kind) {
        this(cfm.ksName, cfm.cfName, ColumnIdentifier.getInterned(name, cfm.getColumnDefinitionNameComparator(kind)), type, position, kind);
    }

    @VisibleForTesting
    public ColumnDefinition(String ksName, String cfName, ColumnIdentifier name, AbstractType<?> type, int position, Kind kind) {
        super(ksName, cfName, name, type);
        assert (name != null && type != null && kind != null);
        assert (position == -1 == !kind.isPrimaryKeyKind());
        this.kind = kind;
        this.position = position;
        this.cellPathComparator = ColumnDefinition.makeCellPathComparator(kind, type);
        this.cellComparator = this.cellPathComparator == null ? ColumnData.comparator : (a, b) -> this.cellPathComparator.compare(a.path(), b.path());
        this.asymmetricCellPathComparator = this.cellPathComparator == null ? null : (a, b) -> this.cellPathComparator.compare(((Cell)a).path(), (CellPath)b);
        this.comparisonOrder = ColumnDefinition.comparisonOrder(kind, this.isComplex(), Math.max(0, position), name);
    }

    private static Comparator<CellPath> makeCellPathComparator(Kind kind, AbstractType<?> type) {
        if (kind.isPrimaryKeyKind() || !type.isCollection() || !type.isMultiCell()) {
            return null;
        }
        final CollectionType collection = (CollectionType)type;
        return new Comparator<CellPath>(){

            @Override
            public int compare(CellPath path1, CellPath path2) {
                if (path1.size() == 0 || path2.size() == 0) {
                    if (path1 == CellPath.BOTTOM) {
                        return path2 == CellPath.BOTTOM ? 0 : -1;
                    }
                    if (path1 == CellPath.TOP) {
                        return path2 == CellPath.TOP ? 0 : 1;
                    }
                    return path2 == CellPath.BOTTOM ? 1 : -1;
                }
                assert (path1.size() == 1 && path2.size() == 1);
                return collection.nameComparator().compare(path1.get(0), path2.get(0));
            }
        };
    }

    public ColumnDefinition copy() {
        return new ColumnDefinition(this.ksName, this.cfName, this.name, this.type, this.position, this.kind);
    }

    public ColumnDefinition withNewName(ColumnIdentifier newName) {
        return new ColumnDefinition(this.ksName, this.cfName, newName, this.type, this.position, this.kind);
    }

    public ColumnDefinition withNewType(AbstractType<?> newType) {
        return new ColumnDefinition(this.ksName, this.cfName, this.name, newType, this.position, this.kind);
    }

    public boolean isPartitionKey() {
        return this.kind == Kind.PARTITION_KEY;
    }

    public boolean isClusteringColumn() {
        return this.kind == Kind.CLUSTERING;
    }

    public boolean isStatic() {
        return this.kind == Kind.STATIC;
    }

    public boolean isRegular() {
        return this.kind == Kind.REGULAR;
    }

    public ClusteringOrder clusteringOrder() {
        if (!this.isClusteringColumn()) {
            return ClusteringOrder.NONE;
        }
        return this.type.isReversed() ? ClusteringOrder.DESC : ClusteringOrder.ASC;
    }

    public int position() {
        return this.position;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnDefinition)) {
            return false;
        }
        ColumnDefinition cd = (ColumnDefinition)o;
        return Objects.equal((Object)this.ksName, (Object)cd.ksName) && Objects.equal((Object)this.cfName, (Object)cd.cfName) && Objects.equal((Object)this.name, (Object)cd.name) && Objects.equal((Object)this.type, (Object)cd.type) && Objects.equal((Object)((Object)this.kind), (Object)((Object)cd.kind)) && Objects.equal((Object)this.position, (Object)cd.position);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ksName, this.cfName, this.name, this.type, this.kind, this.position});
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("kind", (Object)this.kind).add("position", this.position).toString();
    }

    public boolean isPrimaryKeyColumn() {
        return this.kind.isPrimaryKeyKind();
    }

    public boolean isPartOfCellName(boolean isCQL3Table, boolean isSuper) {
        if (isCQL3Table) {
            return this.kind == Kind.REGULAR || this.kind == Kind.STATIC;
        }
        if (isSuper) {
            return this.kind == Kind.REGULAR;
        }
        return this.kind == Kind.STATIC;
    }

    public static Collection<ColumnIdentifier> toIdentifiers(Collection<ColumnDefinition> definitions) {
        return Collections2.transform(definitions, (Function)new Function<ColumnDefinition, ColumnIdentifier>(){

            public ColumnIdentifier apply(ColumnDefinition columnDef) {
                return columnDef.name;
            }
        });
    }

    @Override
    public int compareTo(ColumnDefinition other) {
        if (this == other) {
            return 0;
        }
        if (this.comparisonOrder != other.comparisonOrder) {
            return Long.compare(this.comparisonOrder, other.comparisonOrder);
        }
        return this.name.compareTo(other.name);
    }

    public Comparator<CellPath> cellPathComparator() {
        return this.cellPathComparator;
    }

    public Comparator<Object> asymmetricCellPathComparator() {
        return this.asymmetricCellPathComparator;
    }

    public Comparator<? super Cell> cellComparator() {
        return this.cellComparator;
    }

    public boolean isComplex() {
        return this.cellPathComparator != null;
    }

    public boolean isSimple() {
        return !this.isComplex();
    }

    public CellPath.Serializer cellPathSerializer() {
        return CollectionType.cellPathSerializer;
    }

    public void validateCellValue(ByteBuffer value) {
        this.type.validateCellValue(value);
    }

    public void validateCellPath(CellPath path) {
        if (!this.isComplex()) {
            throw new MarshalException("Only complex cells should have a cell path");
        }
        assert (this.type instanceof CollectionType);
        ((CollectionType)this.type).nameComparator().validate(path.get(0));
    }

    public static String toCQLString(Iterable<ColumnDefinition> defs) {
        return ColumnDefinition.toCQLString(defs.iterator());
    }

    public static String toCQLString(Iterator<ColumnDefinition> defs) {
        if (!defs.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(defs.next().name);
        while (defs.hasNext()) {
            sb.append(", ").append(defs.next().name);
        }
        return sb.toString();
    }

    public AbstractType<?> cellValueType() {
        assert (!(this.type instanceof UserType) || !this.type.isMultiCell());
        return this.type instanceof CollectionType && this.type.isMultiCell() ? ((CollectionType)this.type).valueComparator() : this.type;
    }

    public boolean isCounterColumn() {
        if (this.type instanceof CollectionType) {
            return ((CollectionType)this.type).valueComparator().isCounter();
        }
        return this.type.isCounter();
    }

    public static enum Kind {
        PARTITION_KEY,
        CLUSTERING,
        REGULAR,
        STATIC;


        public boolean isPrimaryKeyKind() {
            return this == PARTITION_KEY || this == CLUSTERING;
        }
    }

    public static enum ClusteringOrder {
        ASC,
        DESC,
        NONE;

    }
}

