/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;

public class DynamicList<E> {
    private final int maxHeight;
    private final Node<E> head;
    private int size;

    public DynamicList(int maxExpectedSize) {
        this.maxHeight = 3 + Math.max(0, (int)Math.ceil(Math.log(maxExpectedSize) / Math.log(2.0)));
        this.head = new Node(this.maxHeight, null);
    }

    private int randomLevel() {
        return 1 + Integer.bitCount(ThreadLocalRandom.current().nextInt() & (1 << this.maxHeight - 1) - 1);
    }

    public Node<E> append(E value) {
        return this.append(value, Integer.MAX_VALUE);
    }

    public Node<E> append(E value, int maxSize) {
        Node next;
        Node newTail = new Node(this.randomLevel(), value);
        if (this.size >= maxSize) {
            return null;
        }
        ++this.size;
        Node tail = this.head;
        int i = this.maxHeight - 1;
        while (i >= newTail.height()) {
            while ((next = tail.next(i)) != null) {
                tail = next;
            }
            int[] nArray = tail.size;
            int n = i--;
            nArray[n] = nArray[n] + 1;
        }
        for (i = newTail.height() - 1; i >= 0; --i) {
            while ((next = tail.next(i)) != null) {
                tail = next;
            }
            tail.setNext(i, newTail);
            newTail.setPrev(i, tail);
        }
        return newTail;
    }

    public void remove(Node<E> node) {
        int i;
        assert (node.value != null);
        node.value = null;
        --this.size;
        for (i = 0; i < node.height(); ++i) {
            Node prev = node.prev(i);
            Node next = node.next(i);
            assert (prev != null);
            prev.setNext(i, next);
            if (next != null) {
                next.setPrev(i, prev);
            }
            int[] nArray = prev.size;
            int n = i;
            nArray[n] = nArray[n] + (node.size[i] - 1);
        }
        i = node.height();
        while (i < this.maxHeight) {
            while (i == node.height()) {
                node = node.prev(i - 1);
            }
            int[] nArray = node.size;
            int n = i++;
            nArray[n] = nArray[n] - 1;
        }
    }

    public E get(int index) {
        if (index >= this.size) {
            return null;
        }
        ++index;
        int c = 0;
        Node finger = this.head;
        for (int i = this.maxHeight - 1; i >= 0; --i) {
            while (c + finger.size[i] <= index) {
                c += finger.size[i];
                finger = finger.next(i);
            }
        }
        assert (c == index);
        return (E)finger.value;
    }

    public int size() {
        return this.size;
    }

    private boolean isWellFormed() {
        for (int i = 0; i < this.maxHeight; ++i) {
            int c = 0;
            Node node = this.head;
            while (node != null) {
                if (node.prev(i) != null && ((Node)node.prev(i)).next(i) != node) {
                    return false;
                }
                if (node.next(i) != null && ((Node)node.next(i)).prev(i) != node) {
                    return false;
                }
                c += node.size[i];
                if (i + 1 < this.maxHeight && node.parent(i + 1).next(i + 1) == node.next(i)) {
                    if (node.parent(i + 1).size[i + 1] != c) {
                        return false;
                    }
                    c = 0;
                }
                node = node.next(i);
            }
            if (i != this.maxHeight - 1 || c == this.size + 1) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        DynamicList<Integer> list = new DynamicList<Integer>(20);
        TreeSet<Integer> canon = new TreeSet<Integer>();
        HashMap<Integer, Node<Integer>> nodes = new HashMap<Integer, Node<Integer>>();
        int c = 0;
        for (int i = 0; i < 100000; ++i) {
            nodes.put(c, list.append(c));
            canon.add(c);
            ++c;
        }
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        assert (super.isWellFormed());
        for (int loop = 0; loop < 100; ++loop) {
            System.out.println(loop);
            for (int i = 0; i < 100000; ++i) {
                int index = rand.nextInt(100000);
                Integer seed = (Integer)list.get(index);
                list.remove((Node)nodes.remove(seed));
                canon.remove(seed);
                nodes.put(c, list.append(c));
                canon.add(c);
                ++c;
            }
            assert (super.isWellFormed());
        }
    }

    public static class Node<E> {
        private final int[] size;
        private final Node<E>[] links;
        private E value;

        private Node(int height, E value) {
            this.value = value;
            this.links = new Node[height * 2];
            this.size = new int[height];
            Arrays.fill(this.size, 1);
        }

        private int height() {
            return this.size.length;
        }

        private Node<E> next(int i) {
            return this.links[i * 2];
        }

        private Node<E> prev(int i) {
            return this.links[1 + i * 2];
        }

        private void setNext(int i, Node<E> next) {
            this.links[i * 2] = next;
        }

        private void setPrev(int i, Node<E> prev) {
            this.links[1 + i * 2] = prev;
        }

        private Node parent(int parentHeight) {
            Node<E> prev = this;
            int height;
            while (parentHeight >= (height = prev.height())) {
                prev = prev.prev(height - 1);
            }
            return prev;
        }
    }
}

