/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.Timer;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.LatencyMetrics;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.TopKSampler;

public class TableMetrics {
    public final Gauge<Long> memtableOnHeapSize;
    public final Gauge<Long> memtableOffHeapSize;
    public final Gauge<Long> memtableLiveDataSize;
    public final Gauge<Long> allMemtablesOnHeapSize;
    public final Gauge<Long> allMemtablesOffHeapSize;
    public final Gauge<Long> allMemtablesLiveDataSize;
    public final Gauge<Long> memtableColumnsCount;
    public final Counter memtableSwitchCount;
    public final Gauge<Double> compressionRatio;
    public final Gauge<long[]> estimatedPartitionSizeHistogram;
    public final Gauge<Long> estimatedPartitionCount;
    public final Gauge<long[]> estimatedColumnCountHistogram;
    public final TableHistogram sstablesPerReadHistogram;
    public final LatencyMetrics readLatency;
    public final LatencyMetrics rangeLatency;
    public final LatencyMetrics writeLatency;
    public final Counter pendingFlushes;
    public final Gauge<Integer> pendingCompactions;
    public final Gauge<Integer> liveSSTableCount;
    public final Counter liveDiskSpaceUsed;
    public final Counter totalDiskSpaceUsed;
    public final Gauge<Long> minPartitionSize;
    public final Gauge<Long> maxPartitionSize;
    public final Gauge<Long> meanPartitionSize;
    public final Gauge<Long> bloomFilterFalsePositives;
    public final Gauge<Long> recentBloomFilterFalsePositives;
    public final Gauge<Double> bloomFilterFalseRatio;
    public final Gauge<Double> recentBloomFilterFalseRatio;
    public final Gauge<Long> bloomFilterDiskSpaceUsed;
    public final Gauge<Long> bloomFilterOffHeapMemoryUsed;
    public final Gauge<Long> indexSummaryOffHeapMemoryUsed;
    public final Gauge<Long> compressionMetadataOffHeapMemoryUsed;
    public final Gauge<Double> keyCacheHitRate;
    public final TableHistogram tombstoneScannedHistogram;
    public final TableHistogram liveScannedHistogram;
    public final TableHistogram colUpdateTimeDeltaHistogram;
    public final TableTimer viewLockAcquireTime;
    public final TableTimer viewReadTime;
    public final Gauge<Long> trueSnapshotsSize;
    public final Counter rowCacheHitOutOfRange;
    public final Counter rowCacheHit;
    public final Counter rowCacheMiss;
    public final LatencyMetrics casPrepare;
    public final LatencyMetrics casPropose;
    public final LatencyMetrics casCommit;
    public final Timer coordinatorReadLatency;
    public final Timer coordinatorScanLatency;
    public final Histogram waitingOnFreeMemtableSpace;
    private final MetricNameFactory factory;
    private final MetricNameFactory aliasFactory;
    private static final MetricNameFactory globalFactory = new AllTableMetricNameFactory("Table");
    private static final MetricNameFactory globalAliasFactory = new AllTableMetricNameFactory("ColumnFamily");
    public final Counter speculativeRetries;
    public static final LatencyMetrics globalReadLatency = new LatencyMetrics(globalFactory, globalAliasFactory, "Read");
    public static final LatencyMetrics globalWriteLatency = new LatencyMetrics(globalFactory, globalAliasFactory, "Write");
    public static final LatencyMetrics globalRangeLatency = new LatencyMetrics(globalFactory, globalAliasFactory, "Range");
    public final Meter readRepairRequests;
    public final Meter shortReadProtectionRequests;
    public final Map<Sampler, TopKSampler<ByteBuffer>> samplers;
    public static final ConcurrentMap<String, Set<Metric>> allTableMetrics = Maps.newConcurrentMap();
    public static final Map<String, String> all = Maps.newHashMap();

    private static long[] combineHistograms(Iterable<SSTableReader> sstables, GetHistogram getHistogram) {
        Iterator<SSTableReader> iterator = sstables.iterator();
        if (!iterator.hasNext()) {
            return new long[0];
        }
        long[] firstBucket = getHistogram.getHistogram(iterator.next()).getBuckets(false);
        long[] values = new long[firstBucket.length];
        System.arraycopy(firstBucket, 0, values, 0, values.length);
        while (iterator.hasNext()) {
            long[] nextBucket = getHistogram.getHistogram(iterator.next()).getBuckets(false);
            if (nextBucket.length > values.length) {
                long[] newValues = new long[nextBucket.length];
                System.arraycopy(firstBucket, 0, newValues, 0, firstBucket.length);
                for (int i = 0; i < newValues.length; ++i) {
                    int n = i;
                    newValues[n] = newValues[n] + nextBucket[i];
                }
                values = newValues;
                continue;
            }
            for (int i = 0; i < values.length; ++i) {
                int n = i;
                values[n] = values[n] + nextBucket[i];
            }
        }
        return values;
    }

    public TableMetrics(final ColumnFamilyStore cfs) {
        this.factory = new TableMetricNameFactory(cfs, "Table");
        this.aliasFactory = new TableMetricNameFactory(cfs, "ColumnFamily");
        this.samplers = Maps.newHashMap();
        for (Sampler sampler : Sampler.values()) {
            this.samplers.put(sampler, new TopKSampler());
        }
        this.memtableColumnsCount = this.createTableGauge("MemtableColumnsCount", new Gauge<Long>(){

            public Long getValue() {
                return cfs.getTracker().getView().getCurrentMemtable().getOperations();
            }
        });
        this.memtableOnHeapSize = this.createTableGauge("MemtableOnHeapSize", new Gauge<Long>(){

            public Long getValue() {
                return cfs.getTracker().getView().getCurrentMemtable().getAllocator().onHeap().owns();
            }
        });
        this.memtableOffHeapSize = this.createTableGauge("MemtableOffHeapSize", new Gauge<Long>(){

            public Long getValue() {
                return cfs.getTracker().getView().getCurrentMemtable().getAllocator().offHeap().owns();
            }
        });
        this.memtableLiveDataSize = this.createTableGauge("MemtableLiveDataSize", new Gauge<Long>(){

            public Long getValue() {
                return cfs.getTracker().getView().getCurrentMemtable().getLiveDataSize();
            }
        });
        this.allMemtablesOnHeapSize = this.createTableGauge("AllMemtablesHeapSize", new Gauge<Long>(){

            public Long getValue() {
                long size = 0L;
                for (ColumnFamilyStore cfs2 : cfs.concatWithIndexes()) {
                    size += cfs2.getTracker().getView().getCurrentMemtable().getAllocator().onHeap().owns();
                }
                return size;
            }
        });
        this.allMemtablesOffHeapSize = this.createTableGauge("AllMemtablesOffHeapSize", new Gauge<Long>(){

            public Long getValue() {
                long size = 0L;
                for (ColumnFamilyStore cfs2 : cfs.concatWithIndexes()) {
                    size += cfs2.getTracker().getView().getCurrentMemtable().getAllocator().offHeap().owns();
                }
                return size;
            }
        });
        this.allMemtablesLiveDataSize = this.createTableGauge("AllMemtablesLiveDataSize", new Gauge<Long>(){

            public Long getValue() {
                long size = 0L;
                for (ColumnFamilyStore cfs2 : cfs.concatWithIndexes()) {
                    size += cfs2.getTracker().getView().getCurrentMemtable().getLiveDataSize();
                }
                return size;
            }
        });
        this.memtableSwitchCount = this.createTableCounter("MemtableSwitchCount");
        this.estimatedPartitionSizeHistogram = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("EstimatedPartitionSizeHistogram"), this.aliasFactory.createMetricName("EstimatedRowSizeHistogram"), new Gauge<long[]>(){

            public long[] getValue() {
                return TableMetrics.combineHistograms(cfs.getSSTables(SSTableSet.CANONICAL), new GetHistogram(){

                    @Override
                    public EstimatedHistogram getHistogram(SSTableReader reader) {
                        return reader.getEstimatedPartitionSize();
                    }
                });
            }
        });
        this.estimatedPartitionCount = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("EstimatedPartitionCount"), this.aliasFactory.createMetricName("EstimatedRowCount"), new Gauge<Long>(){

            public Long getValue() {
                long memtablePartitions = 0L;
                for (Memtable memtable : cfs.getTracker().getView().getAllMemtables()) {
                    memtablePartitions += (long)memtable.partitionCount();
                }
                return SSTableReader.getApproximateKeyCount(cfs.getSSTables(SSTableSet.CANONICAL)) + memtablePartitions;
            }
        });
        this.estimatedColumnCountHistogram = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("EstimatedColumnCountHistogram"), this.aliasFactory.createMetricName("EstimatedColumnCountHistogram"), new Gauge<long[]>(){

            public long[] getValue() {
                return TableMetrics.combineHistograms(cfs.getSSTables(SSTableSet.CANONICAL), new GetHistogram(){

                    @Override
                    public EstimatedHistogram getHistogram(SSTableReader reader) {
                        return reader.getEstimatedColumnCount();
                    }
                });
            }
        });
        this.sstablesPerReadHistogram = this.createTableHistogram("SSTablesPerReadHistogram", cfs.keyspace.metric.sstablesPerReadHistogram, true);
        this.compressionRatio = this.createTableGauge("CompressionRatio", new Gauge<Double>(){

            public Double getValue() {
                double sum = 0.0;
                int total = 0;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.CANONICAL)) {
                    if (sstable.getCompressionRatio() == -1.0) continue;
                    sum += sstable.getCompressionRatio();
                    ++total;
                }
                return total != 0 ? sum / (double)total : 0.0;
            }
        }, new Gauge<Double>(){

            public Double getValue() {
                double sum = 0.0;
                int total = 0;
                for (Keyspace keyspace : Keyspace.all()) {
                    for (SSTableReader sstable : keyspace.getAllSSTables(SSTableSet.CANONICAL)) {
                        if (sstable.getCompressionRatio() == -1.0) continue;
                        sum += sstable.getCompressionRatio();
                        ++total;
                    }
                }
                return total != 0 ? sum / (double)total : 0.0;
            }
        });
        this.readLatency = new LatencyMetrics(this.factory, "Read", cfs.keyspace.metric.readLatency, globalReadLatency);
        this.writeLatency = new LatencyMetrics(this.factory, "Write", cfs.keyspace.metric.writeLatency, globalWriteLatency);
        this.rangeLatency = new LatencyMetrics(this.factory, "Range", cfs.keyspace.metric.rangeLatency, globalRangeLatency);
        this.pendingFlushes = this.createTableCounter("PendingFlushes");
        this.pendingCompactions = this.createTableGauge("PendingCompactions", new Gauge<Integer>(){

            public Integer getValue() {
                return cfs.getCompactionStrategyManager().getEstimatedRemainingTasks();
            }
        });
        this.liveSSTableCount = this.createTableGauge("LiveSSTableCount", new Gauge<Integer>(){

            public Integer getValue() {
                return cfs.getTracker().getView().liveSSTables().size();
            }
        });
        this.liveDiskSpaceUsed = this.createTableCounter("LiveDiskSpaceUsed");
        this.totalDiskSpaceUsed = this.createTableCounter("TotalDiskSpaceUsed");
        this.minPartitionSize = this.createTableGauge("MinPartitionSize", "MinRowSize", new Gauge<Long>(){

            public Long getValue() {
                long min = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.CANONICAL)) {
                    if (min != 0L && sstable.getEstimatedPartitionSize().min() >= min) continue;
                    min = sstable.getEstimatedPartitionSize().min();
                }
                return min;
            }
        }, new Gauge<Long>(){

            public Long getValue() {
                long min = Long.MAX_VALUE;
                for (Metric cfGauge : (Set)allTableMetrics.get("MinPartitionSize")) {
                    min = Math.min(min, ((Number)((Gauge)cfGauge).getValue()).longValue());
                }
                return min;
            }
        });
        this.maxPartitionSize = this.createTableGauge("MaxPartitionSize", "MaxRowSize", new Gauge<Long>(){

            public Long getValue() {
                long max = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.CANONICAL)) {
                    if (sstable.getEstimatedPartitionSize().max() <= max) continue;
                    max = sstable.getEstimatedPartitionSize().max();
                }
                return max;
            }
        }, new Gauge<Long>(){

            public Long getValue() {
                long max = 0L;
                for (Metric cfGauge : (Set)allTableMetrics.get("MaxPartitionSize")) {
                    max = Math.max(max, ((Number)((Gauge)cfGauge).getValue()).longValue());
                }
                return max;
            }
        });
        this.meanPartitionSize = this.createTableGauge("MeanPartitionSize", "MeanRowSize", new Gauge<Long>(){

            public Long getValue() {
                long sum = 0L;
                long count = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.CANONICAL)) {
                    long n = sstable.getEstimatedPartitionSize().count();
                    sum += sstable.getEstimatedPartitionSize().mean() * n;
                    count += n;
                }
                return count > 0L ? sum / count : 0L;
            }
        }, new Gauge<Long>(){

            public Long getValue() {
                long sum = 0L;
                long count = 0L;
                for (Keyspace keyspace : Keyspace.all()) {
                    for (SSTableReader sstable : keyspace.getAllSSTables(SSTableSet.CANONICAL)) {
                        long n = sstable.getEstimatedPartitionSize().count();
                        sum += sstable.getEstimatedPartitionSize().mean() * n;
                        count += n;
                    }
                }
                return count > 0L ? sum / count : 0L;
            }
        });
        this.bloomFilterFalsePositives = this.createTableGauge("BloomFilterFalsePositives", new Gauge<Long>(){

            public Long getValue() {
                long count = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.LIVE)) {
                    count += sstable.getBloomFilterFalsePositiveCount();
                }
                return count;
            }
        });
        this.recentBloomFilterFalsePositives = this.createTableGauge("RecentBloomFilterFalsePositives", new Gauge<Long>(){

            public Long getValue() {
                long count = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.LIVE)) {
                    count += sstable.getRecentBloomFilterFalsePositiveCount();
                }
                return count;
            }
        });
        this.bloomFilterFalseRatio = this.createTableGauge("BloomFilterFalseRatio", new Gauge<Double>(){

            public Double getValue() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.LIVE)) {
                    falseCount += sstable.getBloomFilterFalsePositiveCount();
                    trueCount += sstable.getBloomFilterTruePositiveCount();
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        }, new Gauge<Double>(){

            public Double getValue() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (Keyspace keyspace : Keyspace.all()) {
                    for (SSTableReader sstable : keyspace.getAllSSTables(SSTableSet.LIVE)) {
                        falseCount += sstable.getBloomFilterFalsePositiveCount();
                        trueCount += sstable.getBloomFilterTruePositiveCount();
                    }
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        });
        this.recentBloomFilterFalseRatio = this.createTableGauge("RecentBloomFilterFalseRatio", new Gauge<Double>(){

            public Double getValue() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.LIVE)) {
                    falseCount += sstable.getRecentBloomFilterFalsePositiveCount();
                    trueCount += sstable.getRecentBloomFilterTruePositiveCount();
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        }, new Gauge<Double>(){

            public Double getValue() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (Keyspace keyspace : Keyspace.all()) {
                    for (SSTableReader sstable : keyspace.getAllSSTables(SSTableSet.LIVE)) {
                        falseCount += sstable.getRecentBloomFilterFalsePositiveCount();
                        trueCount += sstable.getRecentBloomFilterTruePositiveCount();
                    }
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        });
        this.bloomFilterDiskSpaceUsed = this.createTableGauge("BloomFilterDiskSpaceUsed", new Gauge<Long>(){

            public Long getValue() {
                long total = 0L;
                for (SSTableReader sst : cfs.getSSTables(SSTableSet.CANONICAL)) {
                    total += sst.getBloomFilterSerializedSize();
                }
                return total;
            }
        });
        this.bloomFilterOffHeapMemoryUsed = this.createTableGauge("BloomFilterOffHeapMemoryUsed", new Gauge<Long>(){

            public Long getValue() {
                long total = 0L;
                for (SSTableReader sst : cfs.getSSTables(SSTableSet.LIVE)) {
                    total += sst.getBloomFilterOffHeapSize();
                }
                return total;
            }
        });
        this.indexSummaryOffHeapMemoryUsed = this.createTableGauge("IndexSummaryOffHeapMemoryUsed", new Gauge<Long>(){

            public Long getValue() {
                long total = 0L;
                for (SSTableReader sst : cfs.getSSTables(SSTableSet.LIVE)) {
                    total += sst.getIndexSummaryOffHeapSize();
                }
                return total;
            }
        });
        this.compressionMetadataOffHeapMemoryUsed = this.createTableGauge("CompressionMetadataOffHeapMemoryUsed", new Gauge<Long>(){

            public Long getValue() {
                long total = 0L;
                for (SSTableReader sst : cfs.getSSTables(SSTableSet.LIVE)) {
                    total += sst.getCompressionMetadataOffHeapSize();
                }
                return total;
            }
        });
        this.speculativeRetries = this.createTableCounter("SpeculativeRetries");
        this.keyCacheHitRate = (Gauge)CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("KeyCacheHitRate"), this.aliasFactory.createMetricName("KeyCacheHitRate"), new RatioGauge(){

            public RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)this.getNumerator(), (double)this.getDenominator());
            }

            protected double getNumerator() {
                long hits = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.LIVE)) {
                    hits += sstable.getKeyCacheHit();
                }
                return hits;
            }

            protected double getDenominator() {
                long requests = 0L;
                for (SSTableReader sstable : cfs.getSSTables(SSTableSet.LIVE)) {
                    requests += sstable.getKeyCacheRequest();
                }
                return Math.max(requests, 1L);
            }
        });
        this.tombstoneScannedHistogram = this.createTableHistogram("TombstoneScannedHistogram", cfs.keyspace.metric.tombstoneScannedHistogram, false);
        this.liveScannedHistogram = this.createTableHistogram("LiveScannedHistogram", cfs.keyspace.metric.liveScannedHistogram, false);
        this.colUpdateTimeDeltaHistogram = this.createTableHistogram("ColUpdateTimeDeltaHistogram", cfs.keyspace.metric.colUpdateTimeDeltaHistogram, false);
        this.coordinatorReadLatency = CassandraMetricsRegistry.Metrics.timer(this.factory.createMetricName("CoordinatorReadLatency"));
        this.coordinatorScanLatency = CassandraMetricsRegistry.Metrics.timer(this.factory.createMetricName("CoordinatorScanLatency"));
        this.waitingOnFreeMemtableSpace = CassandraMetricsRegistry.Metrics.histogram(this.factory.createMetricName("WaitingOnFreeMemtableSpace"), false);
        if (cfs.metadata.isView()) {
            this.viewLockAcquireTime = null;
            this.viewReadTime = null;
        } else {
            this.viewLockAcquireTime = this.createTableTimer("ViewLockAcquireTime", cfs.keyspace.metric.viewLockAcquireTime);
            this.viewReadTime = this.createTableTimer("ViewReadTime", cfs.keyspace.metric.viewReadTime);
        }
        this.trueSnapshotsSize = this.createTableGauge("SnapshotsSize", new Gauge<Long>(){

            public Long getValue() {
                return cfs.trueSnapshotsSize();
            }
        });
        this.rowCacheHitOutOfRange = this.createTableCounter("RowCacheHitOutOfRange");
        this.rowCacheHit = this.createTableCounter("RowCacheHit");
        this.rowCacheMiss = this.createTableCounter("RowCacheMiss");
        this.casPrepare = new LatencyMetrics(this.factory, "CasPrepare", cfs.keyspace.metric.casPrepare);
        this.casPropose = new LatencyMetrics(this.factory, "CasPropose", cfs.keyspace.metric.casPropose);
        this.casCommit = new LatencyMetrics(this.factory, "CasCommit", cfs.keyspace.metric.casCommit);
        this.readRepairRequests = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("ReadRepairRequests"));
        this.shortReadProtectionRequests = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("ShortReadProtectionRequests"));
    }

    public void updateSSTableIterated(int count) {
        this.sstablesPerReadHistogram.update(count);
    }

    public void release() {
        for (Map.Entry<String, String> entry : all.entrySet()) {
            CassandraMetricsRegistry.MetricName name = this.factory.createMetricName(entry.getKey());
            Metric metric = (Metric)CassandraMetricsRegistry.Metrics.getMetrics().get(name.getMetricName());
            if (metric == null) continue;
            CassandraMetricsRegistry.MetricName alias = this.aliasFactory.createMetricName(entry.getValue());
            ((Set)allTableMetrics.get(entry.getKey())).remove(metric);
            CassandraMetricsRegistry.Metrics.remove(name, alias);
        }
        this.readLatency.release();
        this.writeLatency.release();
        this.rangeLatency.release();
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("EstimatedPartitionSizeHistogram"), this.aliasFactory.createMetricName("EstimatedRowSizeHistogram"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("EstimatedPartitionCount"), this.aliasFactory.createMetricName("EstimatedRowCount"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("EstimatedColumnCountHistogram"), this.aliasFactory.createMetricName("EstimatedColumnCountHistogram"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("KeyCacheHitRate"), this.aliasFactory.createMetricName("KeyCacheHitRate"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("CoordinatorReadLatency"), this.aliasFactory.createMetricName("CoordinatorReadLatency"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("CoordinatorScanLatency"), this.aliasFactory.createMetricName("CoordinatorScanLatency"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("WaitingOnFreeMemtableSpace"), this.aliasFactory.createMetricName("WaitingOnFreeMemtableSpace"));
    }

    protected <T extends Number> Gauge<T> createTableGauge(final String name, Gauge<T> gauge) {
        return this.createTableGauge(name, gauge, new Gauge<Long>(){

            public Long getValue() {
                long total = 0L;
                for (Metric cfGauge : (Set)allTableMetrics.get(name)) {
                    total += ((Number)((Gauge)cfGauge).getValue()).longValue();
                }
                return total;
            }
        });
    }

    protected <G, T> Gauge<T> createTableGauge(String name, Gauge<T> gauge, Gauge<G> globalGauge) {
        return this.createTableGauge(name, name, gauge, globalGauge);
    }

    protected <G, T> Gauge<T> createTableGauge(String name, String alias, Gauge<T> gauge, Gauge<G> globalGauge) {
        Gauge<T> cfGauge = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias), gauge);
        if (this.register(name, alias, (Metric)cfGauge)) {
            CassandraMetricsRegistry.Metrics.register(globalFactory.createMetricName(name), globalAliasFactory.createMetricName(alias), globalGauge);
        }
        return cfGauge;
    }

    protected Counter createTableCounter(String name) {
        return this.createTableCounter(name, name);
    }

    protected Counter createTableCounter(final String name, String alias) {
        Counter cfCounter = CassandraMetricsRegistry.Metrics.counter(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias));
        if (this.register(name, alias, (Metric)cfCounter)) {
            CassandraMetricsRegistry.Metrics.register(globalFactory.createMetricName(name), globalAliasFactory.createMetricName(alias), new Gauge<Long>(){

                public Long getValue() {
                    long total = 0L;
                    for (Metric cfGauge : (Set)allTableMetrics.get(name)) {
                        total += ((Counter)cfGauge).getCount();
                    }
                    return total;
                }
            });
        }
        return cfCounter;
    }

    protected TableHistogram createTableHistogram(String name, Histogram keyspaceHistogram, boolean considerZeroes) {
        return this.createTableHistogram(name, name, keyspaceHistogram, considerZeroes);
    }

    protected TableHistogram createTableHistogram(String name, String alias, Histogram keyspaceHistogram, boolean considerZeroes) {
        Histogram cfHistogram = CassandraMetricsRegistry.Metrics.histogram(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias), considerZeroes);
        this.register(name, alias, (Metric)cfHistogram);
        return new TableHistogram(cfHistogram, keyspaceHistogram, CassandraMetricsRegistry.Metrics.histogram(globalFactory.createMetricName(name), globalAliasFactory.createMetricName(alias), considerZeroes));
    }

    protected TableTimer createTableTimer(String name, Timer keyspaceTimer) {
        return this.createTableTimer(name, name, keyspaceTimer);
    }

    protected TableTimer createTableTimer(String name, String alias, Timer keyspaceTimer) {
        Timer cfTimer = CassandraMetricsRegistry.Metrics.timer(this.factory.createMetricName(name), this.aliasFactory.createMetricName(alias));
        this.register(name, alias, (Metric)cfTimer);
        return new TableTimer(cfTimer, keyspaceTimer, CassandraMetricsRegistry.Metrics.timer(globalFactory.createMetricName(name), globalAliasFactory.createMetricName(alias)));
    }

    private boolean register(String name, String alias, Metric metric) {
        boolean ret = allTableMetrics.putIfAbsent(name, ConcurrentHashMap.newKeySet()) == null;
        ((Set)allTableMetrics.get(name)).add(metric);
        all.put(name, alias);
        return ret;
    }

    public static enum Sampler {
        READS,
        WRITES;

    }

    static class AllTableMetricNameFactory
    implements MetricNameFactory {
        private final String type;

        public AllTableMetricNameFactory(String type) {
            this.type = type;
        }

        @Override
        public CassandraMetricsRegistry.MetricName createMetricName(String metricName) {
            String groupName = TableMetrics.class.getPackage().getName();
            StringBuilder mbeanName = new StringBuilder();
            mbeanName.append(groupName).append(":");
            mbeanName.append("type=" + this.type);
            mbeanName.append(",name=").append(metricName);
            return new CassandraMetricsRegistry.MetricName(groupName, this.type, metricName, "all", mbeanName.toString());
        }
    }

    static class TableMetricNameFactory
    implements MetricNameFactory {
        private final String keyspaceName;
        private final String tableName;
        private final boolean isIndex;
        private final String type;

        TableMetricNameFactory(ColumnFamilyStore cfs, String type) {
            this.keyspaceName = cfs.keyspace.getName();
            this.tableName = cfs.name;
            this.isIndex = cfs.isIndex();
            this.type = type;
        }

        @Override
        public CassandraMetricsRegistry.MetricName createMetricName(String metricName) {
            String groupName = TableMetrics.class.getPackage().getName();
            String type = this.isIndex ? "Index" + this.type : this.type;
            StringBuilder mbeanName = new StringBuilder();
            mbeanName.append(groupName).append(":");
            mbeanName.append("type=").append(type);
            mbeanName.append(",keyspace=").append(this.keyspaceName);
            mbeanName.append(",scope=").append(this.tableName);
            mbeanName.append(",name=").append(metricName);
            return new CassandraMetricsRegistry.MetricName(groupName, type, metricName, this.keyspaceName + "." + this.tableName, mbeanName.toString());
        }
    }

    public static class TableTimer {
        public final Timer[] all;
        public final Timer cf;

        private TableTimer(Timer cf, Timer keyspace, Timer global) {
            this.cf = cf;
            this.all = new Timer[]{cf, keyspace, global};
        }

        public void update(long i, TimeUnit unit) {
            for (Timer timer : this.all) {
                timer.update(i, unit);
            }
        }
    }

    public static class TableHistogram {
        public final Histogram[] all;
        public final Histogram cf;

        private TableHistogram(Histogram cf, Histogram keyspace, Histogram global) {
            this.cf = cf;
            this.all = new Histogram[]{cf, keyspace, global};
        }

        public void update(long i) {
            for (Histogram histo : this.all) {
                histo.update(i);
            }
        }
    }

    private static interface GetHistogram {
        public EstimatedHistogram getHistogram(SSTableReader var1);
    }
}

