/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.Closeable;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataPosition;
import org.apache.cassandra.io.util.RewindableDataInput;
import org.apache.cassandra.utils.Throwables;

public class RewindableDataInputStreamPlus
extends FilterInputStream
implements RewindableDataInput,
Closeable {
    private boolean marked = false;
    private boolean exhausted = false;
    private AtomicBoolean closed = new AtomicBoolean(false);
    protected int memAvailable = 0;
    protected int diskTailAvailable = 0;
    protected int diskHeadAvailable = 0;
    private final File spillFile;
    private final int initialMemBufferSize;
    private final int maxMemBufferSize;
    private final int maxDiskBufferSize;
    private volatile byte[] memBuffer;
    private int memBufferSize;
    private RandomAccessFile spillBuffer;
    private final DataInputPlus dataReader = new DataInputPlus.DataInputStreamPlus(this);

    public RewindableDataInputStreamPlus(InputStream in, int initialMemBufferSize, int maxMemBufferSize, File spillFile, int maxDiskBufferSize) {
        super(in);
        this.initialMemBufferSize = initialMemBufferSize;
        this.maxMemBufferSize = maxMemBufferSize;
        this.spillFile = spillFile;
        this.maxDiskBufferSize = maxDiskBufferSize;
    }

    @Override
    public DataPosition mark() {
        this.mark(0);
        return new RewindableDataInputPlusMark();
    }

    @Override
    public void reset(DataPosition mark) throws IOException {
        this.reset();
    }

    @Override
    public long bytesPastMark(DataPosition mark) {
        return this.maxMemBufferSize - this.memAvailable + (this.diskTailAvailable == -1 ? 0 : this.maxDiskBufferSize - this.diskHeadAvailable - this.diskTailAvailable);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.marked) {
            throw new IllegalStateException("Cannot mark already marked stream.");
        }
        if (this.memAvailable > 0 || this.diskHeadAvailable > 0 || this.diskTailAvailable > 0) {
            throw new IllegalStateException("Can only mark stream after reading previously marked data.");
        }
        this.marked = true;
        this.memAvailable = this.maxMemBufferSize;
        this.diskHeadAvailable = -1;
        this.diskTailAvailable = -1;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.marked) {
            throw new IOException("Must call mark() before calling reset().");
        }
        if (this.exhausted) {
            throw new IOException(String.format("Read more than capacity: %d bytes.", this.maxMemBufferSize + this.maxDiskBufferSize));
        }
        this.memBufferSize = this.memAvailable = this.maxMemBufferSize - this.memAvailable;
        if (this.diskTailAvailable == -1) {
            this.diskHeadAvailable = 0;
            this.diskTailAvailable = 0;
        } else {
            int initialPos = this.diskTailAvailable > 0 ? 0 : (int)this.getIfNotClosed(this.spillBuffer).getFilePointer();
            int diskMarkpos = initialPos + this.diskHeadAvailable;
            this.getIfNotClosed(this.spillBuffer).seek(diskMarkpos);
            this.diskHeadAvailable = diskMarkpos - this.diskHeadAvailable;
            this.diskTailAvailable = this.maxDiskBufferSize - this.diskTailAvailable - diskMarkpos;
        }
        this.marked = false;
    }

    @Override
    public int available() throws IOException {
        return super.available() + (this.marked ? 0 : this.memAvailable + this.diskHeadAvailable + this.diskTailAvailable);
    }

    @Override
    public int read() throws IOException {
        int read = this.readOne();
        if (read == -1) {
            return read;
        }
        if (this.marked) {
            if (this.isExhausted(1)) {
                this.exhausted = true;
                return read;
            }
            this.writeOne(read);
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readBytes = this.readMulti(b, off, len);
        if (readBytes == -1) {
            return readBytes;
        }
        if (this.marked) {
            if (this.isExhausted(readBytes)) {
                this.exhausted = true;
                return readBytes;
            }
            this.writeMulti(b, off, readBytes);
        }
        return readBytes;
    }

    private void maybeCreateDiskBuffer() throws IOException {
        if (this.spillBuffer == null) {
            if (!this.spillFile.getParentFile().exists()) {
                this.spillFile.getParentFile().mkdirs();
            }
            this.spillFile.createNewFile();
            this.spillBuffer = new RandomAccessFile(this.spillFile, "rw");
        }
    }

    private int readOne() throws IOException {
        if (!this.marked) {
            if (this.memAvailable > 0) {
                int pos = this.memBufferSize - this.memAvailable;
                --this.memAvailable;
                return this.getIfNotClosed(this.memBuffer)[pos] & 0xFF;
            }
            if (this.diskTailAvailable > 0 || this.diskHeadAvailable > 0) {
                int read = this.getIfNotClosed(this.spillBuffer).read();
                if (this.diskTailAvailable > 0) {
                    --this.diskTailAvailable;
                } else if (this.diskHeadAvailable > 0) {
                    ++this.diskHeadAvailable;
                }
                if (this.diskTailAvailable == 0) {
                    this.spillBuffer.seek(0L);
                }
                return read;
            }
        }
        return this.getIfNotClosed(this.in).read();
    }

    private boolean isExhausted(int readBytes) {
        return this.exhausted || (long)readBytes > (long)this.memAvailable + (long)(this.diskTailAvailable == -1 ? this.maxDiskBufferSize : this.diskTailAvailable + this.diskHeadAvailable);
    }

    private int readMulti(byte[] b, int off, int len) throws IOException {
        int readBytes = 0;
        if (!this.marked) {
            if (this.memAvailable > 0) {
                int n = this.memAvailable < len ? this.memAvailable : len;
                int pos = this.memBufferSize - this.memAvailable;
                System.arraycopy(this.memBuffer, pos, b, off, readBytes += n);
                this.memAvailable -= readBytes;
                off += readBytes;
                len -= readBytes;
            }
            if (len > 0 && this.diskTailAvailable > 0) {
                int readFromTail = this.diskTailAvailable < len ? this.diskTailAvailable : len;
                this.getIfNotClosed(this.spillBuffer).read(b, off, readFromTail);
                readBytes += readFromTail;
                this.diskTailAvailable -= readFromTail;
                off += readFromTail;
                len -= readFromTail;
                if (this.diskTailAvailable == 0) {
                    this.spillBuffer.seek(0L);
                }
            }
            if (len > 0 && this.diskHeadAvailable > 0) {
                int readFromHead = this.diskHeadAvailable < len ? this.diskHeadAvailable : len;
                this.getIfNotClosed(this.spillBuffer).read(b, off, readFromHead);
                readBytes += readFromHead;
                this.diskHeadAvailable -= readFromHead;
                off += readFromHead;
                len -= readFromHead;
            }
        }
        if (len > 0) {
            readBytes += this.getIfNotClosed(this.in).read(b, off, len);
        }
        return readBytes;
    }

    private void writeMulti(byte[] b, int off, int len) throws IOException {
        if (this.memAvailable > 0) {
            int memWritten;
            if (this.memBuffer == null) {
                this.memBuffer = new byte[this.initialMemBufferSize];
            }
            int pos = this.maxMemBufferSize - this.memAvailable;
            int n = memWritten = this.memAvailable < len ? this.memAvailable : len;
            if (pos + memWritten >= this.getIfNotClosed(this.memBuffer).length) {
                this.growMemBuffer(pos, memWritten);
            }
            System.arraycopy(b, off, this.memBuffer, pos, memWritten);
            off += memWritten;
            len -= memWritten;
            this.memAvailable -= memWritten;
        }
        if (len > 0) {
            if (this.diskTailAvailable == -1) {
                this.maybeCreateDiskBuffer();
                this.diskHeadAvailable = (int)this.spillBuffer.getFilePointer();
                this.diskTailAvailable = this.maxDiskBufferSize - this.diskHeadAvailable;
            }
            if (len > 0 && this.diskTailAvailable > 0) {
                int diskTailWritten = this.diskTailAvailable < len ? this.diskTailAvailable : len;
                this.getIfNotClosed(this.spillBuffer).write(b, off, diskTailWritten);
                off += diskTailWritten;
                len -= diskTailWritten;
                this.diskTailAvailable -= diskTailWritten;
                if (this.diskTailAvailable == 0) {
                    this.spillBuffer.seek(0L);
                }
            }
            if (len > 0 && this.diskTailAvailable > 0) {
                int diskHeadWritten = this.diskHeadAvailable < len ? this.diskHeadAvailable : len;
                this.getIfNotClosed(this.spillBuffer).write(b, off, diskHeadWritten);
            }
        }
    }

    private void writeOne(int value) throws IOException {
        if (this.memAvailable > 0) {
            int pos;
            if (this.memBuffer == null) {
                this.memBuffer = new byte[this.initialMemBufferSize];
            }
            if ((pos = this.maxMemBufferSize - this.memAvailable) == this.getIfNotClosed(this.memBuffer).length) {
                this.growMemBuffer(pos, 1);
            }
            this.getIfNotClosed(this.memBuffer)[pos] = (byte)value;
            --this.memAvailable;
            return;
        }
        if (this.diskTailAvailable == -1) {
            this.maybeCreateDiskBuffer();
            this.diskHeadAvailable = (int)this.spillBuffer.getFilePointer();
            this.diskTailAvailable = this.maxDiskBufferSize - this.diskHeadAvailable;
        }
        if (this.diskTailAvailable > 0 || this.diskHeadAvailable > 0) {
            this.getIfNotClosed(this.spillBuffer).write(value);
            if (this.diskTailAvailable > 0) {
                --this.diskTailAvailable;
            } else if (this.diskHeadAvailable > 0) {
                --this.diskHeadAvailable;
            }
            if (this.diskTailAvailable == 0) {
                this.spillBuffer.seek(0L);
            }
            return;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private void growMemBuffer(int pos, int writeSize) {
        int newSize = Math.min(2 * (pos + writeSize), this.maxMemBufferSize);
        byte[] newBuffer = new byte[newSize];
        System.arraycopy(this.memBuffer, 0, newBuffer, 0, pos);
        this.memBuffer = newBuffer;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = 0L;
        if (this.marked) {
            while (n-- > 0L && this.read() != -1) {
                ++skipped;
            }
            return skipped;
        }
        if (this.memAvailable > 0) {
            this.memAvailable = (int)((long)this.memAvailable - (skipped += (long)this.memAvailable < n ? (long)this.memAvailable : n));
            n -= skipped;
        }
        if (n > 0L && this.diskTailAvailable > 0) {
            int skipFromTail = (long)this.diskTailAvailable < n ? this.diskTailAvailable : (int)n;
            this.getIfNotClosed(this.spillBuffer).skipBytes(skipFromTail);
            this.diskTailAvailable -= skipFromTail;
            skipped += (long)skipFromTail;
            n -= (long)skipFromTail;
            if (this.diskTailAvailable == 0) {
                this.spillBuffer.seek(0L);
            }
        }
        if (n > 0L && this.diskHeadAvailable > 0) {
            int skipFromHead = (long)this.diskHeadAvailable < n ? this.diskHeadAvailable : (int)n;
            this.getIfNotClosed(this.spillBuffer).skipBytes(skipFromHead);
            this.diskHeadAvailable -= skipFromHead;
            skipped += (long)skipFromHead;
            n -= (long)skipFromHead;
        }
        if (n > 0L) {
            skipped += this.getIfNotClosed(this.in).skip(n);
        }
        return skipped;
    }

    private <T> T getIfNotClosed(T in) throws IOException {
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
        return in;
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean closeUnderlying) throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            Throwable fail = null;
            if (closeUnderlying) {
                try {
                    super.close();
                }
                catch (IOException e) {
                    fail = Throwables.merge(fail, e);
                }
            }
            try {
                if (this.spillBuffer != null) {
                    this.spillBuffer.close();
                    this.spillBuffer = null;
                }
            }
            catch (IOException e) {
                fail = Throwables.merge(fail, e);
            }
            try {
                if (this.spillFile.exists()) {
                    this.spillFile.delete();
                }
            }
            catch (Throwable e) {
                fail = Throwables.merge(fail, e);
            }
            Throwables.maybeFail(fail, IOException.class);
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.dataReader.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.dataReader.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.dataReader.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.dataReader.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.dataReader.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.dataReader.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.dataReader.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.dataReader.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.dataReader.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.dataReader.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.dataReader.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.dataReader.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.dataReader.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.dataReader.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.dataReader.readUTF();
    }

    protected static class RewindableDataInputPlusMark
    implements DataPosition {
        protected RewindableDataInputPlusMark() {
        }
    }
}

