/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.internal.keys;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.ImmutableBTreePartition;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.index.internal.CassandraIndex;
import org.apache.cassandra.index.internal.CassandraIndexSearcher;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeysSearcher
extends CassandraIndexSearcher {
    private static final Logger logger = LoggerFactory.getLogger(KeysSearcher.class);

    public KeysSearcher(ReadCommand command, RowFilter.Expression expression, CassandraIndex indexer) {
        super(command, expression, indexer);
    }

    @Override
    protected UnfilteredPartitionIterator queryDataFromIndex(final DecoratedKey indexKey, final RowIterator indexHits, final ReadCommand command, final ReadOrderGroup orderGroup) {
        assert (indexHits.staticRow() == Rows.EMPTY_STATIC_ROW);
        return new UnfilteredPartitionIterator(){
            private UnfilteredRowIterator next;

            @Override
            public boolean isForThrift() {
                return command.isForThrift();
            }

            @Override
            public CFMetaData metadata() {
                return command.metadata();
            }

            @Override
            public boolean hasNext() {
                return this.prepareNext();
            }

            @Override
            public UnfilteredRowIterator next() {
                if (this.next == null) {
                    this.prepareNext();
                }
                UnfilteredRowIterator toReturn = this.next;
                this.next = null;
                return toReturn;
            }

            private boolean prepareNext() {
                while (this.next == null && indexHits.hasNext()) {
                    Row hit = (Row)indexHits.next();
                    DecoratedKey key = ((KeysSearcher)KeysSearcher.this).index.baseCfs.decorateKey(hit.clustering().get(0));
                    if (!command.selectsKey(key)) continue;
                    ColumnFilter extendedFilter = KeysSearcher.this.getExtendedFilter(command.columnFilter());
                    SinglePartitionReadCommand dataCmd = SinglePartitionReadCommand.create(this.isForThrift(), ((KeysSearcher)KeysSearcher.this).index.baseCfs.metadata, command.nowInSec(), extendedFilter, command.rowFilter(), DataLimits.NONE, key, command.clusteringIndexFilter(key), null);
                    UnfilteredRowIterator dataIter = KeysSearcher.this.filterIfStale(dataCmd.queryMemtableAndDisk(((KeysSearcher)KeysSearcher.this).index.baseCfs, orderGroup.baseReadOpOrderGroup()), hit, indexKey.getKey(), orderGroup.writeOpOrderGroup(), this.isForThrift(), command.nowInSec());
                    if (dataIter == null) continue;
                    if (dataIter.isEmpty()) {
                        dataIter.close();
                        continue;
                    }
                    this.next = dataIter;
                }
                return this.next != null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                indexHits.close();
                if (this.next != null) {
                    this.next.close();
                }
            }
        };
    }

    private ColumnFilter getExtendedFilter(ColumnFilter initialFilter) {
        if (this.command.columnFilter().includes(this.index.getIndexedColumn())) {
            return initialFilter;
        }
        ColumnFilter.Builder builder = ColumnFilter.selectionBuilder();
        builder.addAll(initialFilter.fetchedColumns());
        builder.add(this.index.getIndexedColumn());
        return builder.build();
    }

    private UnfilteredRowIterator filterIfStale(UnfilteredRowIterator iterator, Row indexHit, ByteBuffer indexedValue, OpOrder.Group writeOp, boolean isForThrift, int nowInSec) {
        if (isForThrift) {
            ImmutableBTreePartition result = ImmutableBTreePartition.create(iterator);
            iterator.close();
            Row data = result.getRow(new Clustering(this.index.getIndexedColumn().name.bytes));
            if (data == null) {
                return null;
            }
            Cell baseData = data.getCell(this.index.baseCfs.metadata.compactValueColumn());
            if (baseData == null || !baseData.isLive(nowInSec) || this.index.getIndexedColumn().type.compare(indexedValue, baseData.value()) != 0) {
                this.index.deleteStaleEntry(this.index.getIndexCfs().decorateKey(indexedValue), new Clustering(this.index.getIndexedColumn().name.bytes), new DeletionTime(indexHit.primaryKeyLivenessInfo().timestamp(), nowInSec), writeOp);
                return null;
            }
            if (this.command.columnFilter().includes(this.index.getIndexedColumn())) {
                return result.unfilteredIterator();
            }
            ClusteringComparator comparator = result.metadata().comparator;
            Slices.Builder slices = new Slices.Builder(comparator);
            for (ColumnDefinition selected : this.command.columnFilter().fetchedColumns()) {
                slices.add(Slice.make(comparator, selected.name.bytes));
            }
            return result.unfilteredIterator(ColumnFilter.all(this.command.metadata()), slices.build(), false);
        }
        assert (iterator.metadata().isCompactTable());
        Row data = iterator.staticRow();
        if (this.index.isStale(data, indexedValue, nowInSec)) {
            this.index.deleteStaleEntry(this.index.getIndexCfs().decorateKey(indexedValue), this.makeIndexClustering(iterator.partitionKey().getKey(), Clustering.EMPTY), new DeletionTime(indexHit.primaryKeyLivenessInfo().timestamp(), nowInSec), writeOp);
            iterator.close();
            return null;
        }
        return iterator;
    }
}

