/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Objects;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ObjectSizes;

public abstract class AbstractClusteringPrefix
implements ClusteringPrefix {
    protected static final ByteBuffer[] EMPTY_VALUES_ARRAY = new ByteBuffer[0];
    private static final long EMPTY_SIZE = ObjectSizes.measure(new Clustering(EMPTY_VALUES_ARRAY));
    protected final ClusteringPrefix.Kind kind;
    protected final ByteBuffer[] values;

    protected AbstractClusteringPrefix(ClusteringPrefix.Kind kind, ByteBuffer[] values) {
        this.kind = kind;
        this.values = values;
    }

    @Override
    public ClusteringPrefix.Kind kind() {
        return this.kind;
    }

    @Override
    public ClusteringPrefix clustering() {
        return this;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public ByteBuffer get(int i) {
        return this.values[i];
    }

    @Override
    public ByteBuffer[] getRawValues() {
        return this.values;
    }

    @Override
    public int dataSize() {
        int size = 0;
        for (int i = 0; i < this.size(); ++i) {
            ByteBuffer bb = this.get(i);
            size += bb == null ? 0 : bb.remaining();
        }
        return size;
    }

    @Override
    public void digest(MessageDigest digest) {
        for (int i = 0; i < this.size(); ++i) {
            ByteBuffer bb = this.get(i);
            if (bb == null) continue;
            digest.update(bb.duplicate());
        }
        FBUtilities.updateWithByte(digest, this.kind().ordinal());
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapOf(this.values);
    }

    public long unsharedHeapSizeExcludingData() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapExcludingData(this.values);
    }

    public final int hashCode() {
        int result = 31;
        for (int i = 0; i < this.size(); ++i) {
            result += 31 * Objects.hashCode(this.get(i));
        }
        return 31 * result + Objects.hashCode((Object)this.kind());
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ClusteringPrefix)) {
            return false;
        }
        ClusteringPrefix that = (ClusteringPrefix)o;
        if (this.kind() != that.kind() || this.size() != that.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (Objects.equals(this.get(i), that.get(i))) continue;
            return false;
        }
        return true;
    }
}

