/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import org.apache.cassandra.utils.CLibraryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLibraryDarwin
implements CLibraryWrapper {
    private static final Logger logger = LoggerFactory.getLogger(CLibraryDarwin.class);
    private static boolean jnaAvailable = true;

    private static native int mlockall(int var0) throws LastErrorException;

    private static native int munlockall() throws LastErrorException;

    private static native int fcntl(int var0, int var1, long var2) throws LastErrorException;

    private static native int open(String var0, int var1) throws LastErrorException;

    private static native int fsync(int var0) throws LastErrorException;

    private static native int close(int var0) throws LastErrorException;

    private static native Pointer strerror(int var0) throws LastErrorException;

    private static native long getpid() throws LastErrorException;

    @Override
    public int callMlockall(int flags) throws UnsatisfiedLinkError, RuntimeException {
        return CLibraryDarwin.mlockall(flags);
    }

    @Override
    public int callMunlockall() throws UnsatisfiedLinkError, RuntimeException {
        return CLibraryDarwin.munlockall();
    }

    @Override
    public int callFcntl(int fd, int command, long flags) throws UnsatisfiedLinkError, RuntimeException {
        return CLibraryDarwin.fcntl(fd, command, flags);
    }

    @Override
    public int callPosixFadvise(int fd, long offset, int len, int flag) throws UnsatisfiedLinkError, RuntimeException {
        throw new UnsatisfiedLinkError();
    }

    @Override
    public int callOpen(String path, int flags) throws UnsatisfiedLinkError, RuntimeException {
        return CLibraryDarwin.open(path, flags);
    }

    @Override
    public int callFsync(int fd) throws UnsatisfiedLinkError, RuntimeException {
        return CLibraryDarwin.fsync(fd);
    }

    @Override
    public int callClose(int fd) throws UnsatisfiedLinkError, RuntimeException {
        return CLibraryDarwin.close(fd);
    }

    @Override
    public Pointer callStrerror(int errnum) throws UnsatisfiedLinkError, RuntimeException {
        return CLibraryDarwin.strerror(errnum);
    }

    @Override
    public long callGetpid() throws UnsatisfiedLinkError, RuntimeException {
        return CLibraryDarwin.getpid();
    }

    @Override
    public boolean jnaAvailable() {
        return jnaAvailable;
    }

    static {
        try {
            Native.register((String)"c");
        }
        catch (NoClassDefFoundError e) {
            logger.warn("JNA not found. Native methods will be disabled.");
            jnaAvailable = false;
        }
        catch (UnsatisfiedLinkError e) {
            logger.warn("JNA link failure, one or more native method will be unavailable.");
            logger.error("JNA link failure details: {}", (Object)e.getMessage());
        }
        catch (NoSuchMethodError e) {
            logger.warn("Obsolete version of JNA present; unable to register C library. Upgrade to JNA 3.2.7 or later");
            jnaAvailable = false;
        }
    }
}

