/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.cassandra.io.util.BufferedDataOutputStreamPlus;

public class DataOutputBuffer
extends BufferedDataOutputStreamPlus {
    public DataOutputBuffer() {
        this(128);
    }

    public DataOutputBuffer(int size) {
        super(ByteBuffer.allocate(size));
    }

    protected DataOutputBuffer(ByteBuffer buffer) {
        super(buffer);
    }

    @Override
    public void flush() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doFlush() throws IOException {
        this.reallocate(this.buffer.capacity() * 2);
    }

    protected void reallocate(long newSize) {
        assert (newSize <= Integer.MAX_VALUE);
        ByteBuffer newBuffer = ByteBuffer.allocate((int)newSize);
        this.buffer.flip();
        newBuffer.put(this.buffer);
        this.buffer = newBuffer;
    }

    @Override
    protected WritableByteChannel newDefaultChannel() {
        return new GrowingChannel();
    }

    @Override
    public void close() {
    }

    public ByteBuffer buffer() {
        ByteBuffer result = this.buffer.duplicate();
        result.flip();
        return result;
    }

    public byte[] getData() {
        return this.buffer.array();
    }

    public int getLength() {
        return this.buffer.position();
    }

    @Override
    public boolean hasPosition() {
        return true;
    }

    @Override
    public long position() {
        return this.getLength();
    }

    public byte[] toByteArray() {
        ByteBuffer buffer = this.buffer();
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }

    private final class GrowingChannel
    implements WritableByteChannel {
        private GrowingChannel() {
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int count = src.remaining();
            DataOutputBuffer.this.reallocate(Math.max(DataOutputBuffer.this.buffer.capacity() * 3 / 2, DataOutputBuffer.this.buffer.capacity() + count));
            DataOutputBuffer.this.buffer.put(src);
            return count;
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public void close() {
        }
    }
}

