/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.CountingPartitionIterator;
import org.apache.cassandra.db.partitions.CountingUnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowDiffListener;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.rows.WrappingUnfilteredRowIterator;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.net.AsyncOneResponse;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.ReadCallback;
import org.apache.cassandra.service.ResponseResolver;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;

public class DataResolver
extends ResponseResolver {
    private final List<AsyncOneResponse> repairResults = Collections.synchronizedList(new ArrayList());

    public DataResolver(Keyspace keyspace, ReadCommand command, ConsistencyLevel consistency, int maxResponseCount) {
        super(keyspace, command, consistency, maxResponseCount);
    }

    @Override
    public PartitionIterator getData() {
        ReadResponse response = (ReadResponse)((MessageIn)this.responses.iterator().next()).payload;
        return UnfilteredPartitionIterators.filter(response.makeIterator(this.command.metadata(), this.command), this.command.nowInSec());
    }

    @Override
    public PartitionIterator resolve() {
        int count = this.responses.size();
        ArrayList<UnfilteredPartitionIterator> iters = new ArrayList<UnfilteredPartitionIterator>(count);
        InetAddress[] sources = new InetAddress[count];
        for (int i = 0; i < count; ++i) {
            MessageIn msg = (MessageIn)this.responses.get(i);
            iters.add(((ReadResponse)msg.payload).makeIterator(this.command.metadata(), this.command));
            sources[i] = msg.from;
        }
        DataLimits.Counter counter = this.command.limits().newCounter(this.command.nowInSec(), true);
        return new CountingPartitionIterator(this.mergeWithShortReadProtection(iters, sources, counter), counter);
    }

    private PartitionIterator mergeWithShortReadProtection(List<UnfilteredPartitionIterator> results, InetAddress[] sources, DataLimits.Counter resultCounter) {
        if (results.size() == 1) {
            return UnfilteredPartitionIterators.filter(results.get(0), this.command.nowInSec());
        }
        RepairMergeListener listener = new RepairMergeListener(sources);
        if (this.command.limits().isUnlimited()) {
            return UnfilteredPartitionIterators.mergeAndFilter(results, this.command.nowInSec(), listener);
        }
        for (int i = 0; i < results.size(); ++i) {
            results.set(i, new ShortReadProtectedIterator(sources[i], results.get(i), resultCounter));
        }
        return UnfilteredPartitionIterators.mergeAndFilter(results, this.command.nowInSec(), listener);
    }

    @Override
    public boolean isDataPresent() {
        return !this.responses.isEmpty();
    }

    private class ShortReadProtectedIterator
    extends CountingUnfilteredPartitionIterator {
        private final InetAddress source;
        private final DataLimits.Counter postReconciliationCounter;

        private ShortReadProtectedIterator(InetAddress source, UnfilteredPartitionIterator iterator, DataLimits.Counter postReconciliationCounter) {
            super(iterator, DataResolver.this.command.limits().newCounter(DataResolver.this.command.nowInSec(), false));
            this.source = source;
            this.postReconciliationCounter = postReconciliationCounter;
        }

        @Override
        public UnfilteredRowIterator next() {
            return new ShortReadProtectedRowIterator(super.next());
        }

        private class ShortReadProtectedRowIterator
        extends WrappingUnfilteredRowIterator {
            private boolean initialReadIsDone;
            private UnfilteredRowIterator shortReadContinuation;
            private Clustering lastClustering;

            ShortReadProtectedRowIterator(UnfilteredRowIterator iter) {
                super(iter);
            }

            @Override
            public boolean hasNext() {
                if (super.hasNext()) {
                    return true;
                }
                this.initialReadIsDone = true;
                if (this.shortReadContinuation != null && this.shortReadContinuation.hasNext()) {
                    return true;
                }
                return this.checkForShortRead();
            }

            @Override
            public Unfiltered next() {
                Unfiltered next;
                Unfiltered unfiltered = next = this.initialReadIsDone ? (Unfiltered)this.shortReadContinuation.next() : super.next();
                if (next.kind() == Unfiltered.Kind.ROW) {
                    this.lastClustering = ((Row)next).clustering();
                }
                return next;
            }

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    if (this.shortReadContinuation != null) {
                        this.shortReadContinuation.close();
                    }
                }
            }

            private boolean checkForShortRead() {
                assert (this.shortReadContinuation == null || !this.shortReadContinuation.hasNext());
                if (!ShortReadProtectedIterator.this.counter.isDoneForPartition()) {
                    return false;
                }
                assert (!ShortReadProtectedIterator.this.postReconciliationCounter.isDoneForPartition());
                int n = ShortReadProtectedIterator.this.postReconciliationCounter.countedInCurrentPartition();
                int x = ShortReadProtectedIterator.this.counter.countedInCurrentPartition();
                int toQuery = x == 0 ? n * 2 : Math.max(n * n / x - n, 1);
                DataLimits retryLimits = DataResolver.this.command.limits().forShortReadRetry(toQuery);
                ClusteringIndexFilter filter = DataResolver.this.command.clusteringIndexFilter(this.partitionKey());
                ClusteringIndexFilter retryFilter = this.lastClustering == null ? filter : filter.forPaging(this.metadata().comparator, this.lastClustering, false);
                SinglePartitionReadCommand<?> cmd = SinglePartitionReadCommand.create(DataResolver.this.command.metadata(), DataResolver.this.command.nowInSec(), DataResolver.this.command.columnFilter(), DataResolver.this.command.rowFilter(), retryLimits, this.partitionKey(), retryFilter);
                this.shortReadContinuation = this.doShortReadRetry(cmd);
                return this.shortReadContinuation.hasNext();
            }

            private UnfilteredRowIterator doShortReadRetry(SinglePartitionReadCommand<?> retryCommand) {
                DataResolver resolver = new DataResolver(DataResolver.this.keyspace, retryCommand, ConsistencyLevel.ONE, 1);
                ReadCallback handler = new ReadCallback(resolver, ConsistencyLevel.ONE, retryCommand, Collections.singletonList(ShortReadProtectedIterator.this.source));
                if (StorageProxy.canDoLocalRequest(ShortReadProtectedIterator.this.source)) {
                    StageManager.getStage(Stage.READ).maybeExecuteImmediately(new StorageProxy.LocalReadRunnable(retryCommand, handler));
                } else {
                    MessagingService.instance().sendRRWithFailure(retryCommand.createMessage(10), ShortReadProtectedIterator.this.source, handler);
                }
                handler.awaitResults();
                assert (resolver.responses.size() == 1);
                return UnfilteredPartitionIterators.getOnlyElement(((ReadResponse)((MessageIn)resolver.responses.get((int)0)).payload).makeIterator(DataResolver.this.command.metadata(), DataResolver.this.command), retryCommand);
            }
        }
    }

    private class RepairMergeListener
    implements UnfilteredPartitionIterators.MergeListener {
        private final InetAddress[] sources;

        public RepairMergeListener(InetAddress[] sources) {
            this.sources = sources;
        }

        @Override
        public UnfilteredRowIterators.MergeListener getRowMergeListener(DecoratedKey partitionKey, List<UnfilteredRowIterator> versions) {
            return new MergeListener(partitionKey, this.columns(versions), this.isReversed(versions));
        }

        private PartitionColumns columns(List<UnfilteredRowIterator> versions) {
            Columns statics = Columns.NONE;
            Columns regulars = Columns.NONE;
            for (UnfilteredRowIterator iter : versions) {
                if (iter == null) continue;
                PartitionColumns cols = iter.columns();
                statics = statics.mergeTo(cols.statics);
                regulars = regulars.mergeTo(cols.regulars);
            }
            return new PartitionColumns(statics, regulars);
        }

        private boolean isReversed(List<UnfilteredRowIterator> versions) {
            for (UnfilteredRowIterator iter : versions) {
                if (iter == null) continue;
                return iter.isReverseOrder();
            }
            assert (false) : "Expected at least one iterator";
            return false;
        }

        @Override
        public void close() {
            try {
                FBUtilities.waitOnFutures(DataResolver.this.repairResults, DatabaseDescriptor.getWriteRpcTimeout());
            }
            catch (TimeoutException ex) {
                int blockFor = DataResolver.this.consistency.blockFor(DataResolver.this.keyspace);
                if (Tracing.isTracing()) {
                    Tracing.trace("Timed out while read-repairing after receiving all {} data and digest responses", (Object)blockFor);
                } else {
                    ResponseResolver.logger.debug("Timeout while read-repairing after receiving all {} data and digest responses", (Object)blockFor);
                }
                throw new ReadTimeoutException(DataResolver.this.consistency, blockFor - 1, blockFor, true);
            }
        }

        private class MergeListener
        implements UnfilteredRowIterators.MergeListener {
            private final DecoratedKey partitionKey;
            private final PartitionColumns columns;
            private final boolean isReversed;
            private final PartitionUpdate[] repairs;
            private final Row.Builder[] currentRows;
            private final RowDiffListener diffListener;
            private final Slice.Bound[] markerOpen;
            private final DeletionTime[] markerTime;

            public MergeListener(DecoratedKey partitionKey, PartitionColumns columns, boolean isReversed) {
                this.repairs = new PartitionUpdate[RepairMergeListener.this.sources.length];
                this.currentRows = new Row.Builder[RepairMergeListener.this.sources.length];
                this.markerOpen = new Slice.Bound[RepairMergeListener.this.sources.length];
                this.markerTime = new DeletionTime[RepairMergeListener.this.sources.length];
                this.partitionKey = partitionKey;
                this.columns = columns;
                this.isReversed = isReversed;
                this.diffListener = new RowDiffListener(){

                    @Override
                    public void onPrimaryKeyLivenessInfo(int i, Clustering clustering, LivenessInfo merged, LivenessInfo original) {
                        if (merged != null && !merged.equals(original)) {
                            MergeListener.this.currentRow(i, clustering).addPrimaryKeyLivenessInfo(merged);
                        }
                    }

                    @Override
                    public void onDeletion(int i, Clustering clustering, Row.Deletion merged, Row.Deletion original) {
                        if (merged != null && !merged.equals(original)) {
                            MergeListener.this.currentRow(i, clustering).addRowDeletion(merged);
                        }
                    }

                    @Override
                    public void onComplexDeletion(int i, Clustering clustering, ColumnDefinition column, DeletionTime merged, DeletionTime original) {
                        if (merged != null && !merged.equals(original)) {
                            MergeListener.this.currentRow(i, clustering).addComplexDeletion(column, merged);
                        }
                    }

                    @Override
                    public void onCell(int i, Clustering clustering, Cell merged, Cell original) {
                        if (merged != null && !merged.equals(original)) {
                            MergeListener.this.currentRow(i, clustering).addCell(merged);
                        }
                    }
                };
            }

            private PartitionUpdate update(int i) {
                if (this.repairs[i] == null) {
                    this.repairs[i] = new PartitionUpdate(DataResolver.this.command.metadata(), this.partitionKey, this.columns, 1);
                }
                return this.repairs[i];
            }

            private Row.Builder currentRow(int i, Clustering clustering) {
                if (this.currentRows[i] == null) {
                    this.currentRows[i] = BTreeRow.sortedBuilder();
                    this.currentRows[i].newRow(clustering);
                }
                return this.currentRows[i];
            }

            @Override
            public void onMergedPartitionLevelDeletion(DeletionTime mergedDeletion, DeletionTime[] versions) {
                for (int i = 0; i < versions.length; ++i) {
                    if (!mergedDeletion.supersedes(versions[i])) continue;
                    this.update(i).addPartitionDeletion(mergedDeletion);
                }
            }

            @Override
            public void onMergedRows(Row merged, Row[] versions) {
                if (merged.isEmpty()) {
                    return;
                }
                Rows.diff(this.diffListener, merged, versions);
                for (int i = 0; i < this.currentRows.length; ++i) {
                    if (this.currentRows[i] == null) continue;
                    this.update(i).add(this.currentRows[i].build());
                }
                Arrays.fill(this.currentRows, null);
            }

            @Override
            public void onMergedRangeTombstoneMarkers(RangeTombstoneMarker merged, RangeTombstoneMarker[] versions) {
                for (int i = 0; i < versions.length; ++i) {
                    RangeTombstoneMarker marker = versions[i];
                    if (merged.isClose(this.isReversed) && this.markerOpen[i] != null) {
                        Slice.Bound open = this.markerOpen[i];
                        RangeTombstone.Bound close = merged.closeBound(this.isReversed);
                        this.update(i).add(new RangeTombstone(Slice.make(this.isReversed ? close : open, this.isReversed ? open : close), this.markerTime[i]));
                    }
                    if (!merged.isOpen(this.isReversed) || marker != null && !merged.openDeletionTime(this.isReversed).supersedes(marker.openDeletionTime(this.isReversed))) continue;
                    this.markerOpen[i] = merged.openBound(this.isReversed);
                    this.markerTime[i] = merged.openDeletionTime(this.isReversed);
                }
            }

            @Override
            public void close() {
                for (int i = 0; i < this.repairs.length; ++i) {
                    if (this.repairs[i] == null) continue;
                    Tracing.trace("Sending read-repair-mutation to {}", (Object)RepairMergeListener.this.sources[i]);
                    MessageOut<Mutation> msg = new Mutation(this.repairs[i]).createMessage(MessagingService.Verb.READ_REPAIR);
                    DataResolver.this.repairResults.add(MessagingService.instance().sendRR(msg, RepairMergeListener.this.sources[i]));
                }
            }
        }
    }
}

