/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.config.ViewDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.MultiColumnRelation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.SingleColumnRelation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.AbstractReadCommandBuilder;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.partitions.AbstractBTreePartition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.view.TemporalRow;
import org.apache.cassandra.db.view.ViewBuilder;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.utils.FBUtilities;

public class View {
    public final String name;
    private volatile ViewDefinition definition;
    private final ColumnFamilyStore baseCfs;
    private Columns columns;
    private final boolean viewHasAllPrimaryKeys;
    private final boolean includeAllColumns;
    private ViewBuilder builder;
    private final SelectStatement.RawStatement rawSelect;
    private SelectStatement select;
    private ReadQuery query;

    public View(ViewDefinition definition, ColumnFamilyStore baseCfs) {
        this.baseCfs = baseCfs;
        this.name = definition.viewName;
        this.includeAllColumns = definition.includeAllColumns;
        this.viewHasAllPrimaryKeys = this.updateDefinition(definition);
        this.rawSelect = definition.select;
    }

    public ViewDefinition getDefinition() {
        return this.definition;
    }

    private boolean resolveAndAddColumns(Iterable<ColumnIdentifier> columns, List<ColumnDefinition> ... definitions) {
        boolean allArePrimaryKeys = true;
        for (ColumnIdentifier identifier : columns) {
            ColumnDefinition cdef = this.baseCfs.metadata.getColumnDefinition(identifier);
            assert (cdef != null) : "Could not resolve column " + identifier.toString();
            for (List<ColumnDefinition> list : definitions) {
                list.add(cdef);
            }
            allArePrimaryKeys = allArePrimaryKeys && cdef.isPrimaryKeyColumn();
        }
        return allArePrimaryKeys;
    }

    public boolean updateDefinition(ViewDefinition definition) {
        this.definition = definition;
        CFMetaData viewCfm = definition.metadata;
        ArrayList partitionDefs = new ArrayList(viewCfm.partitionKeyColumns().size());
        ArrayList primaryKeyDefs = new ArrayList(viewCfm.partitionKeyColumns().size() + viewCfm.clusteringColumns().size());
        ArrayList<ColumnDefinition> baseComplexColumns = new ArrayList<ColumnDefinition>();
        boolean partitionAllPrimaryKeyColumns = this.resolveAndAddColumns(Iterables.transform(viewCfm.partitionKeyColumns(), cd -> cd.name), primaryKeyDefs, partitionDefs);
        boolean clusteringAllPrimaryKeyColumns = this.resolveAndAddColumns(Iterables.transform(viewCfm.clusteringColumns(), cd -> cd.name), primaryKeyDefs);
        for (ColumnDefinition cdef : this.baseCfs.metadata.allColumns()) {
            if (!cdef.isComplex()) continue;
            baseComplexColumns.add(cdef);
        }
        this.columns = new Columns(partitionDefs, primaryKeyDefs, baseComplexColumns);
        return partitionAllPrimaryKeyColumns && clusteringAllPrimaryKeyColumns;
    }

    public boolean updateAffectsView(AbstractBTreePartition partition) {
        ReadQuery selectQuery = this.getReadQuery();
        if (!partition.metadata().cfId.equals(this.definition.baseTableId)) {
            return false;
        }
        if (!selectQuery.selectsKey(partition.partitionKey())) {
            return false;
        }
        if (!partition.deletionInfo().isLive()) {
            return true;
        }
        for (Row row : partition) {
            if (!selectQuery.selectsClustering(partition.partitionKey(), row.clustering())) continue;
            if (this.includeAllColumns || this.viewHasAllPrimaryKeys || !row.deletion().isLive()) {
                return true;
            }
            if (row.primaryKeyLivenessInfo().isLive(FBUtilities.nowInSeconds())) {
                return true;
            }
            for (ColumnData data : row) {
                if (this.definition.metadata.getColumnDefinition(data.column().name) == null) continue;
                return true;
            }
        }
        return false;
    }

    private Clustering viewClustering(TemporalRow temporalRow, TemporalRow.Resolver resolver) {
        CFMetaData viewCfm = this.definition.metadata;
        int numViewClustering = viewCfm.clusteringColumns().size();
        CBuilder clustering = CBuilder.create(viewCfm.comparator);
        for (int i = 0; i < numViewClustering; ++i) {
            ColumnDefinition definition = viewCfm.clusteringColumns().get(i);
            clustering.add(temporalRow.clusteringValue(definition, resolver));
        }
        return clustering.build();
    }

    private PartitionUpdate createTombstone(TemporalRow temporalRow, DecoratedKey partitionKey, Row.Deletion deletion, TemporalRow.Resolver resolver, int nowInSec) {
        CFMetaData viewCfm = this.definition.metadata;
        Row.Builder builder = BTreeRow.unsortedBuilder(nowInSec);
        builder.newRow(this.viewClustering(temporalRow, resolver));
        builder.addRowDeletion(deletion);
        return PartitionUpdate.singleRowUpdate(viewCfm, partitionKey, builder.build());
    }

    private PartitionUpdate createComplexTombstone(TemporalRow temporalRow, DecoratedKey partitionKey, ColumnDefinition deletedColumn, DeletionTime deletionTime, TemporalRow.Resolver resolver, int nowInSec) {
        CFMetaData viewCfm = this.definition.metadata;
        Row.Builder builder = BTreeRow.unsortedBuilder(nowInSec);
        builder.newRow(this.viewClustering(temporalRow, resolver));
        builder.addComplexDeletion(deletedColumn, deletionTime);
        return PartitionUpdate.singleRowUpdate(viewCfm, partitionKey, builder.build());
    }

    private DecoratedKey viewPartitionKey(TemporalRow temporalRow, TemporalRow.Resolver resolver) {
        List<ColumnDefinition> partitionDefs = this.columns.partitionDefs;
        Object[] partitionKey = new Object[partitionDefs.size()];
        for (int i = 0; i < partitionKey.length; ++i) {
            ByteBuffer value = temporalRow.clusteringValue(partitionDefs.get(i), resolver);
            if (value == null) {
                return null;
            }
            partitionKey[i] = value;
        }
        CFMetaData metadata = this.definition.metadata;
        return metadata.decorateKey(CFMetaData.serializePartitionKey(metadata.getKeyValidatorAsClusteringComparator().make(partitionKey)));
    }

    private PartitionUpdate createRangeTombstoneForRow(TemporalRow temporalRow) {
        if (this.viewHasAllPrimaryKeys) {
            return null;
        }
        boolean hasUpdate = false;
        List<ColumnDefinition> primaryKeyDefs = this.columns.primaryKeyDefs;
        for (ColumnDefinition viewPartitionKeys : primaryKeyDefs) {
            if (viewPartitionKeys.isPrimaryKeyColumn() || temporalRow.clusteringValue(viewPartitionKeys, TemporalRow.oldValueIfUpdated) == null) continue;
            hasUpdate = true;
        }
        if (!hasUpdate) {
            return null;
        }
        TemporalRow.Resolver resolver = TemporalRow.earliest;
        return this.createTombstone(temporalRow, this.viewPartitionKey(temporalRow, resolver), Row.Deletion.shadowable(new DeletionTime(temporalRow.viewClusteringTimestamp(), temporalRow.nowInSec)), resolver, temporalRow.nowInSec);
    }

    private PartitionUpdate createUpdatesForInserts(TemporalRow temporalRow) {
        TemporalRow.Resolver resolver = TemporalRow.latest;
        DecoratedKey partitionKey = this.viewPartitionKey(temporalRow, resolver);
        CFMetaData viewCfm = this.definition.metadata;
        if (partitionKey == null) {
            return null;
        }
        Row.Builder regularBuilder = BTreeRow.unsortedBuilder(temporalRow.nowInSec);
        CBuilder clustering = CBuilder.create(viewCfm.comparator);
        for (int i = 0; i < viewCfm.clusteringColumns().size(); ++i) {
            clustering.add(temporalRow.clusteringValue(viewCfm.clusteringColumns().get(i), resolver));
        }
        regularBuilder.newRow(clustering.build());
        regularBuilder.addPrimaryKeyLivenessInfo(LivenessInfo.create(viewCfm, temporalRow.viewClusteringTimestamp(), temporalRow.viewClusteringTtl(), temporalRow.viewClusteringLocalDeletionTime()));
        for (ColumnDefinition columnDefinition : viewCfm.allColumns()) {
            if (columnDefinition.isPrimaryKeyColumn()) continue;
            for (Cell cell : temporalRow.values(columnDefinition, resolver)) {
                regularBuilder.addCell(cell);
            }
        }
        return PartitionUpdate.singleRowUpdate(viewCfm, partitionKey, regularBuilder.build());
    }

    private Collection<Mutation> createForDeletionInfo(TemporalRow.Set rowSet, AbstractBTreePartition partition) {
        ReadQuery selectQuery;
        AbstractReadCommandBuilder.SinglePartitionSliceBuilder builder;
        Object time;
        TemporalRow.Resolver resolver = TemporalRow.earliest;
        DeletionInfo deletionInfo = partition.deletionInfo();
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        if (!this.columns.baseComplexColumns.isEmpty()) {
            for (Row row : partition) {
                if (!row.hasComplexDeletion()) continue;
                TemporalRow temporalRow = rowSet.getClustering(row.clustering());
                assert (temporalRow != null);
                for (ColumnDefinition definition : this.columns.baseComplexColumns) {
                    DecoratedKey targetKey;
                    ComplexColumnData columnData = row.getComplexColumnData(definition);
                    if (columnData == null || ((DeletionTime)(time = columnData.complexDeletion())).isLive() || (targetKey = this.viewPartitionKey(temporalRow, resolver)) == null) continue;
                    mutations.add(new Mutation(this.createComplexTombstone(temporalRow, targetKey, definition, (DeletionTime)time, resolver, temporalRow.nowInSec)));
                }
            }
        }
        ReadCommand command = null;
        if (!deletionInfo.isLive()) {
            DecoratedKey dk = rowSet.dk;
            if (!deletionInfo.getPartitionDeletion().isLive()) {
                command = this.getSelectStatement().internalReadForView(dk, rowSet.nowInSec);
            } else {
                builder = new AbstractReadCommandBuilder.SinglePartitionSliceBuilder(this.baseCfs, dk);
                Iterator<Object> tombstones = deletionInfo.rangeIterator(false);
                while (tombstones.hasNext()) {
                    RangeTombstone tombstone = (RangeTombstone)tombstones.next();
                    builder.addSlice(tombstone.deletedSlice());
                }
                command = builder.build();
            }
        }
        if (command == null) {
            selectQuery = this.getReadQuery();
            builder = null;
            for (Object row : partition) {
                if (row.deletion().isLive() || !selectQuery.selectsClustering(rowSet.dk, row.clustering())) continue;
                if (builder == null) {
                    builder = new AbstractReadCommandBuilder.SinglePartitionSliceBuilder(this.baseCfs, rowSet.dk);
                }
                builder.addSlice(Slice.make(row.clustering()));
            }
            if (builder != null) {
                command = builder.build();
            }
        }
        if (command != null) {
            selectQuery = this.getReadQuery();
            assert (selectQuery.selectsKey(rowSet.dk));
            if (!rowSet.hasTombstonedExisting()) {
                QueryPager pager = command.getPager(null, 4);
                while (!pager.isExhausted()) {
                    Object row;
                    ReadOrderGroup orderGroup = pager.startOrderGroup();
                    row = null;
                    try {
                        PartitionIterator iter = pager.fetchPageInternal(128, orderGroup);
                        time = null;
                        try {
                            if (!iter.hasNext()) break;
                            RowIterator rowIterator = (RowIterator)iter.next();
                            Throwable throwable = null;
                            try {
                                while (rowIterator.hasNext()) {
                                    Row row2 = (Row)rowIterator.next();
                                    if (!selectQuery.selectsClustering(rowSet.dk, row2.clustering())) continue;
                                    rowSet.addRow(row2, false);
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (rowIterator == null) continue;
                                if (throwable != null) {
                                    try {
                                        rowIterator.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                rowIterator.close();
                            }
                        }
                        catch (Throwable throwable) {
                            time = throwable;
                            throw throwable;
                        }
                        finally {
                            if (iter == null) continue;
                            if (time != null) {
                                try {
                                    iter.close();
                                }
                                catch (Throwable targetKey) {
                                    ((Throwable)time).addSuppressed(targetKey);
                                }
                                continue;
                            }
                            iter.close();
                        }
                    }
                    catch (Throwable iter) {
                        row = iter;
                        throw iter;
                    }
                    finally {
                        if (orderGroup == null) continue;
                        if (row != null) {
                            try {
                                orderGroup.close();
                            }
                            catch (Throwable targetKey) {
                                ((Throwable)row).addSuppressed(targetKey);
                            }
                            continue;
                        }
                        orderGroup.close();
                    }
                }
                rowSet.setTombstonedExisting();
            }
            for (TemporalRow temporalRow : rowSet) {
                PartitionUpdate update;
                DecoratedKey value;
                DeletionTime deletionTime = temporalRow.deletionTime(partition);
                if (deletionTime.isLive() || (value = this.viewPartitionKey(temporalRow, resolver)) == null || (update = this.createTombstone(temporalRow, value, Row.Deletion.regular(deletionTime), resolver, temporalRow.nowInSec)) == null) continue;
                mutations.add(new Mutation(update));
            }
        }
        return !mutations.isEmpty() ? mutations : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readLocalRows(TemporalRow.Set rowSet) {
        long start = System.currentTimeMillis();
        AbstractReadCommandBuilder.SinglePartitionSliceBuilder builder = new AbstractReadCommandBuilder.SinglePartitionSliceBuilder(this.baseCfs, rowSet.dk);
        for (TemporalRow temporalRow : rowSet) {
            builder.addSlice(temporalRow.baseSlice());
        }
        QueryPager pager = builder.build().getPager(null, 4);
        block27: while (true) {
            if (pager.isExhausted()) {
                this.baseCfs.metric.viewReadTime.update(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
                return;
            }
            ReadOrderGroup orderGroup = pager.startOrderGroup();
            Throwable throwable = null;
            try {
                PartitionIterator iter = pager.fetchPageInternal(128, orderGroup);
                Throwable throwable2 = null;
                try {
                    while (true) {
                        RowIterator rows;
                        block34: {
                            if (!iter.hasNext()) continue block27;
                            rows = (RowIterator)iter.next();
                            Throwable throwable3 = null;
                            try {
                                while (rows.hasNext()) {
                                    rowSet.addRow((Row)rows.next(), false);
                                }
                                if (rows == null) continue;
                                if (throwable3 == null) break block34;
                            }
                            catch (Throwable throwable4) {
                                try {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    if (rows == null) throw throwable5;
                                    if (throwable3 != null) {
                                        try {
                                            rows.close();
                                            throw throwable5;
                                        }
                                        catch (Throwable throwable6) {
                                            throwable3.addSuppressed(throwable6);
                                            throw throwable5;
                                        }
                                    }
                                    rows.close();
                                    throw throwable5;
                                }
                            }
                            try {
                                rows.close();
                            }
                            catch (Throwable throwable7) {
                                throwable3.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        rows.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (iter == null) continue;
                    if (throwable2 != null) {
                        try {
                            iter.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    iter.close();
                    continue;
                }
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (orderGroup == null) continue;
                if (throwable != null) {
                    try {
                        orderGroup.close();
                    }
                    catch (Throwable throwable11) {
                        throwable.addSuppressed(throwable11);
                    }
                    continue;
                }
                orderGroup.close();
                continue;
            }
            break;
        }
    }

    private TemporalRow.Set separateRows(AbstractBTreePartition partition, Set<ColumnIdentifier> viewPrimaryKeyCols) {
        TemporalRow.Set rowSet = new TemporalRow.Set(this.baseCfs, viewPrimaryKeyCols, partition.partitionKey().getKey());
        for (Row row : partition) {
            rowSet.addRow(row, true);
        }
        return rowSet;
    }

    public TemporalRow.Set getTemporalRowSet(AbstractBTreePartition partition, TemporalRow.Set existing, boolean isBuilding) {
        TemporalRow.Set rowSet;
        if (!this.updateAffectsView(partition)) {
            return existing;
        }
        HashSet<ColumnIdentifier> columns = new HashSet<ColumnIdentifier>(this.columns.primaryKeyDefs.size());
        for (ColumnDefinition def : this.columns.primaryKeyDefs) {
            columns.add(def.name);
        }
        if (existing == null) {
            rowSet = this.separateRows(partition, columns);
            if (!isBuilding) {
                this.readLocalRows(rowSet);
            }
        } else {
            rowSet = existing.withNewViewPrimaryKey(columns);
        }
        return rowSet;
    }

    public SelectStatement getSelectStatement() {
        if (this.select == null) {
            ClientState state = ClientState.forInternalCalls();
            state.setKeyspace(this.baseCfs.keyspace.getName());
            this.rawSelect.prepareKeyspace(state);
            ParsedStatement.Prepared prepared = this.rawSelect.prepare(true);
            this.select = (SelectStatement)prepared.statement;
        }
        return this.select;
    }

    public ReadQuery getReadQuery() {
        if (this.query == null) {
            this.query = this.getSelectStatement().getQuery(QueryOptions.forInternalCalls(Collections.emptyList()), FBUtilities.nowInSeconds());
        }
        return this.query;
    }

    public Collection<Mutation> createMutations(AbstractBTreePartition partition, TemporalRow.Set rowSet, boolean isBuilding) {
        Collection<Mutation> deletion;
        if (!this.updateAffectsView(partition)) {
            return null;
        }
        LinkedList<Mutation> mutations = null;
        for (TemporalRow temporalRow : rowSet) {
            PartitionUpdate insert;
            PartitionUpdate partitionTombstone;
            if (!isBuilding && (partitionTombstone = this.createRangeTombstoneForRow(temporalRow)) != null) {
                if (mutations == null) {
                    mutations = new LinkedList<Mutation>();
                }
                mutations.add(new Mutation(partitionTombstone));
            }
            if ((insert = this.createUpdatesForInserts(temporalRow)) == null) continue;
            if (mutations == null) {
                mutations = new LinkedList();
            }
            mutations.add(new Mutation(insert));
        }
        if (!isBuilding && (deletion = this.createForDeletionInfo(rowSet, partition)) != null && !deletion.isEmpty()) {
            if (mutations == null) {
                mutations = new LinkedList();
            }
            mutations.addAll(deletion);
        }
        return mutations;
    }

    public synchronized void build() {
        if (this.builder != null) {
            this.builder.stop();
            this.builder = null;
        }
        this.builder = new ViewBuilder(this.baseCfs, this);
        CompactionManager.instance.submitViewBuilder(this.builder);
    }

    @Nullable
    public static CFMetaData findBaseTable(String keyspace, String viewName) {
        ViewDefinition view = Schema.instance.getView(keyspace, viewName);
        return view == null ? null : Schema.instance.getCFMetaData(view.baseTableId);
    }

    public static Iterable<ViewDefinition> findAll(String keyspace, String baseTable) {
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(keyspace);
        UUID baseId = Schema.instance.getId(keyspace, baseTable);
        return Iterables.filter((Iterable)ksm.views, view -> view.baseTableId.equals(baseId));
    }

    public static String buildSelectStatement(String cfName, Collection<ColumnDefinition> includedColumns, String whereClause) {
        StringBuilder rawSelect = new StringBuilder("SELECT ");
        if (includedColumns == null || includedColumns.isEmpty()) {
            rawSelect.append("*");
        } else {
            rawSelect.append(includedColumns.stream().map(id -> id.name.toCQLString()).collect(Collectors.joining(", ")));
        }
        rawSelect.append(" FROM \"").append(cfName).append("\" WHERE ").append(whereClause).append(" ALLOW FILTERING");
        return rawSelect.toString();
    }

    public static String relationsToWhereClause(List<Relation> whereClause) {
        ArrayList<String> expressions = new ArrayList<String>(whereClause.size());
        for (Relation rel : whereClause) {
            StringBuilder sb = new StringBuilder();
            if (rel.isMultiColumn()) {
                sb.append(((MultiColumnRelation)rel).getEntities().stream().map(ColumnIdentifier.Raw::toCQLString).collect(Collectors.joining(", ", "(", ")")));
            } else {
                sb.append(((SingleColumnRelation)rel).getEntity().toCQLString());
            }
            sb.append(" ").append((Object)rel.operator()).append(" ");
            if (rel.isIN()) {
                sb.append(rel.getInValues().stream().map(Term.Raw::getText).collect(Collectors.joining(", ", "(", ")")));
            } else {
                sb.append(rel.getValue().getText());
            }
            expressions.add(sb.toString());
        }
        return expressions.stream().collect(Collectors.joining(" AND "));
    }

    private static class Columns {
        public final List<ColumnDefinition> partitionDefs;
        public final List<ColumnDefinition> primaryKeyDefs;
        public final List<ColumnDefinition> baseComplexColumns;

        private Columns(List<ColumnDefinition> partitionDefs, List<ColumnDefinition> primaryKeyDefs, List<ColumnDefinition> baseComplexColumns) {
            this.partitionDefs = partitionDefs;
            this.primaryKeyDefs = primaryKeyDefs;
            this.baseComplexColumns = baseComplexColumns;
        }
    }
}

