/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionPurger;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.WrappingUnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.AlteringUnfilteredRowIterator;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneBoundaryMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;

public abstract class PurgingPartitionIterator
extends WrappingUnfilteredPartitionIterator {
    private final DeletionPurger purger;
    private final int gcBefore;
    private UnfilteredRowIterator next;

    public PurgingPartitionIterator(UnfilteredPartitionIterator iterator, final int gcBefore, final int oldestUnrepairedTombstone, final boolean onlyPurgeRepairedTombstones) {
        super(iterator);
        this.gcBefore = gcBefore;
        this.purger = new DeletionPurger(){

            @Override
            public boolean shouldPurge(long timestamp, int localDeletionTime) {
                if (onlyPurgeRepairedTombstones && localDeletionTime >= oldestUnrepairedTombstone) {
                    return false;
                }
                return timestamp < PurgingPartitionIterator.this.getMaxPurgeableTimestamp() && localDeletionTime < gcBefore;
            }
        };
    }

    protected abstract long getMaxPurgeableTimestamp();

    protected void onNewPartition(DecoratedKey partitionKey) {
    }

    protected void onEmptyPartitionPostPurge(DecoratedKey partitionKey) {
    }

    protected void updateProgress() {
    }

    @Override
    public boolean hasNext() {
        while (this.next == null && super.hasNext()) {
            UnfilteredRowIterator iterator = super.next();
            this.onNewPartition(iterator.partitionKey());
            UnfilteredRowIterator purged = this.purge(iterator);
            if (this.isForThrift() || !purged.isEmpty()) {
                this.next = purged;
                return true;
            }
            this.onEmptyPartitionPostPurge(purged.partitionKey());
            purged.close();
        }
        return this.next != null;
    }

    @Override
    public UnfilteredRowIterator next() {
        UnfilteredRowIterator toReturn = this.next;
        this.next = null;
        this.updateProgress();
        return toReturn;
    }

    private UnfilteredRowIterator purge(final UnfilteredRowIterator iter) {
        return new AlteringUnfilteredRowIterator(iter){

            @Override
            public DeletionTime partitionLevelDeletion() {
                DeletionTime dt = iter.partitionLevelDeletion();
                return PurgingPartitionIterator.this.purger.shouldPurge(dt) ? DeletionTime.LIVE : dt;
            }

            @Override
            public Row computeNextStatic(Row row) {
                return row.purge(PurgingPartitionIterator.this.purger, PurgingPartitionIterator.this.gcBefore);
            }

            @Override
            public Row computeNext(Row row) {
                return row.purge(PurgingPartitionIterator.this.purger, PurgingPartitionIterator.this.gcBefore);
            }

            @Override
            public RangeTombstoneMarker computeNext(RangeTombstoneMarker marker) {
                boolean reversed = this.isReverseOrder();
                if (marker.isBoundary()) {
                    RangeTombstoneBoundaryMarker boundary = (RangeTombstoneBoundaryMarker)marker;
                    boolean shouldPurgeClose = PurgingPartitionIterator.this.purger.shouldPurge(boundary.closeDeletionTime(reversed));
                    boolean shouldPurgeOpen = PurgingPartitionIterator.this.purger.shouldPurge(boundary.openDeletionTime(reversed));
                    if (shouldPurgeClose) {
                        if (shouldPurgeOpen) {
                            return null;
                        }
                        return boundary.createCorrespondingOpenMarker(reversed);
                    }
                    return shouldPurgeOpen ? boundary.createCorrespondingCloseMarker(reversed) : marker;
                }
                return PurgingPartitionIterator.this.purger.shouldPurge(((RangeTombstoneBoundMarker)marker).deletionTime()) ? null : marker;
            }

            @Override
            public Unfiltered next() {
                Unfiltered next = super.next();
                PurgingPartitionIterator.this.updateProgress();
                return next;
            }
        };
    }
}

