/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.WrappingRowIterator;

public class CountingRowIterator
extends WrappingRowIterator {
    protected final DataLimits.Counter counter;

    public CountingRowIterator(RowIterator iter, DataLimits.Counter counter) {
        super(iter);
        this.counter = counter;
        counter.newPartition(iter.partitionKey(), iter.staticRow());
    }

    @Override
    public boolean hasNext() {
        if (this.counter.isDoneForPartition()) {
            return false;
        }
        return super.hasNext();
    }

    @Override
    public Row next() {
        Row row = super.next();
        this.counter.newRow(row);
        return row;
    }

    @Override
    public void close() {
        super.close();
        this.counter.endOfPartition();
    }
}

