/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.serializers.EmptySerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class EmptyType
extends AbstractType<Void> {
    public static final EmptyType instance = new EmptyType();

    private EmptyType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public int compareCustom(ByteBuffer o1, ByteBuffer o2) {
        return 0;
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return "";
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (!source.isEmpty()) {
            throw new MarshalException(String.format("'%s' is not empty", source));
        }
        return ByteBufferUtil.EMPTY_BYTE_BUFFER;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (!(parsed instanceof String)) {
            throw new MarshalException(String.format("Expected an empty string, but got: %s", parsed));
        }
        if (!((String)parsed).isEmpty()) {
            throw new MarshalException(String.format("'%s' is not empty", parsed));
        }
        return new Constants.Value(ByteBufferUtil.EMPTY_BYTE_BUFFER);
    }

    @Override
    public TypeSerializer<Void> getSerializer() {
        return EmptySerializer.instance;
    }

    @Override
    protected int valueLengthIfFixed() {
        return 0;
    }
}

