/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Runnables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.LogFile;
import org.apache.cassandra.db.lifecycle.LogRecord;
import org.apache.cassandra.db.lifecycle.Tracker;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SnapshotDeletingTask;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LogTransaction
extends Transactional.AbstractTransactional
implements Transactional {
    private static final Logger logger = LoggerFactory.getLogger(LogTransaction.class);
    private final Tracker tracker;
    private final LogFile data;
    private final Ref<LogTransaction> selfRef;
    private static final Queue<Runnable> failedDeletions = new ConcurrentLinkedQueue<Runnable>();

    LogTransaction(OperationType opType, CFMetaData metadata) {
        this(opType, metadata, null);
    }

    LogTransaction(OperationType opType, CFMetaData metadata, Tracker tracker) {
        this(opType, new Directories(metadata), tracker);
    }

    LogTransaction(OperationType opType, Directories directories, Tracker tracker) {
        this(opType, directories.getDirectoryForNewSSTables(), tracker);
    }

    LogTransaction(OperationType opType, File folder, Tracker tracker) {
        this.tracker = tracker;
        int folderDescriptor = CLibrary.tryOpenDirectory(folder.getPath());
        this.data = new LogFile(opType, folder, folderDescriptor, UUIDGen.getTimeUUID());
        this.selfRef = new Ref<LogTransaction>(this, new TransactionTidier(this.data, folderDescriptor));
        if (logger.isTraceEnabled()) {
            logger.trace("Created transaction logs with id {}", (Object)this.data.id);
        }
    }

    void trackNew(SSTable table) {
        this.data.add(LogRecord.Type.ADD, table);
    }

    void untrackNew(SSTable table) {
        this.data.remove(LogRecord.Type.ADD, table);
    }

    SSTableTidier obsoleted(SSTableReader reader) {
        if (this.data.contains(LogRecord.Type.ADD, reader)) {
            if (this.data.contains(LogRecord.Type.REMOVE, reader)) {
                throw new IllegalArgumentException();
            }
            return new SSTableTidier(reader, true, this);
        }
        this.data.add(LogRecord.Type.REMOVE, reader);
        if (this.tracker != null) {
            this.tracker.notifyDeleting(reader);
        }
        return new SSTableTidier(reader, false, this);
    }

    OperationType getType() {
        return this.data.getType();
    }

    UUID getId() {
        return this.data.getId();
    }

    @VisibleForTesting
    String getDataFolder() {
        return this.data.folder.getPath();
    }

    @VisibleForTesting
    LogFile getLogFile() {
        return this.data;
    }

    static void delete(File file) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("Deleting {}", (Object)file);
            }
            Files.delete(file.toPath());
        }
        catch (NoSuchFileException e) {
            logger.error("Unable to delete {} as it does not exist", (Object)file);
        }
        catch (IOException e) {
            logger.error("Unable to delete {}", (Object)file, (Object)e);
            throw new RuntimeException(e);
        }
    }

    static void rescheduleFailedDeletions() {
        Runnable task;
        while (null != (task = failedDeletions.poll())) {
            ScheduledExecutors.nonPeriodicTasks.submit(task);
        }
        SnapshotDeletingTask.rescheduleFailedTasks();
    }

    static void waitForDeletions() {
        FBUtilities.waitOnFuture(ScheduledExecutors.nonPeriodicTasks.schedule(Runnables.doNothing(), 0L, TimeUnit.MILLISECONDS));
    }

    @VisibleForTesting
    Throwable complete(Throwable accumulate) {
        try {
            accumulate = this.selfRef.ensureReleased(accumulate);
            return accumulate;
        }
        catch (Throwable t) {
            logger.error("Failed to complete file transaction {}", (Object)this.getId(), (Object)t);
            return Throwables.merge(accumulate, t);
        }
    }

    @Override
    protected Throwable doCommit(Throwable accumulate) {
        this.data.commit();
        return this.complete(accumulate);
    }

    @Override
    protected Throwable doAbort(Throwable accumulate) {
        this.data.abort();
        return this.complete(accumulate);
    }

    @Override
    protected void doPrepare() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeUnfinishedLeftovers(CFMetaData metadata) {
        for (File dir : new Directories(metadata).getCFDirectories()) {
            int folderDescriptor = CLibrary.tryOpenDirectory(dir.getPath());
            try {
                File[] logs;
                for (File log : logs = dir.listFiles(LogFile::isLogFile)) {
                    LogFile data = LogFile.make(log, folderDescriptor);
                    data.readRecords();
                    if (data.verify()) {
                        Throwable failure = data.removeUnfinishedLeftovers(null);
                        if (failure == null) continue;
                        logger.error("Failed to remove unfinished transaction leftovers for log {}", (Object)log, (Object)failure);
                        continue;
                    }
                    logger.error("Unexpected disk state: failed to read transaction log {}", (Object)log);
                }
            }
            finally {
                CLibrary.tryCloseFD(folderDescriptor);
            }
        }
    }

    public static class SSTableTidier
    implements Runnable {
        private final Descriptor desc;
        private final long sizeOnDisk;
        private final Tracker tracker;
        private final boolean wasNew;
        private final Ref<LogTransaction> parentRef;

        public SSTableTidier(SSTableReader referent, boolean wasNew, LogTransaction parent) {
            this.desc = referent.descriptor;
            this.sizeOnDisk = referent.bytesOnDisk();
            this.tracker = parent.tracker;
            this.wasNew = wasNew;
            this.parentRef = parent.selfRef.tryRef();
        }

        @Override
        public void run() {
            SystemKeyspace.clearSSTableReadMeter(this.desc.ksname, this.desc.cfname, this.desc.generation);
            try {
                File datafile = new File(this.desc.filenameFor(Component.DATA));
                LogTransaction.delete(datafile);
                SSTable.delete(this.desc, SSTable.discoverComponentsFor(this.desc));
            }
            catch (Throwable t) {
                logger.error("Failed deletion for {}, we'll retry after GC and on server restart", (Object)this.desc);
                failedDeletions.add(this);
                return;
            }
            if (this.tracker != null && this.tracker.cfstore != null && !this.wasNew) {
                this.tracker.cfstore.metric.totalDiskSpaceUsed.dec(this.sizeOnDisk);
            }
            this.parentRef.release();
        }

        public void abort() {
            this.parentRef.release();
        }
    }

    static class Obsoletion {
        final SSTableReader reader;
        final SSTableTidier tidier;

        Obsoletion(SSTableReader reader, SSTableTidier tidier) {
            this.reader = reader;
            this.tidier = tidier;
        }
    }

    private static class TransactionTidier
    implements RefCounted.Tidy,
    Runnable {
        private final LogFile data;
        private final int folderDescriptor;

        TransactionTidier(LogFile data, int folderDescriptor) {
            this.data = data;
            this.folderDescriptor = folderDescriptor;
        }

        @Override
        public void tidy() throws Exception {
            this.run();
        }

        @Override
        public String name() {
            return this.data.toString();
        }

        @Override
        public void run() {
            if (logger.isTraceEnabled()) {
                logger.trace("Removing files for transaction {}", (Object)this.name());
            }
            assert (this.data.completed()) : "Expected a completed transaction: " + this.data;
            Throwable err = this.data.removeUnfinishedLeftovers(null);
            if (err != null) {
                logger.info("Failed deleting files for transaction {}, we'll retry after GC and on on server restart", (Object)this.name(), (Object)err);
                failedDeletions.add(this);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("Closing file transaction {}", (Object)this.name());
                }
                CLibrary.tryCloseFD(this.folderDescriptor);
            }
        }
    }

    public static final class CorruptTransactionLogException
    extends RuntimeException {
        public final LogFile file;

        public CorruptTransactionLogException(String message, LogFile file) {
            super(message);
            this.file = file;
        }
    }
}

