/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.apache.cassandra.cache.AutoSavingCache;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.CompactionIterator;
import org.apache.cassandra.db.compaction.CompactionManagerMBean;
import org.apache.cassandra.db.compaction.CompactionStrategyManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.Scrubber;
import org.apache.cassandra.db.compaction.Verifier;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.view.ViewBuilder;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.index.SecondaryIndexBuilder;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.SSTableRewriter;
import org.apache.cassandra.io.sstable.SnapshotDeletingTask;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.CompactionMetrics;
import org.apache.cassandra.repair.Validator;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MerkleTrees;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionManager
implements CompactionManagerMBean {
    public static final String MBEAN_OBJECT_NAME = "org.apache.cassandra.db:type=CompactionManager";
    private static final Logger logger = LoggerFactory.getLogger(CompactionManager.class);
    public static final CompactionManager instance;
    public static final int NO_GC = Integer.MIN_VALUE;
    public static final int GC_ALL = Integer.MAX_VALUE;
    public static final ThreadLocal<Boolean> isCompactionManager;
    private final CompactionExecutor executor = new CompactionExecutor();
    private final CompactionExecutor validationExecutor = new ValidationExecutor();
    private static final CompactionExecutor cacheCleanupExecutor;
    private final CompactionMetrics metrics = new CompactionMetrics(this.executor, this.validationExecutor);
    private final Multiset<ColumnFamilyStore> compactingCF = ConcurrentHashMultiset.create();
    private final RateLimiter compactionRateLimiter = RateLimiter.create((double)Double.MAX_VALUE);

    public RateLimiter getRateLimiter() {
        double currentThroughput = (double)DatabaseDescriptor.getCompactionThroughputMbPerSec() * 1024.0 * 1024.0;
        if (currentThroughput == 0.0 || StorageService.instance.isBootstrapMode()) {
            currentThroughput = Double.MAX_VALUE;
        }
        if (this.compactionRateLimiter.getRate() != currentThroughput) {
            this.compactionRateLimiter.setRate(currentThroughput);
        }
        return this.compactionRateLimiter;
    }

    public List<Future<?>> submitBackground(ColumnFamilyStore cfs) {
        if (cfs.isAutoCompactionDisabled()) {
            logger.trace("Autocompaction is disabled");
            return Collections.emptyList();
        }
        int count = this.compactingCF.count((Object)cfs);
        if (count > 0 && this.executor.getActiveCount() >= this.executor.getMaximumPoolSize()) {
            logger.trace("Background compaction is still running for {}.{} ({} remaining). Skipping", new Object[]{cfs.keyspace.getName(), cfs.name, count});
            return Collections.emptyList();
        }
        logger.trace("Scheduling a background task check for {}.{} with {}", new Object[]{cfs.keyspace.getName(), cfs.name, cfs.getCompactionStrategyManager().getName()});
        ArrayList futures = new ArrayList();
        if (this.executor.isShutdown()) {
            logger.info("Executor has shut down, not submitting background task");
            return Collections.emptyList();
        }
        this.compactingCF.add((Object)cfs);
        futures.add(this.executor.submit(new BackgroundCompactionCandidate(cfs)));
        return futures;
    }

    public boolean isCompacting(Iterable<ColumnFamilyStore> cfses) {
        for (ColumnFamilyStore cfs : cfses) {
            if (cfs.getTracker().getCompacting().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void finishCompactionsAndShutdown(long timeout, TimeUnit unit) throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(timeout, unit);
    }

    /*
     * Exception decompiling
     */
    private AllSSTableOpStatus parallelAllSSTableOperation(ColumnFamilyStore cfs, OneSSTableOperation operation, OperationType operationType) throws ExecutionException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 27[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public AllSSTableOpStatus performScrub(ColumnFamilyStore cfs, boolean skipCorrupted, boolean checkData) throws InterruptedException, ExecutionException {
        return this.performScrub(cfs, skipCorrupted, checkData, false);
    }

    public AllSSTableOpStatus performScrub(final ColumnFamilyStore cfs, final boolean skipCorrupted, final boolean checkData, final boolean offline) throws InterruptedException, ExecutionException {
        return this.parallelAllSSTableOperation(cfs, new OneSSTableOperation(){

            @Override
            public Iterable<SSTableReader> filterSSTables(LifecycleTransaction input) {
                return input.originals();
            }

            @Override
            public void execute(LifecycleTransaction input) throws IOException {
                CompactionManager.this.scrubOne(cfs, input, skipCorrupted, checkData, offline);
            }
        }, OperationType.SCRUB);
    }

    public AllSSTableOpStatus performVerify(final ColumnFamilyStore cfs, final boolean extendedVerify) throws InterruptedException, ExecutionException {
        assert (!cfs.isIndex());
        return this.parallelAllSSTableOperation(cfs, new OneSSTableOperation(){

            @Override
            public Iterable<SSTableReader> filterSSTables(LifecycleTransaction input) {
                return input.originals();
            }

            @Override
            public void execute(LifecycleTransaction input) throws IOException {
                CompactionManager.this.verifyOne(cfs, input.onlyOne(), extendedVerify);
            }
        }, OperationType.VERIFY);
    }

    public AllSSTableOpStatus performSSTableRewrite(final ColumnFamilyStore cfs, final boolean excludeCurrentVersion) throws InterruptedException, ExecutionException {
        return this.parallelAllSSTableOperation(cfs, new OneSSTableOperation(){

            @Override
            public Iterable<SSTableReader> filterSSTables(LifecycleTransaction transaction) {
                ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>(transaction.originals());
                Iterator iter = sstables.iterator();
                while (iter.hasNext()) {
                    SSTableReader sstable = (SSTableReader)iter.next();
                    if (!excludeCurrentVersion || !sstable.descriptor.version.equals(sstable.descriptor.getFormat().getLatestVersion())) continue;
                    transaction.cancel(sstable);
                    iter.remove();
                }
                return sstables;
            }

            @Override
            public void execute(LifecycleTransaction txn) throws IOException {
                AbstractCompactionTask task = cfs.getCompactionStrategyManager().getCompactionTask(txn, Integer.MIN_VALUE, Long.MAX_VALUE);
                task.setUserDefined(true);
                task.setCompactionType(OperationType.UPGRADE_SSTABLES);
                task.execute(CompactionManager.this.metrics);
            }
        }, OperationType.UPGRADE_SSTABLES);
    }

    public AllSSTableOpStatus performCleanup(final ColumnFamilyStore cfStore) throws InterruptedException, ExecutionException {
        assert (!cfStore.isIndex());
        Keyspace keyspace = cfStore.keyspace;
        final Collection<Range<Token>> ranges = StorageService.instance.getLocalRanges(keyspace.getName());
        if (ranges.isEmpty()) {
            logger.info("Cleanup cannot run before a node has joined the ring");
            return AllSSTableOpStatus.ABORTED;
        }
        final boolean hasIndexes = cfStore.indexManager.hasIndexes();
        return this.parallelAllSSTableOperation(cfStore, new OneSSTableOperation(){

            @Override
            public Iterable<SSTableReader> filterSSTables(LifecycleTransaction transaction) {
                ArrayList sortedSSTables = Lists.newArrayList(transaction.originals());
                Collections.sort(sortedSSTables, new SSTableReader.SizeComparator());
                return sortedSSTables;
            }

            @Override
            public void execute(LifecycleTransaction txn) throws IOException {
                CleanupStrategy cleanupStrategy = CleanupStrategy.get(cfStore, ranges, FBUtilities.nowInSeconds());
                CompactionManager.this.doCleanupOne(cfStore, txn, cleanupStrategy, ranges, hasIndexes);
            }
        }, OperationType.CLEANUP);
    }

    public ListenableFuture<?> submitAntiCompaction(final ColumnFamilyStore cfs, final Collection<Range<Token>> ranges, final Refs<SSTableReader> sstables, final long repairedAt) {
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            public void runMayThrow() throws Exception {
                LifecycleTransaction modifier = null;
                while (modifier == null) {
                    for (SSTableReader compactingSSTable : cfs.getTracker().getCompacting()) {
                        sstables.releaseIfHolds(compactingSSTable);
                    }
                    HashSet<SSTableReader> compactedSSTables = new HashSet<SSTableReader>();
                    for (SSTableReader sstable : sstables) {
                        if (!sstable.isMarkedCompacted()) continue;
                        compactedSSTables.add(sstable);
                    }
                    sstables.release(compactedSSTables);
                    modifier = cfs.getTracker().tryModify(sstables, OperationType.ANTICOMPACTION);
                }
                CompactionManager.this.performAnticompaction(cfs, ranges, sstables, modifier, repairedAt);
            }
        };
        if (this.executor.isShutdown()) {
            logger.info("Compaction executor has shut down, not submitting anticompaction");
            sstables.release();
            return Futures.immediateCancelledFuture();
        }
        ListenableFutureTask task = ListenableFutureTask.create((Runnable)runnable, null);
        this.executor.submit((Runnable)task);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAnticompaction(ColumnFamilyStore cfs, Collection<Range<Token>> ranges, Refs<SSTableReader> validatedForRepair, LifecycleTransaction txn, long repairedAt) throws InterruptedException, IOException {
        logger.info("Starting anticompaction for {}.{} on {}/{} sstables", new Object[]{cfs.keyspace.getName(), cfs.getColumnFamilyName(), validatedForRepair.size(), cfs.getLiveSSTables()});
        logger.trace("Starting anticompaction for ranges {}", ranges);
        HashSet<SSTableReader> sstables = new HashSet<SSTableReader>(validatedForRepair);
        HashSet<SSTableReader> mutatedRepairStatuses = new HashSet<SSTableReader>();
        HashSet<SSTableReader> nonAnticompacting = new HashSet<SSTableReader>();
        Iterator sstableIterator = sstables.iterator();
        try {
            List normalizedRanges = Range.normalize(ranges);
            while (sstableIterator.hasNext()) {
                SSTableReader sstable = (SSTableReader)sstableIterator.next();
                Range<Token> sstableRange = new Range<Token>(sstable.first.getToken(), sstable.last.getToken());
                boolean shouldAnticompact = false;
                for (Range<Range<Token>> range : normalizedRanges) {
                    if (range.contains(sstableRange)) {
                        logger.info("SSTable {} fully contained in range {}, mutating repairedAt instead of anticompacting", (Object)sstable, range);
                        sstable.descriptor.getMetadataSerializer().mutateRepairedAt(sstable.descriptor, repairedAt);
                        sstable.reloadSSTableMetadata();
                        mutatedRepairStatuses.add(sstable);
                        sstableIterator.remove();
                        shouldAnticompact = true;
                        break;
                    }
                    if (!sstableRange.intersects(range)) continue;
                    logger.info("SSTable {} ({}) will be anticompacted on range {}", new Object[]{sstable, sstableRange, range});
                    shouldAnticompact = true;
                }
                if (shouldAnticompact) continue;
                logger.info("SSTable {} ({}) does not intersect repaired ranges {}, not touching repairedAt.", new Object[]{sstable, sstableRange, normalizedRanges});
                nonAnticompacting.add(sstable);
                sstableIterator.remove();
            }
            cfs.getTracker().notifySSTableRepairedStatusChanged(mutatedRepairStatuses);
            txn.cancel((Iterable<SSTableReader>)Sets.union(nonAnticompacting, mutatedRepairStatuses));
            validatedForRepair.release((Collection<SSTableReader>)Sets.union(nonAnticompacting, mutatedRepairStatuses));
            assert (txn.originals().equals(sstables));
            if (!sstables.isEmpty()) {
                this.doAntiCompaction(cfs, ranges, txn, repairedAt);
            }
            txn.finish();
        }
        finally {
            validatedForRepair.release();
            txn.close();
        }
        logger.info("Completed anticompaction successfully");
    }

    public void performMaximal(ColumnFamilyStore cfStore, boolean splitOutput) {
        FBUtilities.waitOnFutures(this.submitMaximal(cfStore, CompactionManager.getDefaultGcBefore(cfStore, FBUtilities.nowInSeconds()), splitOutput));
    }

    public List<Future<?>> submitMaximal(ColumnFamilyStore cfStore, int gcBefore, boolean splitOutput) {
        Collection<AbstractCompactionTask> tasks = cfStore.getCompactionStrategyManager().getMaximalTasks(gcBefore, splitOutput);
        if (tasks == null) {
            return Collections.emptyList();
        }
        ArrayList futures = new ArrayList();
        for (final AbstractCompactionTask task : tasks) {
            WrappedRunnable runnable = new WrappedRunnable(){

                @Override
                protected void runMayThrow() throws IOException {
                    task.execute(CompactionManager.this.metrics);
                }
            };
            if (this.executor.isShutdown()) {
                logger.info("Compaction executor has shut down, not submitting task");
                return Collections.emptyList();
            }
            futures.add(this.executor.submit(runnable));
        }
        return futures;
    }

    @Override
    public void forceUserDefinedCompaction(String dataFiles) {
        String[] filenames = dataFiles.split(",");
        ArrayListMultimap descriptors = ArrayListMultimap.create();
        for (String filename : filenames) {
            Descriptor desc = Descriptor.fromFilename(filename.trim());
            if (Schema.instance.getCFMetaData(desc) == null) {
                logger.warn("Schema does not exist for file {}. Skipping.", (Object)filename);
                continue;
            }
            ColumnFamilyStore cfs = Keyspace.open(desc.ksname).getColumnFamilyStore(desc.cfname);
            descriptors.put((Object)cfs, (Object)cfs.getDirectories().find(new File(filename.trim()).getName()));
        }
        ArrayList futures = new ArrayList();
        int nowInSec = FBUtilities.nowInSeconds();
        for (ColumnFamilyStore cfs : descriptors.keySet()) {
            futures.add(this.submitUserDefined(cfs, descriptors.get((Object)cfs), CompactionManager.getDefaultGcBefore(cfs, nowInSec)));
        }
        FBUtilities.waitOnFutures(futures);
    }

    public Future<?> submitUserDefined(final ColumnFamilyStore cfs, final Collection<Descriptor> dataFiles, final int gcBefore) {
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            protected void runMayThrow() throws IOException {
                ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>(dataFiles.size());
                for (Descriptor desc : dataFiles) {
                    SSTableReader sstable = CompactionManager.this.lookupSSTable(cfs, desc);
                    if (sstable == null) {
                        logger.info("Will not compact {}: it is not an active sstable", (Object)desc);
                        continue;
                    }
                    sstables.add(sstable);
                }
                if (sstables.isEmpty()) {
                    logger.info("No files to compact for user defined compaction");
                } else {
                    AbstractCompactionTask task = cfs.getCompactionStrategyManager().getUserDefinedTask(sstables, gcBefore);
                    if (task != null) {
                        task.execute(CompactionManager.this.metrics);
                    }
                }
            }
        };
        if (this.executor.isShutdown()) {
            logger.info("Compaction executor has shut down, not submitting task");
            return Futures.immediateCancelledFuture();
        }
        return this.executor.submit(runnable);
    }

    private SSTableReader lookupSSTable(ColumnFamilyStore cfs, Descriptor descriptor) {
        for (SSTableReader sstable : cfs.getSSTables(SSTableSet.CANONICAL)) {
            if (!sstable.descriptor.equals(descriptor)) continue;
            return sstable;
        }
        return null;
    }

    public Future<Object> submitValidation(final ColumnFamilyStore cfStore, final Validator validator) {
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws IOException {
                try {
                    CompactionManager.this.doValidationCompaction(cfStore, validator);
                }
                catch (Throwable e) {
                    validator.fail();
                    throw e;
                }
                return this;
            }
        };
        return this.validationExecutor.submit(callable);
    }

    public void disableAutoCompaction() {
        for (String ksname : Schema.instance.getNonSystemKeyspaces()) {
            for (ColumnFamilyStore cfs : Keyspace.open(ksname).getColumnFamilyStores()) {
                cfs.disableAutoCompaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrubOne(ColumnFamilyStore cfs, LifecycleTransaction modifier, boolean skipCorrupted, boolean checkData, boolean offline) throws IOException {
        CompactionInfo.Holder scrubInfo = null;
        try {
            try (Scrubber scrubber = new Scrubber(cfs, modifier, skipCorrupted, offline, checkData);){
                scrubInfo = scrubber.getScrubInfo();
                this.metrics.beginCompaction(scrubInfo);
                scrubber.scrub();
            }
            if (scrubInfo != null) {
                this.metrics.finishCompaction(scrubInfo);
            }
        }
        catch (Throwable throwable) {
            if (scrubInfo != null) {
                this.metrics.finishCompaction(scrubInfo);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyOne(ColumnFamilyStore cfs, SSTableReader sstable, boolean extendedVerify) throws IOException {
        CompactionInfo.Holder verifyInfo = null;
        try {
            try (Verifier verifier = new Verifier(cfs, sstable, false);){
                verifyInfo = verifier.getVerifyInfo();
                this.metrics.beginCompaction(verifyInfo);
                verifier.verify(extendedVerify);
            }
            if (verifyInfo != null) {
                this.metrics.finishCompaction(verifyInfo);
            }
        }
        catch (Throwable throwable) {
            if (verifyInfo != null) {
                this.metrics.finishCompaction(verifyInfo);
            }
            throw throwable;
        }
    }

    static boolean needsCleanup(SSTableReader sstable, Collection<Range<Token>> ownedRanges) {
        assert (!ownedRanges.isEmpty());
        List sortedRanges = Range.normalize(ownedRanges);
        Range firstRange = sortedRanges.get(0);
        if (sstable.first.getToken().compareTo(firstRange.left) <= 0) {
            return true;
        }
        for (int i = 0; i < sortedRanges.size(); ++i) {
            Range range = sortedRanges.get(i);
            if (((Token)range.right).isMinimum()) {
                return false;
            }
            DecoratedKey firstBeyondRange = sstable.firstKeyBeyond(((Token)range.right).maxKeyBound());
            if (firstBeyondRange == null) {
                return false;
            }
            if (i == sortedRanges.size() - 1) {
                return true;
            }
            Range<Token> nextRange = sortedRanges.get(i + 1);
            if (nextRange.contains(firstBeyondRange.getToken())) continue;
            return true;
        }
        return false;
    }

    private void doCleanupOne(ColumnFamilyStore cfs, LifecycleTransaction txn, CleanupStrategy cleanupStrategy, Collection<Range<Token>> ranges, boolean hasIndexes) throws IOException {
        Object finished;
        Object object;
        assert (!cfs.isIndex());
        SSTableReader sstable = txn.onlyOne();
        if (!hasIndexes && !((AbstractBounds)new Bounds<Token>(sstable.first.getToken(), sstable.last.getToken())).intersects(ranges)) {
            txn.obsoleteOriginals();
            txn.finish();
            return;
        }
        if (!CompactionManager.needsCleanup(sstable, ranges)) {
            logger.trace("Skipping {} for cleanup; all rows should be kept", (Object)sstable);
            return;
        }
        long start = System.nanoTime();
        long totalkeysWritten = 0L;
        long expectedBloomFilterSize = Math.max((long)cfs.metadata.params.minIndexInterval, SSTableReader.getApproximateKeyCount(txn.originals()));
        if (logger.isTraceEnabled()) {
            logger.trace("Expected bloom filter size : {}", (Object)expectedBloomFilterSize);
        }
        logger.info("Cleaning up {}", (Object)sstable);
        File compactionFileLocation = cfs.getDirectories().getWriteableLocationAsFile(cfs.getExpectedCompactedFileSize(txn.originals(), OperationType.CLEANUP));
        if (compactionFileLocation == null) {
            throw new IOException("disk full");
        }
        int nowInSec = FBUtilities.nowInSeconds();
        try (SSTableRewriter writer = new SSTableRewriter(txn, sstable.maxDataAge, false);
             ISSTableScanner scanner = cleanupStrategy.getScanner(sstable, this.getRateLimiter());
             CompactionController controller = new CompactionController(cfs, txn.originals(), CompactionManager.getDefaultGcBefore(cfs, nowInSec));){
            CompactionIterator ci = new CompactionIterator(OperationType.CLEANUP, Collections.singletonList(scanner), controller, nowInSec, UUIDGen.getTimeUUID(), this.metrics);
            object = null;
            try {
                writer.switchWriter(CompactionManager.createWriter(cfs, compactionFileLocation, expectedBloomFilterSize, sstable.getSSTableMetadata().repairedAt, sstable, txn));
                while (ci.hasNext()) {
                    if (ci.isStopRequested()) {
                        throw new CompactionInterruptedException(ci.getCompactionInfo());
                    }
                    UnfilteredRowIterator partition = ci.next();
                    Throwable throwable = null;
                    try {
                        UnfilteredRowIterator notCleaned = cleanupStrategy.cleanup(partition);
                        Throwable throwable2 = null;
                        try {
                            if (notCleaned == null || writer.append(notCleaned) == null) continue;
                            ++totalkeysWritten;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (notCleaned == null) continue;
                            if (throwable2 != null) {
                                try {
                                    notCleaned.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            notCleaned.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (partition == null) continue;
                        if (throwable != null) {
                            try {
                                partition.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        partition.close();
                    }
                }
                cfs.indexManager.flushAllIndexesBlocking();
                finished = writer.finish();
            }
            catch (Throwable partition) {
                object = partition;
                throw partition;
            }
            finally {
                if (ci != null) {
                    if (object != null) {
                        try {
                            ci.close();
                        }
                        catch (Throwable partition) {
                            ((Throwable)object).addSuppressed(partition);
                        }
                    } else {
                        ci.close();
                    }
                }
            }
        }
        if (!finished.isEmpty()) {
            String format = "Cleaned up to %s.  %,d to %,d (~%d%% of original) bytes for %,d keys.  Time: %,dms.";
            long dTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            long startsize = sstable.onDiskLength();
            long endsize = 0L;
            object = finished.iterator();
            while (object.hasNext()) {
                SSTableReader newSstable = (SSTableReader)object.next();
                endsize += newSstable.onDiskLength();
            }
            double ratio = (double)endsize / (double)startsize;
            logger.info(String.format(format, ((SSTableReader)finished.get(0)).getFilename(), startsize, endsize, (int)(ratio * 100.0), totalkeysWritten, dTime));
        }
    }

    public static SSTableWriter createWriter(ColumnFamilyStore cfs, File compactionFileLocation, long expectedBloomFilterSize, long repairedAt, SSTableReader sstable, LifecycleTransaction txn) {
        FileUtils.createDirectory(compactionFileLocation);
        return SSTableWriter.create(cfs.metadata, Descriptor.fromFilename(cfs.getSSTablePath(compactionFileLocation)), expectedBloomFilterSize, repairedAt, sstable.getSSTableLevel(), sstable.header, txn);
    }

    public static SSTableWriter createWriterForAntiCompaction(ColumnFamilyStore cfs, File compactionFileLocation, int expectedBloomFilterSize, long repairedAt, Collection<SSTableReader> sstables, LifecycleTransaction txn) {
        FileUtils.createDirectory(compactionFileLocation);
        int minLevel = Integer.MAX_VALUE;
        for (SSTableReader sstable : sstables) {
            if (minLevel == Integer.MAX_VALUE) {
                minLevel = sstable.getSSTableLevel();
            }
            if (minLevel == sstable.getSSTableLevel()) continue;
            minLevel = 0;
            break;
        }
        return SSTableWriter.create(Descriptor.fromFilename(cfs.getSSTablePath(compactionFileLocation)), Long.valueOf(expectedBloomFilterSize), (Long)repairedAt, cfs.metadata, new MetadataCollector(sstables, cfs.metadata.comparator, minLevel), SerializationHeader.make(cfs.metadata, sstables), txn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValidationCompaction(ColumnFamilyStore cfs, Validator validator) throws IOException {
        if (!cfs.isValid()) {
            return;
        }
        Refs<SSTableReader> sstables = null;
        try {
            int gcBefore;
            String snapshotName = validator.desc.sessionId.toString();
            int nowInSec = FBUtilities.nowInSeconds();
            boolean isSnapshotValidation = cfs.snapshotExists(snapshotName);
            if (isSnapshotValidation) {
                sstables = cfs.getSnapshotSSTableReader(snapshotName);
                gcBefore = cfs.gcBefore((int)(cfs.getSnapshotCreationTime(snapshotName) / 1000L));
            } else {
                StorageService.instance.forceKeyspaceFlush(cfs.keyspace.getName(), cfs.name);
                ActiveRepairService.ParentRepairSession prs = ActiveRepairService.instance.getParentRepairSession(validator.desc.parentSessionId);
                ColumnFamilyStore.RefViewFragment sstableCandidates = cfs.selectAndReference(View.select(SSTableSet.CANONICAL, (Predicate<SSTableReader>)((Predicate)s -> !parentRepairSession.isIncremental || !s.isRepaired())));
                HashSet sstablesToValidate = new HashSet();
                for (SSTableReader sstable : sstableCandidates.sstables) {
                    if (!((AbstractBounds)new Bounds<Token>(sstable.first.getToken(), sstable.last.getToken())).intersects(validator.desc.ranges)) continue;
                    sstablesToValidate.add(sstable);
                }
                Set<SSTableReader> currentlyRepairing = ActiveRepairService.instance.currentlyRepairing(cfs.metadata.cfId, validator.desc.parentSessionId);
                if (!Sets.intersection(currentlyRepairing, (Set)sstablesToValidate).isEmpty()) {
                    logger.error("Cannot start multiple repair sessions over the same sstables");
                    throw new RuntimeException("Cannot start multiple repair sessions over the same sstables");
                }
                sstables = Refs.tryRef(sstablesToValidate);
                if (sstables == null) {
                    logger.error("Could not reference sstables");
                    throw new RuntimeException("Could not reference sstables");
                }
                sstableCandidates.release();
                prs.addSSTables(cfs.metadata.cfId, sstablesToValidate);
                gcBefore = validator.gcBefore > 0 ? validator.gcBefore : CompactionManager.getDefaultGcBefore(cfs, nowInSec);
            }
            long numPartitions = 0L;
            for (SSTableReader sstable : sstables) {
                numPartitions += sstable.estimatedKeysForRanges(validator.desc.ranges);
            }
            int depth = numPartitions > 0L ? (int)Math.min(Math.floor(Math.log(numPartitions)), 20.0) : 0;
            MerkleTrees tree = new MerkleTrees(cfs.getPartitioner());
            tree.addMerkleTrees((int)Math.pow(2.0, depth), validator.desc.ranges);
            long start = System.nanoTime();
            try (AbstractCompactionStrategy.ScannerList scanners = cfs.getCompactionStrategyManager().getScanners(sstables, validator.desc.ranges);
                 ValidationCompactionController controller = new ValidationCompactionController(cfs, gcBefore);
                 ValidationCompactionIterator ci = new ValidationCompactionIterator(scanners.scanners, controller, nowInSec, this.metrics);){
                validator.prepare(cfs, tree);
                while (ci.hasNext()) {
                    if (ci.isStopRequested()) {
                        throw new CompactionInterruptedException(ci.getCompactionInfo());
                    }
                    UnfilteredRowIterator partition = ci.next();
                    Throwable throwable = null;
                    try {
                        validator.add(partition);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (partition == null) continue;
                        if (throwable != null) {
                            try {
                                partition.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        partition.close();
                    }
                }
                validator.complete();
            }
            finally {
                if (isSnapshotValidation) {
                    cfs.clearSnapshot(snapshotName);
                }
            }
            if (logger.isTraceEnabled()) {
                long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                logger.trace("Validation finished in {} msec, depth {} for {} keys, serialized size {} bytes for {}", new Object[]{duration, depth, numPartitions, MerkleTrees.serializer.serializedSize(tree, 0), validator.desc});
            }
        }
        finally {
            if (sstables != null) {
                sstables.release();
            }
        }
    }

    private void doAntiCompaction(ColumnFamilyStore cfs, Collection<Range<Token>> ranges, LifecycleTransaction repaired, long repairedAt) {
        logger.info("Performing anticompaction on {} sstables", (Object)repaired.originals().size());
        Collection<Collection<SSTableReader>> groupedSSTables = cfs.getCompactionStrategyManager().groupSSTablesForAntiCompaction(repaired.originals());
        int antiCompactedSSTableCount = 0;
        for (Collection<SSTableReader> sstableGroup : groupedSSTables) {
            LifecycleTransaction txn = repaired.split(sstableGroup);
            Throwable throwable = null;
            try {
                int antiCompacted = this.antiCompactGroup(cfs, ranges, txn, repairedAt);
                antiCompactedSSTableCount += antiCompacted;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (txn == null) continue;
                if (throwable != null) {
                    try {
                        txn.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                txn.close();
            }
        }
        String format = "Anticompaction completed successfully, anticompacted from {} to {} sstable(s).";
        logger.info(format, (Object)repaired.originals().size(), (Object)antiCompactedSSTableCount);
    }

    /*
     * Exception decompiling
     */
    private int antiCompactGroup(ColumnFamilyStore cfs, Collection<Range<Token>> ranges, LifecycleTransaction anticompactionGroup, long repairedAt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Future<?> submitIndexBuild(final SecondaryIndexBuilder builder) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CompactionManager.this.metrics.beginCompaction(builder);
                try {
                    builder.build();
                }
                finally {
                    CompactionManager.this.metrics.finishCompaction(builder);
                }
            }
        };
        if (this.executor.isShutdown()) {
            logger.info("Compaction executor has shut down, not submitting index build");
            return null;
        }
        return this.executor.submit(runnable);
    }

    public Future<?> submitCacheWrite(final AutoSavingCache.Writer writer) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!AutoSavingCache.flushInProgress.add(writer.cacheType())) {
                    logger.trace("Cache flushing was already in progress: skipping {}", (Object)writer.getCompactionInfo());
                    return;
                }
                try {
                    CompactionManager.this.metrics.beginCompaction(writer);
                    try {
                        writer.saveCache();
                    }
                    finally {
                        CompactionManager.this.metrics.finishCompaction(writer);
                    }
                }
                finally {
                    AutoSavingCache.flushInProgress.remove((Object)writer.cacheType());
                }
            }
        };
        if (this.executor.isShutdown()) {
            logger.info("Executor has shut down, not submitting background task");
            Futures.immediateCancelledFuture();
        }
        return this.executor.submit(runnable);
    }

    public static int getDefaultGcBefore(ColumnFamilyStore cfs, int nowInSec) {
        return cfs.isIndex() ? nowInSec : cfs.gcBefore(nowInSec);
    }

    public Future<?> submitViewBuilder(final ViewBuilder builder) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CompactionManager.this.metrics.beginCompaction(builder);
                try {
                    builder.run();
                }
                finally {
                    CompactionManager.this.metrics.finishCompaction(builder);
                }
            }
        };
        if (this.executor.isShutdown()) {
            logger.info("Compaction executor has shut down, not submitting index build");
            return null;
        }
        return this.executor.submit(runnable);
    }

    public int getActiveCompactions() {
        return CompactionMetrics.getCompactions().size();
    }

    @Override
    public List<Map<String, String>> getCompactions() {
        List<CompactionInfo.Holder> compactionHolders = CompactionMetrics.getCompactions();
        ArrayList<Map<String, String>> out = new ArrayList<Map<String, String>>(compactionHolders.size());
        for (CompactionInfo.Holder ci : compactionHolders) {
            out.add(ci.getCompactionInfo().asMap());
        }
        return out;
    }

    @Override
    public List<String> getCompactionSummary() {
        List<CompactionInfo.Holder> compactionHolders = CompactionMetrics.getCompactions();
        ArrayList<String> out = new ArrayList<String>(compactionHolders.size());
        for (CompactionInfo.Holder ci : compactionHolders) {
            out.add(ci.getCompactionInfo().toString());
        }
        return out;
    }

    @Override
    public TabularData getCompactionHistory() {
        try {
            return SystemKeyspace.getCompactionHistory();
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public long getTotalBytesCompacted() {
        return this.metrics.bytesCompacted.getCount();
    }

    public long getTotalCompactionsCompleted() {
        return this.metrics.totalCompactionsCompleted.getCount();
    }

    public int getPendingTasks() {
        return (Integer)this.metrics.pendingTasks.getValue();
    }

    public long getCompletedTasks() {
        return (Long)this.metrics.completedTasks.getValue();
    }

    @Override
    public void stopCompaction(String type) {
        OperationType operation = OperationType.valueOf(type);
        for (CompactionInfo.Holder holder : CompactionMetrics.getCompactions()) {
            if (holder.getCompactionInfo().getTaskType() != operation) continue;
            holder.stop();
        }
    }

    @Override
    public void stopCompactionById(String compactionId) {
        for (CompactionInfo.Holder holder : CompactionMetrics.getCompactions()) {
            UUID holderId = holder.getCompactionInfo().compactionId();
            if (holderId == null || !holderId.equals(UUID.fromString(compactionId))) continue;
            holder.stop();
        }
    }

    @Override
    public int getCoreCompactorThreads() {
        return this.executor.getCorePoolSize();
    }

    @Override
    public void setCoreCompactorThreads(int number) {
        this.executor.setCorePoolSize(number);
    }

    @Override
    public int getMaximumCompactorThreads() {
        return this.executor.getMaximumPoolSize();
    }

    @Override
    public void setMaximumCompactorThreads(int number) {
        this.executor.setMaximumPoolSize(number);
    }

    @Override
    public int getCoreValidationThreads() {
        return this.validationExecutor.getCorePoolSize();
    }

    @Override
    public void setCoreValidationThreads(int number) {
        this.validationExecutor.setCorePoolSize(number);
    }

    @Override
    public int getMaximumValidatorThreads() {
        return this.validationExecutor.getMaximumPoolSize();
    }

    @Override
    public void setMaximumValidatorThreads(int number) {
        this.validationExecutor.setMaximumPoolSize(number);
    }

    public void interruptCompactionFor(Iterable<CFMetaData> columnFamilies, boolean interruptValidation) {
        assert (columnFamilies != null);
        for (CompactionInfo.Holder compactionHolder : CompactionMetrics.getCompactions()) {
            CompactionInfo info = compactionHolder.getCompactionInfo();
            if (info.getTaskType() == OperationType.VALIDATION && !interruptValidation || !Iterables.contains(columnFamilies, (Object)info.getCFMetaData())) continue;
            compactionHolder.stop();
        }
    }

    public void interruptCompactionForCFs(Iterable<ColumnFamilyStore> cfss, boolean interruptValidation) {
        ArrayList<CFMetaData> metadata = new ArrayList<CFMetaData>();
        for (ColumnFamilyStore cfs : cfss) {
            metadata.add(cfs.metadata);
        }
        this.interruptCompactionFor(metadata, interruptValidation);
    }

    public void waitForCessation(Iterable<ColumnFamilyStore> cfss) {
        long start = System.nanoTime();
        long delay = TimeUnit.MINUTES.toNanos(1L);
        while (System.nanoTime() - start < delay && instance.isCompacting(cfss)) {
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    static {
        isCompactionManager = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        instance = new CompactionManager();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(instance, new ObjectName(MBEAN_OBJECT_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        cacheCleanupExecutor = new CacheCleanupExecutor();
    }

    public static interface CompactionExecutorStatsCollector {
        public void beginCompaction(CompactionInfo.Holder var1);

        public void finishCompaction(CompactionInfo.Holder var1);
    }

    private static class CacheCleanupExecutor
    extends CompactionExecutor {
        public CacheCleanupExecutor() {
            super(1, "CacheCleanupExecutor");
        }
    }

    private static class ValidationExecutor
    extends CompactionExecutor {
        public ValidationExecutor() {
            super(1, Integer.MAX_VALUE, "ValidationExecutor", new SynchronousQueue<Runnable>());
        }
    }

    private static class CompactionExecutor
    extends JMXEnabledThreadPoolExecutor {
        protected CompactionExecutor(int minThreads, int maxThreads, String name, BlockingQueue<Runnable> queue) {
            super(minThreads, maxThreads, 60L, TimeUnit.SECONDS, queue, new NamedThreadFactory(name, 1), "internal");
        }

        private CompactionExecutor(int threadCount, String name) {
            this(threadCount, threadCount, name, new LinkedBlockingQueue<Runnable>());
        }

        public CompactionExecutor() {
            this(Math.max(1, DatabaseDescriptor.getConcurrentCompactors()), "CompactionExecutor");
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            isCompactionManager.set(true);
            super.beforeExecute(t, r);
        }

        @Override
        public void afterExecute(Runnable r, Throwable t) {
            DebuggableThreadPoolExecutor.maybeResetTraceSessionWrapper(r);
            if (t == null) {
                t = DebuggableThreadPoolExecutor.extractThrowable(r);
            }
            if (t != null) {
                if (t instanceof CompactionInterruptedException) {
                    logger.info(t.getMessage());
                    if (t.getSuppressed() != null && t.getSuppressed().length > 0) {
                        logger.warn("Interruption of compaction encountered exceptions:", t);
                    } else {
                        logger.trace("Full interruption stack trace:", t);
                    }
                } else {
                    DebuggableThreadPoolExecutor.handleOrLog(t);
                }
            }
            SnapshotDeletingTask.rescheduleFailedTasks();
        }
    }

    private static class ValidationCompactionController
    extends CompactionController {
        public ValidationCompactionController(ColumnFamilyStore cfs, int gcBefore) {
            super(cfs, gcBefore);
        }

        @Override
        public long maxPurgeableTimestamp(DecoratedKey key) {
            return Long.MAX_VALUE;
        }
    }

    private static class ValidationCompactionIterator
    extends CompactionIterator {
        public ValidationCompactionIterator(List<ISSTableScanner> scanners, ValidationCompactionController controller, int nowInSec, CompactionMetrics metrics) {
            super(OperationType.VALIDATION, scanners, controller, nowInSec, UUIDGen.getTimeUUID(), metrics);
        }
    }

    private static abstract class CleanupStrategy {
        protected final Collection<Range<Token>> ranges;
        protected final int nowInSec;

        protected CleanupStrategy(Collection<Range<Token>> ranges, int nowInSec) {
            this.ranges = ranges;
            this.nowInSec = nowInSec;
        }

        public static CleanupStrategy get(ColumnFamilyStore cfs, Collection<Range<Token>> ranges, int nowInSec) {
            return cfs.indexManager.hasIndexes() ? new Full(cfs, ranges, nowInSec) : new Bounded(cfs, ranges, nowInSec);
        }

        public abstract ISSTableScanner getScanner(SSTableReader var1, RateLimiter var2);

        public abstract UnfilteredRowIterator cleanup(UnfilteredRowIterator var1);

        private static final class Full
        extends CleanupStrategy {
            private final ColumnFamilyStore cfs;

            public Full(ColumnFamilyStore cfs, Collection<Range<Token>> ranges, int nowInSec) {
                super(ranges, nowInSec);
                this.cfs = cfs;
            }

            @Override
            public ISSTableScanner getScanner(SSTableReader sstable, RateLimiter limiter) {
                return sstable.getScanner(limiter);
            }

            @Override
            public UnfilteredRowIterator cleanup(UnfilteredRowIterator partition) {
                if (Range.isInRanges(partition.partitionKey().getToken(), this.ranges)) {
                    return partition;
                }
                this.cfs.invalidateCachedPartition(partition.partitionKey());
                this.cfs.indexManager.deletePartition(partition, this.nowInSec);
                return null;
            }
        }

        private static final class Bounded
        extends CleanupStrategy {
            public Bounded(final ColumnFamilyStore cfs, Collection<Range<Token>> ranges, int nowInSec) {
                super(ranges, nowInSec);
                cacheCleanupExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        cfs.cleanupCache();
                    }
                });
            }

            @Override
            public ISSTableScanner getScanner(SSTableReader sstable, RateLimiter limiter) {
                return sstable.getScanner(this.ranges, limiter);
            }

            @Override
            public UnfilteredRowIterator cleanup(UnfilteredRowIterator partition) {
                return partition;
            }
        }
    }

    public static enum AllSSTableOpStatus {
        ABORTED(1),
        SUCCESSFUL(0);

        public final int statusCode;

        private AllSSTableOpStatus(int statusCode) {
            this.statusCode = statusCode;
        }
    }

    private static interface OneSSTableOperation {
        public Iterable<SSTableReader> filterSSTables(LifecycleTransaction var1);

        public void execute(LifecycleTransaction var1) throws IOException;
    }

    class BackgroundCompactionCandidate
    implements Runnable {
        private final ColumnFamilyStore cfs;

        BackgroundCompactionCandidate(ColumnFamilyStore cfs) {
            this.cfs = cfs;
        }

        @Override
        public void run() {
            try {
                logger.trace("Checking {}.{}", (Object)this.cfs.keyspace.getName(), (Object)this.cfs.name);
                if (!this.cfs.isValid()) {
                    logger.trace("Aborting compaction for dropped CF");
                    return;
                }
                CompactionStrategyManager strategy = this.cfs.getCompactionStrategyManager();
                AbstractCompactionTask task = strategy.getNextBackgroundTask(CompactionManager.getDefaultGcBefore(this.cfs, FBUtilities.nowInSeconds()));
                if (task == null) {
                    logger.trace("No tasks available");
                    return;
                }
                task.execute(CompactionManager.this.metrics);
            }
            finally {
                CompactionManager.this.compactingCF.remove((Object)this.cfs);
            }
            CompactionManager.this.submitBackground(this.cfs);
        }
    }
}

