/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.partitions.PartitionUpdate;

final class UpdatesCollector {
    private final PartitionColumns updatedColumns;
    private final int updatedRows;
    private final Map<String, Map<ByteBuffer, IMutation>> mutations = new HashMap<String, Map<ByteBuffer, IMutation>>();

    public UpdatesCollector(PartitionColumns updatedColumns, int updatedRows) {
        this.updatedColumns = updatedColumns;
        this.updatedRows = updatedRows;
    }

    public PartitionUpdate getPartitionUpdate(CFMetaData cfm, DecoratedKey dk, ConsistencyLevel consistency) {
        Mutation mut = this.getMutation(cfm, dk, consistency);
        PartitionUpdate upd = mut.get(cfm);
        if (upd == null) {
            upd = new PartitionUpdate(cfm, dk, this.updatedColumns, this.updatedRows);
            mut.add(upd);
        }
        return upd;
    }

    public void validateIndexedColumns() {
        for (Map<ByteBuffer, IMutation> perKsMutations : this.mutations.values()) {
            for (IMutation mutation : perKsMutations.values()) {
                for (PartitionUpdate update : mutation.getPartitionUpdates()) {
                    Keyspace.openAndGetStore((CFMetaData)update.metadata()).indexManager.validate(update);
                }
            }
        }
    }

    private Mutation getMutation(CFMetaData cfm, DecoratedKey dk, ConsistencyLevel consistency) {
        String ksName = cfm.ksName;
        IMutation mutation = this.keyspaceMap(ksName).get(dk.getKey());
        if (mutation == null) {
            Mutation mut = new Mutation(ksName, dk);
            mutation = cfm.isCounter() ? new CounterMutation(mut, consistency) : mut;
            this.keyspaceMap(ksName).put(dk.getKey(), mutation);
            return mut;
        }
        return cfm.isCounter() ? ((CounterMutation)mutation).getMutation() : (Mutation)mutation;
    }

    public Collection<IMutation> toMutations() {
        if (this.mutations.size() == 1) {
            return this.mutations.values().iterator().next().values();
        }
        ArrayList<IMutation> ms = new ArrayList<IMutation>();
        for (Map<ByteBuffer, IMutation> ksMap : this.mutations.values()) {
            ms.addAll(ksMap.values());
        }
        return ms;
    }

    private Map<ByteBuffer, IMutation> keyspaceMap(String ksName) {
        Map<ByteBuffer, IMutation> ksMap = this.mutations.get(ksName);
        if (ksMap == null) {
            ksMap = new HashMap<ByteBuffer, IMutation>();
            this.mutations.put(ksName, ksMap);
        }
        return ksMap;
    }
}

