/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.IndexName;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.KeyspaceNotDefinedException;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.messages.ResultMessage;

public class DropIndexStatement
extends SchemaAlteringStatement {
    public final String indexName;
    public final boolean ifExists;
    private CFMetaData indexedTable;

    public DropIndexStatement(IndexName indexName, boolean ifExists) {
        super(indexName.getCfName());
        this.indexName = indexName.getIdx();
        this.ifExists = ifExists;
    }

    @Override
    public String columnFamily() {
        if (this.indexedTable != null) {
            return this.indexedTable.cfName;
        }
        this.indexedTable = this.lookupIndexedTable();
        return this.indexedTable == null ? null : this.indexedTable.cfName;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        CFMetaData cfm = this.lookupIndexedTable();
        if (cfm == null) {
            return;
        }
        state.hasColumnFamilyAccess(cfm.ksName, cfm.cfName, Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }

    @Override
    public ResultMessage execute(QueryState state, QueryOptions options) throws RequestValidationException {
        return this.announceMigration(false) ? new ResultMessage.SchemaChange(this.changeEvent()) : null;
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws InvalidRequestException, ConfigurationException {
        CFMetaData cfm = this.lookupIndexedTable();
        if (cfm == null) {
            return false;
        }
        this.indexedTable = cfm;
        CFMetaData updatedCfm = cfm.copy();
        updatedCfm.indexes(updatedCfm.getIndexes().without(this.indexName));
        MigrationManager.announceColumnFamilyUpdate(updatedCfm, false, isLocalOnly);
        return true;
    }

    private CFMetaData lookupIndexedTable() {
        if (this.indexedTable != null) {
            return this.indexedTable;
        }
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.keyspace());
        if (ksm == null) {
            throw new KeyspaceNotDefinedException("Keyspace " + this.keyspace() + " does not exist");
        }
        return ksm.findIndexedTable(this.indexName).orElseGet(() -> {
            if (this.ifExists) {
                return null;
            }
            throw new InvalidRequestException(String.format("Index '%s' could not be found in any of the tables of keyspace '%s'", this.indexName, this.keyspace()));
        });
    }
}

