/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Ints;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EntryWeigher;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.BatchQueryOptions;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.CqlLexer;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.ErrorCollector;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.exceptions.CassandraException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.metrics.CQLMetrics;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationListener;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.thrift.ThriftClientState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CassandraVersion;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MD5Digest;
import org.github.jamm.MemoryMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProcessor
implements QueryHandler {
    public static final CassandraVersion CQL_VERSION = new CassandraVersion("3.3.1");
    public static final QueryProcessor instance = new QueryProcessor();
    private static final Logger logger = LoggerFactory.getLogger(QueryProcessor.class);
    private static final MemoryMeter meter = new MemoryMeter().withGuessing(MemoryMeter.Guess.FALLBACK_BEST).ignoreKnownSingletons();
    private static final long MAX_CACHE_PREPARED_MEMORY = Runtime.getRuntime().maxMemory() / 256L;
    private static final EntryWeigher<MD5Digest, ParsedStatement.Prepared> cqlMemoryUsageWeigher = new EntryWeigher<MD5Digest, ParsedStatement.Prepared>(){

        public int weightOf(MD5Digest key, ParsedStatement.Prepared value) {
            return Ints.checkedCast((long)(QueryProcessor.measure(key) + QueryProcessor.measure(value.statement) + QueryProcessor.measure(value.boundNames)));
        }
    };
    private static final EntryWeigher<Integer, ParsedStatement.Prepared> thriftMemoryUsageWeigher = new EntryWeigher<Integer, ParsedStatement.Prepared>(){

        public int weightOf(Integer key, ParsedStatement.Prepared value) {
            return Ints.checkedCast((long)(QueryProcessor.measure(key) + QueryProcessor.measure(value.statement) + QueryProcessor.measure(value.boundNames)));
        }
    };
    private static final ConcurrentLinkedHashMap<MD5Digest, ParsedStatement.Prepared> preparedStatements;
    private static final ConcurrentLinkedHashMap<Integer, ParsedStatement.Prepared> thriftPreparedStatements;
    private static final ConcurrentMap<String, ParsedStatement.Prepared> internalStatements;
    public static final CQLMetrics metrics;
    private static final AtomicInteger lastMinuteEvictionsCount;

    public static int preparedStatementsCount() {
        return preparedStatements.size() + thriftPreparedStatements.size();
    }

    private static QueryState internalQueryState() {
        return InternalStateInstance.INSTANCE.queryState;
    }

    private QueryProcessor() {
        MigrationManager.instance.register(new MigrationSubscriber());
    }

    @Override
    public ParsedStatement.Prepared getPrepared(MD5Digest id) {
        return (ParsedStatement.Prepared)preparedStatements.get((Object)id);
    }

    @Override
    public ParsedStatement.Prepared getPreparedForThrift(Integer id) {
        return (ParsedStatement.Prepared)thriftPreparedStatements.get((Object)id);
    }

    public static void validateKey(ByteBuffer key) throws InvalidRequestException {
        if (key == null || key.remaining() == 0) {
            throw new InvalidRequestException("Key may not be empty");
        }
        if (key == ByteBufferUtil.UNSET_BYTE_BUFFER) {
            throw new InvalidRequestException("Key may not be unset");
        }
        if (key.remaining() > 65535) {
            throw new InvalidRequestException("Key length of " + key.remaining() + " is longer than maximum of " + 65535);
        }
    }

    public ResultMessage processStatement(CQLStatement statement, QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        logger.trace("Process {} @CL.{}", (Object)statement, (Object)options.getConsistency());
        ClientState clientState = queryState.getClientState();
        statement.checkAccess(clientState);
        statement.validate(clientState);
        ResultMessage result = statement.execute(queryState, options);
        return result == null ? new ResultMessage.Void() : result;
    }

    public static ResultMessage process(String queryString, ConsistencyLevel cl, QueryState queryState) throws RequestExecutionException, RequestValidationException {
        return instance.process(queryString, queryState, QueryOptions.forInternalCalls(cl, Collections.emptyList()));
    }

    @Override
    public ResultMessage process(String query, QueryState state, QueryOptions options, Map<String, ByteBuffer> customPayload) throws RequestExecutionException, RequestValidationException {
        return this.process(query, state, options);
    }

    public ResultMessage process(String queryString, QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        ParsedStatement.Prepared p = QueryProcessor.getStatement(queryString, queryState.getClientState());
        options.prepare(p.boundNames);
        CQLStatement prepared = p.statement;
        if (prepared.getBoundTerms() != options.getValues().size()) {
            throw new InvalidRequestException("Invalid amount of bind variables");
        }
        if (!queryState.getClientState().isInternal) {
            QueryProcessor.metrics.regularStatementsExecuted.inc();
        }
        return this.processStatement(prepared, queryState, options);
    }

    public static ParsedStatement.Prepared parseStatement(String queryStr, QueryState queryState) throws RequestValidationException {
        return QueryProcessor.getStatement(queryStr, queryState.getClientState());
    }

    public static UntypedResultSet process(String query, ConsistencyLevel cl) throws RequestExecutionException {
        return QueryProcessor.process(query, cl, Collections.emptyList());
    }

    public static UntypedResultSet process(String query, ConsistencyLevel cl, List<ByteBuffer> values) throws RequestExecutionException {
        ResultMessage result = instance.process(query, QueryState.forInternalCalls(), QueryOptions.forInternalCalls(cl, values));
        if (result instanceof ResultMessage.Rows) {
            return UntypedResultSet.create(((ResultMessage.Rows)result).result);
        }
        return null;
    }

    private static QueryOptions makeInternalOptions(ParsedStatement.Prepared prepared, Object[] values) {
        return QueryProcessor.makeInternalOptions(prepared, values, ConsistencyLevel.ONE);
    }

    private static QueryOptions makeInternalOptions(ParsedStatement.Prepared prepared, Object[] values, ConsistencyLevel cl) {
        if (prepared.boundNames.size() != values.length) {
            throw new IllegalArgumentException(String.format("Invalid number of values. Expecting %d but got %d", prepared.boundNames.size(), values.length));
        }
        ArrayList<ByteBuffer> boundValues = new ArrayList<ByteBuffer>(values.length);
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            AbstractType<?> type = prepared.boundNames.get((int)i).type;
            boundValues.add(value instanceof ByteBuffer || value == null ? (ByteBuffer)value : type.decompose(value));
        }
        return QueryOptions.forInternalCalls(cl, boundValues);
    }

    private static ParsedStatement.Prepared prepareInternal(String query) throws RequestValidationException {
        ParsedStatement.Prepared prepared = (ParsedStatement.Prepared)internalStatements.get(query);
        if (prepared != null) {
            return prepared;
        }
        prepared = QueryProcessor.parseStatement(query, QueryProcessor.internalQueryState());
        prepared.statement.validate(QueryProcessor.internalQueryState().getClientState());
        internalStatements.putIfAbsent(query, prepared);
        return prepared;
    }

    public static UntypedResultSet executeInternal(String query, Object ... values) {
        ParsedStatement.Prepared prepared = QueryProcessor.prepareInternal(query);
        ResultMessage result = prepared.statement.executeInternal(QueryProcessor.internalQueryState(), QueryProcessor.makeInternalOptions(prepared, values));
        if (result instanceof ResultMessage.Rows) {
            return UntypedResultSet.create(((ResultMessage.Rows)result).result);
        }
        return null;
    }

    public static UntypedResultSet execute(String query, ConsistencyLevel cl, QueryState state, Object ... values) throws RequestExecutionException {
        try {
            ParsedStatement.Prepared prepared = QueryProcessor.prepareInternal(query);
            ResultMessage result = prepared.statement.execute(state, QueryProcessor.makeInternalOptions(prepared, values));
            if (result instanceof ResultMessage.Rows) {
                return UntypedResultSet.create(((ResultMessage.Rows)result).result);
            }
            return null;
        }
        catch (RequestValidationException e) {
            throw new RuntimeException("Error validating " + query, e);
        }
    }

    public static UntypedResultSet executeInternalWithPaging(String query, int pageSize, Object ... values) {
        ParsedStatement.Prepared prepared = QueryProcessor.prepareInternal(query);
        if (!(prepared.statement instanceof SelectStatement)) {
            throw new IllegalArgumentException("Only SELECTs can be paged");
        }
        SelectStatement select = (SelectStatement)prepared.statement;
        QueryPager pager = select.getQuery(QueryProcessor.makeInternalOptions(prepared, values), FBUtilities.nowInSeconds()).getPager(null, 4);
        return UntypedResultSet.create(select, pager, pageSize);
    }

    public static UntypedResultSet executeOnceInternal(String query, Object ... values) {
        ParsedStatement.Prepared prepared = QueryProcessor.parseStatement(query, QueryProcessor.internalQueryState());
        prepared.statement.validate(QueryProcessor.internalQueryState().getClientState());
        ResultMessage result = prepared.statement.executeInternal(QueryProcessor.internalQueryState(), QueryProcessor.makeInternalOptions(prepared, values));
        if (result instanceof ResultMessage.Rows) {
            return UntypedResultSet.create(((ResultMessage.Rows)result).result);
        }
        return null;
    }

    public static UntypedResultSet resultify(String query, RowIterator partition) {
        return QueryProcessor.resultify(query, PartitionIterators.singletonIterator(partition));
    }

    public static UntypedResultSet resultify(String query, PartitionIterator partitions) {
        try (PartitionIterator iter = partitions;){
            SelectStatement ss = (SelectStatement)QueryProcessor.getStatement((String)query, null).statement;
            ResultSet cqlRows = ss.process(iter, FBUtilities.nowInSeconds());
            UntypedResultSet untypedResultSet = UntypedResultSet.create(cqlRows);
            return untypedResultSet;
        }
    }

    @Override
    public ResultMessage.Prepared prepare(String query, QueryState state, Map<String, ByteBuffer> customPayload) throws RequestValidationException {
        return this.prepare(query, state);
    }

    public ResultMessage.Prepared prepare(String queryString, QueryState queryState) {
        ClientState cState = queryState.getClientState();
        return QueryProcessor.prepare(queryString, cState, cState instanceof ThriftClientState);
    }

    public static ResultMessage.Prepared prepare(String queryString, ClientState clientState, boolean forThrift) {
        ResultMessage.Prepared existing = QueryProcessor.getStoredPreparedStatement(queryString, clientState.getRawKeyspace(), forThrift);
        if (existing != null) {
            return existing;
        }
        ParsedStatement.Prepared prepared = QueryProcessor.getStatement(queryString, clientState);
        int boundTerms = prepared.statement.getBoundTerms();
        if (boundTerms > 65535) {
            throw new InvalidRequestException(String.format("Too many markers(?). %d markers exceed the allowed maximum of %d", boundTerms, 65535));
        }
        assert (boundTerms == prepared.boundNames.size());
        return QueryProcessor.storePreparedStatement(queryString, clientState.getRawKeyspace(), prepared, forThrift);
    }

    private static MD5Digest computeId(String queryString, String keyspace) {
        String toHash = keyspace == null ? queryString : keyspace + queryString;
        return MD5Digest.compute(toHash);
    }

    private static Integer computeThriftId(String queryString, String keyspace) {
        String toHash = keyspace == null ? queryString : keyspace + queryString;
        return toHash.hashCode();
    }

    private static ResultMessage.Prepared getStoredPreparedStatement(String queryString, String keyspace, boolean forThrift) throws InvalidRequestException {
        if (forThrift) {
            Integer thriftStatementId = QueryProcessor.computeThriftId(queryString, keyspace);
            ParsedStatement.Prepared existing = (ParsedStatement.Prepared)thriftPreparedStatements.get((Object)thriftStatementId);
            return existing == null ? null : ResultMessage.Prepared.forThrift(thriftStatementId, existing.boundNames);
        }
        MD5Digest statementId = QueryProcessor.computeId(queryString, keyspace);
        ParsedStatement.Prepared existing = (ParsedStatement.Prepared)preparedStatements.get((Object)statementId);
        return existing == null ? null : new ResultMessage.Prepared(statementId, existing);
    }

    private static ResultMessage.Prepared storePreparedStatement(String queryString, String keyspace, ParsedStatement.Prepared prepared, boolean forThrift) throws InvalidRequestException {
        long statementSize = QueryProcessor.measure(prepared.statement);
        if (statementSize > MAX_CACHE_PREPARED_MEMORY) {
            throw new InvalidRequestException(String.format("Prepared statement of size %d bytes is larger than allowed maximum of %d bytes.", statementSize, MAX_CACHE_PREPARED_MEMORY));
        }
        if (forThrift) {
            Integer statementId = QueryProcessor.computeThriftId(queryString, keyspace);
            thriftPreparedStatements.put((Object)statementId, (Object)prepared);
            return ResultMessage.Prepared.forThrift(statementId, prepared.boundNames);
        }
        MD5Digest statementId = QueryProcessor.computeId(queryString, keyspace);
        preparedStatements.put((Object)statementId, (Object)prepared);
        return new ResultMessage.Prepared(statementId, prepared);
    }

    @Override
    public ResultMessage processPrepared(CQLStatement statement, QueryState state, QueryOptions options, Map<String, ByteBuffer> customPayload) throws RequestExecutionException, RequestValidationException {
        return this.processPrepared(statement, state, options);
    }

    public ResultMessage processPrepared(CQLStatement statement, QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        List<ByteBuffer> variables = options.getValues();
        if (!variables.isEmpty() || statement.getBoundTerms() != 0) {
            if (variables.size() != statement.getBoundTerms()) {
                throw new InvalidRequestException(String.format("there were %d markers(?) in CQL but %d bound variables", statement.getBoundTerms(), variables.size()));
            }
            if (logger.isTraceEnabled()) {
                for (int i = 0; i < variables.size(); ++i) {
                    logger.trace("[{}] '{}'", (Object)(i + 1), (Object)variables.get(i));
                }
            }
        }
        QueryProcessor.metrics.preparedStatementsExecuted.inc();
        return this.processStatement(statement, queryState, options);
    }

    @Override
    public ResultMessage processBatch(BatchStatement statement, QueryState state, BatchQueryOptions options, Map<String, ByteBuffer> customPayload) throws RequestExecutionException, RequestValidationException {
        return this.processBatch(statement, state, options);
    }

    public ResultMessage processBatch(BatchStatement batch, QueryState queryState, BatchQueryOptions options) throws RequestExecutionException, RequestValidationException {
        ClientState clientState = queryState.getClientState();
        batch.checkAccess(clientState);
        batch.validate();
        batch.validate(clientState);
        return batch.execute(queryState, options);
    }

    public static ParsedStatement.Prepared getStatement(String queryStr, ClientState clientState) throws RequestValidationException {
        Tracing.trace("Parsing {}", (Object)queryStr);
        ParsedStatement statement = QueryProcessor.parseStatement(queryStr);
        if (statement instanceof CFStatement) {
            ((CFStatement)statement).prepareKeyspace(clientState);
        }
        Tracing.trace("Preparing statement");
        return statement.prepare();
    }

    public static ParsedStatement parseStatement(String queryStr) throws SyntaxException {
        try {
            ErrorCollector errorCollector = new ErrorCollector(queryStr);
            ANTLRStringStream stream = new ANTLRStringStream(queryStr);
            CqlLexer lexer = new CqlLexer((CharStream)stream);
            lexer.addErrorListener(errorCollector);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            CqlParser parser = new CqlParser((TokenStream)tokenStream);
            parser.addErrorListener(errorCollector);
            ParsedStatement statement = parser.query();
            errorCollector.throwFirstSyntaxError();
            return statement;
        }
        catch (CassandraException ce) {
            throw ce;
        }
        catch (RuntimeException re) {
            logger.error(String.format("The statement: [%s] could not be parsed.", queryStr), (Throwable)re);
            throw new SyntaxException(String.format("Failed parsing statement: [%s] reason: %s %s", queryStr, re.getClass().getSimpleName(), re.getMessage()));
        }
        catch (RecognitionException e) {
            throw new SyntaxException("Invalid or malformed CQL query string: " + e.getMessage());
        }
    }

    private static long measure(Object key) {
        return meter.measureDeep(key);
    }

    static {
        internalStatements = new ConcurrentHashMap<String, ParsedStatement.Prepared>();
        metrics = new CQLMetrics();
        lastMinuteEvictionsCount = new AtomicInteger(0);
        preparedStatements = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(MAX_CACHE_PREPARED_MEMORY).weigher(cqlMemoryUsageWeigher).listener((EvictionListener)new EvictionListener<MD5Digest, ParsedStatement.Prepared>(){

            public void onEviction(MD5Digest md5Digest, ParsedStatement.Prepared prepared) {
                QueryProcessor.metrics.preparedStatementsEvicted.inc();
                lastMinuteEvictionsCount.incrementAndGet();
            }
        }).build();
        thriftPreparedStatements = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(MAX_CACHE_PREPARED_MEMORY).weigher(thriftMemoryUsageWeigher).listener((EvictionListener)new EvictionListener<Integer, ParsedStatement.Prepared>(){

            public void onEviction(Integer integer, ParsedStatement.Prepared prepared) {
                QueryProcessor.metrics.preparedStatementsEvicted.inc();
                lastMinuteEvictionsCount.incrementAndGet();
            }
        }).build();
        ScheduledExecutors.scheduledTasks.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long count = lastMinuteEvictionsCount.getAndSet(0);
                if (count > 0L) {
                    logger.info("{} prepared statements discarded in the last minute because cache limit reached ({} bytes)", (Object)count, (Object)MAX_CACHE_PREPARED_MEMORY);
                }
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    private static class MigrationSubscriber
    extends MigrationListener {
        private MigrationSubscriber() {
        }

        private void removeInvalidPreparedStatements(String ksName, String cfName) {
            this.removeInvalidPreparedStatements(internalStatements.values().iterator(), ksName, cfName);
            this.removeInvalidPreparedStatements(preparedStatements.values().iterator(), ksName, cfName);
            this.removeInvalidPreparedStatements(thriftPreparedStatements.values().iterator(), ksName, cfName);
        }

        private void removeInvalidPreparedStatements(Iterator<ParsedStatement.Prepared> iterator, String ksName, String cfName) {
            while (iterator.hasNext()) {
                if (!this.shouldInvalidate(ksName, cfName, iterator.next().statement)) continue;
                iterator.remove();
            }
        }

        private boolean shouldInvalidate(String ksName, String cfName, CQLStatement statement) {
            String statementCfName;
            String statementKsName;
            if (statement instanceof ModificationStatement) {
                ModificationStatement modificationStatement = (ModificationStatement)statement;
                statementKsName = modificationStatement.keyspace();
                statementCfName = modificationStatement.columnFamily();
            } else if (statement instanceof SelectStatement) {
                SelectStatement selectStatement = (SelectStatement)statement;
                statementKsName = selectStatement.keyspace();
                statementCfName = selectStatement.columnFamily();
            } else {
                if (statement instanceof BatchStatement) {
                    BatchStatement batchStatement = (BatchStatement)statement;
                    for (ModificationStatement stmt : batchStatement.getStatements()) {
                        if (!this.shouldInvalidate(ksName, cfName, stmt)) continue;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            return ksName.equals(statementKsName) && (cfName == null || cfName.equals(statementCfName));
        }

        @Override
        public void onCreateFunction(String ksName, String functionName, List<AbstractType<?>> argTypes) {
            MigrationSubscriber.onCreateFunctionInternal(ksName, functionName, argTypes);
        }

        @Override
        public void onCreateAggregate(String ksName, String aggregateName, List<AbstractType<?>> argTypes) {
            MigrationSubscriber.onCreateFunctionInternal(ksName, aggregateName, argTypes);
        }

        private static void onCreateFunctionInternal(String ksName, String functionName, List<AbstractType<?>> argTypes) {
            if (Schema.instance.getKSMetaData((String)ksName).functions.get(new FunctionName(ksName, functionName)).size() > 1) {
                MigrationSubscriber.removeInvalidPreparedStatementsForFunction(preparedStatements.values().iterator(), ksName, functionName);
                MigrationSubscriber.removeInvalidPreparedStatementsForFunction(thriftPreparedStatements.values().iterator(), ksName, functionName);
            }
        }

        @Override
        public void onUpdateColumnFamily(String ksName, String cfName, boolean columnsDidChange) {
            logger.trace("Column definitions for {}.{} changed, invalidating related prepared statements", (Object)ksName, (Object)cfName);
            if (columnsDidChange) {
                this.removeInvalidPreparedStatements(ksName, cfName);
            }
        }

        @Override
        public void onDropKeyspace(String ksName) {
            logger.trace("Keyspace {} was dropped, invalidating related prepared statements", (Object)ksName);
            this.removeInvalidPreparedStatements(ksName, null);
        }

        @Override
        public void onDropColumnFamily(String ksName, String cfName) {
            logger.trace("Table {}.{} was dropped, invalidating related prepared statements", (Object)ksName, (Object)cfName);
            this.removeInvalidPreparedStatements(ksName, cfName);
        }

        @Override
        public void onDropFunction(String ksName, String functionName, List<AbstractType<?>> argTypes) {
            MigrationSubscriber.onDropFunctionInternal(ksName, functionName, argTypes);
        }

        @Override
        public void onDropAggregate(String ksName, String aggregateName, List<AbstractType<?>> argTypes) {
            MigrationSubscriber.onDropFunctionInternal(ksName, aggregateName, argTypes);
        }

        private static void onDropFunctionInternal(String ksName, String functionName, List<AbstractType<?>> argTypes) {
            MigrationSubscriber.removeInvalidPreparedStatementsForFunction(preparedStatements.values().iterator(), ksName, functionName);
            MigrationSubscriber.removeInvalidPreparedStatementsForFunction(thriftPreparedStatements.values().iterator(), ksName, functionName);
        }

        private static void removeInvalidPreparedStatementsForFunction(Iterator<ParsedStatement.Prepared> statements, String ksName, String functionName) {
            Predicate matchesFunction = f -> ksName.equals(f.name().keyspace) && functionName.equals(f.name().name);
            Iterators.removeIf(statements, statement -> Iterables.any(statement.statement.getFunctions(), (Predicate)matchesFunction));
        }
    }

    private static enum InternalStateInstance {
        INSTANCE;

        private final QueryState queryState;

        private InternalStateInstance() {
            ClientState state = ClientState.forInternalCalls();
            state.setKeyspace("system");
            this.queryState = new QueryState(state);
        }
    }
}

