/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IndexMetadata {
    private static final Logger logger = LoggerFactory.getLogger(IndexMetadata.class);
    public final String name;
    public final IndexType indexType;
    public final TargetType targetType;
    public final Map<String, String> options;
    public final Set<ColumnIdentifier> columns;

    private IndexMetadata(String name, Map<String, String> options, IndexType indexType, TargetType targetType, Set<ColumnIdentifier> columns) {
        this.name = name;
        this.options = options == null ? ImmutableMap.of() : ImmutableMap.copyOf(options);
        this.indexType = indexType;
        this.targetType = targetType;
        this.columns = columns == null ? ImmutableSet.of() : ImmutableSet.copyOf(columns);
    }

    public static IndexMetadata singleColumnIndex(ColumnIdentifier column, String name, IndexType type, Map<String, String> options) {
        return new IndexMetadata(name, options, type, TargetType.COLUMN, Collections.singleton(column));
    }

    public static IndexMetadata singleColumnIndex(ColumnDefinition column, String name, IndexType type, Map<String, String> options) {
        return IndexMetadata.singleColumnIndex(column.name, name, type, options);
    }

    public static boolean isNameValid(String name) {
        return name != null && !name.isEmpty() && name.matches("\\w+");
    }

    public static String getDefaultIndexName(String cfName, ColumnIdentifier columnName) {
        return (cfName + "_" + columnName + "_idx").replaceAll("\\W", "");
    }

    public void validate() {
        if (!IndexMetadata.isNameValid(this.name)) {
            throw new ConfigurationException("Illegal index name " + this.name);
        }
        if (this.indexType == null) {
            throw new ConfigurationException("Index type is null for index " + this.name);
        }
        if (this.targetType == null) {
            throw new ConfigurationException("Target type is null for index " + this.name);
        }
        if (this.indexType == IndexType.CUSTOM) {
            if (this.options == null || !this.options.containsKey("class_name")) {
                throw new ConfigurationException(String.format("Required option missing for index %s : %s", this.name, "class_name"));
            }
            String className = this.options.get("class_name");
            Class indexerClass = FBUtilities.classForName(className, "custom indexer");
            if (!Index.class.isAssignableFrom(indexerClass)) {
                throw new ConfigurationException(String.format("Specified Indexer class (%s) does not implement the Indexer interface", className));
            }
            this.validateCustomIndexOptions(indexerClass, this.options);
        }
    }

    private void validateCustomIndexOptions(Class<? extends Index> indexerClass, Map<String, String> options) throws ConfigurationException {
        try {
            Map filteredOptions = Maps.filterKeys(options, key -> !key.equals("class_name"));
            if (filteredOptions.isEmpty()) {
                return;
            }
            Map unknownOptions = (Map)indexerClass.getMethod("validateOptions", Map.class).invoke(null, filteredOptions);
            if (!unknownOptions.isEmpty()) {
                throw new ConfigurationException(String.format("Properties specified %s are not understood by %s", unknownOptions.keySet(), indexerClass.getSimpleName()));
            }
        }
        catch (NoSuchMethodException e) {
            logger.info("Indexer {} does not have a static validateOptions method. Validation ignored", (Object)indexerClass.getName());
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ConfigurationException) {
                throw (ConfigurationException)e.getTargetException();
            }
            throw new ConfigurationException("Failed to validate custom indexer options: " + options);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to validate custom indexer options: " + options);
        }
    }

    public ColumnDefinition indexedColumn(CFMetaData cfm) {
        return cfm.getColumnDefinition(this.columns.iterator().next());
    }

    public boolean isCustom() {
        return this.indexType == IndexType.CUSTOM;
    }

    public boolean isKeys() {
        return this.indexType == IndexType.KEYS;
    }

    public boolean isComposites() {
        return this.indexType == IndexType.COMPOSITES;
    }

    public boolean isRowIndex() {
        return this.targetType == TargetType.ROW;
    }

    public boolean isColumnIndex() {
        return this.targetType == TargetType.COLUMN;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.indexType, this.targetType, this.options, this.columns});
    }

    public boolean equalsWithoutName(IndexMetadata other) {
        return Objects.equal((Object)((Object)this.indexType), (Object)((Object)other.indexType)) && Objects.equal((Object)((Object)this.targetType), (Object)((Object)other.targetType)) && Objects.equal(this.columns, other.columns) && Objects.equal(this.options, other.options);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IndexMetadata)) {
            return false;
        }
        IndexMetadata other = (IndexMetadata)obj;
        return Objects.equal((Object)this.name, (Object)other.name) && this.equalsWithoutName(other);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("indexType", (Object)this.indexType).append("targetType", (Object)this.targetType).append("columns", this.columns).append("options", this.options).build();
    }

    public static enum TargetType {
        COLUMN,
        ROW;

    }

    public static enum IndexType {
        KEYS,
        CUSTOM,
        COMPOSITES;

    }
}

